/*
 * Decompiled with CFR 0.152.
 */
package util.status;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import util.status.DTMonitor;

public class DTMonitorRenderer
extends JPanel
implements TableCellRenderer {
    private final JLabel jLabelWs = new JLabel();
    private final JLabel jLabelDb = new JLabel();
    private Border selectedBorder;
    private Border wsBorder;

    public DTMonitorRenderer() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.jLabelWs);
        this.add(this.jLabelDb);
        this.jLabelDb.setOpaque(true);
        this.jLabelWs.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object dbItem, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected && dbItem != null) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(1, 0, 1, 0, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(null);
        }
        this.jLabelDb.setBackground(table.getBackground());
        this.jLabelDb.setForeground(table.getForeground());
        if (dbItem != null) {
            if (dbItem instanceof DTMonitor) {
                DTMonitor monitor = (DTMonitor)dbItem;
                this.jLabelWs.setBackground(monitor.getStatus());
                this.jLabelWs.setText(monitor.statusString());
                this.jLabelDb.setText(monitor.dbStatusString());
            } else {
                assert (false);
                this.jLabelWs.setText(dbItem.toString());
                this.jLabelDb.setText("");
            }
        }
        if (this.wsBorder == null) {
            this.wsBorder = BorderFactory.createMatteBorder(0, 0, 0, 2, table.getGridColor());
        }
        this.jLabelWs.setBorder(this.wsBorder);
        return this;
    }
}

