/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import jsbugs.TableModelSB;
import jsbugs.table.IGetValue;
import jsbugs.table.SampleRenderer;
import jsbugs.table.SimpleTableColumn;
import model3.Biocom;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import util.SBException;

public class BiocomTableModel
extends TableModelSB {
    private char units = (char)77;
    List<Biocom> comments = null;
    static String[] columnTitles = new String[]{"Sample", "Corrected Depth", "Discipline", "Analyst", "Comment", "Mod. By", "Modified"};
    private static final int[] defaultColumnWidths = new int[]{55, 55, 30, 30, 200, 30, 30};
    static final int COL_SAMPLE = 0;
    static final int COL_CORRECTED = 1;
    static final int COL_DISC = 2;
    static final int COL_ANALYST = 3;
    static final int COL_TEXT = 4;
    static final int COL_MODIFIER = 5;
    static final int COL_MODIFIED = 6;
    private SampleRenderer sampleRenderer = new SampleRenderer(this.units);
    private SimpleTableColumn<Biocom> sampleColumn = new SimpleTableColumn<Biocom>("Sample", 55, Sample.class, new IGetValue<Biocom>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(Biocom biocom) {
            return biocom.getTopSample();
        }
    });
    private SimpleTableColumn<Biocom> disciplineColumn = new SimpleTableColumn<Biocom>("Discipline", 30, String.class, new IGetValue<Biocom>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(Biocom biocom) {
            return biocom.getDiscipline().getNoun();
        }
    });
    private SimpleTableColumn<Biocom> analystColumn = new SimpleTableColumn<Biocom>("Analyst", 30, String.class, new IGetValue<Biocom>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(Biocom biocom) {
            try {
                return biocom.getAnalystString();
            }
            catch (SQLException ex) {
                return ex.getMessage();
            }
            catch (SBException ex) {
                return ex.getMessage();
            }
        }
    });
    private SimpleTableColumn<Biocom> commentsColumn = new SimpleTableColumn<Biocom>("Comment", 200, String.class, new IGetValue<Biocom>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(Biocom biocom) {
            return biocom.getText();
        }
    });
    private SimpleTableColumn<Biocom> modifiedByColumn = new SimpleTableColumn<Biocom>("Mod. By", 30, String.class, new IGetValue<Biocom>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(Biocom biocom) {
            return biocom.getModifierAbr();
        }
    });
    private SimpleTableColumn<Biocom> modifiedOnColumn = new SimpleTableColumn<Biocom>("Modified", 30, Date.class, new IGetValue<Biocom>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(Biocom biocom) {
            return biocom.getModified();
        }
    });
    List<SimpleTableColumn<Biocom>> columns = new ArrayList<SimpleTableColumn>(Arrays.asList(this.sampleColumn, this.disciplineColumn, this.analystColumn, this.commentsColumn, this.modifiedByColumn, this.modifiedOnColumn));
    private boolean displayCuttingSampleCorrections = true;

    @Override
    void setUnits(char units) {
        if (this.units != units) {
            this.units = units;
            this.sampleRenderer.setUnits(units);
        }
    }

    public void setBioComments(List<Biocom> comments, Well well) {
        this.comments = comments;
    }

    public char getUnits() {
        return this.units;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.comments == null || row > this.comments.size() - 1) {
            return null;
        }
        Biocom biocom = this.comments.get(row);
        SimpleTableColumn<Biocom> columnValue = this.columns.get(col);
        return columnValue.getValueFromRow(biocom);
    }

    @Override
    public int getRowCount() {
        if (this.comments == null) {
            return 0;
        }
        return this.comments.size();
    }

    public Class getColumnClass(int col) {
        SimpleTableColumn<Biocom> columnValue = this.columns.get(col);
        return columnValue.getValueClass();
    }

    @Override
    public void setupTable(JTable jTableComments, SBdb sbdb) {
        this.init(jTableComments, sbdb);
        jTableComments.getColumnModel().getColumn(0).setCellRenderer(this.sampleRenderer);
        this.restoreColumnOrder(jTableComments);
    }

    @Override
    public String[] getColumnTitles() {
        String[] titles = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            titles[i] = this.columns.get(i).getTitle();
        }
        return titles;
    }

    @Override
    public String getPrefString() {
        return "TMBIOCOM";
    }

    @Override
    public String getPrefOrderString() {
        return "TOBIOCOM";
    }

    @Override
    public String getAutoResizeString() {
        return "TARBIOCOM";
    }

    @Override
    public int[] getDefaultColumnWidths() {
        int[] widths = new int[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            widths[i] = this.columns.get(i).getDefaultWidth();
        }
        return widths;
    }
}

