/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.io.FileChooserUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartTemplateBase;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.SBGraphicsConverter;
import jsbchart.panel.spatial.PointDataLayerFactory;
import jsbchart.panel.spatial.SBPointDataLayer;
import jsbugs.ChartJPanel;
import jsbugs.DialogPrintPreviewChart;
import jsbugs.DialogProcessing;
import jsbugs.FrameJsbugs;
import jsbugs.PDFExporter;
import jsbugs.io.DialogShapefileExport;
import jsbugs.io.ImageFileType;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.Lastval;
import model3.SBdb;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFDocumentGraphics2DConfigurator;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.util.UnitConv;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.map.Layer;
import org.w3c.dom.Document;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.exception.StackError;

public class ChartExporter {
    private static PrintService printService = null;
    private static final Logger LOGGER = Logger.getLogger(ChartExporter.class.getName());
    private static boolean usePDFBox = true;

    private ChartExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printChart(Chart chart, Frame parent, SBdb db, boolean demoLicense) {
        PrinterJob job = PrinterJob.getPrinterJob();
        HashPrintRequestAttributeSet prset = new HashPrintRequestAttributeSet();
        if (printService != null) {
            try {
                job.setPrintService(printService);
            }
            catch (PrinterException ex) {
                System.out.println("PrinterException setting service");
                ex.printStackTrace();
            }
        }
        if (!job.printDialog()) {
            return;
        }
        printService = job.getPrintService();
        ChartProperties cp = chart.getProperties();
        ChartProperties tempCP = new ChartProperties(chart.getProperties().getProperties(), chart.getProperties().bgSchID);
        tempCP.header = cp.header;
        tempCP.key = cp.key;
        tempCP.background = Color.WHITE;
        tempCP.foreground = Color.BLACK;
        try {
            chart.setProperties(tempCP);
            ChartBlockBase selectedBlock = null;
            for (ChartBlockBase block : chart.getBlocks()) {
                if (block.isSelected()) {
                    selectedBlock = block;
                }
                block.setSelected(false);
                block.setTemplateSelected(false);
            }
            parent.setCursor(Cursor.getPredefinedCursor(3));
            PageFormat pf = job.getPageFormat(prset);
            parent.setCursor(Cursor.getDefaultCursor());
            System.out.println("Paper size: " + pf.getPaper().getWidth() * 25.4 / 72.0 + " x " + pf.getPaper().getHeight() * 25.4 / 72.0);
            Paper paper = pf.getPaper();
            paper.setImageableArea(0.0, 0.0, pf.getPaper().getWidth(), pf.getPaper().getHeight());
            pf.setPaper(paper);
            System.out.print("Orientation: ");
            if (pf.getOrientation() == 0) {
                System.out.println("Landscape");
            } else if (pf.getOrientation() == 1) {
                System.out.println("Portrait");
            }
            System.out.println("Imageable area: " + pf.getImageableWidth() * 25.4 / 72.0 + " x " + pf.getImageableHeight() * 25.4 / 72.0);
            ChartJPanel printPanel = new ChartJPanel(chart, pf, db.decodeChartPrintPrefs());
            if (demoLicense) {
                printPanel.watermark = true;
            }
            DialogPrintPreviewChart dialog = new DialogPrintPreviewChart(parent, true, printPanel, job, db);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                return;
            }
            job.setPrintable(printPanel, printPanel.getPf());
            System.out.println("Copies: " + job.getCopies());
            job.print();
            chart.setSelectedBlock(selectedBlock);
        }
        catch (PrinterAbortException exp) {
            JOptionPane.showMessageDialog(parent, exp.getMessage());
        }
        catch (Exception exp) {
            StackError.showStackError((String)"Problem printing", (Throwable)exp);
        }
        finally {
            chart.setProperties(cp);
        }
    }

    static void saveChart(final Chart chart, String defaultFileName, boolean vector, JFrame frame, final SBdb sbdb, final boolean demoLicense) throws SBException {
        if (chart == null) {
            JOptionPane.showMessageDialog(frame, "No chart selected/created. Use the Chart tab and select chart", frame.getTitle(), 1);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        for (ImageFileType vtype : ImageFileType.values()) {
            if (vtype.isVector() != vector) continue;
            jFileChooser.addChoosableFileFilter((FileFilter)vtype.getFilter());
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = vector ? new File(Lastval.getString(sbdb, "WINVECIMG", "UNXVECIMG")) : new File(Lastval.getString(sbdb, "WINRASIMG", "UNXRASIMG"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
            jFileChooser.setSelectedFile(new File(defaultFileName == null ? ChartExporter.getDefaultExportFileName(chart.getTemplate()) : defaultFileName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0 == jFileChooser.showSaveDialog(frame)) {
            try {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                setDir = jFileChooser.getSelectedFile();
                SbugsFileFilter filter = (SbugsFileFilter)jFileChooser.getFileFilter();
                if (filter == null) {
                    ImageFileType type;
                    if (setDir.getName().lastIndexOf(".") > 0 && (type = ImageFileType.getType(setDir.getName().substring(setDir.getName().lastIndexOf(".") + 1))) != null) {
                        filter = type.getFilter();
                    }
                    if (filter == null) {
                        filter = ImageFileType.getDefaultFilter(vector);
                    }
                }
                if (!setDir.getName().endsWith("." + filter.getExtension())) {
                    setDir = new File(setDir.getPath() + "." + filter.getExtension());
                }
                if (setDir.exists() && JOptionPane.showConfirmDialog(frame, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                    return;
                }
                if (vector) {
                    Boolean embedFonts;
                    final File dir = setDir;
                    final ImageFileType type = ImageFileType.getType(filter.getExtension());
                    if (type == ImageFileType.PDF) {
                        if (chart.getMMheight() > 5000.0f || chart.getMMwidth() > 5000.0f) {
                            Object[] options = new Object[]{"Resize", "Cancel"};
                            int n = JOptionPane.showOptionDialog(frame, "PDF Files are restricted to 5000mm maximum dimension. Would you like to resize the chart to fit within this limit?", frame.getTitle(), 0, 3, null, options, options[1]);
                            if (n == 1) {
                                return;
                            }
                        }
                        if ((embedFonts = ChartExporter.getEmbedFontsOption(sbdb)) == null) {
                            return;
                        }
                        if (embedFonts.booleanValue()) {
                            List<Font> fontsToEmbed = ChartExporter.getChartFonts(chart);
                            PDFExporter exporter = new PDFExporter(new DimensionF(0.0f, 0.0f), null, false);
                            for (Font f : fontsToEmbed) {
                                if (exporter.canFindFont(f)) continue;
                                LOGGER.log(Level.INFO, "Couldn't find the font " + f.getFontName() + " for embedding into pdf output.");
                                String message = "The font " + f.getFontName() + " was not found to be embedded in the pdf, if you continue without embedding a font the resulting file may be much larger than normal. ";
                                message = message + "Other options are to change the font used in the chart to another option (such as Helvetica), or use the print option and choose to print to a pdf file.";
                                message = message + "\n\nWould you like to continue without embedding a font?";
                                int opt = JOptionPane.showConfirmDialog(null, message, "Print to PDF", 0, 3);
                                if (opt == 1) {
                                    return;
                                }
                                break;
                            }
                        }
                    } else {
                        embedFonts = true;
                    }
                    final JFrame messageParent = frame;
                    final DialogProcessing dialog = new DialogProcessing((Frame)frame, true);
                    dialog.setMessage("Writing image file...");
                    dialog.setLocationRelativeTo(frame);
                    new SwingWorker(){
                        boolean done;

                        protected Object doInBackground() throws IOException, TranscoderException {
                            try {
                                ChartExporter.saveVectorImage(dir, type, chart, sbdb, demoLicense, embedFonts);
                                dialog.setComplete();
                            }
                            catch (FileNotFoundException fnf) {
                                JOptionPane.showMessageDialog(messageParent, fnf.getMessage(), "Error saving chart", 0);
                                dialog.setMessage(fnf.getMessage());
                            }
                            catch (IOException ioe) {
                                StackError.showStackError((String)"IO Error creating file", (Throwable)ioe);
                            }
                            catch (NoClassDefFoundError c) {
                                JOptionPane.showMessageDialog(messageParent, "A required library may be missing - please contact your system administrator\n" + c.getMessage(), "Error saving chart", 0);
                            }
                            catch (OutOfMemoryError e) {
                                JOptionPane.showMessageDialog(messageParent, "Error writing image - out of memory!\nNote that some chart panels are more memory-intensive than others:\ntry removing lithology and wireline log panels, or save to SVG.", "Memory error", 0);
                            }
                            catch (Exception e) {
                                StackError.showStackError((String)"Error creating file", (Throwable)e);
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            dialog.dispose();
                            if (dialog.isTaskComplete() && Desktop.isDesktopSupported()) {
                                try {
                                    Desktop.getDesktop().open(dir);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }.execute();
                    dialog.setVisible(true);
                    if (!dialog.isTaskComplete()) {
                        return;
                    }
                } else {
                    RenderedImage img;
                    block42: {
                        img = Chart.getChartImage(chart, demoLicense);
                        if (img != null) break block42;
                        JOptionPane.showMessageDialog(frame, "Not enough memory to write this image", "Image", 2);
                        return;
                    }
                    try {
                        if (ImageIO.write(img, filter.getExtension(), setDir)) {
                            System.out.println("Image written.");
                        }
                    }
                    catch (Exception e) {
                        StackError.showStackError((String)"Error writing file", (Throwable)e);
                    }
                }
                try {
                    Lastval.putString(sbdb, vector ? "WINVECIMG" : "WINRASIMG", setDir.getPath());
                    sbdb.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                frame.setCursor(Cursor.getDefaultCursor());
            }
            JOptionPane.showMessageDialog(frame, "Image written.", "Export image", 1);
        }
    }

    public static void saveVectorImage(File file, ImageFileType type, Chart chart, SBdb sbdb, boolean demoLicense, boolean embedFonts) throws IOException {
        assert (type.isVector());
        switch (type) {
            case SVG: {
                Document doc = ChartExporter.createSVGFile(file, chart, sbdb, demoLicense);
                break;
            }
            case PDF: {
                if (!usePDFBox) {
                    Document doc = ChartExporter.createPDFFile(file, chart, demoLicense);
                    break;
                }
                try {
                    ChartExporter.createPDFFilePDFBox(file, chart, demoLicense, embedFonts);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "There was an error creating a compact PDF file: " + e.getMessage() + "\nPress OK to create the PDF using vector fonts (larger file) and and alternative driver, to continue to use this setting during this session.", "Error", 0);
                    usePDFBox = false;
                    LOGGER.log(Level.CONFIG, "Exception creating PDF from PDFBox: ", e);
                    ChartExporter.saveVectorImage(file, type, chart, sbdb, demoLicense, false);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public static Boolean getEmbedFontsOption(SBdb sbdb) throws SQLException {
        if (Lastval.getInt(sbdb, "PDFQEMBED", 0) == 1) {
            int opt = JOptionPane.showConfirmDialog(null, "Do you want to embed fonts in the PDF? \n\nYes: Smaller files.\nNo: Larger files, avoids font compatibility problems in some graphics programs", "Font Choice", 1, 3);
            if (opt == 1) {
                return false;
            }
            if (opt != 0) {
                return null;
            }
        }
        return true;
    }

    private static Document createSVGFile(File svgFile, Chart chart, SBdb sbdb, boolean demoLicense) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            document = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException p) {
            p.printStackTrace();
        }
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setComment("Generated in StrataBugs version v3.0 on " + DateFormat.getDateInstance(2).format(new Date()) + " by " + sbdb.getLicenceCustomer().getCompany() + ", " + sbdb.getLicenceCustomer().getLocation());
        SVGGraphics2D g = new SVGGraphics2D(ctx, false);
        int width = (int)chart.getMMwidth();
        int height = (int)chart.getMMheight();
        g.setSVGCanvasSize(new Dimension((int)Math.ceil(chart.getMMwidth() * 2.8346457f), (int)Math.ceil(chart.getMMheight() * 2.8346457f)));
        AffineTransform tnf = new AffineTransform();
        tnf.scale(0.028346456587314606, 0.028346456587314606);
        g.transform(tnf);
        g.setClip(0, 0, (int)Math.ceil(chart.getMMwidth() * 100.0f), (int)Math.ceil(chart.getMMheight() * 100.0f));
        SBGraphics sbg = new SBGraphics((Graphics2D)g, null, true, true);
        sbg.setColor(chart.getProperties().background);
        sbg.fillRect(0.0f, 0.0f, chart.getMMwidth(), chart.getMMheight());
        ChartBlockBase selectedBlock = null;
        for (ChartBlockBase block : chart.getBlocks()) {
            if (block.isSelected()) {
                selectedBlock = block;
            }
            block.setSelected(false);
            block.setTemplateSelected(false);
        }
        if (demoLicense) {
            chart.drawWatermark(sbg, true);
        } else {
            chart.draw(sbg, Chart.Mode.NORMAL, Chart.Mode.NORMAL);
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(svgFile), "UTF-8");
            g.stream((Writer)osw);
        }
        catch (FileNotFoundException | UnsupportedEncodingException | SVGGraphics2DIOException e) {
            e.printStackTrace();
        }
        chart.setSelectedBlock(selectedBlock);
        return document;
    }

    static Document createPDFFile(File pdfFile, Chart chart, boolean demoLicense) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            document = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException p) {
            p.printStackTrace();
        }
        PDFDocumentGraphics2D g = new PDFDocumentGraphics2D(false);
        g.setGraphicContext(new GraphicContext());
        try {
            ChartExporter.configure(g, ChartExporter.createAutoFontsConfiguration());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        OutputStream out = new FileOutputStream(pdfFile);
        out = new BufferedOutputStream(out);
        DimensionF outputSize = new DimensionF(chart.getMMwidth(), chart.getMMheight());
        double chartScale = 0.028346456587314606;
        if (outputSize.getWidth() > 5000.0f || outputSize.getHeight() > 5000.0f) {
            float shrinkFactor = chart.getMMwidth() > chart.getMMheight() ? 5000.0f / chart.getMMwidth() : 5000.0f / chart.getMMheight();
            chartScale *= (double)shrinkFactor;
            outputSize = new DimensionF(outputSize.getWidth() * shrinkFactor, outputSize.getHeight() * shrinkFactor);
        }
        int widthPt = (int)Math.round(UnitConv.mm2pt((double)outputSize.getWidth()));
        int heightPt = (int)Math.round(UnitConv.mm2pt((double)outputSize.getHeight()));
        g.setupDocument(out, widthPt, heightPt);
        AffineTransform tnf = new AffineTransform();
        tnf.scale(chartScale, chartScale);
        g.transform(tnf);
        float resolutionScaling = g.getDeviceDPI() / 72.0f;
        int clipW = (int)(chart.getMMwidth() * 100.0f * resolutionScaling);
        int clipH = (int)(chart.getMMheight() * 100.0f * resolutionScaling);
        g.setClip(0, 0, clipW, clipH);
        SBGraphics sbg = new SBGraphics((Graphics2D)g, null, true, true);
        ChartBlockBase selectedBlock = ChartExporter.unselectChartBlocks(chart);
        ChartExporter.drawChart(sbg, chart, demoLicense);
        g.finish();
        out.flush();
        out.close();
        chart.setSelectedBlock(selectedBlock);
        return document;
    }

    public static void createPDFFilePDFBox(File pdfFile, Chart chart, boolean demoLicense, boolean embedFonts) throws IOException {
        DimensionF chartSizeMM = new DimensionF(chart.getMMwidth(), chart.getMMheight());
        float shrinkFactor = ChartExporter.calculateChartShrinkFactor(chartSizeMM);
        DimensionF scaledChartSize = new DimensionF(chartSizeMM.getWidth() * shrinkFactor, chartSizeMM.getHeight() * shrinkFactor);
        List<Font> fontsToEmbed = ChartExporter.getChartFonts(chart);
        try (PDFExporter exporter = new PDFExporter(scaledChartSize, fontsToEmbed, embedFonts);){
            exporter.drawPage(g2d -> ChartExporter.scaleGraphicsAndDrawChart(g2d, chart, demoLicense, shrinkFactor));
            exporter.save(pdfFile);
        }
    }

    private static float calculateChartShrinkFactor(DimensionF chartSizeMM) {
        float shrinkFactor = 1.0f;
        if (chartSizeMM.getWidth() > 5000.0f || chartSizeMM.getHeight() > 5000.0f) {
            shrinkFactor = chartSizeMM.getWidth() > chartSizeMM.getHeight() ? 5000.0f / chartSizeMM.getWidth() : 5000.0f / chartSizeMM.getHeight();
        }
        return shrinkFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scaleGraphicsAndDrawChart(Graphics2D g2d, Chart chart, boolean demoLicense, float shrinkFactor) {
        AffineTransform saveTransform = g2d.getTransform();
        SBGraphicsConverter converter = new SBGraphicsConverter(0.028346456587314606);
        try {
            double scaleFactor = converter.getTransformFactor() * (double)shrinkFactor;
            AffineTransform tnf = new AffineTransform();
            tnf.scale(scaleFactor, scaleFactor);
            g2d.transform(tnf);
            g2d.setClip(0, 0, (int)(chart.getMMwidth() * 100.0f), (int)(chart.getMMheight() * 100.0f));
            SBGraphics sg = new SBGraphics(g2d, null, true, true);
            ChartBlockBase selectedBlock = ChartExporter.unselectChartBlocks(chart);
            ChartExporter.drawChart(sg, chart, demoLicense);
            chart.setSelectedBlock(selectedBlock);
        }
        finally {
            g2d.setTransform(saveTransform);
        }
    }

    private static List<Font> getChartFonts(Chart chart) {
        ArrayList<Font> fontsToEmbed = new ArrayList<Font>();
        fontsToEmbed.add(new Font(chart.getProperties().font, 0, (int)(chart.getProperties().getFontSize() * 100.0f)));
        fontsToEmbed.add(new Font(chart.getProperties().font, 1, (int)(chart.getProperties().getFontSize() * 100.0f)));
        fontsToEmbed.add(new Font(chart.getProperties().font, 2, (int)(chart.getProperties().getFontSize() * 100.0f)));
        fontsToEmbed.add(new Font(chart.getProperties().font, 3, (int)(chart.getProperties().getFontSize() * 100.0f)));
        return fontsToEmbed;
    }

    private static ChartBlockBase unselectChartBlocks(Chart c) {
        ChartBlockBase selectedBlock = null;
        for (ChartBlockBase block : c.getBlocks()) {
            if (block.isSelected()) {
                selectedBlock = block;
            }
            block.setSelected(false);
            block.setTemplateSelected(false);
        }
        return selectedBlock;
    }

    private static void drawChart(SBGraphics sg, Chart chart, boolean demoLicense) {
        sg.setColor(chart.getProperties().background);
        sg.fillRect(0.0f, 0.0f, chart.getMMwidth(), chart.getMMheight());
        if (demoLicense) {
            chart.drawWatermark(sg, true);
        } else {
            chart.draw(sg, Chart.Mode.NORMAL, Chart.Mode.NORMAL);
        }
    }

    public static Configuration createAutoFontsConfiguration() {
        LOGGER.log(Level.CONFIG, "Chart exporter: configuring cfg ");
        DefaultConfiguration c = new DefaultConfiguration("cfg");
        LOGGER.log(Level.CONFIG, "Chart exporter: configuring fonts ");
        DefaultConfiguration fonts = new DefaultConfiguration("fonts");
        c.addChild(fonts);
        if (!FrameJsbugs.isMacPlatform()) {
            LOGGER.log(Level.CONFIG, "Chart exporter: configuring auto-detect ");
            DefaultConfiguration autodetect = new DefaultConfiguration("auto-detect");
            fonts.addChild(autodetect);
        } else {
            LOGGER.log(Level.CONFIG, "Chart exporter: skipping auto-detect for mac ");
        }
        LOGGER.log(Level.CONFIG, "Chart exporter: returning configuration ");
        return c;
    }

    public static void configure(PDFDocumentGraphics2D g2d, Configuration cfg) throws ConfigurationException {
        PDFDocumentGraphics2DConfigurator configurator = new PDFDocumentGraphics2DConfigurator();
        boolean useComplexScriptFeatures = false;
        LOGGER.log(Level.CONFIG, "Chart exporter: configurator.configure ...");
        configurator.configure(g2d, cfg, useComplexScriptFeatures);
        LOGGER.log(Level.CONFIG, "Chart exporter: configured ");
    }

    public static void saveShapefileData(Frame parent, SBdb sbdb, Chart c) throws Exception {
        try {
            List<MapBlock> mapBlocks = c.getBlocks().stream().filter(b -> b instanceof MapBlock).map(b -> (MapBlock)b).collect(Collectors.toList());
            MapBlock exportMapBlock = null;
            File exportFile = null;
            if (mapBlocks.isEmpty()) {
                JOptionPane.showMessageDialog(parent, "No map block found in the current chart. A map block is required for a shapefile export.", "Shapefile Export", 2);
            } else if (mapBlocks.size() == 1) {
                exportMapBlock = (MapBlock)mapBlocks.get(0);
                boolean retry = false;
                do {
                    if ((exportFile = ChartExporter.getShapefileExportFile(sbdb, c.getTemplate().getName(), exportMapBlock)) == null) {
                        return;
                    }
                    if (!exportFile.exists() && !exportFile.isDirectory()) continue;
                    Object[] options = new String[]{"Overwrite", "Choose another file", "Cancel"};
                    String msg = "The file " + exportFile.getName() + " already exists. \r\nOverwrite file?";
                    int option = JOptionPane.showOptionDialog(parent, msg, "Confirm file overwrite", -1, 3, null, options, options[2]);
                    switch (option) {
                        case 0: {
                            retry = false;
                            break;
                        }
                        case 1: {
                            retry = true;
                            break;
                        }
                        case 2: {
                            retry = false;
                            exportFile = null;
                        }
                    }
                } while (retry);
            } else {
                DialogShapefileExport dlg = new DialogShapefileExport(parent, true, mapBlocks, sbdb);
                dlg.setSuggestedChartName(c.getTemplate().getName());
                dlg.setLocationRelativeTo(parent);
                dlg.pack();
                dlg.setVisible(true);
                if (dlg.isOK()) {
                    exportMapBlock = dlg.getSelectedMapBlock();
                    exportFile = dlg.getExportFile();
                }
                dlg.dispose();
            }
            if (exportMapBlock != null && exportFile != null) {
                ChartExporter.doShapefileExport(exportMapBlock, c, exportFile);
                JOptionPane.showMessageDialog(parent, exportFile.getName() + " written.", parent.getTitle(), 1);
            }
        }
        catch (Exception ex) {
            String msg = "An error occurred while exporting the shapefile";
            LOGGER.log(Level.SEVERE, msg, ex);
            SbugsExceptionHandler.showStackError(msg, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doShapefileExport(MapBlock mapBlock, Chart c, File shapefile) throws MalformedURLException, IOException {
        PointDataLayerFactory pdlFactory = new PointDataLayerFactory(mapBlock);
        List<SBPointDataLayer> pointLayers = mapBlock.getLayers().stream().filter(l -> l instanceof SBPointDataLayer).map(l -> (SBPointDataLayer)l).collect(Collectors.toList());
        Layer l2 = pdlFactory.getLayer(c.getProperties(), pointLayers);
        FeatureSource fs = l2.getFeatureSource();
        FeatureCollection fc = fs.getFeatures();
        FeatureIterator fi = fc.features();
        Feature f = fi.next();
        if (f != null) {
            FeatureType type = f.getType();
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", shapefile.toURI().toURL());
            params.put("create spatial index", Boolean.TRUE);
            ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
            newDataStore.createSchema((SimpleFeatureType)type);
            DefaultTransaction transaction = new DefaultTransaction("create");
            String typeName = newDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
            if (featureSource instanceof SimpleFeatureStore) {
                SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                featureStore.setTransaction((Transaction)transaction);
                try {
                    featureStore.addFeatures(fc);
                    transaction.commit();
                }
                catch (Exception problem) {
                    problem.printStackTrace();
                    transaction.rollback();
                }
                finally {
                    transaction.close();
                }
            } else {
                System.out.println(typeName + " does not support read/write access");
            }
        }
    }

    public static String getDefaultExportFileName(ChartTemplateBase template) {
        if (template != null) {
            return SB.makeFileName((String)template.getName().trim());
        }
        return "export";
    }

    public static File getShapefileExportFile(SBdb sbdb, String chartName, MapBlock mapBlock) {
        UserPrefsHelper prefs = new UserPrefsHelper(sbdb);
        String suggestedPath = prefs.getLastExportShapefileFile().getPath();
        String suggestedName = ChartExporter.getDefaultShapefileExportFileName(chartName, mapBlock);
        return FileChooserUtils.saveAsDialogWithFilters(null, (String)suggestedPath, (String)suggestedName, (FileNameExtensionFilter[])new FileNameExtensionFilter[]{FileChooserUtils.SHAPFEILE_FILTER});
    }

    public static String getDefaultShapefileExportFileName(String chartName, MapBlock mapBlock) {
        if (chartName != null && !"".equals(chartName.trim()) && mapBlock != null) {
            String filename = chartName + "_" + mapBlock.getTemplate().getName();
            return filename.replace(' ', '-');
        }
        return "export";
    }
}

