/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogAgeCurve;
import jsbugs.DialogAgeCurveReader;
import jsbugs.DialogTSCAgeCurveReader;
import jsbugs.FrameJsbugs;
import model3.AgeCurve;
import model3.Lastval;
import model3.SBRestrictable;
import model3.SBdb;
import model3.TSCreatorReader;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;

public class DialogAgeCurves
extends JDialog {
    private final SBdb db;
    private final TableModelAgeCurves model;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonRead;
    private JScrollPane jScrollPane1;
    private JTable jTableAgeCurves;

    public DialogAgeCurves(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.model = new TableModelAgeCurves(this.db);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Age Curves");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        try {
            this.model.setAgeCurves();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error loading age curves", sql, this.db);
        }
        this.model.setupTable(this.jTableAgeCurves);
        this.jTableAgeCurves.setRowSorter(new TableRowSorter<TableModelAgeCurves>(this.model));
        new ColumnSortResetHandler(this.jTableAgeCurves).attach();
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonRead.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableAgeCurves = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(550, 200));
        this.jTableAgeCurves.setModel(this.model);
        this.jTableAgeCurves.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogAgeCurves this$0;
            {
                DialogAgeCurves dialogAgeCurves = this$0;
                Objects.requireNonNull(dialogAgeCurves);
                this.this$0 = dialogAgeCurves;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableAgeCurvesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableAgeCurves);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurves this$0;
            {
                DialogAgeCurves dialogAgeCurves = this$0;
                Objects.requireNonNull(dialogAgeCurves);
                this.this$0 = dialogAgeCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Add new curve from file");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurves this$0;
            {
                DialogAgeCurves dialogAgeCurves = this$0;
                Objects.requireNonNull(dialogAgeCurves);
                this.this$0 = dialogAgeCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected curve from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurves this$0;
            {
                DialogAgeCurves dialogAgeCurves = this$0;
                Objects.requireNonNull(dialogAgeCurves);
                this.this$0 = dialogAgeCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurves this$0;
            {
                DialogAgeCurves dialogAgeCurves = this$0;
                Objects.requireNonNull(dialogAgeCurves);
                this.this$0 = dialogAgeCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAgeCurves this$0;
            {
                DialogAgeCurves dialogAgeCurves = this$0;
                Objects.requireNonNull(dialogAgeCurves);
                this.this$0 = dialogAgeCurves;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 581, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonDelete, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRead, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, -2, 75, -2).addComponent(this.jButtonClose, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE)).addComponent(this.jButtonHelp)).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 213, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 80, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonReadActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.db, "WINAGECURV", "UNXAGECURV"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter("csv", "General CSV files");
        jFileChooser.addChoosableFileFilter((FileFilter)filter);
        filter = new SbugsFileFilter("txt", "Timescale Creator files");
        jFileChooser.addChoosableFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                Lastval.putString(this.db, "WINAGECURV", "UNXAGECURV", file.getPath());
                this.db.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            System.out.println("Fie Name selected: " + file.getName());
            AgeCurve curve = null;
            if (file.getName().toLowerCase().endsWith(".txt")) {
                TSCreatorReader tscReader;
                try {
                    tscReader = new TSCreatorReader(this.db, file.getPath());
                }
                catch (IOException | SBException ioe) {
                    StackError.showStackError((String)"Error reading file", (Throwable)ioe);
                    return;
                }
                DialogTSCAgeCurveReader dialog = new DialogTSCAgeCurveReader((Dialog)this, true, this.db, tscReader);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    curve = new AgeCurve(dialog.curve, dialog.units, dialog.colour, dialog.style, dialog.lineWidth, dialog.schID);
                }
            } else {
                DialogAgeCurveReader dialog = new DialogAgeCurveReader(this, true, this.db, file.getPath());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        curve = new AgeCurve(file, dialog.title, dialog.units, dialog.colour, dialog.style, dialog.lineWidth, dialog.schID);
                    }
                    catch (IOException ioe) {
                        StackError.showStackError((String)"Error reading file", (Throwable)ioe);
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
            if (curve == null) {
                return;
            }
            try {
                this.db.addAgeCurve(curve);
                this.db.commit();
                this.model.fireTableDataChanged();
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (SBPermissionException pe) {
                JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableAgeCurves.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No curves selected", this.getTitle(), 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int[] selection = this.jTableAgeCurves.getSelectedRows();
            LinkedList<AgeCurve> toDelete = new LinkedList<AgeCurve>();
            for (int i = 0; i < selection.length; ++i) {
                toDelete.add(this.model.ageCurves.get(this.jTableAgeCurves.convertRowIndexToModel(selection[i])));
            }
            int opt = JOptionPane.showConfirmDialog(this, "Really delete " + (toDelete.size() == 1 ? "this curve?" : "these curves?"), this.getTitle(), 0, 3);
            if (opt != 0) {
                return;
            }
            for (AgeCurve ageCurve : toDelete) {
                this.db.deleteAgeCurve(ageCurve.getCurveID());
                this.model.ageCurves.remove(ageCurve);
            }
            this.db.commit();
            this.model.fireTableDataChanged();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableAgeCurves.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No curve selected", this.getTitle(), 1);
            return;
        }
        if (this.jTableAgeCurves.getSelectedRowCount() > 1) {
            JOptionPane.showMessageDialog(this, "Select one curve to edit", this.getTitle(), 1);
            return;
        }
        AgeCurve curve = this.model.ageCurves.get(this.jTableAgeCurves.convertRowIndexToModel(this.jTableAgeCurves.getSelectedRow()));
        DialogAgeCurve dialog = new DialogAgeCurve(this, true, curve, this.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.model.fireTableDataChanged();
        }
    }

    private void jTableAgeCurvesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtoaddagecurves.html");
    }

    private static class TableModelAgeCurves
    extends AbstractTableModel {
        List<AgeCurve> ageCurves;
        SBdb db;
        static String[] titles = new String[]{"Title", "Units", "Youngest", "Oldest", "Scheme"};
        static int[] widths = new int[]{60, 20, 20, 20, 60, 60};
        static final int COL_TITLE = 0;
        static final int COL_UNITS = 1;
        static final int COL_YOUNG = 2;
        static final int COL_OLD = 3;
        static final int COL_SCHEME = 4;

        TableModelAgeCurves(SBdb db) {
            this.db = db;
        }

        @Override
        public int getColumnCount() {
            return titles.length;
        }

        @Override
        public int getRowCount() {
            if (this.ageCurves == null) {
                return 0;
            }
            return this.ageCurves.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            AgeCurve ageCurve = this.ageCurves.get(row);
            switch (col) {
                case 0: {
                    return ageCurve.getTitle();
                }
                case 1: {
                    return ageCurve.getUnits();
                }
                case 2: {
                    if (ageCurve.getYoungest() == null) {
                        return "";
                    }
                    return SB.floatString((double)ageCurve.getYoungest(), (int)3);
                }
                case 3: {
                    if (ageCurve.getOldest() == null) {
                        return "";
                    }
                    return SB.floatString((double)ageCurve.getOldest(), (int)3);
                }
                case 4: {
                    try {
                        return this.db.getIGDScheme(ageCurve.getSchID()).toString();
                    }
                    catch (Exception e) {
                        System.out.println("Error getting IGD scheme: " + String.valueOf(e));
                        e.printStackTrace();
                    }
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                default: 
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                default: 
            }
            return String.class;
        }

        void setAgeCurves() throws SQLException {
            this.ageCurves = this.db.getAgeCurves();
        }

        void setupTable(JTable jTable) {
            SB.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < titles.length; ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(titles[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
            }
        }
    }
}

