/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.DialogSelectSample;
import jsbugs.DialogSource;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.DialogSelectAnalyst;
import model3.AnalystHeader;
import model3.EnvScheme;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogAnalysis
extends SBDialog {
    private static final int WEIGHTLEN = 11;
    private static final int SPLITLEN = 5;
    private static final int USRIDLEN = 5;
    private static final int SOURCEIDLEN = 5;
    private static final int FOVLEN = 3;
    private static final int NOTLEN = 240;
    private static final int LEN_LABEL = 15;
    private static final String selectString = "<select>";
    private final DefaultComboBoxModel modelProximal = new DefaultComboBoxModel();
    private final DefaultComboBoxModel modelDistal = new DefaultComboBoxModel();
    private final SBdb db;
    private final Sample sample;
    private Sample newSample;
    private final Well well;
    private final AnalystHeader analyHdr;
    private final char units;
    private EnvScheme envScheme;
    Smpdtl smpdtl;
    private ButtonGroup buttonGroupStatus;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonPickers;
    private JButton jButtonSample;
    private JButton jButtonSources;
    private JComboBox jComboBoxDistal;
    private JComboBox jComboBoxProximal;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButtonAnalysed;
    private JRadioButton jRadioButtonBarren;
    private JRadioButton jRadioButtonPrepared;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextArea jTextAreaNotes;
    private JTextField jTextFieldAnalyNo;
    private JTextField jTextFieldAnalyst;
    private JTextField jTextFieldCoarse;
    private JTextField jTextFieldCreated;
    private JTextField jTextFieldCreator;
    private JTextField jTextFieldDiscipline;
    private JTextField jTextFieldDistal;
    private JTextField jTextFieldFOV;
    private JTextField jTextFieldFine;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldMedium;
    private JTextField jTextFieldModified;
    private JTextField jTextFieldModifier;
    private JTextField jTextFieldPicker;
    private JTextField jTextFieldProximal;
    private JTextField jTextFieldSample;
    private JTextField jTextFieldSource;
    private JTextField jTextFieldWeight;

    public DialogAnalysis(Frame parent, boolean modal, SBdb db, Well well, Sample sample, Smpdtl smpdtl, AnalystHeader analyHdr, char units) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.sample = sample;
        this.smpdtl = smpdtl;
        this.well = well;
        this.db = db;
        this.analyHdr = analyHdr;
        this.units = units;
        this.init();
    }

    private void init() throws SQLException, SBException {
        Discipline discID;
        this.jTextFieldSample.setText(this.sample.toString(this.units));
        if (this.analyHdr.getEnvSchID() > 0) {
            this.envScheme = this.db.getEnvScheme(this.analyHdr.getEnvSchID());
        }
        this.setUpEnvPanel();
        if (this.smpdtl == null) {
            this.setTitle("Analysis : Add");
            discID = this.analyHdr == null ? this.db.getUser().getDiscipline() : this.analyHdr.getDiscipline();
            this.jTextFieldDiscipline.setText(discID.getNoun());
            if (this.analyHdr != null) {
                this.jTextFieldAnalyst.setText(this.analyHdr.getAnalyst());
                this.jTextFieldAnalyNo.setText("" + this.analyHdr.getAnalyNumber());
            }
        } else {
            this.setTitle("Analysis : Edit");
            discID = Discipline.getDisc((char)this.smpdtl.getDiscID());
            this.jTextFieldDiscipline.setText(discID.getNoun());
            this.jTextFieldAnalyst.setText(this.smpdtl.getAnalystAbr());
            this.jTextFieldAnalyNo.setText("" + this.smpdtl.getAnalyNo());
            this.jTextFieldLabel.setText(this.smpdtl.getLabel());
            this.jTextFieldPicker.setText(this.smpdtl.getPicker());
            this.jTextFieldSource.setText(this.smpdtl.getSource());
            this.jTextAreaNotes.setText(this.smpdtl.getNotes());
            if (this.smpdtl.getModified() != null) {
                this.jTextFieldModified.setText(SB.df.format(this.smpdtl.getModified()));
            }
            if (this.smpdtl.getModifierID() > 0) {
                this.jTextFieldModifier.setText(this.db.getUser(this.smpdtl.getModifierID()).getAbr());
            }
            if (this.sample.getCreated() != null) {
                this.jTextFieldCreated.setText(SB.df.format(this.sample.getCreated()));
            }
            if (this.sample.getCreatorID() > 0) {
                this.jTextFieldCreator.setText(this.db.getUser(this.sample.getCreatorID()).getAbr());
            }
            this.jTextFieldWeight.setText((String)(this.smpdtl.getWeight() == 0.0f ? "" : "" + this.smpdtl.getWeight()));
            if (this.smpdtl.getCoarse() == 0.0f && this.smpdtl.getMedium() == 0.0f && this.smpdtl.getFine() == 0.0f) {
                this.jTextFieldCoarse.setText("");
                this.jTextFieldMedium.setText("");
                this.jTextFieldFine.setText("");
            } else {
                this.jTextFieldCoarse.setText("" + this.smpdtl.getCoarse());
                this.jTextFieldMedium.setText("" + this.smpdtl.getMedium());
                this.jTextFieldFine.setText("" + this.smpdtl.getFine());
            }
            if (this.smpdtl.getFOV() == 0) {
                this.jTextFieldFOV.setText("");
            } else {
                this.jTextFieldFOV.setText("" + this.smpdtl.getFOV());
            }
            if (this.envScheme != null) {
                this.jComboBoxProximal.setSelectedIndex(this.smpdtl.getProximal());
                this.jComboBoxDistal.setSelectedIndex(this.smpdtl.getDistal());
            }
            if (this.smpdtl.getBarren()) {
                this.jRadioButtonBarren.setSelected(true);
            } else if (this.smpdtl.isAnalysed()) {
                this.jRadioButtonAnalysed.setSelected(true);
            } else {
                this.jRadioButtonPrepared.setSelected(true);
            }
        }
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
        } else if (this.db.restrictedToDiscID(discID)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText("You can only add/edit data within: " + this.db.getUser().getDiscipline().getNoun());
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void setUpEnvPanel() {
        if (this.envScheme == null) {
            this.jComboBoxDistal.setEnabled(false);
            this.jComboBoxProximal.setEnabled(false);
        } else {
            this.modelDistal.addElement(selectString);
            this.modelProximal.addElement(selectString);
            for (int i = 1; i < this.envScheme.getNClasses() + 1; ++i) {
                String term = this.envScheme.getTerm(i);
                this.modelDistal.addElement(term);
                this.modelProximal.addElement(term);
            }
            this.modelDistal.setSelectedItem(selectString);
            this.modelProximal.setSelectedItem(selectString);
        }
    }

    private void initComponents() {
        this.buttonGroupStatus = new ButtonGroup();
        this.jSeparator1 = new JSeparator();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaNotes = new JTextArea();
        this.jLabel5 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jTextFieldCoarse = new JTextField();
        this.jTextFieldMedium = new JTextField();
        this.jTextFieldFine = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jTextFieldWeight = new JTextField();
        this.jLabel18 = new JLabel();
        this.jTextFieldFOV = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jTextFieldCreated = new JTextField();
        this.jLabel12 = new JLabel();
        this.jTextFieldCreator = new JTextField();
        this.jLabel11 = new JLabel();
        this.jTextFieldModified = new JTextField();
        this.jLabel13 = new JLabel();
        this.jTextFieldModifier = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jComboBoxProximal = new JComboBox();
        this.jComboBoxDistal = new JComboBox();
        this.jTextFieldProximal = new JTextField();
        this.jTextFieldDistal = new JTextField();
        this.jPanel4 = new JPanel();
        this.jTextFieldAnalyNo = new JTextField();
        this.jTextFieldDiscipline = new JTextField();
        this.jTextFieldAnalyst = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldSample = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldPicker = new JTextField();
        this.jTextFieldSource = new JTextField();
        this.jButtonPickers = new JButton();
        this.jButtonSources = new JButton();
        this.jButtonSample = new JButton();
        this.jLabel19 = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jRadioButtonPrepared = new JRadioButton();
        this.jRadioButtonAnalysed = new JRadioButton();
        this.jRadioButtonBarren = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 500));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jTextAreaNotes.setColumns(20);
        this.jTextAreaNotes.setLineWrap(true);
        this.jTextAreaNotes.setRows(2);
        this.jTextAreaNotes.setWrapStyleWord(true);
        this.jTextAreaNotes.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextAreaNotesKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaNotes);
        this.jLabel5.setForeground(new Color(51, 102, 204));
        this.jLabel5.setText("Notes:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Details & Split Factors", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jTextFieldCoarse.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldCoarseKeyTyped(evt);
            }
        });
        this.jTextFieldMedium.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldMediumKeyTyped(evt);
            }
        });
        this.jTextFieldFine.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldFineKeyTyped(evt);
            }
        });
        this.jLabel6.setText("Coarse:");
        this.jLabel7.setText("Medium:");
        this.jLabel8.setText("Fine:");
        this.jLabel9.setText("Weight:");
        this.jTextFieldWeight.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldWeightKeyTyped(evt);
            }
        });
        this.jLabel18.setText("Fields of view:");
        this.jTextFieldFOV.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldFOVKeyTyped(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel9).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel7).add((Component)this.jLabel8)).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldFine, -1, 118, Short.MAX_VALUE).add((Component)this.jTextFieldMedium, -1, 118, Short.MAX_VALUE).add(2, (Component)this.jTextFieldCoarse, -1, 118, Short.MAX_VALUE).add(2, (Component)this.jTextFieldWeight, -1, 118, Short.MAX_VALUE))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel18).addPreferredGap(0).add((Component)this.jTextFieldFOV, -1, 89, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.jTextFieldWeight, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldCoarse, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jTextFieldMedium, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.jTextFieldFine, -2, -1, -2)).addPreferredGap(0, 17, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel18).add((Component)this.jTextFieldFOV, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Dates", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel10.setText("Created:");
        this.jTextFieldCreated.setEditable(false);
        this.jLabel12.setText("By user:");
        this.jTextFieldCreator.setEditable(false);
        this.jLabel11.setText("Modified:");
        this.jTextFieldModified.setEditable(false);
        this.jLabel13.setText("By user:");
        this.jTextFieldModifier.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel13).add((Component)this.jLabel11).add((Component)this.jLabel12).add((Component)this.jLabel10)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jTextFieldModifier, -1, 112, Short.MAX_VALUE).add((Component)this.jTextFieldModified, -1, 112, Short.MAX_VALUE).add((Component)this.jTextFieldCreator, -1, 112, Short.MAX_VALUE).add(2, (Component)this.jTextFieldCreated, -1, 112, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldCreated, -2, -1, -2).add((Component)this.jLabel10)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.jTextFieldCreator, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.jTextFieldModified, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldModifier, -2, -1, -2).add((Component)this.jLabel13)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Palaeoenvironments", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel16.setText("Proximal:");
        this.jLabel17.setText("Distal:");
        this.jComboBoxProximal.setModel(this.modelProximal);
        this.jComboBoxProximal.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxProximal.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxProximalActionPerformed(evt);
            }
        });
        this.jComboBoxDistal.setModel(this.modelDistal);
        this.jComboBoxDistal.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxDistal.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxDistalActionPerformed(evt);
            }
        });
        this.jTextFieldProximal.setEditable(false);
        this.jTextFieldDistal.setEditable(false);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(2).add((Component)this.jLabel17).add((Component)this.jLabel16)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1, false).add((Component)this.jComboBoxDistal, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxProximal, -2, 158, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jTextFieldProximal, -1, 23, Short.MAX_VALUE).add((Component)this.jTextFieldDistal, -1, 23, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel16).add((Component)this.jComboBoxProximal, -2, -1, -2).add((Component)this.jTextFieldProximal, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel17).add((Component)this.jComboBoxDistal, -2, -1, -2).add((Component)this.jTextFieldDistal, -2, -1, -2)).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Analysis", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jTextFieldAnalyNo.setEditable(false);
        this.jTextFieldAnalyNo.setBackground(new Color(255, 255, 204));
        this.jTextFieldAnalyNo.setText("1");
        this.jTextFieldAnalyNo.setToolTipText("");
        this.jTextFieldDiscipline.setEditable(false);
        this.jTextFieldDiscipline.setBackground(new Color(255, 255, 204));
        this.jTextFieldAnalyst.setEditable(false);
        this.jTextFieldAnalyst.setBackground(new Color(255, 255, 204));
        this.jLabel2.setText("Analyst:");
        this.jTextFieldSample.setEditable(false);
        this.jTextFieldSample.setBackground(new Color(255, 255, 204));
        this.jLabel14.setText("Discipline:");
        this.jLabel1.setText("Sample:");
        this.jLabel15.setText("Suite:");
        this.jLabel3.setText("Prepared by:");
        this.jLabel4.setText("Source:");
        this.jTextFieldPicker.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldPickerKeyTyped(evt);
            }
        });
        this.jTextFieldSource.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldSourceKeyTyped(evt);
            }
        });
        this.jButtonPickers.setText("...");
        this.jButtonPickers.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonPickers.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPickersActionPerformed(evt);
            }
        });
        this.jButtonSources.setText("...");
        this.jButtonSources.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSources.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSourcesActionPerformed(evt);
            }
        });
        this.jButtonSample.setText("...");
        this.jButtonSample.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSampleActionPerformed(evt);
            }
        });
        this.jLabel19.setHorizontalAlignment(11);
        this.jLabel19.setText("Label:");
        this.jTextFieldLabel.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalysis this$0;
            {
                DialogAnalysis dialogAnalysis = this$0;
                Objects.requireNonNull(dialogAnalysis);
                this.this$0 = dialogAnalysis;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldLabelKeyTyped(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add(26, 26, 26).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2).add((Component)this.jLabel15).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.jLabel14)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1, false).add((Component)this.jTextFieldAnalyst, -2, 66, -2).add((Component)this.jTextFieldAnalyNo, -2, 37, -2).add((Component)this.jTextFieldDiscipline, -1, 168, Short.MAX_VALUE).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jTextFieldSample).addPreferredGap(0).add((Component)this.jButtonSample, -2, 36, -2)))).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel4))).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add(16, 16, 16).add((Component)this.jLabel19, -2, 60, -2))).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jTextFieldLabel, -2, 126, -2).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1, false).add((Component)this.jTextFieldSource).add((Component)this.jTextFieldPicker, -2, 126, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1, false).add((Component)this.jButtonPickers, 0, 0, Short.MAX_VALUE).add((Component)this.jButtonSources, -2, 36, -2)))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel14).add((Component)this.jTextFieldDiscipline, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldSample, -2, -1, -2).add((Component)this.jButtonSample)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldAnalyst, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jTextFieldAnalyNo, -2, -1, -2).add((Component)this.jLabel15)).addPreferredGap(0, 11, Short.MAX_VALUE).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jTextFieldLabel, -2, -1, -2).add((Component)this.jLabel19)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jTextFieldPicker, -2, -1, -2).add((Component)this.jLabel3)).add((Component)this.jButtonPickers)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jTextFieldSource, -2, -1, -2).add((Component)this.jLabel4).add((Component)this.jButtonSources)).addContainerGap()));
        jPanel4Layout.linkSize(new Component[]{this.jTextFieldDiscipline, this.jTextFieldSample}, 2);
        this.buttonGroupStatus.add(this.jRadioButtonPrepared);
        this.jRadioButtonPrepared.setSelected(true);
        this.jRadioButtonPrepared.setText("Prepared");
        this.buttonGroupStatus.add(this.jRadioButtonAnalysed);
        this.jRadioButtonAnalysed.setText("Analysed");
        this.buttonGroupStatus.add(this.jRadioButtonBarren);
        this.jRadioButtonBarren.setText("Barren");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1).add((Component)this.jSeparator2).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1, -2, -1, -2).add(241, 241, 241).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp, -2, 69, -2).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonPrepared).addPreferredGap(1).add((Component)this.jRadioButtonAnalysed).addPreferredGap(1).add((Component)this.jRadioButtonBarren)))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel5).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel4, -2, -1, -2).add((Component)this.jPanel3, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -2, -1, -2).add((Component)this.jPanel1, -2, -1, -2)))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.linkSize(new Component[]{this.jRadioButtonAnalysed, this.jRadioButtonBarren, this.jRadioButtonPrepared}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2))).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonBarren).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jRadioButtonPrepared).add((Component)this.jRadioButtonAnalysed))).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 71, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jSeparator2, -2, 8, -2).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jSeparator1, -2, 10, -2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonHelp).add((Component)this.jButtonOK).add((Component)this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jTextAreaNotesKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaNotes, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonPickersActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.db, true);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.selectedUser != null) {
                this.jTextFieldPicker.setText(dialog.selectedUser.getAbr());
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jTextFieldSourceKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldPicker, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldPickerKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldPicker, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldFineKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldFine, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMediumKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMedium, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCoarseKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldCoarse, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldWeightKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldWeight, (int)11, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int distal;
        String notes;
        String label = this.jTextFieldLabel.getText().trim();
        String picker = this.jTextFieldPicker.getText().trim();
        String source = this.jTextFieldSource.getText().trim();
        float weight = 0.0f;
        float coarse = 0.0f;
        float medium = 0.0f;
        float fine = 0.0f;
        int fov = 0;
        if (this.jTextFieldWeight.getText().length() > 0) {
            weight = Float.parseFloat(this.jTextFieldWeight.getText());
        }
        if (this.jTextFieldCoarse.getText().length() > 0) {
            coarse = Float.parseFloat(this.jTextFieldCoarse.getText());
        }
        if (this.jTextFieldMedium.getText().length() > 0) {
            medium = Float.parseFloat(this.jTextFieldMedium.getText());
        }
        if (this.jTextFieldFine.getText().length() > 0) {
            fine = Float.parseFloat(this.jTextFieldFine.getText());
        }
        if ((notes = this.jTextAreaNotes.getText().trim()).length() > 240) {
            notes = notes.substring(0, 240);
        }
        Smpdtl.AnalysisType analysisType = this.jRadioButtonBarren.isSelected() ? Smpdtl.AnalysisType.BARREN : (this.jRadioButtonAnalysed.isSelected() ? Smpdtl.AnalysisType.ANALYSED : Smpdtl.AnalysisType.PREPARED);
        int proximal = this.jComboBoxProximal.getSelectedIndex();
        if (proximal < 0) {
            proximal = 0;
        }
        if ((distal = this.jComboBoxDistal.getSelectedIndex()) < 0) {
            distal = 0;
        }
        if (proximal != 0 && distal == 0 || distal != 0 && proximal == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Proximal and distal must both be set", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldFOV.getText().length() > 0) {
            fov = Integer.parseInt(this.jTextFieldFOV.getText());
        }
        try {
            if (this.smpdtl == null) {
                if (this.newSample == null) {
                    this.newSample = this.sample;
                }
                try {
                    this.smpdtl = this.newSample.addDtl(this.well.getWellID(), this.analyHdr, analysisType, label, picker, source, notes, weight, coarse, medium, fine, proximal, distal, fov);
                }
                catch (SBException sbe) {
                    Object msg = sbe.getMessage();
                    String s = "Cannot add analysis: ";
                    msg = ((String)msg).startsWith("Duplicate analyst ID") ? s + "this analysis already exists" : s + (String)msg;
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 0);
                    return;
                }
                this.well.setDataChanged();
            } else {
                boolean changed = false;
                boolean clearOccs = false;
                if (analysisType == Smpdtl.AnalysisType.BARREN && !this.smpdtl.getBarren()) {
                    changed = true;
                    if (this.smpdtl.getNOccs() > 0) {
                        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Clear occurrences?", this.getTitle(), 1, 3);
                        if (opt == 2) {
                            return;
                        }
                        clearOccs = opt == 0;
                    }
                } else if (analysisType != this.smpdtl.getAnalysisType()) {
                    changed = true;
                }
                if (this.newSample != null && this.newSample != this.sample) {
                    Smpdtl newSmpdtl;
                    try {
                        newSmpdtl = this.newSample.addDtl(this.well.getWellID(), this.analyHdr, analysisType, label, picker, source, notes, weight, coarse, medium, fine, proximal, distal, fov);
                    }
                    catch (SBException sbe) {
                        Object msg = sbe.getMessage();
                        String s = "Cannot add analysis: ";
                        msg = ((String)msg).startsWith("Duplicate analyst ID") ? s + "this analysis already exists" : s + (String)msg;
                        JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 0);
                        return;
                    }
                    this.smpdtl.copyOccs(this.well.getWellID(), newSmpdtl);
                    this.sample.deleteDtl(this.well.getWellID(), this.smpdtl.getAnalyID(), this.smpdtl);
                    this.smpdtl = newSmpdtl;
                    this.well.setDataChanged();
                } else {
                    this.newSample = this.sample;
                    if (!changed) {
                        changed = this.hasChanged(label, picker, source, notes, weight, coarse, medium, fine, proximal, distal, fov);
                    }
                    if (changed) {
                        this.newSample.updateDtl(this.well.getWellID(), this.smpdtl, this.analyHdr, analysisType, clearOccs, label, picker, source, notes, weight, coarse, medium, fine, proximal, distal, fov);
                        this.smpdtl.notifyObservers();
                        this.well.setDataChanged();
                    }
                }
            }
            this.newSample.notifyObservers();
            this.well.notifyObservers((Object)this.smpdtl);
            this.db.commit();
            this.setOK();
        }
        catch (SQLException sqle) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sqle, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoganalysis.html");
    }

    private void jButtonSourcesActionPerformed(ActionEvent evt) {
        try {
            DialogSource dialog = new DialogSource((JDialog)((Object)this), true, this.db);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.jTextFieldSource.setText(dialog.selection.getID());
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jComboBoxDistalActionPerformed(ActionEvent evt) {
        this.setEnvColourField(false);
        if (this.jComboBoxProximal.getSelectedIndex() == 0) {
            this.jComboBoxProximal.setSelectedIndex(this.jComboBoxDistal.getSelectedIndex());
            this.setEnvColourField(true);
        }
    }

    private void jComboBoxProximalActionPerformed(ActionEvent evt) {
        this.setEnvColourField(true);
        if (this.jComboBoxDistal.getSelectedIndex() == 0) {
            this.jComboBoxDistal.setSelectedIndex(this.jComboBoxProximal.getSelectedIndex());
            this.setEnvColourField(false);
        }
    }

    private void jTextFieldFOVKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldFOV, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonSampleActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.sample, this.units, false);
            dialog.setLocation(this.jButtonSample.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.newSample = dialog.selection;
                this.jTextFieldSample.setText(this.newSample.toString(this.units));
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jTextFieldLabelKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldLabel, (int)15, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void setEnvColourField(boolean proximal) {
        try {
            String term = (String)(proximal ? this.jComboBoxProximal : this.jComboBoxDistal).getSelectedItem();
            if (term != null) {
                Color colour = term.equals(selectString) ? new Color(240, 240, 240) : this.envScheme.getColour(this.envScheme.getTermIndex(term));
                (proximal ? this.jTextFieldProximal : this.jTextFieldDistal).setBackground(colour);
            }
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
    }

    private boolean hasChanged(String label, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal, int fov) {
        if (this.smpdtl == null) {
            throw new IllegalStateException("Can't edit null analysis");
        }
        if (this.smpdtl.getLabel() == null && !label.isEmpty() || this.smpdtl.getLabel() != null && !picker.equals(this.smpdtl.getLabel())) {
            return true;
        }
        if (this.smpdtl.getPicker() == null && !picker.isEmpty() || this.smpdtl.getPicker() != null && !picker.equals(this.smpdtl.getPicker())) {
            return true;
        }
        if (this.smpdtl.getSource() == null && !source.isEmpty() || this.smpdtl.getSource() != null && !source.equals(this.smpdtl.getSource())) {
            return true;
        }
        if (this.smpdtl.getNotes() == null && !notes.isEmpty() || this.smpdtl.getNotes() != null && !notes.equals(this.smpdtl.getNotes())) {
            return true;
        }
        if (weight != this.smpdtl.getWeight() || fov != this.smpdtl.getFOV()) {
            return true;
        }
        if (coarse != this.smpdtl.getCoarse() || medium != this.smpdtl.getMedium() || fine != this.smpdtl.getFine()) {
            return true;
        }
        return proximal != this.smpdtl.getProximal() || distal != this.smpdtl.getDistal();
    }
}

