/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import jsbugs.DialogMergeOccurrences;
import model3.CoOccurrence;
import model3.SBdb;
import model3.Taxon;
import util.SBException;
import util.exception.StackError;

public class DialogAutoMergeTaxa
extends JDialog
implements PropertyChangeListener {
    SBdb db;
    TaxonMergeTask task;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonGo;
    private JLabel jLabel1;
    private JProgressBar jProgressBarTaxa;
    private JRadioButton jRadioButtonInCat;
    private JRadioButton jRadioButtonOutCat;

    public DialogAutoMergeTaxa(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.setTitle("Auto-Merge Taxa");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonGo = new JButton();
        this.jButtonCancel = new JButton();
        this.jProgressBarTaxa = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jRadioButtonInCat = new JRadioButton();
        this.jRadioButtonOutCat = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.jButtonGo.setText("Go");
        this.jButtonGo.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAutoMergeTaxa this$0;
            {
                DialogAutoMergeTaxa dialogAutoMergeTaxa = this$0;
                Objects.requireNonNull(dialogAutoMergeTaxa);
                this.this$0 = dialogAutoMergeTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGoActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAutoMergeTaxa this$0;
            {
                DialogAutoMergeTaxa dialogAutoMergeTaxa = this$0;
                Objects.requireNonNull(dialogAutoMergeTaxa);
                this.this$0 = dialogAutoMergeTaxa;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("<html>Use this utility to automatically merge equivalent taxa in your database. <br>\n<strong>Warning:</strong> back up your database before using!! <br>\n<br>\nCancel will <strong>NOT</strong> undo the changes.\n</html>");
        this.buttonGroup1.add(this.jRadioButtonInCat);
        this.jRadioButtonInCat.setSelected(true);
        this.jRadioButtonInCat.setText("Merge equivalent taxa WITHIN categories only");
        this.buttonGroup1.add(this.jRadioButtonOutCat);
        this.jRadioButtonOutCat.setText("Merge taxa between categories (use after the above, if necessary!)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jProgressBarTaxa, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonGo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jRadioButtonInCat).addComponent(this.jRadioButtonOutCat, -2, 367, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addComponent(this.jRadioButtonInCat).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonOutCat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBarTaxa, -2, 29, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonGo)).addGap(16, 16, 16)));
        this.pack();
    }

    private void jButtonGoActionPerformed(ActionEvent evt) {
        try {
            this.jButtonGo.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.db.loadTaxa();
            System.out.println("Taxa loaded: " + this.db.getTaxa().size());
            this.jProgressBarTaxa.setString("Processing: " + this.db.getTaxa().size() + " species");
            this.jProgressBarTaxa.setValue(0);
            this.jProgressBarTaxa.setStringPainted(true);
            this.task = new TaxonMergeTask(this, this.db, this.jRadioButtonInCat.isSelected(), this);
            this.task.addPropertyChangeListener(this);
            this.task.execute();
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            this.db.doRollback();
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            this.jProgressBarTaxa.setValue((Integer)evt.getNewValue());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.task != null) {
            this.task.cancel(true);
            this.task = null;
        }
        this.db.doRollback();
        this.dispose();
    }

    class TaxonMergeTask
    extends SwingWorker<Void, Void> {
        SBdb db;
        boolean withinCategory;
        BufferedWriter log;
        JDialog parent;
        final /* synthetic */ DialogAutoMergeTaxa this$0;

        TaxonMergeTask(DialogAutoMergeTaxa this$0, SBdb db, boolean cat, JDialog parent) {
            DialogAutoMergeTaxa dialogAutoMergeTaxa = this$0;
            Objects.requireNonNull(dialogAutoMergeTaxa);
            this.this$0 = dialogAutoMergeTaxa;
            this.db = db;
            this.withinCategory = cat;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void doInBackground() {
            HashSet<Integer> removed = new HashSet<Integer>();
            try {
                this.this$0.setCursor(Cursor.getPredefinedCursor(3));
                Statement stmt = this.db.getDatabase().createStatement();
                File fileName = new File("SbugsMerge.log");
                this.log = new BufferedWriter(new FileWriter(fileName, true));
                this.outLog("Start: " + new Date().toString());
                Collection<Taxon> taxa = this.db.getTaxa();
                double total = this.db.getTaxa().size();
                Iterator<Taxon> it = taxa.iterator();
                int n = 0;
                block9: while (it.hasNext() && !this.isCancelled()) {
                    Taxon taxon = it.next();
                    if (removed.contains(taxon.getSpecID())) continue;
                    double nProc = (double)n++ / total;
                    this.setProgress((int)(nProc * 100.0));
                    for (Taxon taxon2 : taxa) {
                        if (removed.contains(taxon2.getSpecID()) || taxon == taxon2 || taxon.getDisc() != taxon2.getDisc() || !taxon.toString(false, this.withinCategory).equals(taxon2.toString(false, this.withinCategory))) continue;
                        Taxon donor = null;
                        Taxon target = null;
                        if (taxon.getAuthor().length() > 0) {
                            if (taxon2.getAuthor().length() == 0) {
                                target = taxon;
                                donor = taxon2;
                            }
                        } else if (taxon2.getAuthor().length() > 0) {
                            target = taxon2;
                            donor = taxon;
                        }
                        if (donor == null) {
                            boolean taxon1Qual = false;
                            boolean taxon2Qual = false;
                            for (int i = 0; i < 8; ++i) {
                                if (taxon.getQualifier(i).hasQuals()) {
                                    taxon1Qual = true;
                                }
                                if (!taxon2.getQualifier(i).hasQuals()) continue;
                                taxon2Qual = true;
                            }
                            if (taxon1Qual && !taxon2Qual) {
                                donor = taxon2;
                                target = taxon;
                            } else if (taxon2Qual && !taxon1Qual) {
                                donor = taxon;
                                target = taxon2;
                            }
                        }
                        if (donor == null && taxon.getSubSpecies().length() > 0 && taxon2.getSubSpecies().length() == 0) {
                            donor = taxon2;
                            target = taxon;
                        }
                        if (donor == null && taxon.getSubGenus().length() > 0 && taxon2.getSubGenus().length() == 0) {
                            donor = taxon2;
                            target = taxon;
                        }
                        if (donor == null && (taxon.getAlphaCode() == null || taxon.getAlphaCode().length() == 0) && taxon2.getAlphaCode() != null && taxon2.getAlphaCode().length() > 0) {
                            donor = taxon2;
                            target = taxon;
                        }
                        int donorOcc = -1;
                        int targetOcc = -1;
                        if (donor == null) {
                            int occ1 = taxon.checkOcc(false);
                            int occ2 = taxon2.checkOcc(false);
                            if (occ2 > occ1) {
                                donor = taxon;
                                donorOcc = occ1;
                                target = taxon2;
                                targetOcc = occ2;
                            } else {
                                target = taxon;
                                donor = taxon2;
                                donorOcc = occ2;
                                targetOcc = occ1;
                            }
                        }
                        this.outLog("Removing      : " + donor.toString(true, false, true) + "\t\t ID=" + donor.getSpecID() + "\t(Number of Occurrences: " + (donorOcc >= 0 ? donorOcc : donor.checkOcc(false)) + ")");
                        this.outLog("Replacing with: " + target.toString(true, false, true) + "\t\t ID=" + target.getSpecID() + "\t(Number of Occurrences: " + (targetOcc >= 0 ? targetOcc : target.checkOcc(false)) + ")");
                        try {
                            this.db.mergeTaxa(donor, target, -1, 0);
                        }
                        catch (SBException ex) {
                            if (ex.getData() != null) {
                                List coOccs = (List)ex.getData();
                                for (CoOccurrence coOcc : coOccs) {
                                    if (coOcc.donor.getSpecID() != donor.getSpecID()) {
                                        throw new SBException("Error in getting coOccurrences: donor: " + coOcc.donor.getSpecID() + " / " + donor.getSpecID());
                                    }
                                    if (coOcc.target.getSpecID() == target.getSpecID()) continue;
                                    throw new SBException("Error in getting coOccurrences: target: " + coOcc.target.getSpecID() + " / " + target.getSpecID());
                                }
                                DialogMergeOccurrences dialog = new DialogMergeOccurrences(this.parent, true, this.db, coOccs);
                                dialog.setLocationRelativeTo(this.parent);
                                dialog.setVisible(true);
                                if (!dialog.isOK()) {
                                    throw new SBException("Merger Cancelled");
                                }
                                this.db.mergeTaxa(donor, target, -1, 0);
                            }
                            throw ex;
                        }
                        this.outLog(".");
                        removed.add(donor.getSpecID());
                        continue block9;
                    }
                }
                if (this.isCancelled()) {
                    this.db.doRollback();
                    System.out.println("Task Cancelled!");
                } else {
                    this.db.commit();
                    this.setProgress(100);
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(null, "Task complete: " + removed.size() + " species merged. See '" + fileName.getPath() + "' for details", "Auto Merge species", 1);
                }
            }
            catch (Exception ex) {
                this.db.doRollback();
                StackError.showStackError((String)ex.toString(), (Throwable)ex);
            }
            finally {
                this.this$0.setCursor(Cursor.getDefaultCursor());
            }
            try {
                this.outLog("Species removed: " + String.valueOf(removed));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }

        @Override
        public void done() {
            this.this$0.jButtonGo.setEnabled(true);
            this.this$0.jButtonCancel.setText("Close");
            this.this$0.setCursor(Cursor.getDefaultCursor());
            System.out.println("Done!");
            if (this.log != null) {
                try {
                    this.outLog("Finish: " + new Date().toString());
                    this.log.flush();
                    this.log.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        void outLog(String strg) throws IOException {
            System.out.println(strg);
            this.log.write(strg + "\n");
        }
    }
}

