/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.DialogFilePreview;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.DialogSelectAnalyst;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;

public class DialogBugWareReader
extends JDialog {
    SBdb db;
    String fileName;
    boolean isOK;
    boolean ignoreSemiQuant;
    boolean useBioStratComments;
    boolean usePrimaryEvents;
    EventType eventType = null;
    boolean useSampleLithology;
    boolean useSampleTops;
    char units;
    char discID;
    Userdef analyst = null;
    private ButtonGroup buttonGroupComments;
    private ButtonGroup buttonGroupDisc;
    private ButtonGroup buttonGroupEventSelection;
    private ButtonGroup buttonGroupEventType;
    private ButtonGroup buttonGroupLithology;
    private ButtonGroup buttonGroupSamples;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonPreview;
    private JButton jButtonSelectAnalyst;
    private JCheckBox jCheckBoxIgnoreSemiQuant;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JRadioButton jRadioButtonAnalysisComments1;
    private JRadioButton jRadioButtonBase;
    private JRadioButton jRadioButtonBiostratComments1;
    private JRadioButton jRadioButtonEventBase;
    private JRadioButton jRadioButtonEventSingle;
    private JRadioButton jRadioButtonEventTop;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonLithologyAsComments;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JRadioButton jRadioButtonPrimeComments;
    private JRadioButton jRadioButtonPrimeEvents;
    private JRadioButton jRadioButtonSampleLithology;
    private JRadioButton jRadioButtonTop;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDbAnalyst;
    private JTextField jTextFieldFileAnalyst;

    public DialogBugWareReader(Frame parent, boolean modal, SBdb db, String fileName) {
        super(parent, modal);
        this.db = db;
        this.fileName = fileName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("BugWare File Import Parameters");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.db.useSampleTops()) {
            this.jRadioButtonTop.setSelected(true);
        } else {
            this.jRadioButtonBase.setSelected(true);
        }
        if (this.fileName != null && this.fileName.toLowerCase().endsWith("def")) {
            this.jRadioButtonMicro.setSelected(true);
        } else if (this.fileName != null && this.fileName.toLowerCase().endsWith("den")) {
            this.jRadioButtonNanno.setSelected(true);
        }
        try {
            String buff;
            BufferedReader in = new BufferedReader(new FileReader(this.fileName));
            while ((buff = in.readLine()) != null) {
                if (!buff.toUpperCase().startsWith("PALEONTOLOGIST:")) continue;
                this.jTextFieldFileAnalyst.setText(buff.substring(buff.indexOf(58) + 1).trim());
                break;
            }
            in.close();
        }
        catch (Exception eio) {
            JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage(), this.getTitle(), 0);
            eio.printStackTrace();
        }
        this.setEventTypeControls(false);
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupDisc = new ButtonGroup();
        this.buttonGroupComments = new ButtonGroup();
        this.buttonGroupSamples = new ButtonGroup();
        this.buttonGroupLithology = new ButtonGroup();
        this.buttonGroupEventType = new ButtonGroup();
        this.buttonGroupEventSelection = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMicro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonPaly = new JRadioButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.jRadioButtonSampleLithology = new JRadioButton();
        this.jRadioButtonLithologyAsComments = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonPreview = new JButton();
        this.jCheckBoxIgnoreSemiQuant = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jTextFieldFileAnalyst = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonSelectAnalyst = new JButton();
        this.jTextFieldDbAnalyst = new JTextField();
        this.jPanel4 = new JPanel();
        this.jRadioButtonTop = new JRadioButton();
        this.jRadioButtonBase = new JRadioButton();
        this.jPanel6 = new JPanel();
        this.jRadioButtonAnalysisComments1 = new JRadioButton();
        this.jRadioButtonBiostratComments1 = new JRadioButton();
        this.jPanel7 = new JPanel();
        this.jRadioButtonPrimeEvents = new JRadioButton();
        this.jRadioButtonPrimeComments = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.jRadioButtonEventTop = new JRadioButton();
        this.jRadioButtonEventBase = new JRadioButton();
        this.jRadioButtonEventSingle = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Discipline", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupDisc.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Micropalaeontology");
        this.buttonGroupDisc.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nannopalaeontology");
        this.buttonGroupDisc.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Palynology");
        this.buttonGroupDisc.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macropalaeontology");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonMicro).add((Component)this.jRadioButtonNanno).add((Component)this.jRadioButtonPaly).add((Component)this.jRadioButtonMacro)).addContainerGap(36, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonMicro).addPreferredGap(1).add((Component)this.jRadioButtonNanno).addPreferredGap(1).add((Component)this.jRadioButtonPaly).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonMacro)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Depth units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonMetres).addPreferredGap(1).add((Component)this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Lithology processing", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupLithology.add(this.jRadioButtonSampleLithology);
        this.jRadioButtonSampleLithology.setText("Into sample lithology %");
        this.buttonGroupLithology.add(this.jRadioButtonLithologyAsComments);
        this.jRadioButtonLithologyAsComments.setText("Store lithology as comments");
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.jRadioButtonSampleLithology).add((Component)this.jRadioButtonLithologyAsComments)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonSampleLithology).addPreferredGap(1).add((Component)this.jRadioButtonLithologyAsComments).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBugWareReader this$0;
            {
                DialogBugWareReader dialogBugWareReader = this$0;
                Objects.requireNonNull(dialogBugWareReader);
                this.this$0 = dialogBugWareReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBugWareReader this$0;
            {
                DialogBugWareReader dialogBugWareReader = this$0;
                Objects.requireNonNull(dialogBugWareReader);
                this.this$0 = dialogBugWareReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBugWareReader this$0;
            {
                DialogBugWareReader dialogBugWareReader = this$0;
                Objects.requireNonNull(dialogBugWareReader);
                this.this$0 = dialogBugWareReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonPreview.setText("Preview...");
        this.jButtonPreview.setToolTipText("Preview file contents in separate window");
        this.jButtonPreview.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBugWareReader this$0;
            {
                DialogBugWareReader dialogBugWareReader = this$0;
                Objects.requireNonNull(dialogBugWareReader);
                this.this$0 = dialogBugWareReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPreviewActionPerformed(evt);
            }
        });
        this.jCheckBoxIgnoreSemiQuant.setText("Ignore semi-quantitative abundances");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Analyst", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jTextFieldFileAnalyst.setEditable(false);
        this.jTextFieldFileAnalyst.setBackground(new Color(255, 255, 204));
        this.jLabel1.setText("Analyst name in file header:");
        this.jLabel2.setText("Database analyst:");
        this.jButtonSelectAnalyst.setText("...");
        this.jButtonSelectAnalyst.setToolTipText("Select analyst");
        this.jButtonSelectAnalyst.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBugWareReader this$0;
            {
                DialogBugWareReader dialogBugWareReader = this$0;
                Objects.requireNonNull(dialogBugWareReader);
                this.this$0 = dialogBugWareReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectAnalystActionPerformed(evt);
            }
        });
        this.jTextFieldDbAnalyst.setEditable(false);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(2).add((Component)this.jTextFieldFileAnalyst).add(1, (Component)this.jLabel1).add(1, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jTextFieldDbAnalyst).addPreferredGap(0).add((Component)this.jButtonSelectAnalyst, -2, 30, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldFileAnalyst, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButtonSelectAnalyst).add((Component)this.jTextFieldDbAnalyst, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Samples with single depths", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupSamples.add(this.jRadioButtonTop);
        this.jRadioButtonTop.setText("Use as top depth");
        this.buttonGroupSamples.add(this.jRadioButtonBase);
        this.jRadioButtonBase.setText("Use as base depth");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jRadioButtonTop).add((Component)this.jRadioButtonBase)).addContainerGap(141, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonTop).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonBase).addContainerGap()));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, "Comments destination", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupComments.add(this.jRadioButtonAnalysisComments1);
        this.jRadioButtonAnalysisComments1.setText("Sample analyses");
        this.buttonGroupComments.add(this.jRadioButtonBiostratComments1);
        this.jRadioButtonBiostratComments1.setText("Biostratigraphic comments");
        GroupLayout jPanel6Layout = new GroupLayout((Container)this.jPanel6);
        this.jPanel6.setLayout((LayoutManager)jPanel6Layout);
        jPanel6Layout.setHorizontalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((Component)this.jRadioButtonAnalysisComments1).add((Component)this.jRadioButtonBiostratComments1)).addContainerGap(16, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonAnalysisComments1).addPreferredGap(1).add((Component)this.jRadioButtonBiostratComments1).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Events", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupEventSelection.add(this.jRadioButtonPrimeEvents);
        this.jRadioButtonPrimeEvents.setText("events");
        this.jRadioButtonPrimeEvents.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBugWareReader this$0;
            {
                DialogBugWareReader dialogBugWareReader = this$0;
                Objects.requireNonNull(dialogBugWareReader);
                this.this$0 = dialogBugWareReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPrimeEventsActionPerformed(evt);
            }
        });
        this.buttonGroupEventSelection.add(this.jRadioButtonPrimeComments);
        this.jRadioButtonPrimeComments.setText("comments");
        this.jRadioButtonPrimeComments.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBugWareReader this$0;
            {
                DialogBugWareReader dialogBugWareReader = this$0;
                Objects.requireNonNull(dialogBugWareReader);
                this.this$0 = dialogBugWareReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPrimeCommentsActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Primary comments are:");
        this.buttonGroupEventType.add(this.jRadioButtonEventTop);
        this.jRadioButtonEventTop.setText("Top");
        this.buttonGroupEventType.add(this.jRadioButtonEventBase);
        this.jRadioButtonEventBase.setText("Base");
        this.buttonGroupEventType.add(this.jRadioButtonEventSingle);
        this.jRadioButtonEventSingle.setText("Single");
        this.jRadioButtonEventSingle.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBugWareReader this$0;
            {
                DialogBugWareReader dialogBugWareReader = this$0;
                Objects.requireNonNull(dialogBugWareReader);
                this.this$0 = dialogBugWareReader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonEventSingleActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout((Container)this.jPanel7);
        this.jPanel7.setLayout((LayoutManager)jPanel7Layout);
        jPanel7Layout.setHorizontalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().add((Component)this.jRadioButtonEventTop).add(10, 10, 10).add((Component)this.jRadioButtonEventBase).add(10, 10, 10).add((Component)this.jRadioButtonEventSingle)).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().add((Component)this.jLabel3).add(2, 2, 2).add((Component)this.jRadioButtonPrimeComments).addPreferredGap(1).add((Component)this.jRadioButtonPrimeEvents))).addContainerGap()));
        jPanel7Layout.setVerticalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel7Layout.createParallelGroup(3).add((Component)this.jRadioButtonPrimeEvents).add((Component)this.jRadioButtonPrimeComments).add((Component)this.jLabel3)).addPreferredGap(1).add((GroupLayout.Group)jPanel7Layout.createParallelGroup(3).add((Component)this.jRadioButtonEventTop).add((Component)this.jRadioButtonEventBase).add((Component)this.jRadioButtonEventSingle)).addContainerGap(11, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel4, -2, -1, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(203, 203, 203).add((Component)this.jPanel7, -2, -1, -2))).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).add(6, 6, 6).add((Component)this.jButtonPreview).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2))).add((Component)this.jPanel5, -2, -1, -2).add((Component)this.jCheckBoxIgnoreSemiQuant)).add(0, 0, Short.MAX_VALUE)).add((Component)this.jSeparator1)))).addContainerGap()).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel6, -2, -1, -2).addContainerGap(292, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).add(18, 18, 18).add((Component)this.jPanel7, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel5, -2, -1, -2).add((Component)this.jPanel4, -2, -1, -2)).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(1).add((Component)this.jCheckBoxIgnoreSemiQuant).addPreferredGap(1).add((Component)this.jSeparator1, -2, 11, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK).add((Component)this.jButtonPreview)).addContainerGap(23, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(155, 155, 155).add((Component)this.jPanel6, -2, -1, -2).addContainerGap(311, Short.MAX_VALUE))));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonPreviewActionPerformed(ActionEvent evt) {
        DialogFilePreview dialog = new DialogFilePreview(this, false, this.fileName);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonSelectAnalystActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst(this, true, this.db, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.analyst = dialog.selectedUser;
            if (this.analyst != null) {
                this.jTextFieldDbAnalyst.setText(this.analyst.getAbr());
            }
        }
        catch (SQLException sql) {
            JOptionPane.showMessageDialog(this, "Error opening Analyst dialog:/n" + String.valueOf(sql), this.getTitle(), 0);
            sql.printStackTrace();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupUnits.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select units used in file", this.getTitle(), 2);
            return;
        }
        if (this.buttonGroupDisc.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select discipline used in file", this.getTitle(), 2);
            return;
        }
        if (this.buttonGroupComments.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select comments destination", this.getTitle(), 2);
            return;
        }
        if (this.buttonGroupLithology.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select lithology destination", this.getTitle(), 2);
            return;
        }
        if (this.analyst == null) {
            JOptionPane.showMessageDialog(this, "Select an analyst", this.getTitle(), 2);
            return;
        }
        this.ignoreSemiQuant = this.jCheckBoxIgnoreSemiQuant.isSelected();
        this.useBioStratComments = this.jRadioButtonBiostratComments1.isSelected();
        this.usePrimaryEvents = this.jRadioButtonPrimeEvents.isSelected();
        if (this.usePrimaryEvents) {
            if (this.buttonGroupEventType.getSelection() == null) {
                JOptionPane.showMessageDialog(this, "Select event type", this.getTitle(), 2);
                return;
            }
            this.eventType = this.jRadioButtonEventTop.isSelected() ? EventType.TOP : (this.jRadioButtonEventBase.isSelected() ? EventType.BASE : EventType.SINGLE);
        }
        this.useSampleLithology = this.jRadioButtonSampleLithology.isSelected();
        this.useSampleTops = this.jRadioButtonTop.isSelected();
        this.units = (char)(this.jRadioButtonMetres.isSelected() ? 77 : 70);
        if (this.jRadioButtonMicro.isSelected()) {
            this.discID = (char)77;
        } else if (this.jRadioButtonMacro.isSelected()) {
            this.discID = (char)65;
        } else if (this.jRadioButtonNanno.isSelected()) {
            this.discID = (char)78;
        } else if (this.jRadioButtonPaly.isSelected()) {
            this.discID = (char)80;
        }
        this.isOK = true;
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogbugwarereader.html");
    }

    private void jRadioButtonEventSingleActionPerformed(ActionEvent evt) {
    }

    private void jRadioButtonPrimeCommentsActionPerformed(ActionEvent evt) {
        this.setEventTypeControls(false);
    }

    private void jRadioButtonPrimeEventsActionPerformed(ActionEvent evt) {
        this.setEventTypeControls(true);
    }

    private void setEventTypeControls(boolean toSet) {
        this.jRadioButtonEventTop.setEnabled(toSet);
        this.jRadioButtonEventBase.setEnabled(toSet);
        this.jRadioButtonEventSingle.setEnabled(toSet);
    }
}

