/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.image.EditableImageSet;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.well.SectionType;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileFilter;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.CoreImage;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogCoreImage
extends SBDialog {
    private final DepthUnits units;
    private final SBdb db;
    private final Well well;
    private CoreImage original;
    private EditableImageSet image;
    CoreImage added = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelectImage;
    private JLabel jLabelBase;
    private JLabel jLabelImage;
    private JLabel jLabelTop;
    private JLabel jLabelUnits1;
    private JLabel jLabelUnits2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldTopDepth;

    public DialogCoreImage(JDialog parent, boolean modal, SBdb db, Well well, CoreImage coreImage, DepthUnits units, double defaultTop) throws SQLException {
        super((Window)parent, modal);
        this.initComponents();
        this.well = well;
        this.db = db;
        this.original = coreImage;
        this.units = units;
        this.init(defaultTop);
    }

    private void init(double defaultTop) throws SQLException {
        this.image = new EditableImageSet(this.db.getImageLoader());
        if (this.original == null) {
            this.setTitle("Core Image : Add");
            if (defaultTop > 0.0) {
                this.jTextFieldTopDepth.setText(DepthUtils.depthString((double)defaultTop, (DepthUnits)this.units, (int)2, (SectionType)this.well.getSectionType(), (boolean)false).trim());
            }
        } else {
            this.setTitle("Core Image : Edit");
            this.jTextFieldTopDepth.setText(DepthUtils.depthString((double)this.original.getTopDepth(), (DepthUnits)this.units, (int)2, (SectionType)this.well.getSectionType(), (boolean)false).trim());
            this.jTextFieldBaseDepth.setText(DepthUtils.depthString((double)this.original.getBaseDepth(), (DepthUnits)this.units, (int)2, (SectionType)this.well.getSectionType(), (boolean)false).trim());
            ImageRecord imageRecord = this.db.getImageRecordService().getImageRecord(this.original.getImageID());
            this.image.addImageRecord(imageRecord);
            this.setImage();
        }
        this.jLabelUnits1.setText(this.units.getAbr());
        this.jLabelUnits2.setText(this.units.getAbr());
        if (this.well.getSectionType() == SectionType.OUTCROP) {
            this.jLabelTop.setText("Top elevation:");
            this.jLabelBase.setText("Base elevation:");
        }
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initComponents() {
        this.jLabelTop = new JLabel();
        this.jLabelBase = new JLabel();
        this.jTextFieldTopDepth = TextFieldUtils.buildDecimalOnlyTextField(true, null, 6);
        this.jTextFieldBaseDepth = TextFieldUtils.buildDecimalOnlyTextField(true, null, 6);
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonSelectImage = new JButton();
        this.jLabelUnits1 = new JLabel();
        this.jLabelUnits2 = new JLabel();
        this.jLabelImage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(265, 500));
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ DialogCoreImage this$0;
            {
                DialogCoreImage dialogCoreImage = this$0;
                Objects.requireNonNull(dialogCoreImage);
                this.this$0 = dialogCoreImage;
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                this.this$0.formComponentResized(evt);
            }
        });
        this.jLabelTop.setHorizontalAlignment(11);
        this.jLabelTop.setText("Top depth:");
        this.jLabelBase.setHorizontalAlignment(11);
        this.jLabelBase.setText("Base depth:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreImage this$0;
            {
                DialogCoreImage dialogCoreImage = this$0;
                Objects.requireNonNull(dialogCoreImage);
                this.this$0 = dialogCoreImage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreImage this$0;
            {
                DialogCoreImage dialogCoreImage = this$0;
                Objects.requireNonNull(dialogCoreImage);
                this.this$0 = dialogCoreImage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonSelectImage.setText("Select...");
        this.jButtonSelectImage.setToolTipText("Select an image");
        this.jButtonSelectImage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreImage this$0;
            {
                DialogCoreImage dialogCoreImage = this$0;
                Objects.requireNonNull(dialogCoreImage);
                this.this$0 = dialogCoreImage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectImageActionPerformed(evt);
            }
        });
        this.jLabelUnits1.setText("ft");
        this.jLabelUnits2.setText("ft");
        this.jLabelImage.setBackground(new Color(255, 255, 255));
        this.jLabelImage.setText("Press select to select image...");
        this.jLabelImage.setBorder(new MatteBorder(null));
        this.jSeparator1.setOrientation(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator3).add((Component)this.jLabelImage, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTop).addPreferredGap(0).add((Component)this.jTextFieldTopDepth, -2, 68, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelBase).addPreferredGap(0).add((Component)this.jTextFieldBaseDepth, -2, 68, -2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jLabelUnits2, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelUnits1)).add(16, 16, 16).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonSelectImage)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK, -2, 73, -2).addPreferredGap(0).add((Component)this.jButtonCancel, -2, 65, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jSeparator1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldTopDepth).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelTop).add((Component)this.jLabelUnits1))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelUnits2).add((Component)this.jTextFieldBaseDepth, -2, -1, -2).add((Component)this.jLabelBase))).add((Component)this.jButtonSelectImage)).addPreferredGap(1).add((Component)this.jSeparator2).addPreferredGap(0).add((Component)this.jLabelImage, -2, 333, -2).addPreferredGap(0).add((Component)this.jSeparator3, -2, 5, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float baseDepth;
        if (this.jTextFieldTopDepth.getText().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter a top depth", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldBaseDepth.getText().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter a base depth", this.getTitle(), 2);
            return;
        }
        if (this.image.getSize() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select an image", this.getTitle(), 2);
            return;
        }
        float topDepth = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText().trim()), (DepthUnits)this.units, (SectionType)this.well.getSectionType());
        if (topDepth > (baseDepth = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText().trim()), (DepthUnits)this.units, (SectionType)this.well.getSectionType()))) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Top depth cannot be greater than base depth", this.getTitle(), 2);
            return;
        }
        switch (this.well.getSectionType()) {
            default: {
                if (!((double)baseDepth > this.well.getTD())) break;
                JOptionPane.showMessageDialog((Component)((Object)this), "Base depth is below well TD (" + this.well.getTD() + ")", this.getTitle(), 2);
                return;
            }
            case OUTCROP: {
                if (!((double)topDepth < this.well.getHeader().getKickoValue())) break;
                String kicko = DepthUtils.depthString((double)this.well.getHeader().getKickoValue(), (DepthUnits)this.units, (int)2, (SectionType)this.well.getSectionType());
                JOptionPane.showMessageDialog((Component)((Object)this), "Top depth is above outcrop datum (" + kicko + ")", this.getTitle(), 2);
                return;
            }
        }
        try {
            for (CoreImage ci : this.well.getCoreImages()) {
                if (ci == this.original) continue;
                try {
                    SB.checkOverlap((int)((int)(topDepth * 100.0f)), (int)((int)(baseDepth * 100.0f)), (int)((int)(ci.getTopDepth() * 100.0)), (int)((int)(ci.getBaseDepth() * 100.0)));
                }
                catch (SBException ex) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Top/Base depths overlp existing core image(s)", this.getTitle(), 1);
                    return;
                }
            }
            if (this.original != null) {
                this.well.deleteCoreImage(this.original);
            }
            this.added = this.well.addCoreImage(topDepth, baseDepth, this.image);
            this.db.commit();
            this.setOK();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error storing core image", e, (Component)((Object)this));
        }
    }

    private void jButtonSelectImageActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.findLastImageDirectory());
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("jpeg");
        filter.addExtension("tif");
        filter.addExtension("tiff");
        jFileChooser.setFileFilter((FileFilter)filter);
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                if (this.image.getSize() > 0) {
                    this.image.removeImage(0);
                }
                this.image.addImageFromFile(file);
                Lastval.putString(this.db, "WINIMG", "UNXIMG", file.getPath());
                this.db.commit();
            }
            catch (IOException | RuntimeException | SQLException ex) {
                SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
            }
        }
        this.setImage();
    }

    private File findLastImageDirectory() {
        File setDir;
        try {
            setDir = new File(Lastval.getString(this.db, "WINIMG", "UNXIMG"));
            setDir = setDir.getParent() == null || !setDir.getParentFile().exists() ? new File(".") : new File(setDir.getParent());
        }
        catch (SQLException ex) {
            Logger.getLogger(DialogCoreImage.class.getName()).log(Level.WARNING, "Error getting last image file name", ex);
            setDir = new File(".");
        }
        return setDir;
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.jLabelImage.getWidth() > this.getWidth()) {
            int width = this.getWidth() - 30;
            int height = this.getHeight() - 200;
            this.jLabelImage.setIcon(null);
            this.jLabelImage.setSize(width, height);
        }
        try {
            this.setImage();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
        }
    }

    private void setImage() {
        if (this.image != null && this.image.getSize() > 0) {
            this.jLabelImage.setText(null);
            ImageRecord imageRecord = this.image.getImageRecords().get(0);
            Image loadedImage = this.image.getImage(imageRecord.imageID(), new Dimension(this.jLabelImage.getBounds().width, this.jLabelImage.getBounds().height));
            if (loadedImage != null) {
                ImageIcon icon = new ImageIcon(loadedImage);
                this.jLabelImage.setIcon(icon);
            }
        } else {
            this.jLabelImage.setIcon(null);
            this.jLabelImage.setText("Press Select... to add an image here");
            this.jLabelImage.setHorizontalAlignment(0);
            this.jLabelImage.setVerticalAlignment(0);
        }
    }
}

