/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.CoreShiftDepth;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.SbugsIO;
import jsbugs.TableModelCoreShift;
import jsbugs.table.ColouredRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.CoredInterval;
import model3.Cores;
import model3.Well;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jdesktop.layout.GroupLayout;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.table.SbugsTable;

public class DialogCoreShifts
extends JDialog {
    private final Well well;
    private final TableModelCoreShift model = new TableModelCoreShift();
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonGenerate;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonRead;
    private JButton jButtonRemove;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableShift;

    public DialogCoreShifts(JDialog parent, boolean modal, Well well, char units) throws SQLException {
        super((Dialog)parent, modal);
        this.well = well;
        this.initComponents();
        this.init(units);
    }

    private void init(char units) throws SQLException {
        this.setTitle("Core Shifts: " + this.well.getWellName());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.model.load(this.well, units);
        SB.setTableHeaderBold((JTable)this.jTableShift);
        TableColumnModel columnModel = this.jTableShift.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelCoreShift.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelCoreShift.widths[i]);
        }
        columnModel.getColumn(0).setCellRenderer(new ColouredRenderer(false, ColouredRenderer.GREY, 2));
        if (!this.well.canWrite(this.well.getDataModel(), null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.well.getDataModel(), "well", false));
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableShift = new SbugsTable((TableModel)this.model);
        this.jButtonRead = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jButtonGenerate = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 300));
        this.jTableShift.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableShift);
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreShifts this$0;
            {
                DialogCoreShifts dialogCoreShifts = this$0;
                Objects.requireNonNull(dialogCoreShifts);
                this.this$0 = dialogCoreShifts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreShifts this$0;
            {
                DialogCoreShifts dialogCoreShifts = this$0;
                Objects.requireNonNull(dialogCoreShifts);
                this.this$0 = dialogCoreShifts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreShifts this$0;
            {
                DialogCoreShifts dialogCoreShifts = this$0;
                Objects.requireNonNull(dialogCoreShifts);
                this.this$0 = dialogCoreShifts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreShifts this$0;
            {
                DialogCoreShifts dialogCoreShifts = this$0;
                Objects.requireNonNull(dialogCoreShifts);
                this.this$0 = dialogCoreShifts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreShifts this$0;
            {
                DialogCoreShifts dialogCoreShifts = this$0;
                Objects.requireNonNull(dialogCoreShifts);
                this.this$0 = dialogCoreShifts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreShifts this$0;
            {
                DialogCoreShifts dialogCoreShifts = this$0;
                Objects.requireNonNull(dialogCoreShifts);
                this.this$0 = dialogCoreShifts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonGenerate.setText("Generate");
        this.jButtonGenerate.setToolTipText("Create depth values from cored intervals");
        this.jButtonGenerate.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonGenerate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreShifts this$0;
            {
                DialogCoreShifts dialogCoreShifts = this$0;
                Objects.requireNonNull(dialogCoreShifts);
                this.this$0 = dialogCoreShifts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGenerateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 199, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonGenerate, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonRemove, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1).add((Component)this.jButtonRead, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 248, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonRemove).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonGenerate).addPreferredGap(0).add((Component)this.jButtonRead).addPreferredGap(0, 41, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.model.coreshift.hasDuplicateDepths()) {
            JOptionPane.showMessageDialog(this, "Cannot save because there are duplicate depths.\nEnsure that all depths are unique", this.getTitle(), 1);
            return;
        }
        try {
            if (this.jTableShift.isEditing()) {
                this.jTableShift.getCellEditor().stopCellEditing();
            }
            this.well.updateCoreShift(this.model.coreshift);
            this.well.getDataModel().commit();
            this.dispose();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.well.getDataModel().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        File file = SbugsIO.chooseFileToOpen(this.well.getDataModel(), this, "CSHIFTFILE", "Core shift files", "xlsx", "xls");
        if (file != null) {
            this.readXLS(file);
            this.model.fireTableDataChanged();
        }
    }

    void readXLS(File file) {
        try (FileInputStream is = new FileInputStream(file);){
            Workbook wb = WorkbookFactory.create((InputStream)is);
            Sheet sheet = wb.getSheetAt(0);
            Row titleRow = sheet.getRow(0);
            if (titleRow == null) {
                System.out.println("column titles null for sheet 0");
                return;
            }
            Short depthCol = null;
            Short shiftCol = null;
            for (short cellNum = titleRow.getFirstCellNum(); cellNum <= titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
                Cell cell = titleRow.getCell((int)cellNum);
                if (cellNum >= 20) {
                    System.out.println("CellNumber: " + cellNum + " exceeds column title length!");
                }
                if (cell == null) {
                    System.out.println("Can't get cell for cellNum: " + cellNum);
                    continue;
                }
                String title = cell.getStringCellValue();
                if (title.equalsIgnoreCase("depth")) {
                    depthCol = cellNum;
                } else if (title.equalsIgnoreCase("shift")) {
                    shiftCol = cellNum;
                }
                if (depthCol != null && shiftCol != null) break;
            }
            if (depthCol == null || shiftCol == null) {
                JOptionPane.showMessageDialog(this, "Can't find shifts.", this.getTitle(), 2);
                return;
            }
            for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
                float shift;
                Row row = sheet.getRow(nRow);
                if (row == null) continue;
                Cell depthCell = row.getCell((int)depthCol.shortValue());
                Cell shiftCell = row.getCell((int)shiftCol.shortValue());
                if (depthCell.getCellType() == CellType.NUMERIC && shiftCell.getCellType() == CellType.NUMERIC) {
                    double depth = depthCell.getNumericCellValue();
                    shift = (float)shiftCell.getNumericCellValue();
                    this.model.coreshift.add(new CoreShiftDepth(DepthUtils.convToM((double)depth, (char)this.model.units), shift));
                    continue;
                }
                try {
                    double depth = Double.parseDouble(depthCell.getStringCellValue());
                    shift = Float.parseFloat(shiftCell.getStringCellValue());
                    this.model.coreshift.add(new CoreShiftDepth(DepthUtils.convToM((double)depth, (char)this.model.units), shift));
                    continue;
                }
                catch (NumberFormatException e) {
                    System.out.println("Didn't parse row: " + e.getMessage());
                }
            }
        }
        catch (IOException | RuntimeException ioe) {
            SbugsExceptionHandler.showStackError(ioe, this);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        int row = this.jTableShift.getSelectedRow();
        if (row >= 0) {
            this.model.coreshift.add(row + 1, new CoreShiftDepth(0.0, 0.0f));
        } else {
            this.model.coreshift.add(new CoreShiftDepth(0.0, 0.0f));
            row = this.model.coreshift.size() - 1;
        }
        this.model.fireTableDataChanged();
        this.jTableShift.setRowSelectionInterval(row, row);
        this.jScrollPane1.scrollRectToVisible(this.jTableShift.getCellRect(row, 0, true));
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.jTableShift.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select row(s) to remove", this.getTitle(), 2);
            return;
        }
        int[] selection = this.jTableShift.getSelectedRows();
        LinkedList<CoreShiftDepth> toRemove = new LinkedList<CoreShiftDepth>();
        for (int i : selection) {
            toRemove.add(this.model.coreshift.get(i));
        }
        toRemove.forEach(d -> this.model.coreshift.remove(d));
        this.model.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogcoreshifts.html");
    }

    private void jButtonGenerateActionPerformed(ActionEvent evt) {
        try {
            Cores cores = this.well.getCores();
            for (CoredInterval ci : cores.getList()) {
                this.model.coreshift.add(new CoreShiftDepth(ci.getTopDepth(), 0.0f));
                this.model.coreshift.add(new CoreShiftDepth(ci.getBaseDepth(), 0.0f));
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        this.model.fireTableDataChanged();
    }
}

