/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Boundary;
import com.stratadata.util.ui.DialogBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbugs.uiutil.EnumCombo;
import model3.IGDIntervalZone;
import model3.WellEvent;

public class DialogCorrelationLine
extends DialogBase {
    private JObjectRadioButton[] buttons;
    private static final int NBUTTONS = 3;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private static final String INHERIT_BND = "Inherit";
    private static final String DEFAULT_POS = "Default";
    private final DefaultComboBoxModel labelPositionModel = new DefaultComboBoxModel<CorrLineStyle.LabelPosition>(CorrLineStyle.LabelPosition.values());
    private JPanel jPanel1;
    private JLabel jLabelColour;
    private JLabel jLabelWeight;
    private JLabel jLabelStyle;
    private JTextField jTextFieldColour;
    private JButton jButtonColour;
    private JSpinner jSpinnerWeight;
    private JComboBox<Object> jComboBoxBnd;
    private JRadioButton jRadioButtonColourSet;
    private JRadioButton jRadioButtonColourInherit;
    private JCheckBox jCheckBoxStyleDefault;
    private JCheckBox jCheckBoxLabel;
    private JLabel jLabelPosition;
    private JComboBox jComboBoxPosition;
    private JCheckBox jCheckBoxLabelAbr;
    private JLabel jLabelFontSize;
    private JComboBox<Object> jComboBoxLabelFontSize;
    private EnumCombo enumComboAlignment;
    private JLabel jLabelAlignment;
    private JCheckBox jCheckBoxShowLabelType;
    private JRadioButton rButton0;
    private JRadioButton rButton1;
    private JRadioButton rButton2;
    private JSeparator jSeparator1;
    private ButtonGroup buttonGroupColour;

    public DialogCorrelationLine(Frame parent, CorrelationType type, Object o, CorrelationLine line, boolean showObjectTypes) {
        super((Window)parent);
        this.initComponents();
        super.addOkButtonActionListener(this::jButtonOKActionPerformed);
        this.init(type, o, line, showObjectTypes);
    }

    /*
     * WARNING - void declaration
     */
    private void init(CorrelationType type, Object o, CorrelationLine line, boolean showObjectTypes) {
        void var7_10;
        String[] buttonText;
        Object[] buttonTypes;
        block20: {
            block19: {
                this.setTitle("Line Properties");
                this.buttons = new JObjectRadioButton[3];
                this.buttons[0] = (JObjectRadioButton)this.rButton0;
                this.buttons[1] = (JObjectRadioButton)this.rButton1;
                this.buttons[2] = (JObjectRadioButton)this.rButton2;
                if (!showObjectTypes) break block19;
                switch (type) {
                    case EVENT: {
                        buttonTypes = new Object[]{EventType.TOP, EventType.BASE, EventType.SINGLE};
                        buttonText = new String[]{WellEvent.getType(EventType.TOP.getChar()), WellEvent.getType(EventType.BASE.getChar()), WellEvent.getType(EventType.SINGLE.getChar())};
                        break;
                    }
                    case CHRONO: 
                    case LITHO: 
                    case BIOZONE: {
                        void var7_8;
                        buttonTypes = IGDIntervalZone.BoundaryType.values();
                        buttonText = new String[buttonTypes.length];
                        boolean bl = false;
                        while (var7_8 < buttonText.length) {
                            buttonText[var7_8] = IGDIntervalZone.BoundaryType.values()[var7_8].toString();
                            ++var7_8;
                        }
                        break block20;
                    }
                    default: {
                        buttonTypes = new Object[]{};
                        buttonText = new String[]{};
                        break;
                    }
                }
                break block20;
            }
            buttonTypes = new Object[]{};
            buttonText = new String[]{};
        }
        assert (3 >= buttonTypes.length);
        boolean bl = false;
        while (var7_10 < 3) {
            if (var7_10 < buttonTypes.length) {
                this.buttons[var7_10].o = buttonTypes[var7_10];
                this.buttons[var7_10].setText(buttonText[var7_10]);
                this.buttonGroup.add(this.buttons[var7_10]);
                if (line != null && buttonTypes[var7_10] == line.getObjectType()) {
                    this.buttons[var7_10].setSelected(true);
                }
            } else {
                this.buttons[var7_10].setVisible(false);
            }
            ++var7_10;
        }
        if (buttonTypes.length == 1) {
            this.buttons[0].setSelected(true);
        }
        this.jComboBoxBnd.removeAllItems();
        this.jComboBoxBnd.addItem(INHERIT_BND);
        for (Boundary boundary : Boundary.values()) {
            this.jComboBoxBnd.addItem(boundary);
        }
        this.labelPositionModel.insertElementAt(DEFAULT_POS, 0);
        this.jComboBoxLabelFontSize.removeAllItems();
        for (ChartProperties.FontSize fontSize : ChartProperties.FontSize.values()) {
            this.jComboBoxLabelFontSize.addItem((Object)fontSize);
        }
        if (line != null && line.getStyle() != null) {
            this.jComboBoxBnd.setSelectedItem(line.getStyle().getBnd() != null ? line.getStyle().getBnd() : INHERIT_BND);
            this.jSpinnerWeight.setValue(Float.valueOf(line.getStyle().getWeight()));
            if (line.getStyle().getColour() != null) {
                this.jTextFieldColour.setBackground(line.getStyle().getColour());
                this.jRadioButtonColourSet.setSelected(true);
            } else {
                this.jRadioButtonColourInherit.setSelected(true);
            }
            this.jCheckBoxLabel.setSelected(line.getStyle().getLabel());
            this.jCheckBoxLabelAbr.setSelected(line.getStyle().getLabelAbr());
            this.jCheckBoxShowLabelType.setSelected(line.getStyle().getShowLabelType());
            this.jComboBoxPosition.setSelectedItem(line.getStyle().getLabelPosition() != null ? line.getStyle().getLabelPosition() : DEFAULT_POS);
            this.jComboBoxLabelFontSize.setSelectedItem((Object)line.getStyle().getFontSize());
        } else {
            Boundary boundary = CorrLineStyle.getDefaultBnd(type);
            this.jComboBoxBnd.setSelectedItem(boundary != null ? boundary : INHERIT_BND);
            this.jComboBoxLabelFontSize.setSelectedItem((Object)ChartProperties.FontSize.SMALL);
            this.jCheckBoxShowLabelType.setSelected(true);
        }
        this.jCheckBoxStyleDefault.setSelected(line == null || line.getStyle() == null);
        this.enumComboAlignment.init(HorizontalAlignment.class);
        if (line != null && line.getStyle() != null && line.getStyle().getAlignment() != null) {
            this.enumComboAlignment.setSelectedItem((Object)line.getStyle().getAlignment());
        } else {
            this.enumComboAlignment.setSelectedItem((Object)HorizontalAlignment.Centre);
        }
        this.enableStyle();
        this.enableAbr();
        this.pack();
    }

    private void enableStyle() {
        boolean b = !this.jCheckBoxStyleDefault.isSelected();
        this.jLabelColour.setEnabled(b);
        this.jLabelStyle.setEnabled(b);
        this.jLabelWeight.setEnabled(b);
        this.jRadioButtonColourInherit.setEnabled(b);
        this.jRadioButtonColourSet.setEnabled(b);
        this.jTextFieldColour.setEnabled(b);
        this.jButtonColour.setEnabled(b);
        this.jSpinnerWeight.setEnabled(b);
        this.jComboBoxBnd.setEnabled(b);
        this.jCheckBoxLabel.setEnabled(b);
        this.jCheckBoxLabelAbr.setEnabled(b);
        this.jCheckBoxShowLabelType.setEnabled(b);
        this.jLabelPosition.setEnabled(b && this.jCheckBoxLabel.isSelected());
        this.jComboBoxPosition.setEnabled(b && this.jCheckBoxLabel.isSelected());
        this.jComboBoxLabelFontSize.setEnabled(b && this.jCheckBoxLabel.isSelected());
        this.jLabelFontSize.setEnabled(b && this.jCheckBoxLabel.isSelected());
        this.enumComboAlignment.setEnabled(b && this.jCheckBoxLabel.isSelected());
        this.jLabelAlignment.setEnabled(b && this.jCheckBoxLabel.isSelected());
    }

    private void enableAbr() {
        this.jCheckBoxLabelAbr.setEnabled(this.jCheckBoxLabel.isSelected());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelColour = new JLabel();
        this.jLabelWeight = new JLabel();
        this.jLabelStyle = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jButtonColour = new JButton();
        this.jSpinnerWeight = new JSpinner();
        this.jComboBoxBnd = new JComboBox();
        this.jRadioButtonColourSet = new JRadioButton();
        this.jRadioButtonColourInherit = new JRadioButton();
        this.jCheckBoxStyleDefault = new JCheckBox();
        this.jCheckBoxLabel = new JCheckBox();
        this.jLabelPosition = new JLabel();
        this.jComboBoxPosition = new JComboBox();
        this.jCheckBoxLabelAbr = new JCheckBox();
        this.jLabelFontSize = new JLabel();
        this.jComboBoxLabelFontSize = new JComboBox();
        this.enumComboAlignment = new EnumCombo();
        this.jLabelAlignment = new JLabel();
        this.jCheckBoxShowLabelType = new JCheckBox();
        this.rButton0 = new JObjectRadioButton();
        this.rButton1 = new JObjectRadioButton();
        this.rButton2 = new JObjectRadioButton();
        this.jSeparator1 = new JSeparator();
        this.buttonGroupColour = new ButtonGroup();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        JPanel contentPanel = this.getContentPanel();
        this.jPanel1.setBorder(new TitledBorder("Line Style"));
        this.jLabelColour.setText("Colour:");
        this.jLabelWeight.setText("Weight:");
        this.jLabelStyle.setText("Style:");
        this.jTextFieldColour.setEditable(false);
        this.jButtonColour.setText("...");
        this.jButtonColour.addActionListener(e -> this.jButtonColourActionPerformed(e));
        this.jSpinnerWeight.setModel(new SpinnerNumberModel(0.2f, 0.1f, 10.0, 0.1f));
        this.jComboBoxBnd.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jRadioButtonColourInherit.setSelected(true);
        this.jRadioButtonColourInherit.setText("Inherit from data");
        this.jCheckBoxStyleDefault.setText("Use template default");
        this.jCheckBoxStyleDefault.addActionListener(e -> this.jCheckBoxStyleDefaultActionPerformed(e));
        this.jCheckBoxLabel.setText("Label");
        this.jCheckBoxLabel.addActionListener(e -> this.jCheckBoxLabelActionPerformed(e));
        this.jLabelPosition.setText("Position:");
        this.jComboBoxPosition.setModel(this.labelPositionModel);
        this.jCheckBoxLabelAbr.setText("Label abbreviations");
        this.jCheckBoxLabelAbr.setToolTipText("No effect for Surfaces");
        this.jLabelFontSize.setText("Font size:");
        this.jComboBoxLabelFontSize.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.enumComboAlignment.addActionListener(e -> this.enumComboAlignmentActionPerformed(e));
        this.jLabelAlignment.setText("Alignment:");
        this.jCheckBoxShowLabelType.setText("Show label top/base");
        this.jCheckBoxShowLabelType.setToolTipText("Only for interval based lines");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jCheckBoxStyleDefault, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jLabelColour).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonColourInherit).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonColourSet).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldColour).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonColour, -2, 30, -2)))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabelStyle)).addComponent(this.jLabelWeight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jComboBoxBnd, GroupLayout.Alignment.TRAILING).addComponent(this.jSpinnerWeight, GroupLayout.Alignment.TRAILING))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jCheckBoxLabelAbr).addComponent(this.jCheckBoxLabel).addComponent(this.jCheckBoxShowLabelType)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelFontSize).addComponent(this.jLabelPosition).addComponent(this.jLabelAlignment)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jComboBoxPosition).addComponent(this.jComboBoxLabelFontSize).addComponent(this.enumComboAlignment, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxStyleDefault).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonColourInherit).addComponent(this.jLabelColour)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldColour, -2, -1, -2).addComponent(this.jButtonColour)).addComponent(this.jRadioButtonColourSet)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerWeight, -2, -1, -2).addComponent(this.jLabelWeight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxBnd, -2, -1, -2).addComponent(this.jLabelStyle)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxLabelAbr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxShowLabelType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPosition).addComponent(this.jComboBoxPosition, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelFontSize).addComponent(this.jComboBoxLabelFontSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enumComboAlignment, -2, -1, -2).addComponent(this.jLabelAlignment)).addContainerGap(7, Short.MAX_VALUE)));
        this.rButton0.setText("jRadioButton1");
        this.rButton1.setText("jRadioButton2");
        this.rButton2.setText("jRadioButton3");
        GroupLayout contentPanelLayout = new GroupLayout(contentPanel);
        contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addContainerGap().addGroup(contentPanelLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)).addGroup(contentPanelLayout.createSequentialGroup().addGroup(contentPanelLayout.createParallelGroup().addComponent(this.rButton2).addComponent(this.rButton1).addComponent(this.rButton0)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1)).addContainerGap()));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rButton0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rButton2).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.buttonGroupColour.add(this.jRadioButtonColourSet);
        this.buttonGroupColour.add(this.jRadioButtonColourInherit);
    }

    private void jCheckBoxStyleDefaultActionPerformed(ActionEvent evt) {
        this.enableStyle();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttons[0].isVisible() && this.buttonGroup.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a data type.", this.getTitle(), 2);
            return;
        }
        this.returnWithCode(DialogBase.ReturnCode.SUCCESS);
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog((Component)((Object)this), "Colour : Select", null);
        if (c != null) {
            this.jTextFieldColour.setBackground(c);
            this.jRadioButtonColourSet.setSelected(true);
        }
    }

    private void jCheckBoxLabelActionPerformed(ActionEvent evt) {
        this.jLabelPosition.setEnabled(this.jCheckBoxLabel.isSelected());
        this.jComboBoxPosition.setEnabled(this.jCheckBoxLabel.isSelected());
        this.jLabelFontSize.setEnabled(this.jCheckBoxLabel.isSelected());
        this.jComboBoxLabelFontSize.setEnabled(this.jCheckBoxLabel.isSelected());
        this.enumComboAlignment.setEnabled(this.jCheckBoxLabel.isSelected());
        this.jLabelAlignment.setEnabled(this.jCheckBoxLabel.isSelected());
        this.enableAbr();
    }

    private void enumComboAlignmentActionPerformed(ActionEvent evt) {
    }

    Object getSelectedType() {
        for (JObjectRadioButton button : this.buttons) {
            if (!button.isSelected()) continue;
            return button.o;
        }
        return null;
    }

    CorrLineStyle getStyle() {
        if (this.jCheckBoxStyleDefault.isSelected()) {
            return null;
        }
        Color colour = this.jRadioButtonColourInherit.isSelected() ? null : this.jTextFieldColour.getBackground();
        Boundary bnd = this.jComboBoxBnd.getSelectedItem() == INHERIT_BND ? null : (Boundary)this.jComboBoxBnd.getSelectedItem();
        CorrLineStyle.LabelPosition labelPos = this.jComboBoxPosition.getSelectedItem() == DEFAULT_POS ? null : (CorrLineStyle.LabelPosition)((Object)this.jComboBoxPosition.getSelectedItem());
        ChartProperties.FontSize labelSize = (ChartProperties.FontSize)((Object)this.jComboBoxLabelFontSize.getItemAt(this.jComboBoxLabelFontSize.getSelectedIndex()));
        HorizontalAlignment alignment = (HorizontalAlignment)((Object)this.enumComboAlignment.getSelectedItem());
        return new CorrLineStyle(colour, Float.parseFloat(this.jSpinnerWeight.getValue().toString()), bnd, this.jCheckBoxLabel.isSelected(), labelPos, this.jCheckBoxLabelAbr.isSelected(), labelSize, alignment, this.jCheckBoxShowLabelType.isSelected());
    }

    private static class JObjectRadioButton
    extends JRadioButton {
        Object o;

        private JObjectRadioButton() {
        }
    }
}

