/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogEditOccurrences
extends JDialog {
    private final Taxon taxon;
    private final SBdb db;
    private ButtonGroup buttonGroupOption;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JRadioButton jRadioButtonCaved;
    private JRadioButton jRadioButtonInSitu;
    private JRadioButton jRadioButtonNotCaved;
    private JRadioButton jRadioButtonPositive;
    private JRadioButton jRadioButtonQuestionable;
    private JRadioButton jRadioButtonRw;
    private JSeparator jSeparator1;
    private JTextField jTextFieldCaved;
    private JTextField jTextFieldInSitu;
    private JTextField jTextFieldNotCaved;
    private JTextField jTextFieldPositive;
    private JTextField jTextFieldQuestionable;
    private JTextField jTextFieldRw;
    private JTextField jTextFieldTaxonName;
    private JTextField jTextFieldTotal;

    public DialogEditOccurrences(Frame parent, boolean modal, SBdb db, Taxon taxon) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.taxon = taxon;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        int[] stats = new int[7];
        this.taxon.getStats(stats);
        this.jTextFieldTaxonName.setText(this.taxon.toString(true));
        this.setTitle("Edit Occurrences");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldTotal.setText(Integer.toString(stats[0]));
        if (stats[1] > 0 && stats[2] > 0) {
            this.jRadioButtonRw.setEnabled(false);
            this.jRadioButtonInSitu.setEnabled(false);
        } else {
            if (stats[1] == 0) {
                this.jRadioButtonRw.setEnabled(false);
            }
            if (stats[2] == 0) {
                this.jRadioButtonInSitu.setEnabled(false);
            }
        }
        this.jTextFieldInSitu.setText(Integer.toString(stats[1]));
        this.jTextFieldRw.setText(Integer.toString(stats[2]));
        if (stats[3] > 0 && stats[4] > 0) {
            this.jRadioButtonPositive.setEnabled(false);
            this.jRadioButtonQuestionable.setEnabled(false);
        } else {
            if (stats[3] == 0) {
                this.jRadioButtonQuestionable.setEnabled(false);
            }
            if (stats[4] == 0) {
                this.jRadioButtonPositive.setEnabled(false);
            }
        }
        this.jTextFieldPositive.setText(Integer.toString(stats[3]));
        this.jTextFieldQuestionable.setText(Integer.toString(stats[4]));
        if (stats[5] > 0 && stats[6] > 0) {
            this.jRadioButtonCaved.setEnabled(false);
            this.jRadioButtonNotCaved.setEnabled(false);
        } else {
            if (stats[5] == 0) {
                this.jRadioButtonNotCaved.setEnabled(false);
            }
            if (stats[6] == 0) {
                this.jRadioButtonCaved.setEnabled(false);
            }
        }
        this.jTextFieldNotCaved.setText(Integer.toString(stats[6]));
        this.jTextFieldCaved.setText(Integer.toString(stats[5]));
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
        }
    }

    private void initComponents() {
        this.buttonGroupOption = new ButtonGroup();
        this.jTextFieldTaxonName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jRadioButtonRw = new JRadioButton();
        this.jRadioButtonInSitu = new JRadioButton();
        this.jRadioButtonPositive = new JRadioButton();
        this.jRadioButtonQuestionable = new JRadioButton();
        this.jRadioButtonCaved = new JRadioButton();
        this.jRadioButtonNotCaved = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldRw = new JTextField();
        this.jTextFieldInSitu = new JTextField();
        this.jTextFieldPositive = new JTextField();
        this.jTextFieldQuestionable = new JTextField();
        this.jTextFieldCaved = new JTextField();
        this.jTextFieldNotCaved = new JTextField();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jTextFieldTotal = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jTextFieldTaxonName.setEditable(false);
        this.jLabel1.setText("Taxon name:");
        this.buttonGroupOption.add(this.jRadioButtonRw);
        this.jRadioButtonRw.setText("Reworked");
        this.buttonGroupOption.add(this.jRadioButtonInSitu);
        this.jRadioButtonInSitu.setText("In situ");
        this.buttonGroupOption.add(this.jRadioButtonPositive);
        this.jRadioButtonPositive.setText("Positive");
        this.buttonGroupOption.add(this.jRadioButtonQuestionable);
        this.jRadioButtonQuestionable.setText("Questionable");
        this.buttonGroupOption.add(this.jRadioButtonCaved);
        this.jRadioButtonCaved.setText("Caved");
        this.buttonGroupOption.add(this.jRadioButtonNotCaved);
        this.jRadioButtonNotCaved.setText("Not caved");
        this.jLabel2.setText("Number of Occurrences, per type. Check one option to switch ALL occurrences. ");
        this.jTextFieldRw.setEditable(false);
        this.jTextFieldInSitu.setEditable(false);
        this.jTextFieldPositive.setEditable(false);
        this.jTextFieldQuestionable.setEditable(false);
        this.jTextFieldCaved.setEditable(false);
        this.jTextFieldNotCaved.setEditable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditOccurrences this$0;
            {
                DialogEditOccurrences dialogEditOccurrences = this$0;
                Objects.requireNonNull(dialogEditOccurrences);
                this.this$0 = dialogEditOccurrences;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditOccurrences this$0;
            {
                DialogEditOccurrences dialogEditOccurrences = this$0;
                Objects.requireNonNull(dialogEditOccurrences);
                this.this$0 = dialogEditOccurrences;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jTextFieldTotal.setBackground(new Color(255, 255, 204));
        this.jTextFieldTotal.setEditable(false);
        this.jLabel3.setText("Total :");
        this.jLabel4.setText("<html>\nNote: Each pair of types should add\n<br>\nup to the total number below.\n<br>\n\nSelect Questionable, for example, to\n<br>\nswitch all Positive occurrences to \n<br>\nquestionable occurrences\n<br>\nfor this taxon.\n<br>\n<br>\n\nYou cannot switch occurrences\n<br>\nif there are already some of each type of\n<br>\noccurrence in the database.\n<br>\n</html>\n\n");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditOccurrences this$0;
            {
                DialogEditOccurrences dialogEditOccurrences = this$0;
                Objects.requireNonNull(dialogEditOccurrences);
                this.this$0 = dialogEditOccurrences;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSeparator1, -1, 470, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldInSitu, -2, -1, -2).add((Component)this.jTextFieldRw, -2, 59, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonInSitu).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonRw).add(66, 66, 66).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldTotal, -2, -1, -2)).add((Component)this.jLabel4, -2, -1, -2))))).add((Component)this.jLabel2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jTextFieldPositive, -2, -1, -2).add((Component)this.jTextFieldQuestionable, -2, -1, -2).add((Component)this.jTextFieldCaved, -2, -1, -2).add((Component)this.jTextFieldNotCaved, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonCaved).add((Component)this.jRadioButtonQuestionable).add((Component)this.jRadioButtonPositive).add((Component)this.jRadioButtonNotCaved))).add((Component)this.jTextFieldTaxonName, -1, 401, Short.MAX_VALUE))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jTextFieldCaved, this.jTextFieldInSitu, this.jTextFieldNotCaved, this.jTextFieldPositive, this.jTextFieldQuestionable, this.jTextFieldRw, this.jTextFieldTotal}, 1);
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTaxonName, -2, -1, -2)).add(18, 18, 18).add((Component)this.jLabel2)).add((GroupLayout.Group)layout.createSequentialGroup().add(81, 81, 81).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jRadioButtonRw).add((Component)this.jLabel4, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldTotal, -2, -1, -2).add((Component)this.jLabel3))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldRw, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldInSitu, -2, -1, -2).add((Component)this.jRadioButtonInSitu)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldPositive, -2, -1, -2).add((Component)this.jRadioButtonPositive)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldQuestionable, -2, -1, -2).add((Component)this.jRadioButtonQuestionable)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldCaved, -2, -1, -2).add((Component)this.jRadioButtonCaved)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldNotCaved, -2, -1, -2).add((Component)this.jRadioButtonNotCaved)))))).add(18, 18, 18).add((Component)this.jSeparator1, -2, 5, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        char newValue;
        String field;
        String toString;
        String fromString;
        int nUpdate;
        Object msg = "Really update all ";
        if (this.jRadioButtonRw.isSelected()) {
            nUpdate = Integer.parseInt(this.jTextFieldInSitu.getText());
            fromString = "In Situ";
            toString = "Reworked";
            field = "status";
            newValue = 'R';
        } else if (this.jRadioButtonInSitu.isSelected()) {
            nUpdate = Integer.parseInt(this.jTextFieldRw.getText());
            fromString = "Reworked";
            toString = "In Situ";
            field = "status";
            newValue = 'I';
        } else if (this.jRadioButtonPositive.isSelected()) {
            nUpdate = Integer.parseInt(this.jTextFieldQuestionable.getText());
            fromString = "Questionable";
            toString = "Positive";
            field = "ident_type";
            newValue = 'P';
        } else if (this.jRadioButtonQuestionable.isSelected()) {
            nUpdate = Integer.parseInt(this.jTextFieldPositive.getText());
            fromString = "Positive";
            toString = "Questionable";
            field = "ident_type";
            newValue = '?';
        } else if (this.jRadioButtonNotCaved.isSelected()) {
            nUpdate = Integer.parseInt(this.jTextFieldCaved.getText());
            fromString = "Caved";
            toString = "Not caved";
            field = "caved";
            newValue = 'N';
        } else if (this.jRadioButtonCaved.isSelected()) {
            nUpdate = Integer.parseInt(this.jTextFieldNotCaved.getText());
            fromString = "Not caved";
            toString = "Caved";
            field = "caved";
            newValue = 'Y';
        } else {
            JOptionPane.showMessageDialog(this, "No update option selected.", this.getTitle(), 2);
            return;
        }
        msg = (String)msg + nUpdate + " " + fromString + " occurrences  of " + this.taxon.toString() + " to " + toString + "?";
        if (JOptionPane.showConfirmDialog(this.rootPane, msg, this.getTitle(), 0, 3) == 0) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                int nUpdated = this.db.updateOcc(this.taxon, field, newValue);
                this.db.commit();
                JOptionPane.showMessageDialog(this.rootPane, "Number of records updated: " + nUpdated + ". Commit?", this.getTitle(), 1);
                this.dispose();
            }
            catch (SBPermissionException pe) {
                JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
            }
            catch (SQLException | SBException ex) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", (Exception)ex, this.db);
            }
            catch (RuntimeException re) {
                this.db.doRollback();
                StackError.showStackError((String)"", (Throwable)re);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogeditoccurrences.html");
    }
}

