/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonFactory;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.DialogSelectTaxa;
import jsbugs.FrameJsbugs;
import model3.Lastval;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogEvent
extends SBDialog {
    private static final int DESCR_LEN = 240;
    private static final int NAME_LEN = 100;
    private final SBdb db;
    private final SBEvent original;
    model3.Taxon taxon;
    SBEvent sbEvent;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonTaxon;
    private JCheckBox jCheckBoxGenerate;
    private JCheckBox jCheckBoxHasBases;
    private JCheckBox jCheckBoxHasSingles;
    private JCheckBox jCheckBoxHasTops;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAbr;
    private JTextField jTextFieldDescription;
    private JTextField jTextFieldEvent;
    private JTextField jTextFieldPfxBaseSchemes;
    private JTextField jTextFieldPfxBaseWells;
    private JTextField jTextFieldPfxSingleSchemes;
    private JTextField jTextFieldPfxSingleWells;
    private JTextField jTextFieldPfxTopSchemes;
    private JTextField jTextFieldPfxTopWells;
    private JTextField jTextFieldTaxon;

    public DialogEvent(Frame parent, boolean modal, SBdb db, SBEvent event, model3.Taxon taxon) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.original = event;
        this.taxon = taxon;
        this.init();
    }

    public DialogEvent(JDialog parent, boolean modal, SBdb db, SBEvent event, model3.Taxon taxon) {
        super((Window)parent, modal);
        this.initComponents();
        this.db = db;
        this.original = event;
        this.taxon = taxon;
        this.init();
    }

    public DialogEvent(JDialog parent, boolean modal, SBdb db, SBEvent event) {
        super((Window)parent, modal);
        this.initComponents();
        this.db = db;
        this.original = event;
        this.init();
    }

    public void setEventName(String name) {
        this.jTextFieldEvent.setText(name);
    }

    private void setPfxField(SBEvent event, EventType evType, EventContext context, JTextField field) {
        String pfx = event.getPrefix(evType, context, false);
        if (pfx == null) {
            field.setForeground(Color.GRAY);
            field.setText(evType.toString(context));
        } else {
            field.setForeground(Color.BLACK);
            field.setText(pfx);
        }
    }

    private String getPfxField(EventType evType, EventContext context, JTextField field, JCheckBox hasPrefix) {
        String pfx = field.getText().trim();
        if (pfx.equalsIgnoreCase(evType.toString(context)) || pfx.isEmpty() && !hasPrefix.isSelected()) {
            return null;
        }
        return pfx;
    }

    private void init() {
        if (this.original == null || this.db != this.original.getDatabase()) {
            this.setTitle("Event : Add");
        } else {
            this.setTitle("Event : Edit");
        }
        if (this.original != null) {
            this.jTextFieldDescription.setText(this.original.getEvDesc());
            this.jTextFieldEvent.setText(this.original.getName());
            this.jTextFieldAbr.setText(this.original.getAbr() != null ? this.original.getAbr() : "");
            if (this.original.getTaxon() != null) {
                this.taxon = this.original.getTaxon().getLink() != null ? this.original.getTaxon().getLink() : this.original.getTaxon();
                this.jTextFieldTaxon.setText(this.taxon.toString());
            }
            if (this.original.hasEvType(EventType.TOP)) {
                this.jCheckBoxHasTops.setSelected(true);
                this.setPfxField(this.original, EventType.TOP, EventContext.WELL, this.jTextFieldPfxTopWells);
                this.setPfxField(this.original, EventType.TOP, EventContext.SCHEME, this.jTextFieldPfxTopSchemes);
            } else {
                this.jTextFieldPfxTopWells.setEnabled(false);
                this.jTextFieldPfxTopSchemes.setEnabled(false);
            }
            if (this.original.hasEvType(EventType.BASE)) {
                this.jCheckBoxHasBases.setSelected(true);
                this.setPfxField(this.original, EventType.BASE, EventContext.WELL, this.jTextFieldPfxBaseWells);
                this.setPfxField(this.original, EventType.BASE, EventContext.SCHEME, this.jTextFieldPfxBaseSchemes);
            } else {
                this.jTextFieldPfxBaseWells.setEnabled(false);
                this.jTextFieldPfxBaseSchemes.setEnabled(false);
            }
            if (this.original.hasEvType(EventType.SINGLE)) {
                this.jCheckBoxHasSingles.setSelected(true);
                this.setPfxField(this.original, EventType.SINGLE, EventContext.WELL, this.jTextFieldPfxSingleWells);
                this.setPfxField(this.original, EventType.SINGLE, EventContext.SCHEME, this.jTextFieldPfxSingleSchemes);
            } else {
                this.jTextFieldPfxSingleWells.setEnabled(false);
                this.jTextFieldPfxSingleSchemes.setEnabled(false);
            }
            this.jCheckBoxGenerate.setSelected(this.original.isGenerate());
        } else if (this.taxon != null) {
            this.jTextFieldTaxon.setText(this.taxon.toString());
            this.jTextFieldEvent.setText(this.taxon.toString(false, false));
            this.jCheckBoxHasTops.setSelected(true);
            this.jCheckBoxHasTopsActionPerformed(null);
            this.jCheckBoxHasBases.setSelected(true);
            this.jCheckBoxHasBasesActionPerformed(null);
            this.jCheckBoxGenerate.setSelected(true);
        }
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initComponents() {
        this.jTextFieldTaxon = new JTextField();
        this.jTextFieldEvent = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonTaxon = new JButton();
        this.jButtonTaxon.putClientProperty("JComponent.sizeVariant", "small");
        this.jPanel1 = new JPanel();
        this.jCheckBoxGenerate = new JCheckBox();
        this.jCheckBoxHasTops = new JCheckBox();
        this.jCheckBoxHasBases = new JCheckBox();
        this.jCheckBoxHasSingles = new JCheckBox();
        this.jTextFieldPfxSingleWells = new JTextField();
        this.jTextFieldPfxSingleSchemes = new JTextField();
        this.jTextFieldPfxBaseWells = new JTextField();
        this.jTextFieldPfxBaseSchemes = new JTextField();
        this.jTextFieldPfxTopWells = new JTextField();
        this.jTextFieldPfxTopSchemes = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jTextFieldDescription = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldAbr = new JTextField();
        this.jLabel5 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jTextFieldTaxon.setEditable(false);
        this.jTextFieldTaxon.setBackground(new Color(255, 255, 204));
        this.jTextFieldEvent.setToolTipText("Type event name");
        this.jTextFieldEvent.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldEventKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Taxon name:");
        this.jLabel2.setText("Event name:");
        this.jButtonTaxon.setText("...");
        this.jButtonTaxon.setToolTipText("Select taxon");
        this.jButtonTaxon.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTaxonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Type"), "Permitted event types", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxGenerate.setText("Use to generate top or base well events");
        this.jCheckBoxGenerate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxGenerate.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxHasTops.setText("Top");
        this.jCheckBoxHasTops.setMargin(new Insets(2, 0, 2, 0));
        this.jCheckBoxHasTops.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxHasTopsActionPerformed(evt);
            }
        });
        this.jCheckBoxHasBases.setText("Base");
        this.jCheckBoxHasBases.setMargin(new Insets(2, 0, 2, 0));
        this.jCheckBoxHasBases.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxHasBasesActionPerformed(evt);
            }
        });
        this.jCheckBoxHasSingles.setText("Single");
        this.jCheckBoxHasSingles.setMargin(new Insets(2, 0, 2, 0));
        this.jCheckBoxHasSingles.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxHasSinglesActionPerformed(evt);
            }
        });
        this.jTextFieldPfxSingleWells.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldPfxSingleWellsKeyTyped(evt);
            }
        });
        this.jTextFieldPfxSingleSchemes.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldPfxSingleSchemesKeyTyped(evt);
            }
        });
        this.jTextFieldPfxBaseWells.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldPfxBaseWellsKeyTyped(evt);
            }
        });
        this.jTextFieldPfxBaseSchemes.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldPfxBaseSchemesKeyTyped(evt);
            }
        });
        this.jTextFieldPfxTopWells.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldPfxTopWellsKeyTyped(evt);
            }
        });
        this.jTextFieldPfxTopSchemes.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldPfxTopSchemesKeyTyped(evt);
            }
        });
        this.jLabel6.setText("Prefix in wells:");
        this.jLabel7.setText("Prefix in schemes:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel6).add((Component)this.jLabel7)).addPreferredGap(0, 15, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxGenerate, -2, 302, -2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxHasTops).add((Component)this.jTextFieldPfxTopSchemes, -2, 97, -2).add((Component)this.jTextFieldPfxTopWells, -2, 97, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxHasBases).add((Component)this.jTextFieldPfxBaseSchemes, -2, 97, -2).add((Component)this.jTextFieldPfxBaseWells, -2, 97, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldPfxSingleSchemes, -2, 97, -2).add((Component)this.jCheckBoxHasSingles).add((Component)this.jTextFieldPfxSingleWells, -2, 97, -2)))).add(34, 34, 34)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jCheckBoxHasSingles).add((Component)this.jCheckBoxHasBases).add((Component)this.jCheckBoxHasTops)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jTextFieldPfxSingleWells, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jTextFieldPfxSingleSchemes, -2, -1, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jTextFieldPfxBaseWells, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jTextFieldPfxBaseSchemes, -2, -1, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jTextFieldPfxTopWells, -2, -1, -2).add((Component)this.jLabel6)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jTextFieldPfxTopSchemes, -2, -1, -2).add((Component)this.jLabel7)))).addPreferredGap(1).add((Component)this.jCheckBoxGenerate).addContainerGap()));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jTextFieldDescription.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDescriptionKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Description:");
        this.jLabel4.setText("Abbreviation:");
        this.jTextFieldAbr.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEvent this$0;
            {
                DialogEvent dialogEvent = this$0;
                Objects.requireNonNull(dialogEvent);
                this.this$0 = dialogEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldAbrKeyTyped(evt);
            }
        });
        this.jLabel5.setForeground(new Color(102, 102, 102));
        this.jLabel5.setText("(optional)");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldAbr).addPreferredGap(0).add((Component)this.jLabel5)).add((Component)this.jTextFieldEvent).add((Component)this.jTextFieldTaxon)).addPreferredGap(0).add((Component)this.jButtonTaxon, -2, 35, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldDescription))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jButtonTaxon).add((Component)this.jTextFieldTaxon, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldEvent, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldAbr, -2, -1, -2).add((Component)this.jLabel5)).add(18, 18, 18).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldDescription, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 8, -2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonTaxonActionPerformed(ActionEvent evt) {
        try {
            Taxon lookupTaxon = null;
            if (this.jTextFieldEvent.getText().length() > 0) {
                lookupTaxon = TaxonFactory.parse((String)this.jTextFieldEvent.getText().trim());
            }
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)((Object)this), true, this.db, Lastval.getInt(this.db, "SYNSCHID", 1), true, lookupTaxon);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelectedItem() != null) {
                this.taxon = this.db.getTaxon(((Taxon)dialog.getSelectedItem()).getSpecID());
                this.jTextFieldTaxon.setText(this.taxon.toString());
                if (this.jTextFieldEvent.getText().trim().length() == 0) {
                    this.jTextFieldEvent.setText(this.taxon.toString(false, false));
                }
                if (!this.jCheckBoxGenerate.isSelected()) {
                    this.jCheckBoxGenerate.setSelected(true);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String evName = this.jTextFieldEvent.getText().trim();
        if (evName.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter an event name", this.getTitle(), 2);
            this.jTextFieldEvent.requestFocusInWindow();
            return;
        }
        if (!(this.jCheckBoxHasTops.isSelected() || this.jCheckBoxHasBases.isSelected() || this.jCheckBoxHasSingles.isSelected())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "At least one type of event must be permitted", this.getTitle(), 2);
            return;
        }
        try {
            String topWellPfx = this.getPfxField(EventType.TOP, EventContext.WELL, this.jTextFieldPfxTopWells, this.jCheckBoxHasTops);
            String baseWellPfx = this.getPfxField(EventType.BASE, EventContext.WELL, this.jTextFieldPfxBaseWells, this.jCheckBoxHasBases);
            String singleWellPfx = this.getPfxField(EventType.SINGLE, EventContext.WELL, this.jTextFieldPfxSingleWells, this.jCheckBoxHasSingles);
            String topSchemePfx = this.getPfxField(EventType.TOP, EventContext.SCHEME, this.jTextFieldPfxTopSchemes, this.jCheckBoxHasTops);
            String baseSchemePfx = this.getPfxField(EventType.BASE, EventContext.SCHEME, this.jTextFieldPfxBaseSchemes, this.jCheckBoxHasBases);
            String singleSchemePfx = this.getPfxField(EventType.SINGLE, EventContext.SCHEME, this.jTextFieldPfxSingleSchemes, this.jCheckBoxHasSingles);
            if ((topWellPfx != null && !topWellPfx.isBlank() && topWellPfx.equalsIgnoreCase(baseWellPfx) || topSchemePfx != null && !topSchemePfx.isBlank() && topSchemePfx.equalsIgnoreCase(baseSchemePfx)) && JOptionPane.showConfirmDialog((Component)((Object)this), "Warning: prefixes for top and base are equal, Continue?", this.getTitle(), 0, 2) == 1) {
                return;
            }
            SBEvent.Builder builder = new SBEvent.Builder().name(evName).taxon(this.taxon).desc(this.jTextFieldDescription.getText()).abr(this.jTextFieldAbr.getText());
            builder.isGenerate(this.jCheckBoxGenerate.isSelected());
            builder.setUpType(EventType.TOP, this.jCheckBoxHasTops.isSelected(), topWellPfx, topSchemePfx);
            builder.setUpType(EventType.BASE, this.jCheckBoxHasBases.isSelected(), baseWellPfx, baseSchemePfx);
            builder.setUpType(EventType.SINGLE, this.jCheckBoxHasSingles.isSelected(), singleWellPfx, singleSchemePfx);
            if ((this.original == null || evName.compareToIgnoreCase(this.original.getName()) != 0) && this.db.getSBEvent(builder.getDictionaryEvent()) != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "An event of that name already exists in the database.", this.getTitle(), 2);
                return;
            }
            if (this.original == null || this.db != this.original.getDatabase()) {
                this.sbEvent = this.db.addSBEvent(builder);
                if (this.sbEvent.isGenerate() != this.jCheckBoxGenerate.isSelected()) {
                    try {
                        this.sbEvent.setGenerate(this.jCheckBoxGenerate.isSelected());
                    }
                    catch (SBEvent.GenerateUniqueException e) {
                        JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this.getTitle(), 2);
                    }
                }
            } else {
                for (EventType eventType : EventType.values()) {
                    if (this.checkEventTypeUpdate(builder, eventType)) continue;
                    return;
                }
                this.db.updateSBEvent(this.original, builder);
                this.sbEvent = this.original;
                this.original.notifyObservers();
            }
            this.db.commit();
            this.db.notifyObservers(this.sbEvent);
            this.setOK();
        }
        catch (SBEvent.GenerateUniqueException | SBPermissionException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), ((Throwable)e).getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private boolean checkEventTypeUpdate(SBEvent.Builder builder, EventType eventType) throws SQLException {
        if (!builder.getDictionaryEvent().isPermitted(eventType)) {
            int nWellOccs = this.db.getSBEvent(this.original.getEvID()).getNoccs(true, eventType);
            int nCmpStdOccs = this.db.getSBEvent(this.original.getEvID()).getNcmpStdOccs(eventType);
            if (nWellOccs > 0 || nCmpStdOccs > 0) {
                String msg = "Can't update event type " + eventType.toString() + " because there are existing events - ";
                if (nWellOccs > 0) {
                    msg = msg + " in wells: " + nWellOccs;
                }
                if (nCmpStdOccs > 0) {
                    msg = msg + " in Composite Standards: " + nCmpStdOccs;
                }
                JOptionPane.showMessageDialog((Component)((Object)this), msg);
                return false;
            }
        }
        return true;
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogevent.html");
    }

    private void jTextFieldDescriptionKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldDescription, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldEventKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldEvent, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldAbrKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldAbr, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jCheckBoxHasTopsActionPerformed(ActionEvent evt) {
        this.setPfxField(this.jCheckBoxHasTops, this.jTextFieldPfxTopWells, EventType.TOP, EventContext.WELL);
        this.setPfxField(this.jCheckBoxHasTops, this.jTextFieldPfxTopSchemes, EventType.TOP, EventContext.SCHEME);
    }

    private void jCheckBoxHasBasesActionPerformed(ActionEvent evt) {
        this.setPfxField(this.jCheckBoxHasBases, this.jTextFieldPfxBaseWells, EventType.BASE, EventContext.WELL);
        this.setPfxField(this.jCheckBoxHasBases, this.jTextFieldPfxBaseSchemes, EventType.BASE, EventContext.SCHEME);
    }

    private void jCheckBoxHasSinglesActionPerformed(ActionEvent evt) {
        this.setPfxField(this.jCheckBoxHasSingles, this.jTextFieldPfxSingleWells, EventType.SINGLE, EventContext.WELL);
        this.setPfxField(this.jCheckBoxHasSingles, this.jTextFieldPfxSingleSchemes, EventType.SINGLE, EventContext.SCHEME);
    }

    private void jTextFieldPfxTopSchemesKeyTyped(KeyEvent evt) {
        this.setPfxKeyTyped(this.jTextFieldPfxTopSchemes);
    }

    private void jTextFieldPfxBaseWellsKeyTyped(KeyEvent evt) {
        this.setPfxKeyTyped(this.jTextFieldPfxBaseWells);
    }

    private void jTextFieldPfxBaseSchemesKeyTyped(KeyEvent evt) {
        this.setPfxKeyTyped(this.jTextFieldPfxBaseSchemes);
    }

    private void jTextFieldPfxSingleWellsKeyTyped(KeyEvent evt) {
        this.setPfxKeyTyped(this.jTextFieldPfxSingleWells);
    }

    private void jTextFieldPfxSingleSchemesKeyTyped(KeyEvent evt) {
        this.setPfxKeyTyped(this.jTextFieldPfxSingleSchemes);
    }

    private void jTextFieldPfxTopWellsKeyTyped(KeyEvent evt) {
        this.setPfxKeyTyped(this.jTextFieldPfxTopWells);
    }

    private void setPfxKeyTyped(JTextField field) {
        field.setForeground(Color.black);
    }

    void setTaxon(model3.Taxon taxon) {
        this.taxon = taxon;
        this.jTextFieldTaxon.setText(taxon.toString());
        this.jTextFieldEvent.setText(taxon.toString(false, false));
        this.jCheckBoxGenerate.setSelected(true);
        this.jCheckBoxHasTops.setSelected(true);
        this.jCheckBoxHasTopsActionPerformed(null);
        this.jCheckBoxHasBases.setSelected(true);
        this.jCheckBoxHasBasesActionPerformed(null);
        this.jCheckBoxHasSingles.setSelected(false);
    }

    private void setPfxField(JCheckBox jCheckBox, JTextField jTextField, EventType evType, EventContext context) {
        if (jCheckBox.isSelected()) {
            jTextField.setEnabled(true);
            String strg = jTextField.getText();
            if (strg.isEmpty() || strg.equalsIgnoreCase(evType.toString(context))) {
                jTextField.setText(evType.toString(context));
                jTextField.setForeground(Color.GRAY);
            } else {
                jTextField.setForeground(Color.BLACK);
            }
        } else {
            jTextField.setEnabled(false);
            jTextField.setText("");
        }
    }
}

