/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventType;
import com.stratadata.util.io.FileChooserUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import jsbugs.EventStdOccTableModel;
import jsbugs.EventWellOccTableModel;
import jsbugs.FrameJsbugs;
import jsbugs.model2.event.DialogCmpStd;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.Lastval;
import model3.SBEvent;
import model3.SBdb;
import model3.Surface;
import model3.WellOccQueryResult;
import org.apache.commons.lang3.StringUtils;
import util.FilePathUtils;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.gridwriter.CellFormat;
import util.gridwriter.GridSheet;
import util.gridwriter.GridWriter;

public class DialogEventOcc
extends JDialog {
    private final EventWellOccTableModel wellModel = new EventWellOccTableModel();
    private final EventStdOccTableModel cmpstdModel = new EventStdOccTableModel();
    private static int tab = 0;
    private final SBdb db;
    private final int igdType;
    private SBEvent event;
    private Surface surface;
    private final Frame parent;
    public WellOccQueryResult selectedWellResult = null;
    private JButton jButtonClose;
    private JButton jButtonGotoComposite;
    private JButton jButtonGotoWell;
    private JButton jButtonWriteCSV;
    private JLabel jLabelLabel;
    private JLabel jLabelMeanAge;
    private JPanel jPanel1;
    private JPanel jPanelCmpStd;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JTable jTableCmpstds;
    private JTable jTableWells;
    private JTextField jTextFieldEvent;

    public DialogEventOcc(Frame parent, boolean modal, int igdType, SBdb db) {
        super(parent, modal);
        this.parent = parent;
        this.db = db;
        this.igdType = igdType;
        this.initComponents();
    }

    public DialogEventOcc(JDialog parent, boolean modal, int igdType, SBdb db) {
        super((Dialog)parent, modal);
        this.parent = null;
        this.db = db;
        this.igdType = igdType;
        this.initComponents();
        this.jButtonGotoWell.setEnabled(false);
    }

    public void setEvent(SBEvent event) {
        if (this.igdType != 20) {
            throw new IllegalStateException("Error initialising DialogEventOcc with incorrect igdType");
        }
        this.event = event;
        this.init();
    }

    public void setSurface(Surface surface) {
        if (this.igdType != 21) {
            throw new IllegalStateException("Error initialising DialogEventOcc with incorrect igdType");
        }
        this.surface = surface;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object title;
        this.wellModel.setupTable(this.jTableWells, this.db);
        switch (this.igdType) {
            case 21: {
                title = "Sequence Pick usage : " + String.valueOf(this.surface);
                this.jTextFieldEvent.setText(this.surface.toString(true));
                this.jLabelLabel.setText("Surface:");
                this.jTabbedPane1.remove(this.jPanelCmpStd);
                break;
            }
            case 20: {
                title = "Event Usage : " + String.valueOf(this.event);
                this.jTextFieldEvent.setText(this.event.getName());
                this.jLabelLabel.setText("Event:");
                this.cmpstdModel.setupTable(this.jTableCmpstds);
                break;
            }
            default: {
                title = "Error - IGDtype unset";
            }
        }
        this.setTitle((String)title);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        try {
            this.db.getInterps();
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError("Error loading interpHdrs", ex, this);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.igdType == 20) {
                this.wellModel.events = this.event.getWellOccs();
                this.cmpstdModel.events = this.event.getCmpstdOccs();
            } else {
                this.wellModel.events = this.surface.getWellOccs();
            }
            for (WellOccQueryResult queryResult : this.wellModel.events) {
                try {
                    this.db.getWell(queryResult.wellID).loadInterps();
                    System.out.println("Loading version data for well: " + String.valueOf(this.db.getWell(queryResult.wellID)));
                    this.db.getWell(queryResult.wellID).getInterp(queryResult.interpID);
                }
                catch (SBException ex) {
                    System.out.println("Cannot get well interp due to error: " + ex.getMessage());
                    queryResult.wellName = "Restricted";
                    queryResult.interpName = "";
                }
            }
            this.setMeanAge();
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ DialogEventOcc this$0;
            {
                DialogEventOcc dialogEventOcc = this$0;
                Objects.requireNonNull(dialogEventOcc);
                this.this$0 = dialogEventOcc;
            }

            public String doInBackground() {
                this.this$0.wellModel.loadStratigraphy();
                return "";
            }

            @Override
            public void done() {
                this.this$0.wellModel.fireTableDataChanged();
            }
        };
        worker.execute();
        this.wellModel.fireTableDataChanged();
        this.cmpstdModel.fireTableDataChanged();
        this.jTabbedPane1.setSelectedIndex(tab);
    }

    private void setMeanAge() {
        if (this.wellModel.events.size() < 2) {
            this.jLabelMeanAge.setText("");
            return;
        }
        Object label = "";
        try {
            for (EventType type : EventType.values()) {
                String typeString;
                if (this.igdType == 21 && type != EventType.SINGLE) continue;
                double[] stats = SBEvent.getAgeStats(this.db, type, this.wellModel.events);
                String string = typeString = type == EventType.SINGLE ? "" : type.toString();
                if (stats[0] < (double)0.0029f && stats[1] < (double)0.0029f) continue;
                if (!((String)label).isEmpty()) {
                    label = (String)label + ", ";
                }
                label = (String)label + typeString + " [Mean:" + SB.floatString((double)stats[0], (int)2).trim() + ", Median:" + SB.floatString((double)stats[1], (int)2).trim() + "]";
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
            this.jLabelMeanAge.setText("Error!");
            return;
        }
        this.jLabelMeanAge.setText((String)label);
    }

    private void initComponents() {
        this.jLabelLabel = new JLabel();
        this.jTextFieldEvent = new JTextField();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableWells = new JTable();
        this.jButtonGotoWell = new JButton();
        this.jLabelMeanAge = new JLabel();
        this.jPanelCmpStd = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableCmpstds = new JTable();
        this.jButtonGotoComposite = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonWriteCSV = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 350));
        this.jLabelLabel.setText("xxxxxxxx");
        this.jTextFieldEvent.setEditable(false);
        this.jTextFieldEvent.setBackground(new Color(255, 255, 204));
        this.jTableWells.setModel(this.wellModel);
        this.jTableWells.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTableWells);
        this.jButtonGotoWell.setText("Go to Well...");
        this.jButtonGotoWell.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEventOcc this$0;
            {
                DialogEventOcc dialogEventOcc = this$0;
                Objects.requireNonNull(dialogEventOcc);
                this.this$0 = dialogEventOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGotoWellActionPerformed(evt);
            }
        });
        this.jLabelMeanAge.setText("Median: Mean:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 497, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelMeanAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonGotoWell))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 168, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonGotoWell).addComponent(this.jLabelMeanAge)).addContainerGap()));
        this.jTabbedPane1.addTab("Wells", this.jPanel1);
        this.jTableCmpstds.setModel(this.cmpstdModel);
        this.jTableCmpstds.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jTableCmpstds);
        this.jButtonGotoComposite.setText("Go to Composite...");
        this.jButtonGotoComposite.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEventOcc this$0;
            {
                DialogEventOcc dialogEventOcc = this$0;
                Objects.requireNonNull(dialogEventOcc);
                this.this$0 = dialogEventOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGotoCompositeActionPerformed(evt);
            }
        });
        GroupLayout jPanelCmpStdLayout = new GroupLayout(this.jPanelCmpStd);
        this.jPanelCmpStd.setLayout(jPanelCmpStdLayout);
        jPanelCmpStdLayout.setHorizontalGroup(jPanelCmpStdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelCmpStdLayout.createSequentialGroup().addContainerGap().addGroup(jPanelCmpStdLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -1, 497, Short.MAX_VALUE).addGroup(jPanelCmpStdLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonGotoComposite))).addContainerGap()));
        jPanelCmpStdLayout.setVerticalGroup(jPanelCmpStdLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelCmpStdLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 168, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonGotoComposite).addContainerGap()));
        this.jTabbedPane1.addTab("Composite Standards", this.jPanelCmpStd);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEventOcc this$0;
            {
                DialogEventOcc dialogEventOcc = this$0;
                Objects.requireNonNull(dialogEventOcc);
                this.this$0 = dialogEventOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonWriteCSV.setText("Save as...");
        this.jButtonWriteCSV.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEventOcc this$0;
            {
                DialogEventOcc dialogEventOcc = this$0;
                Objects.requireNonNull(dialogEventOcc);
                this.this$0 = dialogEventOcc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWriteCSVActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldEvent)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonWriteCSV).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClose))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelLabel).addComponent(this.jTextFieldEvent, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonWriteCSV)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        tab = this.jTabbedPane1.getSelectedIndex();
        this.dispose();
    }

    private void jButtonGotoWellActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select a well event", this.getTitle(), 1);
            return;
        }
        this.selectedWellResult = this.wellModel.events.get(this.jTableWells.convertRowIndexToModel(this.jTableWells.getSelectedRow()));
        this.dispose();
    }

    private void jButtonGotoCompositeActionPerformed(ActionEvent evt) {
        if (this.jTableCmpstds.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select a composite standard event", this.getTitle(), 1);
            return;
        }
        SBEvent.CmpstdEventQueryResult result = this.cmpstdModel.events.get(this.jTableCmpstds.convertRowIndexToModel(this.jTableCmpstds.getSelectedRow()));
        try {
            CompositeStandard cmpStd = this.db.getCompositeStandard(result.stdID);
            DialogCmpStd dialog = new DialogCmpStd(this.parent, true, this.db, cmpStd);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.cmpstdModel.events = this.event.getCmpstdOccs();
                this.cmpstdModel.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonWriteCSVActionPerformed(ActionEvent evt) {
        if (!(this.wellModel != null && this.wellModel.getRowCount() != 0 || this.cmpstdModel != null && this.cmpstdModel.getRowCount() != 0)) {
            JOptionPane.showMessageDialog(this, "There are no occurrence data to save", this.getTitle(), 1);
            return;
        }
        try {
            Object occ;
            int row;
            String fileName = Lastval.getString(this.db, "OCCCSVFILE");
            String fileDefaultName = SB.makeFileName((String)this.event.getName());
            File file = FileChooserUtils.saveAsGridDataDialog((Component)this.jPanel1, (String)fileName, (String)fileDefaultName);
            if (file == null) {
                return;
            }
            fileName = file.getPath();
            GridWriter gw = new GridWriter();
            gw.getXLSOptions().setSheetName("Event Occurrences - " + this.event.getName());
            gw.getXLSOptions().setAuthorName(this.db.getUser().getName());
            boolean continueSave = FileOverwriteCheck.checkForGridFileOverwriting(this, (Component)this, file, gw);
            if (!continueSave) {
                return;
            }
            boolean csvOutput = FilePathUtils.isFileExtension((String)fileName, (String[])FileChooserUtils.CSV_FILTER.getExtensions());
            GridSheet gb = new GridSheet();
            CellFormat format = new CellFormat().setBold(true).setBorder(2);
            gb.addRow();
            gb.append(new Object[]{format, "Event occurrences: "});
            gb.append(new Object[]{format, this.event.getName()});
            format = new CellFormat().setBold(true).setBorder(2);
            gb.addRow();
            gb.addRow();
            gb.append(new Object[]{format, "Well name", "Version", "Sample", "Event Type", "Age (Ma)"});
            for (row = 0; row < this.wellModel.getRowCount(); ++row) {
                occ = this.wellModel.events.get(row);
                gb.addRow(new Object[]{((WellOccQueryResult)occ).wellName});
                gb.append(new Object[]{((WellOccQueryResult)occ).interpName});
                gb.append(new Object[]{((WellOccQueryResult)occ).sample.toString()});
                gb.append(new Object[]{((WellOccQueryResult)occ).type.toString()});
                gb.append(new Object[]{StringUtils.isBlank((CharSequence)this.wellModel.getAgeString((WellOccQueryResult)occ)) ? "" : Double.valueOf(Double.parseDouble(this.wellModel.getAgeString((WellOccQueryResult)occ)))});
            }
            gb.addRow();
            format = new CellFormat().setBold(true).setBorder(2);
            gb.addRow();
            gb.append(new Object[]{format, "Composite Standard", "Event Type", "Age/CSU"});
            for (row = 0; row < this.cmpstdModel.getRowCount(); ++row) {
                occ = this.cmpstdModel.events.get(row);
                gb.addRow(new Object[]{((SBEvent.CmpstdEventQueryResult)occ).stdName});
                gb.append(new Object[]{CompositeStandardEvent.getEvTypeString(((SBEvent.CmpstdEventQueryResult)occ).type)});
                gb.append(new Object[]{((SBEvent.CmpstdEventQueryResult)occ).csu});
            }
            gw.write(file, gb.getObjectArray());
            Lastval.putString(this.db, "OCCCSVFILE", fileName);
            this.db.commit();
            JOptionPane.showMessageDialog(this, "File written", this.getTitle(), 1);
        }
        catch (IOException | SQLException | SBException sqle) {
            FrameJsbugs.showStackError(sqle.getMessage(), (Exception)sqle, this.db);
            sqle.printStackTrace();
            this.db.doRollback();
        }
    }
}

