/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import util.SB;

public class DialogEventPrefix
extends JDialog {
    SBdb sbdb;
    static final int PREFIX_LEN = 8;
    static final String TOP_DEFAULT = "Top";
    static final String BASE_DEFAULT = "Base";
    private JButton jButtonCancel;
    private JButton jButtonDefaults;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxSingle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JTextField jTextFieldCompositeBase;
    private JTextField jTextFieldCompositeTop;
    private JTextField jTextFieldWellBase;
    private JTextField jTextFieldWellTop;

    public DialogEventPrefix(Frame parent, boolean modal, SBdb sbdb) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jTextFieldWellTop.setText(EventType.TOP.toString(EventContext.WELL));
        this.jTextFieldWellBase.setText(EventType.BASE.toString(EventContext.WELL));
        this.jTextFieldCompositeTop.setText(EventType.TOP.toString(EventContext.SCHEME));
        this.jTextFieldCompositeBase.setText(EventType.BASE.toString(EventContext.SCHEME));
        this.jCheckBoxSingle.setSelected(!EventType.SINGLE.toString(EventContext.WELL).isEmpty());
        this.setTitle("Event Prefixes");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonDefaults = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldCompositeTop = new JTextField();
        this.jTextFieldCompositeBase = new JTextField();
        this.jPanel2 = new JPanel();
        this.jTextFieldWellBase = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextFieldWellTop = new JTextField();
        this.jLabel2 = new JLabel();
        this.jCheckBoxSingle = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEventPrefix this$0;
            {
                DialogEventPrefix dialogEventPrefix = this$0;
                Objects.requireNonNull(dialogEventPrefix);
                this.this$0 = dialogEventPrefix;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEventPrefix this$0;
            {
                DialogEventPrefix dialogEventPrefix = this$0;
                Objects.requireNonNull(dialogEventPrefix);
                this.this$0 = dialogEventPrefix;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel3.setText("<html>These prefixes are used when displaying<br>events throughout the system, including on<br>charts.</html>");
        this.jButtonDefaults.setText("Restore defaults");
        this.jButtonDefaults.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonDefaults.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEventPrefix this$0;
            {
                DialogEventPrefix dialogEventPrefix = this$0;
                Objects.requireNonNull(dialogEventPrefix);
                this.this$0 = dialogEventPrefix;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDefaultsActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Composite Standards", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel4.setText(" Extinction / LAD:");
        this.jLabel5.setText("Inception / FAD:");
        this.jTextFieldCompositeTop.setText(TOP_DEFAULT);
        this.jTextFieldCompositeTop.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEventPrefix this$0;
            {
                DialogEventPrefix dialogEventPrefix = this$0;
                Objects.requireNonNull(dialogEventPrefix);
                this.this$0 = dialogEventPrefix;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldCompositeTopKeyTyped(evt);
            }
        });
        this.jTextFieldCompositeBase.setText(BASE_DEFAULT);
        this.jTextFieldCompositeBase.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEventPrefix this$0;
            {
                DialogEventPrefix dialogEventPrefix = this$0;
                Objects.requireNonNull(dialogEventPrefix);
                this.this$0 = dialogEventPrefix;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldCompositeBaseKeyTyped(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldCompositeBase).addComponent(this.jTextFieldCompositeTop)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCompositeTop, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldCompositeBase, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Wells and Outcrops", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jTextFieldWellBase.setText(BASE_DEFAULT);
        this.jTextFieldWellBase.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEventPrefix this$0;
            {
                DialogEventPrefix dialogEventPrefix = this$0;
                Objects.requireNonNull(dialogEventPrefix);
                this.this$0 = dialogEventPrefix;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldWellBaseKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Top / FDO:");
        this.jTextFieldWellTop.setText(TOP_DEFAULT);
        this.jTextFieldWellTop.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEventPrefix this$0;
            {
                DialogEventPrefix dialogEventPrefix = this$0;
                Objects.requireNonNull(dialogEventPrefix);
                this.this$0 = dialogEventPrefix;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldWellTopKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Base / LDO:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldWellBase).addComponent(this.jTextFieldWellTop)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldWellTop, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldWellBase, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxSingle.setText("Use Single prefix");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jCheckBoxSingle, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDefaults, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSingle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonDefaults)).addContainerGap()));
        this.pack();
    }

    private void jButtonDefaultsActionPerformed(ActionEvent evt) {
        this.jTextFieldWellTop.setText(TOP_DEFAULT);
        this.jTextFieldWellBase.setText(BASE_DEFAULT);
        this.jTextFieldCompositeTop.setText(TOP_DEFAULT);
        this.jTextFieldCompositeBase.setText(BASE_DEFAULT);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String stdBase;
        String stdTop;
        String wellBase;
        String wellTop = this.jTextFieldWellTop.getText().trim();
        if (wellTop.isEmpty()) {
            wellTop = TOP_DEFAULT;
        }
        if ((wellBase = this.jTextFieldWellBase.getText().trim()).isEmpty()) {
            wellBase = BASE_DEFAULT;
        }
        if ((stdTop = this.jTextFieldCompositeTop.getText().trim()).isEmpty()) {
            stdTop = TOP_DEFAULT;
        }
        if ((stdBase = this.jTextFieldCompositeBase.getText().trim()).isEmpty()) {
            stdBase = BASE_DEFAULT;
        }
        if (wellTop.equals(wellBase)) {
            JOptionPane.showMessageDialog(this, "Well top and base prefxes must be different", this.getTitle(), 2);
            return;
        }
        if (stdTop.equals(stdBase)) {
            JOptionPane.showMessageDialog(this, "Composite top and base prefxes must be different", this.getTitle(), 2);
            return;
        }
        try {
            this.sbdb.putDatabasePref("EVENTPRXWT", wellTop);
            this.sbdb.putDatabasePref("EVENTPRXWB", wellBase);
            this.sbdb.putDatabasePref("EVENTPRXCT", stdTop);
            this.sbdb.putDatabasePref("EVENTPRXCB", stdBase);
            boolean useSingle = this.jCheckBoxSingle.isSelected();
            this.sbdb.putDatabasePref("EVENTPRSGL", useSingle);
            this.sbdb.commit();
            EventType.setPrefixes((String)wellTop, (String)wellBase, (String)stdTop, (String)stdBase, (boolean)useSingle);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("Error putting preferences", sql, this);
        }
        this.dispose();
    }

    private void jTextFieldWellTopKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldWellTop, (int)8, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldWellBaseKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldWellBase, (int)8, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCompositeTopKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldCompositeTop, (int)8, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCompositeBaseKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldCompositeBase, (int)8, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }
}

