/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.io.FileChooserUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.FrameJsbugs;
import jsbugs.io.JPanelCSVOptions;
import jsbugs.io.welldata.GridBuilderWellInterpSummary;
import jsbugs.uiutil.ComboboxItem;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.util.UserPrefsHelper;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import model3.WsWell;
import org.apache.commons.lang3.StringUtils;
import util.DepthUnits;
import util.FilePathUtils;
import util.exception.StackError;
import util.gridwriter.CSVExportOptions;
import util.gridwriter.GridWriter;

public class DialogExportText
extends JDialog {
    JFileChooser jFileChooser = null;
    SBdb db;
    Set<Integer> dataTypes;
    List<Well> wells;
    InterpHdr interp;
    private final Set<InterpHdr> interpVersions;
    private final UserPrefsHelper prefs;
    private ButtonGroup buttonGroupFormat;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectFile;
    private JCheckBox jCheckBoxDecimalPlaces;
    private JCheckBox jCheckBoxDuplicateSingleDepths;
    private JCheckBox jCheckBoxIncludeVersionName;
    private JCheckBox jCheckBoxShowUncorrectedDepths;
    private JCheckBox jCheckBoxUseCoreCorrections;
    private JCheckBox jCheckBoxUseCuttingCorrections;
    private JCheckBox jCheckBoxWriteWellCodes;
    private JComboBox<Integer> jComboBoxDecimalPlaces;
    private JComboBox<ComboboxItem<Object>> jComboBoxInterpVersions;
    private JComboBox<ComboboxItem<Character>> jComboBoxUnits;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelCSVOptions;
    private JPanelCSVOptions jPanelCSVOptions1;
    private JRadioButton jRadioButtonFormat1;
    private JRadioButton jRadioButtonFormat2;
    private JRadioButton jRadioButtonFormat3;
    private JRadioButton jRadioButtonFormat4;
    private JRadioButton jRadioButtonFormat5;
    private JRadioButton jRadioButtonFormat6;
    private JSeparator jSeparator1;
    private JTextField jTextFieldFile;

    public DialogExportText(Frame parent, boolean modal, SBdb db, Set<Integer> dataTypes, List<Well> wells, InterpHdr interp, char units, Set<InterpHdr> interpVersions) {
        super(parent, modal);
        this.db = db;
        this.dataTypes = dataTypes;
        this.wells = wells;
        this.interp = interp;
        this.prefs = new UserPrefsHelper(db);
        this.interpVersions = interpVersions;
        this.initComponents();
        this.init(units);
    }

    private void init(char initialUnits) {
        this.setTitle("Save Text File Options");
        ArrayList<ComboboxItem<Object>> options = new ArrayList<ComboboxItem<Object>>();
        if (this.interpVersions.size() > 1) {
            options.add(new ComboboxItem<Set<InterpHdr>>(this.interpVersions, "All"));
        }
        for (InterpHdr hdr : this.interpVersions) {
            options.add(new ComboboxItem<InterpHdr>(hdr, hdr.toString()));
        }
        this.jComboBoxInterpVersions.setModel(new DefaultComboBoxModel<Object>(options.toArray()));
        if (this.interp != null) {
            for (int i = 0; i < this.jComboBoxInterpVersions.getItemCount(); ++i) {
                InterpHdr hdr;
                ComboboxItem<Object> item = this.jComboBoxInterpVersions.getItemAt(i);
                if (item == null || !(item.getValue() instanceof InterpHdr) || (hdr = (InterpHdr)item.getValue()).getInterpID() != this.interp.getInterpID()) continue;
                this.jComboBoxInterpVersions.setSelectedIndex(i);
            }
        }
        ArrayList<ComboboxItem<Character>> unitOptions = new ArrayList<ComboboxItem<Character>>();
        if (initialUnits == 'D') {
            initialUnits = this.getUnitsForAllWells();
        }
        if (initialUnits == 'D') {
            unitOptions.add(new ComboboxItem<Character>(null, ""));
        }
        unitOptions.add(new ComboboxItem<Character>(Character.valueOf(DepthUnits.M.getChar()), DepthUnits.M.getFullName()));
        unitOptions.add(new ComboboxItem<Character>(Character.valueOf(DepthUnits.F.getChar()), DepthUnits.F.getFullName()));
        this.jComboBoxUnits.setModel(new DefaultComboBoxModel<Object>(unitOptions.toArray()));
        if (initialUnits != 'D') {
            for (int i = 0; i < this.jComboBoxUnits.getItemCount(); ++i) {
                ComboboxItem<Character> item = this.jComboBoxUnits.getItemAt(i);
                if (item == null || item.getValue() == null || item.getValue().charValue() != initialUnits) continue;
                this.jComboBoxUnits.setSelectedIndex(i);
                break;
            }
        }
        this.jRadioButtonFormat1.setSelected(true);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        Integer[] array = new Integer[]{0, 1, 2, 3};
        this.jComboBoxDecimalPlaces.setModel(new DefaultComboBoxModel<Integer>(array));
        if (this.areAnyWellsConnectedToDb()) {
            this.jCheckBoxUseCoreCorrections.setEnabled(true);
            boolean coreCorrections = this.prefs.getUseCoreSampleCorrections();
            this.jCheckBoxUseCoreCorrections.setSelected(coreCorrections);
            this.jCheckBoxUseCuttingCorrections.setEnabled(true);
            boolean cuttingCorrections = this.prefs.getUseCuttingSampleCorrections();
            this.jCheckBoxUseCuttingCorrections.setSelected(cuttingCorrections);
            this.jCheckBoxShowUncorrectedDepths.setSelected(this.prefs.getUseUncorrectedDepths());
            this.jCheckBoxDuplicateSingleDepths.setSelected(this.prefs.getDuplicateDepths());
            this.jCheckBoxShowUncorrectedDepths.setEnabled(coreCorrections || cuttingCorrections);
            this.jCheckBoxShowUncorrectedDepths.setSelected(this.jCheckBoxShowUncorrectedDepths.isSelected() && (coreCorrections || cuttingCorrections));
        }
        this.onSelectedVersionChanged();
    }

    private void initComponents() {
        this.buttonGroupFormat = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jRadioButtonFormat1 = new JRadioButton();
        this.jRadioButtonFormat2 = new JRadioButton();
        this.jRadioButtonFormat3 = new JRadioButton();
        this.jRadioButtonFormat4 = new JRadioButton();
        this.jRadioButtonFormat5 = new JRadioButton();
        this.jRadioButtonFormat6 = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jCheckBoxUseCoreCorrections = new JCheckBox();
        this.jCheckBoxUseCuttingCorrections = new JCheckBox();
        this.jCheckBoxWriteWellCodes = new JCheckBox();
        this.jCheckBoxIncludeVersionName = new JCheckBox();
        this.jCheckBoxDuplicateSingleDepths = new JCheckBox();
        this.jCheckBoxShowUncorrectedDepths = new JCheckBox();
        this.jComboBoxInterpVersions = new JComboBox();
        this.jPanelCSVOptions = new JPanel();
        this.jPanelCSVOptions1 = new JPanelCSVOptions();
        this.jCheckBoxDecimalPlaces = new JCheckBox();
        this.jComboBoxDecimalPlaces = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxUnits = new JComboBox();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportText this$0;
            {
                DialogExportText dialogExportText = this$0;
                Objects.requireNonNull(dialogExportText);
                this.this$0 = dialogExportText;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportText this$0;
            {
                DialogExportText dialogExportText = this$0;
                Objects.requireNonNull(dialogExportText);
                this.this$0 = dialogExportText;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportText this$0;
            {
                DialogExportText dialogExportText = this$0;
                Objects.requireNonNull(dialogExportText);
                this.this$0 = dialogExportText;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel1.setText("File:");
        this.jTextFieldFile.setEditable(false);
        this.jTextFieldFile.setBackground(new Color(255, 255, 204));
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.setToolTipText("Select a file");
        this.jButtonSelectFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportText this$0;
            {
                DialogExportText dialogExportText = this$0;
                Objects.requireNonNull(dialogExportText);
                this.this$0 = dialogExportText;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectFileActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Format", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupFormat.add(this.jRadioButtonFormat1);
        this.jRadioButtonFormat1.setText("Top depth only (one column per data type / scheme / hierarchy level)");
        this.buttonGroupFormat.add(this.jRadioButtonFormat2);
        this.jRadioButtonFormat2.setText("Top and base depths (all other data in one column - flat list)");
        this.buttonGroupFormat.add(this.jRadioButtonFormat3);
        this.jRadioButtonFormat3.setText("Well name, zones top/base, depth, type, level, discipline - flat list, 2 lines per interval");
        this.buttonGroupFormat.add(this.jRadioButtonFormat4);
        this.jRadioButtonFormat4.setText("As above but including boundary types");
        this.buttonGroupFormat.add(this.jRadioButtonFormat5);
        this.jRadioButtonFormat5.setText("Top and base depth (one column per data type / scheme / hierarchy level)");
        this.buttonGroupFormat.add(this.jRadioButtonFormat6);
        this.jRadioButtonFormat6.setText("Flat list with data Type and pick Type");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonFormat1).addComponent(this.jRadioButtonFormat2).addComponent(this.jRadioButtonFormat3).addComponent(this.jRadioButtonFormat4).addComponent(this.jRadioButtonFormat5).addComponent(this.jRadioButtonFormat6)).addContainerGap(57, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jRadioButtonFormat1, this.jRadioButtonFormat2, this.jRadioButtonFormat3, this.jRadioButtonFormat4, this.jRadioButtonFormat5);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonFormat1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFormat5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFormat2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFormat4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFormat3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonFormat6)));
        jPanel1Layout.linkSize(1, this.jRadioButtonFormat1, this.jRadioButtonFormat2, this.jRadioButtonFormat3, this.jRadioButtonFormat4, this.jRadioButtonFormat5);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxUseCoreCorrections.setText("Output core-corrected depths for core samples");
        this.jCheckBoxUseCoreCorrections.setEnabled(false);
        this.jCheckBoxUseCoreCorrections.setName("jCheckBoxUseCoreCorrections");
        this.jCheckBoxUseCoreCorrections.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportText this$0;
            {
                DialogExportText dialogExportText = this$0;
                Objects.requireNonNull(dialogExportText);
                this.this$0 = dialogExportText;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxUseCoreCorrectionsActionPerformed(evt);
            }
        });
        this.jCheckBoxUseCuttingCorrections.setText("Output core-corrected depths for cutting samples");
        this.jCheckBoxUseCuttingCorrections.setEnabled(false);
        this.jCheckBoxUseCuttingCorrections.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportText this$0;
            {
                DialogExportText dialogExportText = this$0;
                Objects.requireNonNull(dialogExportText);
                this.this$0 = dialogExportText;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxUseCuttingCorrectionsActionPerformed(evt);
            }
        });
        this.jCheckBoxWriteWellCodes.setText("Write well codes");
        this.jCheckBoxIncludeVersionName.setText("Include version name");
        this.jCheckBoxDuplicateSingleDepths.setText("Duplicate single depth columns to top & base");
        this.jCheckBoxShowUncorrectedDepths.setText("Output uncorrected depths as well");
        this.jCheckBoxShowUncorrectedDepths.setEnabled(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxUseCuttingCorrections, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxUseCoreCorrections, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxWriteWellCodes, -2, 275, -2).addComponent(this.jCheckBoxIncludeVersionName).addComponent(this.jCheckBoxDuplicateSingleDepths)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jCheckBoxShowUncorrectedDepths, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxUseCoreCorrections).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxUseCuttingCorrections, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxShowUncorrectedDepths, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxWriteWellCodes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeVersionName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDuplicateSingleDepths).addContainerGap()));
        this.jComboBoxInterpVersions.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportText this$0;
            {
                DialogExportText dialogExportText = this$0;
                Objects.requireNonNull(dialogExportText);
                this.this$0 = dialogExportText;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxInterpVersionsActionPerformed(evt);
            }
        });
        this.jPanelCSVOptions.setBorder(BorderFactory.createTitledBorder(null, "CSV Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxDecimalPlaces.setText("Set number of decimal places to export to");
        this.jCheckBoxDecimalPlaces.setMargin(new Insets(0, 2, 2, 2));
        this.jCheckBoxDecimalPlaces.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportText this$0;
            {
                DialogExportText dialogExportText = this$0;
                Objects.requireNonNull(dialogExportText);
                this.this$0 = dialogExportText;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxDecimalPlacesActionPerformed(evt);
            }
        });
        this.jComboBoxDecimalPlaces.setEnabled(false);
        GroupLayout jPanelCSVOptionsLayout = new GroupLayout(this.jPanelCSVOptions);
        this.jPanelCSVOptions.setLayout(jPanelCSVOptionsLayout);
        jPanelCSVOptionsLayout.setHorizontalGroup(jPanelCSVOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCSVOptionsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelCSVOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCSVOptionsLayout.createSequentialGroup().addComponent(this.jCheckBoxDecimalPlaces).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDecimalPlaces, -2, 44, -2)).addComponent(this.jPanelCSVOptions1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelCSVOptionsLayout.setVerticalGroup(jPanelCSVOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCSVOptionsLayout.createSequentialGroup().addComponent(this.jPanelCSVOptions1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE).addGroup(jPanelCSVOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxDecimalPlaces).addComponent(this.jComboBoxDecimalPlaces, -2, -1, -2))));
        this.jLabel3.setText("Version:");
        this.jLabel2.setText("Units:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelCSVOptions, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldFile).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxInterpVersions, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxUnits, 0, -1, Short.MAX_VALUE).addComponent(this.jButtonSelectFile, -2, 33, -2)))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFile, -2, -1, -2).addComponent(this.jButtonSelectFile).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxInterpVersions, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jComboBoxUnits, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelCSVOptions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogexporttext.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String fileName = this.jTextFieldFile.getText().trim();
        if (fileName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "File name blank", this.getTitle(), 2);
            return;
        }
        if (this.getUnits() == null) {
            JOptionPane.showMessageDialog(this, "No unit selected", this.getTitle(), 2);
            return;
        }
        GridWriter gw = new GridWriter();
        File file = new File(fileName);
        gw.getXLSOptions().setSheetName("StrataBugs Picks");
        gw.getXLSOptions().setAuthorName(this.db.getUser().getName());
        boolean continueSave = FileOverwriteCheck.checkForGridFileOverwriting(this, (Component)this, file, gw);
        if (!continueSave) {
            return;
        }
        boolean csvOutput = FilePathUtils.isFileExtension((String)fileName, (String[])FileChooserUtils.CSV_FILTER.getExtensions());
        if (csvOutput) {
            int minDigits = 0;
            int maxDigits = 6;
            if (this.jCheckBoxDecimalPlaces.isSelected()) {
                int selectedDigits;
                maxDigits = selectedDigits = ((Integer)this.jComboBoxDecimalPlaces.getSelectedItem()).intValue();
                minDigits = selectedDigits;
            }
            CSVExportOptions csvOptions = new CSVExportOptions(this.jPanelCSVOptions1.getColumnDelimiter(), this.jPanelCSVOptions1.getDecimalSeparator(), minDigits, maxDigits);
            gw.setCSVOptions(csvOptions);
        }
        this.prefs.setUseCoreSampleCorrections(this.jCheckBoxUseCoreCorrections.isSelected());
        this.prefs.setUseCuttingSampleCorrections(this.jCheckBoxUseCuttingCorrections.isSelected());
        this.prefs.setDuplicateDepths(this.jCheckBoxDuplicateSingleDepths.isSelected());
        this.prefs.setUseUncorrectedDepths(this.jCheckBoxShowUncorrectedDepths.isSelected());
        GridBuilderWellInterpSummary gb = new GridBuilderWellInterpSummary(this.db);
        gb.setUseCoreSampleCorrections(this.jCheckBoxUseCoreCorrections.isSelected());
        gb.setUseCuttingSampleCorrections(this.jCheckBoxUseCuttingCorrections.isSelected());
        gb.setIncludeWellCode(this.jCheckBoxWriteWellCodes.isSelected());
        gb.setIncludeVersionName(this.jCheckBoxIncludeVersionName.isSelected());
        gb.setDuplicateSingleDepths(this.jCheckBoxDuplicateSingleDepths.isSelected());
        gb.setIncludeUncorrectedDepths(this.jCheckBoxShowUncorrectedDepths.isSelected());
        Set<Integer> interpIds = this.getSelectedInterpIds();
        try {
            Object[][] grid = null;
            grid = this.jRadioButtonFormat1.isSelected() ? gb.buildGridOneColumnPerType(this.wells, interpIds, this.getUnits().charValue(), this.dataTypes, false) : (this.jRadioButtonFormat5.isSelected() ? gb.buildGridOneColumnPerType(this.wells, interpIds, this.getUnits().charValue(), this.dataTypes, true) : (this.jRadioButtonFormat2.isSelected() ? gb.buildGridFlat(this.wells, interpIds, this.getUnits().charValue(), this.dataTypes, false) : (this.jRadioButtonFormat4.isSelected() ? gb.buildGridFlat(this.wells, interpIds, this.getUnits().charValue(), this.dataTypes, true) : (this.jRadioButtonFormat3.isSelected() ? gb.buildGrid2LinesPerSample(this.wells, interpIds, this.getUnits().charValue(), this.dataTypes) : gb.buildGridFlatWithExtra(this.wells, interpIds, this.getUnits().charValue(), this.dataTypes)))));
            if (grid != null) {
                gw.write(file, grid);
            }
            JOptionPane.showMessageDialog(this, "File written", this.getTitle(), 1);
            this.dispose();
        }
        catch (Exception ex) {
            StackError.showStackError((String)("Error writing file: " + ex.getMessage()), (Throwable)ex);
            ex.printStackTrace();
        }
        try {
            this.prefs.setLastInterpSummaryFile(file);
            this.db.commit();
        }
        catch (SQLException ex) {
            Logger.getLogger(Lastval.class.getName()).log(Level.SEVERE, "Error committing user preference.", ex);
        }
    }

    private Set<Integer> getSelectedInterpIds() {
        HashSet<Integer> interpIds = new HashSet<Integer>();
        ComboboxItem selected = (ComboboxItem)this.jComboBoxInterpVersions.getSelectedItem();
        if (selected.getValue() instanceof InterpHdr) {
            interpIds.add(((InterpHdr)selected.getValue()).getInterpID());
        } else if (selected.getValue() instanceof Collection) {
            Collection c = (Collection)selected.getValue();
            for (Object o : c) {
                if (!(o instanceof InterpHdr)) continue;
                interpIds.add(((InterpHdr)o).getInterpID());
            }
        }
        return interpIds;
    }

    private boolean areAnyWellsConnectedToDb() {
        for (Well w : this.wells) {
            WsWell wsw;
            if (!(w instanceof WsWell) || (wsw = (WsWell)w).getLink() == null) continue;
            return true;
        }
        return false;
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        File result;
        File lastFileFile;
        String lastFile = this.jTextFieldFile.getText();
        if (StringUtils.isEmpty((CharSequence)lastFile) && (lastFileFile = this.prefs.getLastInterpSummaryFile()) != null) {
            lastFile = lastFileFile.getPath();
        }
        if ((result = FileChooserUtils.saveAsGridDataDialog((Component)this.jPanel1, (String)lastFile)) != null) {
            this.jTextFieldFile.setText(result.getPath());
            boolean isCSVFile = this.csvFileSelected();
            this.jPanelCSVOptions1.setEnabled(isCSVFile);
            this.jCheckBoxDecimalPlaces.setEnabled(isCSVFile);
            this.jComboBoxDecimalPlaces.setEnabled(isCSVFile && this.jCheckBoxDecimalPlaces.isSelected());
        }
    }

    private void jComboBoxInterpVersionsActionPerformed(ActionEvent evt) {
        this.onSelectedVersionChanged();
    }

    private void onSelectedVersionChanged() {
        ComboboxItem selected = (ComboboxItem)this.jComboBoxInterpVersions.getSelectedItem();
        if (selected.getLabel() == "All") {
            this.jCheckBoxIncludeVersionName.setSelected(true);
            this.jCheckBoxIncludeVersionName.setEnabled(false);
        } else {
            this.jCheckBoxIncludeVersionName.setEnabled(true);
        }
    }

    private boolean csvFileSelected() {
        boolean isCSV = !FilePathUtils.isFileExtension((String)this.jTextFieldFile.getText(), (String[])FileChooserUtils.EXCEL_FILTER.getExtensions()) && !FilePathUtils.isFileExtension((String)this.jTextFieldFile.getText(), (String[])FileChooserUtils.LEGACY_EXCEL_FILTER.getExtensions());
        return isCSV;
    }

    private Character getUnits() {
        ComboboxItem item = (ComboboxItem)this.jComboBoxUnits.getSelectedItem();
        return (Character)item.getValue();
    }

    private char getUnitsForAllWells() {
        char wellUnits = this.wells.get(0).getHeader().getWellUnits();
        for (Well w : this.wells) {
            char u = w.getHeader().getWellUnits();
            if (u == wellUnits) continue;
            return 'D';
        }
        return wellUnits;
    }

    private void jCheckBoxDecimalPlacesActionPerformed(ActionEvent evt) {
        boolean setDps = this.jCheckBoxDecimalPlaces.isSelected();
        this.jComboBoxDecimalPlaces.setEnabled(setDps);
    }

    private void jCheckBoxUseCoreCorrectionsActionPerformed(ActionEvent evt) {
        this.jCheckBoxShowUncorrectedDepths.setEnabled(this.jCheckBoxUseCoreCorrections.isSelected() || this.jCheckBoxUseCuttingCorrections.isSelected());
    }

    private void jCheckBoxUseCuttingCorrectionsActionPerformed(ActionEvent evt) {
        this.jCheckBoxShowUncorrectedDepths.setEnabled(this.jCheckBoxUseCoreCorrections.isSelected() || this.jCheckBoxUseCuttingCorrections.isSelected());
    }
}

