/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.FrameJsbugs;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.SBdb;
import util.SB;
import util.exception.StackError;

public class DialogHierNames
extends JDialog {
    private static final String[] titles = new String[]{"Level", "Name"};
    private static final int[] widths = new int[]{20, 80};
    private final SBdb sbdb;
    private final HashMap<Integer, String[]> hierNames = new HashMap();
    private int igdType;
    private final HierNamesTableModel model = new HierNamesTableModel(this);
    private final DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
    private static final int[] igdTypes = new int[]{3, 2, 4, 10, 26};
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableHierNames;

    public DialogHierNames(Frame parent, boolean modal, SBdb sbdb) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboModel.addElement("<Select>");
        int[] nArray = igdTypes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            this.comboModel.addElement(IGDInterval.getIGDName(i2));
            this.hierNames.put(i2, IGDIntervalZone.getHierNames(i2));
        }
        this.jComboBoxType.setSelectedIndex(0);
        SB.setTableHeaderBold((JTable)this.jTableHierNames);
        TableColumnModel columnModel = this.jTableHierNames.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(titles[i]);
            columnModel.getColumn(i).setPreferredWidth(widths[i]);
        }
        this.setTitle("Hierarchy Level Labels");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableHierNames = new JTable();
        this.jLabel1 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTableHierNames.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableHierNames);
        this.jLabel1.setText("Type:");
        this.jComboBoxType.setModel(this.comboModel);
        this.jComboBoxType.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogHierNames this$0;
            {
                DialogHierNames dialogHierNames = this$0;
                Objects.requireNonNull(dialogHierNames);
                this.this$0 = dialogHierNames;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxTypeActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogHierNames this$0;
            {
                DialogHierNames dialogHierNames = this$0;
                Objects.requireNonNull(dialogHierNames);
                this.this$0 = dialogHierNames;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogHierNames this$0;
            {
                DialogHierNames dialogHierNames = this$0;
                Objects.requireNonNull(dialogHierNames);
                this.this$0 = dialogHierNames;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogHierNames this$0;
            {
                DialogHierNames dialogHierNames = this$0;
                Objects.requireNonNull(dialogHierNames);
                this.this$0 = dialogHierNames;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxType, 0, -1, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 174, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        for (Map.Entry<Integer, String[]> entry : this.hierNames.entrySet()) {
            for (String s : entry.getValue()) {
                if (s.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Blank name in " + IGDInterval.getIGDName(entry.getKey()), this.getTitle(), 2);
                    return;
                }
                assert (s.length() <= 30);
            }
        }
        try {
            IGDIntervalZone.updateHierNames(this.sbdb, this.hierNames);
            this.sbdb.commit();
            this.dispose();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        this.igdType = IGDIntervalZone.getIGDType(this.jComboBoxType.getSelectedItem().toString());
        this.model.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogHierNames.html");
    }

    private class HierNamesTableModel
    extends AbstractTableModel {
        final /* synthetic */ DialogHierNames this$0;

        private HierNamesTableModel(DialogHierNames dialogHierNames) {
            DialogHierNames dialogHierNames2 = dialogHierNames;
            Objects.requireNonNull(dialogHierNames2);
            this.this$0 = dialogHierNames2;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.igdType == 0) {
                return 0;
            }
            return IGDIntervalZone.getNHier(this.this$0.igdType, true);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.this$0.igdType == 0) {
                return null;
            }
            switch (col) {
                default: {
                    return "" + (row + 1);
                }
                case 1: 
            }
            return this.this$0.hierNames.get(this.this$0.igdType)[row];
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            switch (col) {
                case 1: {
                    String s = o.toString().trim();
                    if (s.length() > 30) {
                        s = s.substring(0, 30);
                    }
                    this.this$0.hierNames.get((Object)Integer.valueOf((int)this.this$0.igdType))[row] = s;
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 1: {
                    return true;
                }
            }
            return false;
        }
    }
}

