/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.sbconnect.ICConnection;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;

public class DialogICConnection
extends JDialog {
    ICConnection connection;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonTest;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JTextField jTextFieldServer;
    private JLabel jLabel2;
    private JTextField jTextFieldDatabase;
    private JLabel jLabel3;
    private JTextField jTextFieldUsername;
    private JLabel jLabel4;
    private JPasswordField jPasswordField;

    public DialogICConnection(JDialog parent, boolean modal, String params) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.init(params);
    }

    private void init(String params) {
        this.setTitle("StrataBugs - IC connection");
        if (params != null) {
            this.connection = new ICConnection(params);
            this.jTextFieldServer.setText(this.connection.getServer());
            this.jTextFieldDatabase.setText(this.connection.getDatabase());
            this.jTextFieldUsername.setText(this.connection.getUser());
            this.jPasswordField.setText(this.connection.getPassword());
        }
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonTest = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldServer = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldDatabase = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(e -> this.jButtonCancelActionPerformed(e));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(e -> this.jButtonOKActionPerformed(e));
        this.jButtonTest.setText("Test connection");
        this.jButtonTest.addActionListener(e -> this.jButtonTestActionPerformed(e));
        this.jPanel1.setBorder(new TitledBorder("IC Server connection"));
        this.jPanel1.setBorder(new CompoundBorder(new TitledBorder(new EmptyBorder(0, 0, 0, 0), "JFormDesigner Evaluation", 2, 5, new Font("Dialog", 1, 12), Color.red), this.jPanel1.getBorder()));
        this.jPanel1.addPropertyChangeListener(new PropertyChangeListener(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("border".equals(e.getPropertyName())) {
                    throw new RuntimeException();
                }
            }
        });
        this.jLabel1.setText("Server: ");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel2.setText("Database and connection parameters:");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel3.setText("Username (if required):");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel4.setText("Password (if required):");
        this.jLabel4.setHorizontalAlignment(4);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jTextFieldServer).addComponent(this.jTextFieldDatabase).addComponent(this.jTextFieldUsername).addComponent(this.jPasswordField, -1, 385, Short.MAX_VALUE)).addGap(16, 16, 16)));
        jPanel1Layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldServer, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDatabase, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldUsername, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jPasswordField, -2, -1, -2)).addContainerGap(22, Short.MAX_VALUE)));
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -2, -1, -2).addGroup(contentPaneLayout.createSequentialGroup().addComponent(this.jButtonTest).addGap(18, 18, 18).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonTest)).addContainerGap(13, Short.MAX_VALUE)));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (!this.createConnection()) {
            JOptionPane.showMessageDialog(this, "Server or database blank", "IC Connection", 1);
        }
        this.dispose();
    }

    private void jButtonTestActionPerformed(ActionEvent evt) {
        if (!this.createConnection()) {
            JOptionPane.showMessageDialog(this, "Server or database blank", "IC Connection", 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            System.out.println("Connecting with: " + this.connection.getConnectionString());
            Connection con = DriverManager.getConnection(this.connection.getConnectionString());
            JOptionPane.showMessageDialog(this, "Success", "IC Connection", 1);
            con.close();
            this.connection = null;
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this, "Error getting connection: " + e.getMessage(), "IC Connection", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean createConnection() {
        String server = this.jTextFieldServer.getText().trim();
        if (StringUtils.isEmpty((CharSequence)server)) {
            return false;
        }
        String database = this.jTextFieldDatabase.getText().trim();
        if (StringUtils.isEmpty((CharSequence)database)) {
            return false;
        }
        char[] pwd = this.jPasswordField.getPassword();
        this.connection = new ICConnection(server, database, this.jTextFieldUsername.getText().trim(), new String(pwd));
        return true;
    }
}

