/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import jsbugs.DialogSelectVersion;
import jsbugs.FrameJsbugs;
import model3.InterpHdr;
import model3.SBdb;
import model3.project.Project;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.exception.StackError;

public class DialogIGD
extends SBDialog {
    private final SBdb sbdb;
    private final DefaultComboBoxModel comboBoxModelProjects = new DefaultComboBoxModel();
    int igdType;
    int interpID;
    Project project = null;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonVersion;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxVersion;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JRadioButton jRadioButtonBiocom;
    private JRadioButton jRadioButtonBiozones;
    private JRadioButton jRadioButtonChrono;
    private JRadioButton jRadioButtonEnvs;
    private JRadioButton jRadioButtonEvents;
    private JRadioButton jRadioButtonLitho;
    private JRadioButton jRadioButtonSequence;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;

    public DialogIGD(Frame parent, boolean modal, SBdb sbdb) throws SQLException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.setTitle("Open Geological Interpretation");
        this.initComponents();
        this.init();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void init() throws SQLException {
        this.refreshInterpCombo();
        this.comboBoxModelProjects.removeAllElements();
        this.sbdb.loadProjectCombo(this.comboBoxModelProjects, true);
    }

    private void refreshInterpCombo() {
        try {
            this.jComboBoxVersion.removeAllItems();
            for (InterpHdr interp : this.sbdb.getInterps()) {
                this.jComboBoxVersion.addItem(interp);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButton1 = new JButton();
        this.jRadioButtonChrono = new JRadioButton();
        this.jRadioButtonSequence = new JRadioButton();
        this.jRadioButtonLitho = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxVersion = new JComboBox();
        this.jButtonVersion = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jRadioButtonBiozones = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jRadioButtonEvents = new JRadioButton();
        this.jRadioButtonEnvs = new JRadioButton();
        this.jRadioButtonBiocom = new JRadioButton();
        this.jSeparator2 = new JSeparator();
        this.jButton1.setText("jButton1");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.buttonGroup1.add(this.jRadioButtonChrono);
        this.jRadioButtonChrono.setText("Chronostratigraphy");
        this.jRadioButtonChrono.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonChrono.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.jRadioButtonSequence);
        this.jRadioButtonSequence.setText("Sequence");
        this.jRadioButtonSequence.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSequence.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.jRadioButtonLitho);
        this.jRadioButtonLitho.setText("Lithostratigraphy");
        this.jRadioButtonLitho.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLitho.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel2.setText("Version:");
        this.jComboBoxVersion.setMaximumRowCount(30);
        this.jComboBoxVersion.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jButtonVersion.setText("...");
        this.jButtonVersion.setToolTipText("Show versions, manage versions");
        this.jButtonVersion.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonVersion.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGD this$0;
            {
                DialogIGD dialogIGD = this$0;
                Objects.requireNonNull(dialogIGD);
                this.this$0 = dialogIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonVersionActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGD this$0;
            {
                DialogIGD dialogIGD = this$0;
                Objects.requireNonNull(dialogIGD);
                this.this$0 = dialogIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGD this$0;
            {
                DialogIGD dialogIGD = this$0;
                Objects.requireNonNull(dialogIGD);
                this.this$0 = dialogIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonBiozones);
        this.jRadioButtonBiozones.setText("Biozones");
        this.jRadioButtonBiozones.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonBiozones.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel1.setText("Project:");
        this.jComboBoxProject.setModel(this.comboBoxModelProjects);
        this.jComboBoxProject.setToolTipText("Leave blank to select wells later");
        this.jComboBoxProject.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.buttonGroup1.add(this.jRadioButtonEvents);
        this.jRadioButtonEvents.setText("Events");
        this.jRadioButtonEvents.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.buttonGroup1.add(this.jRadioButtonEnvs);
        this.jRadioButtonEnvs.setText("Palaeoenvironments");
        this.jRadioButtonEnvs.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.buttonGroup1.add(this.jRadioButtonBiocom);
        this.jRadioButtonBiocom.setText("Biostratigraphic Comments");
        this.jRadioButtonBiocom.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator2).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonChrono, -1, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonLitho, -1, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonBiozones, -1, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonSequence, -1, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonEnvs, -1, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonBiocom, -1, -1, Short.MAX_VALUE)).add(44, 44, 44)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jComboBoxProject, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxVersion, 0, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonVersion, -2, 28, -2).add(10, 10, 10)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSeparator1).add((GroupLayout.Group)layout.createSequentialGroup().add(71, 71, 71).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.linkSize(new Component[]{this.jRadioButtonBiozones, this.jRadioButtonChrono, this.jRadioButtonEvents, this.jRadioButtonLitho, this.jRadioButtonSequence}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxProject, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxVersion, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jButtonVersion)).addPreferredGap(1).add((Component)this.jSeparator2, -2, 5, -2).addPreferredGap(0).add((Component)this.jRadioButtonChrono, -2, 15, -2).add(1, 1, 1).add((Component)this.jRadioButtonLitho).add(1, 1, 1).add((Component)this.jRadioButtonBiozones, -2, 23, -2).add(1, 1, 1).add((Component)this.jRadioButtonSequence, -2, 20, -2).add(1, 1, 1).add((Component)this.jRadioButtonEvents).add(1, 1, 1).add((Component)this.jRadioButtonEnvs).add(1, 1, 1).add((Component)this.jRadioButtonBiocom).add(11, 11, 11).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.jRadioButtonBiocom, this.jRadioButtonBiozones, this.jRadioButtonChrono, this.jRadioButtonEnvs, this.jRadioButtonEvents, this.jRadioButtonLitho, this.jRadioButtonSequence}, 2);
        this.pack();
    }

    private void jButtonVersionActionPerformed(ActionEvent evt) {
        try {
            DialogSelectVersion dialog = new DialogSelectVersion((Dialog)((Object)this), true, this.sbdb, null);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            this.refreshInterpCombo();
            if (dialog.selection != null) {
                InterpHdr interpHdr = dialog.selection.get(0);
                this.jComboBoxVersion.setSelectedItem(interpHdr);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No type selected", this.getTitle(), 2);
            return;
        }
        if (this.jRadioButtonChrono.isSelected()) {
            this.igdType = 3;
        } else if (this.jRadioButtonBiozones.isSelected()) {
            this.igdType = 4;
        } else if (this.jRadioButtonLitho.isSelected()) {
            this.igdType = 2;
        } else if (this.jRadioButtonSequence.isSelected()) {
            this.igdType = 10;
        } else if (this.jRadioButtonEvents.isSelected()) {
            this.igdType = 20;
        } else if (this.jRadioButtonBiocom.isSelected()) {
            this.igdType = 19;
        } else if (this.jRadioButtonEnvs.isSelected()) {
            this.igdType = 5;
        }
        try {
            Object o = this.jComboBoxProject.getSelectedItem();
            if (o instanceof Project) {
                if (this.sbdb.getnWells(((Project)((Object)o)).getID()) == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Selected project does not contain any wells.", this.getTitle(), 2);
                    return;
                }
                this.project = (Project)((Object)o);
            } else {
                this.project = null;
            }
            InterpHdr interp = (InterpHdr)this.jComboBoxVersion.getSelectedItem();
            this.interpID = interp.getInterpID();
            this.setOK();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

