/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDHdr;
import model3.IGDScheme;
import model3.Well;
import model3.WellInterp;
import util.SBException;

public class DialogIGDHdr
extends SBDialog {
    private static final int SOURCE_LEN = 25;
    private static final int AUTH_LEN = 25;
    private static final int COMM_LEN = 240;
    private final Well well;
    private final WellInterp wellInterp;
    private final IGDHdr hdr;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxIGDSchemes;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldAuthorised;
    private JTextField jTextFieldSource;

    public DialogIGDHdr(JDialog parent, boolean modal, Well well, WellInterp wellInterp, IGDHdr hdr) throws SQLException {
        super((Window)parent, modal);
        this.well = well;
        this.wellInterp = wellInterp;
        this.hdr = hdr;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.jComboBoxIGDSchemes.removeAllItems();
        if (this.hdr != null) {
            this.setTitle("Notes : Edit");
            this.jTextAreaComment.setText(this.hdr.getComments());
            this.jTextFieldSource.setText(this.hdr.getSource());
            this.jTextFieldAuthorised.setText(this.hdr.getAuthorised());
            this.jComboBoxIGDSchemes.addItem(this.well.getDataModel().getIGDScheme(this.hdr.getSchID()));
            this.jComboBoxIGDSchemes.setEnabled(false);
        } else {
            this.setTitle("Notes : Add");
            List<IGDScheme> schemes = this.well.getDataModel().getIGDSchemes();
            for (IGDScheme scheme : schemes) {
                this.jComboBoxIGDSchemes.addItem(scheme);
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxIGDSchemes = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = TextFieldUtils.buildLimitedLengthTextArea(240);
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldSource = TextFieldUtils.buildLimitedLengthTextField(25);
        this.jTextFieldAuthorised = TextFieldUtils.buildLimitedLengthTextField(25);
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Scheme:");
        this.jComboBoxIGDSchemes.setMaximumRowCount(50);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Comment:");
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Source:");
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("Authorised:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDHdr this$0;
            {
                DialogIGDHdr dialogIGDHdr = this$0;
                Objects.requireNonNull(dialogIGDHdr);
                this.this$0 = dialogIGDHdr;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDHdr this$0;
            {
                DialogIGDHdr dialogIGDHdr = this$0;
                Objects.requireNonNull(dialogIGDHdr);
                this.this$0 = dialogIGDHdr;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING)).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxIGDSchemes, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldSource).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jTextFieldAuthorised, -2, 305, -2))))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxIGDSchemes, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane1, -1, 115, Short.MAX_VALUE)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldSource, -2, -1, -2)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAuthorised, -2, -1, -2).addComponent(this.jLabel4)).addGap(14, 14, 14).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextAreaComment.getText().trim().isEmpty() && this.jTextFieldAuthorised.getText().trim().isEmpty() && this.jTextFieldSource.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No data entered", this.getTitle(), 1);
            return;
        }
        try {
            if (this.hdr == null) {
                int schID = ((IGDScheme)this.jComboBoxIGDSchemes.getSelectedItem()).getID();
                List<IGDHdr> hdrs = this.wellInterp.getHeaders(this.well.getWellID());
                for (IGDHdr h : hdrs) {
                    if (h.getSchID() != schID) continue;
                    JOptionPane.showMessageDialog((Component)((Object)this), "Comments for the selected scheme already exist.", this.getTitle(), 1);
                    return;
                }
                this.wellInterp.addIGDHdr(this.well.getWellID(), schID, this.jTextAreaComment.getText().trim(), this.jTextFieldSource.getText().trim(), this.jTextFieldAuthorised.getText().trim());
            } else {
                this.wellInterp.updateIGDHdr(this.well.getWellID(), this.hdr, this.jTextAreaComment.getText().trim(), this.jTextFieldSource.getText().trim(), this.jTextFieldAuthorised.getText().trim());
            }
            this.well.getDataModel().commit();
            this.setOK();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }
}

