/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.user.Userdef;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import jsbugs.DialogIGDHdr;
import jsbugs.table.DateRenderer;
import model3.IGDHdr;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogIGDHdrs
extends JDialog {
    private final TableModelIGDHdrs model = new TableModelIGDHdrs();
    private final WellInterp wellInterp;
    private final Well well;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableIGDHdrs;

    public DialogIGDHdrs(Frame parent, boolean modal, Well well, WellInterp wellInterp) throws SBException, SQLException {
        super(parent, modal);
        this.initComponents();
        this.wellInterp = wellInterp;
        this.well = well;
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.setTitle("Interpretation Notes : " + this.well.getWellName() + " : " + this.wellInterp.toString());
        this.model.setupTable(this.jTableIGDHdrs);
        this.model.db = this.well.getDataModel();
        this.model.hdrs = this.wellInterp.getHeaders(this.well.getWellID());
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButtonClose = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.jTableIGDHdrs = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 250));
        this.jLabel1.setText("Notes describing the use of schemes within the current version");
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDHdrs this$0;
            {
                DialogIGDHdrs dialogIGDHdrs = this$0;
                Objects.requireNonNull(dialogIGDHdrs);
                this.this$0 = dialogIGDHdrs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDHdrs this$0;
            {
                DialogIGDHdrs dialogIGDHdrs = this$0;
                Objects.requireNonNull(dialogIGDHdrs);
                this.this$0 = dialogIGDHdrs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDHdrs this$0;
            {
                DialogIGDHdrs dialogIGDHdrs = this$0;
                Objects.requireNonNull(dialogIGDHdrs);
                this.this$0 = dialogIGDHdrs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDHdrs this$0;
            {
                DialogIGDHdrs dialogIGDHdrs = this$0;
                Objects.requireNonNull(dialogIGDHdrs);
                this.this$0 = dialogIGDHdrs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jTableIGDHdrs.setModel(this.model);
        this.jTableIGDHdrs.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogIGDHdrs this$0;
            {
                DialogIGDHdrs dialogIGDHdrs = this$0;
                Objects.requireNonNull(dialogIGDHdrs);
                this.this$0 = dialogIGDHdrs;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableIGDHdrsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableIGDHdrs);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 773, Short.MAX_VALUE).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAdd, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonEdit, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonDelete).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -2, 63, -2).addComponent(this.jButtonClose)))).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonClose, this.jButtonDelete, this.jButtonEdit, this.jSeparator1);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addGap(8, 8, 8).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 66, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogIGDHdr dialog = new DialogIGDHdr(this, true, this.well, this.wellInterp, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableIGDHdrs.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select an item to edit", this.getTitle(), 1);
            return;
        }
        IGDHdr hdr = this.model.hdrs.get(this.jTableIGDHdrs.getSelectedRow());
        try {
            DialogIGDHdr dialog = new DialogIGDHdr(this, true, this.well, this.wellInterp, hdr);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableIGDHdrs.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select an item to delete", this.getTitle(), 1);
            return;
        }
        IGDHdr hdr = this.model.hdrs.get(this.jTableIGDHdrs.getSelectedRow());
        if (JOptionPane.showConfirmDialog(this, "Delete selected item?", this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            this.wellInterp.deleteIGDHdr(this.well.getWellID(), hdr);
            this.model.fireTableDataChanged();
            this.well.getDataModel().commit();
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
    }

    private void jTableIGDHdrsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private static class TableModelIGDHdrs
    extends AbstractTableModel {
        static final int COL_SCHEME = 0;
        static final int COL_COMMENTS = 1;
        static final int COL_SOURCE = 2;
        static final int COL_AUTHOR = 3;
        static final int COL_CREATED = 4;
        static final int COL_CREATOR = 5;
        static final int COL_MODIFIED = 6;
        static final int COL_MODIFIER = 7;
        static final String[] colTitles = new String[]{"Scheme", "Comments", "Source", "Authorised", "Created", "Creator", "Modified", "Modifier"};
        static final int[] colWidths = new int[]{50, 80, 40, 40, 30, 30, 30, 30};
        List<IGDHdr> hdrs;
        SBdb db;

        private TableModelIGDHdrs() {
        }

        @Override
        public int getRowCount() {
            if (this.hdrs == null) {
                return 0;
            }
            return this.hdrs.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.hdrs == null) {
                return "";
            }
            try {
                IGDHdr hdr = this.hdrs.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return this.db.getIGDScheme(hdr.getSchID());
                    }
                    case 1: {
                        return hdr.getComments();
                    }
                    case 2: {
                        return hdr.getSource();
                    }
                    case 3: {
                        return hdr.getAuthorised();
                    }
                    case 4: {
                        Date created = hdr.getCreated();
                        return created;
                    }
                    case 6: {
                        Date modified = hdr.getModified();
                        return modified;
                    }
                    case 5: {
                        Userdef user;
                        if (hdr.getCreator() > 0 && (user = this.db.getUser(hdr.getCreator())) != null) {
                            return user.getAbr();
                        }
                        return "";
                    }
                    case 7: {
                        Userdef user;
                        if (hdr.getModifier() > 0 && (user = this.db.getUser(hdr.getModifier())) != null) {
                            return user.getAbr();
                        }
                        return "";
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
        }

        public Class getColumnClass(int c) {
            switch (c) {
                default: {
                    return String.class;
                }
                case 4: 
                case 6: 
            }
            return Date.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        void setupTable(JTable jTable) {
            SB.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            }
            jTable.getColumnModel().getColumn(4).setCellRenderer(new DateRenderer());
            jTable.getColumnModel().getColumn(6).setCellRenderer(new DateRenderer());
        }
    }
}

