/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogIntervalComment;
import jsbugs.DialogSelectVersion;
import jsbugs.FrameJsbugs;
import jsbugs.IntervalCommentsTableModel;
import model3.IGDInterval;
import model3.Intcom;
import model3.InterpHdr;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import util.InvalidFieldException;
import util.SBException;
import util.exception.StackError;

public class DialogIntcoms
extends JDialog {
    private final IntervalCommentsTableModel model = new IntervalCommentsTableModel();
    private final SBdb sbdb;
    private final Well well;
    private final int interpID;
    private final int igdType;
    private final char units;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonCopy;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonMove;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTable1;

    public DialogIntcoms(Frame parent, boolean modal, Well well, int interpID, int igdType, char units) throws SBException, SQLException {
        super(parent, modal);
        this.sbdb = well.getDataModel();
        this.well = well;
        this.interpID = interpID;
        this.igdType = igdType;
        this.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.setTitle("Comments : " + IGDInterval.getIGDName(this.igdType) + " : " + String.valueOf(this.sbdb.getInterp(this.interpID)));
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.model.setupTable(this.jTable1, this.sbdb);
        this.jTable1.setRowSorter(new TableRowSorter<IntervalCommentsTableModel>(this.model));
        new ColumnSortResetHandler(this.jTable1).attach();
        this.model.comments = this.well.getInterp(this.interpID).getIntcoms(this.igdType);
        this.model.setUnits(this.units);
        this.model.setWellType(this.well.getType());
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonCopy = new JButton();
        this.jButtonMove = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 250));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntcoms this$0;
            {
                DialogIntcoms dialogIntcoms = this$0;
                Objects.requireNonNull(dialogIntcoms);
                this.this$0 = dialogIntcoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTable1.setModel(this.model);
        this.jTable1.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogIntcoms this$0;
            {
                DialogIntcoms dialogIntcoms = this$0;
                Objects.requireNonNull(dialogIntcoms);
                this.this$0 = dialogIntcoms;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntcoms this$0;
            {
                DialogIntcoms dialogIntcoms = this$0;
                Objects.requireNonNull(dialogIntcoms);
                this.this$0 = dialogIntcoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntcoms this$0;
            {
                DialogIntcoms dialogIntcoms = this$0;
                Objects.requireNonNull(dialogIntcoms);
                this.this$0 = dialogIntcoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntcoms this$0;
            {
                DialogIntcoms dialogIntcoms = this$0;
                Objects.requireNonNull(dialogIntcoms);
                this.this$0 = dialogIntcoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonCopy.setText("Copy...");
        this.jButtonCopy.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntcoms this$0;
            {
                DialogIntcoms dialogIntcoms = this$0;
                Objects.requireNonNull(dialogIntcoms);
                this.this$0 = dialogIntcoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyActionPerformed(evt);
            }
        });
        this.jButtonMove.setText("Move...");
        this.jButtonMove.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntcoms this$0;
            {
                DialogIntcoms dialogIntcoms = this$0;
                Objects.requireNonNull(dialogIntcoms);
                this.this$0 = dialogIntcoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 462, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1).addComponent(this.jButtonMove, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCopy, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 427, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            WellInterp wellInterp = this.well.getInterp(this.interpID);
            DialogIntervalComment dialog = new DialogIntervalComment(this, true, this.sbdb, this.well, wellInterp, null, this.units, this.igdType);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException sbe) {
            FrameJsbugs.showStackError("Error opening dialog", (Exception)sbe, this.sbdb);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedColumnCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one comment to edit", this.getTitle(), 2);
            return;
        }
        try {
            WellInterp wellInterp = this.well.getInterp(this.interpID);
            Intcom intcom = this.model.comments.get(this.jTable1.convertRowIndexToModel(this.jTable1.getSelectedRow()));
            DialogIntervalComment dialog = new DialogIntervalComment(this, true, this.sbdb, this.well, wellInterp, intcom, this.units, this.igdType);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.model.fireTableRowsUpdated(this.jTable1.getSelectedRow(), this.jTable1.getSelectedRow());
        }
        catch (SQLException | SBException sbe) {
            FrameJsbugs.showStackError("Error opening dialog", (Exception)sbe, this.sbdb);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int nRows = this.jTable1.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select comment(s) to delete", this.getTitle(), 2);
            return;
        }
        Object msg = "Really delete ";
        msg = nRows == 1 ? (String)msg + "this comment?" : (String)msg + "these " + nRows + " comments?";
        if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            WellInterp wellInterp = this.well.getInterp(this.interpID);
            LinkedList<Intcom> toKill = new LinkedList<Intcom>();
            for (int row : this.jTable1.getSelectedRows()) {
                toKill.add(this.model.comments.get(this.jTable1.convertRowIndexToModel(row)));
            }
            wellInterp.deleteIntcoms(this.well.getWellID(), toKill);
            this.sbdb.commit();
            wellInterp.notifyObservers(22);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException ex) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error deleting interval comment", (Exception)ex, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            int row = this.jTable1.rowAtPoint(evt.getPoint());
            this.jTable1.getSelectionModel().setSelectionInterval(row, row);
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
        this.copyIntcoms(false);
    }

    private void jButtonMoveActionPerformed(ActionEvent evt) {
        this.copyIntcoms(true);
    }

    private void copyIntcoms(boolean move) {
        DialogSelectVersion dialog;
        WellInterp wellInterp;
        if (this.jTable1.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 1);
            return;
        }
        try {
            wellInterp = this.well.getInterp(this.interpID);
            dialog = new DialogSelectVersion((Dialog)this, true, this.sbdb, null);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error opening version selection dialog", sql, this.sbdb);
            return;
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error opening version selection dialog", (Throwable)sbe);
            return;
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection == null || dialog.selection.isEmpty()) {
            return;
        }
        InterpHdr newInterp = dialog.selection.get(0);
        LinkedList<Intcom> toMove = new LinkedList<Intcom>();
        for (int row : this.jTable1.getSelectedRows()) {
            toMove.add(this.model.comments.get(this.jTable1.convertRowIndexToModel(row)));
        }
        if (toMove.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 1);
            return;
        }
        try {
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            this.well.loadInterp(newWellInterp);
            newWellInterp.getIntcoms(this.igdType);
            for (Intcom intcom : toMove) {
                try {
                    wellInterp.copyIntcom(this.well, intcom, newWellInterp, move);
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Cannot " + (move ? "move" : "copy"), 2);
                    continue;
                }
                this.sbdb.commit();
            }
            this.model.fireTableDataChanged();
            wellInterp.notifyObservers(toMove.get(0));
            newWellInterp.notifyObservers(toMove.get(0));
        }
        catch (SQLException | SBException ex) {
            FrameJsbugs.showStackError("Error copying/moving interval comment", (Exception)ex, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }
}

