/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbchart.core.ChartManager;
import jsbchart.legacy.LegacyChart;
import jsbchart.legacy.LegacyChartPanelOption;
import jsbchart.legacy.LegacyChartType;
import jsbugs.FrameJsbugs;
import model3.SBdb;
import model3.project.Project;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogLegacyCharts
extends JDialog {
    private static final String[] colNames = new String[]{"Name", "Type", "Well"};
    private static final int[] colWidths = new int[]{100, 20, 40};
    private static final int NAMELEN = 150;
    private static final String ALL_STRING = "All types";
    private static final String PROJ_GLOABL = "Global";
    private final DefaultComboBoxModel typeModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private final TableModelLegCharts model = new TableModelLegCharts(this);
    private final ChartManager chartManager;
    private final SBdb sbdb;
    List<LegacyChart> selection;
    int convertToProjID = 0;
    LegacyChartPanelOption panelOption = LegacyChartPanelOption.DEFAULT_TEMPLATES;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonConvert;
    private JButton jButtonHelp;
    private JButton jButtonSearch;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonTemplDecoupled;
    private JRadioButton jRadioButtonTemplDefault;
    private JRadioButton jRadioButtonTemplNew;
    private JScrollPane jScrollPane1;
    private JTable jTableCharts;
    private JTextField jTextFieldName;
    private JTextField jTextFieldWellName;

    public DialogLegacyCharts(Frame parent, boolean modal, ChartManager chartManager, SBdb sbdb) {
        super(parent, modal);
        this.chartManager = chartManager;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Legacy Charts");
        this.getRootPane().setDefaultButton(this.jButtonConvert);
        this.initTypeCombo();
        this.initProjectCombo();
        this.model.setupTable(this.jTableCharts);
        this.jTableCharts.setRowSorter(new TableRowSorter<TableModelLegCharts>(this.model));
        new ColumnSortResetHandler(this.jTableCharts).attach();
        this.jTableCharts.getTableHeader().setReorderingAllowed(false);
    }

    private void initTypeCombo() {
        this.typeModel.insertElementAt(ALL_STRING, 0);
        for (LegacyChartType t : LegacyChartType.values()) {
            this.typeModel.addElement(t);
        }
        this.jComboBoxType.setSelectedIndex(0);
    }

    private void initProjectCombo() {
        this.projectModel.addElement(PROJ_GLOABL);
        try {
            this.sbdb.loadProjectCombo(this.projectModel, false);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCharts = new JTable();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jButtonSearch = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonConvert = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jRadioButtonTemplDefault = new JRadioButton();
        this.jRadioButtonTemplNew = new JRadioButton();
        this.jRadioButtonTemplDecoupled = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.jTextFieldWellName = new JTextField();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(380, 450));
        this.jTableCharts.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCharts);
        this.jLabel1.setText("Chart name:");
        this.jTextFieldName.setText("%");
        this.jTextFieldName.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogLegacyCharts this$0;
            {
                DialogLegacyCharts dialogLegacyCharts = this$0;
                Objects.requireNonNull(dialogLegacyCharts);
                this.this$0 = dialogLegacyCharts;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldNameFocusGained(evt);
            }
        });
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogLegacyCharts this$0;
            {
                DialogLegacyCharts dialogLegacyCharts = this$0;
                Objects.requireNonNull(dialogLegacyCharts);
                this.this$0 = dialogLegacyCharts;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Type:");
        this.jComboBoxType.setModel(this.typeModel);
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLegacyCharts this$0;
            {
                DialogLegacyCharts dialogLegacyCharts = this$0;
                Objects.requireNonNull(dialogLegacyCharts);
                this.this$0 = dialogLegacyCharts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLegacyCharts this$0;
            {
                DialogLegacyCharts dialogLegacyCharts = this$0;
                Objects.requireNonNull(dialogLegacyCharts);
                this.this$0 = dialogLegacyCharts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonConvert.setText("Convert...");
        this.jButtonConvert.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLegacyCharts this$0;
            {
                DialogLegacyCharts dialogLegacyCharts = this$0;
                Objects.requireNonNull(dialogLegacyCharts);
                this.this$0 = dialogLegacyCharts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonConvertActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Conversion Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel3.setText("Convert to Project:");
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projectModel);
        this.buttonGroup1.add(this.jRadioButtonTemplDefault);
        this.jRadioButtonTemplDefault.setText("Use default panel templates for type");
        this.buttonGroup1.add(this.jRadioButtonTemplNew);
        this.jRadioButtonTemplNew.setText("Create new panel templates where necessary");
        this.buttonGroup1.add(this.jRadioButtonTemplDecoupled);
        this.jRadioButtonTemplDecoupled.setSelected(true);
        this.jRadioButtonTemplDecoupled.setText("Use decoupled panel templates");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxProject, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonTemplDecoupled).addComponent(this.jRadioButtonTemplNew).addComponent(this.jRadioButtonTemplDefault)).addGap(0, 97, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBoxProject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonTemplDefault).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonTemplDecoupled).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonTemplNew).addGap(20, 20, 20)));
        this.jLabel4.setText("Well name:");
        this.jTextFieldWellName.setText("%");
        this.jTextFieldWellName.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogLegacyCharts this$0;
            {
                DialogLegacyCharts dialogLegacyCharts = this$0;
                Objects.requireNonNull(dialogLegacyCharts);
                this.this$0 = dialogLegacyCharts;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldWellNameFocusGained(evt);
            }
        });
        this.jTextFieldWellName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogLegacyCharts this$0;
            {
                DialogLegacyCharts dialogLegacyCharts = this$0;
                Objects.requireNonNull(dialogLegacyCharts);
                this.this$0 = dialogLegacyCharts;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldWellNameKeyTyped(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLegacyCharts this$0;
            {
                DialogLegacyCharts dialogLegacyCharts = this$0;
                Objects.requireNonNull(dialogLegacyCharts);
                this.this$0 = dialogLegacyCharts;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldName, -2, 155, -2)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxType, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldWellName)))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSearch, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonConvert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldWellName, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxType, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jButtonSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 196, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonConvert).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldNameFocusGained(FocusEvent evt) {
        this.jTextFieldName.setCaretPosition(0);
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)150, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonConvertActionPerformed(ActionEvent evt) {
        if (this.jTableCharts.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select a chart", this.getTitle(), 2);
            return;
        }
        this.selection = new LinkedList<LegacyChart>();
        int[] nArray = this.jTableCharts.getSelectedRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            this.selection.add(this.model.charts.get(this.jTableCharts.convertRowIndexToModel(i2)));
        }
        if (this.jComboBoxProject.getSelectedItem() instanceof Project) {
            this.convertToProjID = ((Project)((Object)this.jComboBoxProject.getSelectedItem())).getID();
        } else {
            int opt = JOptionPane.showConfirmDialog(this, "New panel, block and chart templates will be global.\nAre you sure you want to continue?", this.getTitle(), 0);
            if (opt != 0) {
                this.selection = null;
                return;
            }
        }
        if (this.jRadioButtonTemplNew.isSelected()) {
            this.panelOption = LegacyChartPanelOption.CREATE_TEMPLATES;
        } else if (this.jRadioButtonTemplDecoupled.isSelected()) {
            this.panelOption = LegacyChartPanelOption.INVISIBLE_TEMPLATES;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSearchActionPerformed(ActionEvent evt) {
        try {
            int opt;
            String wellName;
            LegacyChartType type = null;
            Object o = this.jComboBoxType.getSelectedItem();
            if (!(o instanceof String)) {
                type = (LegacyChartType)((Object)o);
            }
            if ((wellName = this.jTextFieldWellName.getText().trim()).equals("%")) {
                wellName = null;
            }
            if (type != LegacyChartType.TEMPLATE && wellName == null && this.jTextFieldName.getText().trim().equals("%") && (opt = JOptionPane.showConfirmDialog(this, "It may take a long time to do an unrestricted search for all legacy charts.\nDo you want to continue?", this.getTitle(), 0, 3)) == 1) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.model.charts = this.chartManager.searchLegacyCharts(this.jTextFieldName.getText().trim(), wellName, type);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldWellNameFocusGained(FocusEvent evt) {
        this.jTextFieldWellName.setCaretPosition(0);
    }

    private void jTextFieldWellNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldWellName, (int)150, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("charts_legacy.html");
    }

    private class TableModelLegCharts
    extends AbstractTableModel {
        private static final int COL_DESCR = 0;
        private static final int COL_TYPE = 1;
        private static final int COL_WELL = 2;
        private List<LegacyChart> charts;
        final /* synthetic */ DialogLegacyCharts this$0;

        private TableModelLegCharts(DialogLegacyCharts dialogLegacyCharts) {
            DialogLegacyCharts dialogLegacyCharts2 = dialogLegacyCharts;
            Objects.requireNonNull(dialogLegacyCharts2);
            this.this$0 = dialogLegacyCharts2;
        }

        @Override
        public int getRowCount() {
            if (this.charts == null) {
                return 0;
            }
            return this.charts.size();
        }

        @Override
        public int getColumnCount() {
            return colNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.charts == null) {
                return null;
            }
            switch (columnIndex) {
                case 1: {
                    return this.charts.get((int)rowIndex).type;
                }
                case 0: {
                    return this.charts.get((int)rowIndex).name;
                }
                case 2: {
                    return this.charts.get((int)rowIndex).wellName;
                }
            }
            return null;
        }

        void setupTable(JTable table) {
            for (int i = 0; i < colNames.length; ++i) {
                table.getColumnModel().getColumn(i).setHeaderValue(colNames[i]);
                table.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            }
            SB.setTableHeaderBold((JTable)table);
        }
    }
}

