/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import jsbugs.userconnect.SbugsExceptionHandler;
import org.jdesktop.layout.GroupLayout;
import util.SbugsFileFilter;

public class DialogLicenceCheck
extends JDialog {
    public boolean selectedLicenceFile = false;
    private static final Logger LOGGER = Logger.getLogger(DialogLicenceCheck.class.getName());
    private JButton jButtonClose;
    private JButton jButtonCopy;
    private JButton jButtonHelp;
    private JButton jButtonSelectLicenceFile;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JTextField jTextFieldHostid;
    private JTextField jTextFieldServerMessage;

    public DialogLicenceCheck(Frame parent, boolean modal, String serverMessage, String hostid) {
        super(parent, modal);
        this.initComponents();
        this.jTextFieldHostid.setText(hostid);
        this.jTextFieldServerMessage.setText(serverMessage);
        this.setTitle("StrataBugs Licence");
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldServerMessage = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldHostid = new JTextField();
        this.jButtonCopy = new JButton();
        this.jLabel5 = new JLabel();
        this.jButtonSelectLicenceFile = new JButton();
        this.jLabel6 = new JLabel();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLicenceCheck this$0;
            {
                DialogLicenceCheck dialogLicenceCheck = this$0;
                Objects.requireNonNull(dialogLicenceCheck);
                this.this$0 = dialogLicenceCheck;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setForeground(new Color(51, 102, 204));
        this.jLabel1.setText("Cannot take out licence.");
        this.jLabel2.setText("Message from licence server is:");
        this.jTextFieldServerMessage.setEditable(false);
        this.jLabel3.setText("<html><strong>Check:</strong><br><br><p>1. License file (*.lic) installed in StrataBugs folder, or RLM_LICENSE environment variable.<br>2. Licence name and expiry date.</html>");
        this.jLabel4.setText("The hostID of your computer:");
        this.jTextFieldHostid.setEditable(false);
        this.jButtonCopy.setText("Copy hostID to Clipboard");
        this.jButtonCopy.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLicenceCheck this$0;
            {
                DialogLicenceCheck dialogLicenceCheck = this$0;
                Objects.requireNonNull(dialogLicenceCheck);
                this.this$0 = dialogLicenceCheck;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyActionPerformed(evt);
            }
        });
        this.jLabel5.setText("<html><strong>paste</strong> this into an email to request a licence.</html>");
        this.jButtonSelectLicenceFile.setText("Select licence file ...");
        this.jButtonSelectLicenceFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLicenceCheck this$0;
            {
                DialogLicenceCheck dialogLicenceCheck = this$0;
                Objects.requireNonNull(dialogLicenceCheck);
                this.this$0 = dialogLicenceCheck;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectLicenceFileActionPerformed(evt);
            }
        });
        this.jLabel6.setText("If you have been sent a licence file, select it here.");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(188, 188, 188).add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (Component)this.jTextFieldServerMessage).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel2).add(0, 0, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel3, -2, -1, -2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(1).add((Component)this.jTextFieldHostid, -2, 335, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonCopy).addPreferredGap(0).add((Component)this.jLabel5, -2, -1, -2))))).addContainerGap()).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jButtonSelectLicenceFile, -2, 164, -2).addPreferredGap(0).add((Component)this.jLabel6).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.jButtonCopy, this.jButtonSelectLicenceFile}, 1);
        jPanel1Layout.linkSize(new Component[]{this.jLabel5, this.jLabel6}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(1).add((Component)this.jTextFieldServerMessage, -2, -1, -2).addPreferredGap(1).add((Component)this.jLabel3, -2, 64, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldHostid, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jButtonCopy).add((Component)this.jLabel5, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jButtonSelectLicenceFile).add((Component)this.jLabel6)).addContainerGap(12, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLicenceCheck this$0;
            {
                DialogLicenceCheck dialogLicenceCheck = this$0;
                Objects.requireNonNull(dialogLicenceCheck);
                this.this$0 = dialogLicenceCheck;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonHelp}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonClose).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"licensing.html");
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
        StringSelection stringSelection = new StringSelection("My host ID for StrataBugs is: " + this.jTextFieldHostid.getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private void jButtonSelectLicenceFileActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = new File(".");
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("lic");
        filter.setDescription("Licence files");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            Path destPath = Paths.get(".", new String[0]);
            if (!Files.isWritable(destPath)) {
                LOGGER.log(Level.INFO, "Can't write into {0}", destPath.toAbsolutePath());
                destPath = Paths.get(SbugsLicense.getProgramDataPath(), new String[0]);
            }
            LOGGER.log(Level.INFO, "Using licence file path {0}", destPath.toAbsolutePath());
            try {
                if (!Files.exists(destPath, new LinkOption[0])) {
                    LOGGER.log(Level.INFO, "Creating licence file path {0}", destPath.toAbsolutePath());
                    Files.createDirectory(destPath, new FileAttribute[0]);
                }
                Files.copy(file.toPath(), new File(String.valueOf(destPath.toAbsolutePath()) + File.separator + file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.selectedLicenceFile = true;
                JOptionPane.showMessageDialog(this, "Copied licence file to: " + String.valueOf(destPath.toAbsolutePath()) + "\nPress OK to retry...", "Licence file copy", 1);
                this.dispose();
            }
            catch (IOException e) {
                SbugsExceptionHandler.showDialogStackError(e, this);
            }
        }
    }
}

