/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.LithologyCellRenderer;
import jsbugs.table.ColourButtonRenderer;
import jsbugs.table.ColourChooserEditor;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Lithdesc;
import model3.Lithology;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.table.SbugsTable;

public class DialogLithdesc
extends JDialog {
    static final String[] COL_TITLES = new String[]{"Code", "Description", "Abr.", "Pattern", "Colour", "Grain Size", "Sort order"};
    static final int[] COL_WIDTHS = new int[]{30, 60, 30, 40, 10, 30, 30};
    private final TableModelLithdesc model = new TableModelLithdesc();
    private final SBdb db;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public DialogLithdesc(Frame parent, boolean modal, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Lithologies");
        this.model.setupTable(this.jTable1);
        this.jTable1.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.jTable1.setRowSorter(new TableRowSorter<TableModelLithdesc>(this.model));
        new ColumnSortResetHandler(this.jTable1).attach();
        this.model.lithdesc = this.db.getLithdesc();
        this.model.list = this.db.getLithdesc().getBase();
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new SbugsTable();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 400));
        this.jTable1.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLithdesc this$0;
            {
                DialogLithdesc dialogLithdesc = this$0;
                Objects.requireNonNull(dialogLithdesc);
                this.this$0 = dialogLithdesc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLithdesc this$0;
            {
                DialogLithdesc dialogLithdesc = this$0;
                Objects.requireNonNull(dialogLithdesc);
                this.this$0 = dialogLithdesc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLithdesc this$0;
            {
                DialogLithdesc dialogLithdesc = this$0;
                Objects.requireNonNull(dialogLithdesc);
                this.this$0 = dialogLithdesc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 478, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 594, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialoglithdesc.html");
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            HashSet<Integer> sorts = new HashSet<Integer>();
            for (Lithology lith : this.model.list) {
                if (lith.getSortOrder() <= 0 || sorts.add(lith.getSortOrder())) continue;
                JOptionPane.showMessageDialog(this, "List contains duplicate sort order entries", this.getTitle(), 1);
                return;
            }
            for (Lithology lith : this.model.list) {
                Lithology dbLith = this.db.getLithdesc().getLithology(lith.getLithID());
                if (dbLith == null || !((double)Math.abs(lith.getGrainSize() - dbLith.getGrainSize()) > 1.0E-4 || lith.getSortOrder() != dbLith.getSortOrder() || !lith.getDescr().equals(dbLith.getDescr()) || lith.getAbr() != null && !lith.getAbr().equals(dbLith.getAbr())) && lith.getBackColour().equals(dbLith.getBackColour())) continue;
                dbLith.update(lith);
            }
            this.db.commit();
            this.dispose();
        }
        catch (SQLException | SBException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private static class TableModelLithdesc
    extends AbstractTableModel {
        static final int COL_CODE = 0;
        static final int COL_DESC = 1;
        static final int COL_ABBR = 2;
        static final int COL_PATTERN = 3;
        static final int COL_COLOUR = 4;
        static final int COL_GRAINSIZE = 5;
        static final int COL_SORT = 6;
        Lithdesc lithdesc;
        List<Lithology> list;

        private TableModelLithdesc() {
        }

        @Override
        public int getRowCount() {
            if (this.list == null) {
                return 0;
            }
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Lithology lith = this.list.get(rowIndex);
            if (lith == null) {
                return "";
            }
            try {
                switch (columnIndex) {
                    case 0: {
                        return "" + lith.getLithID();
                    }
                    case 1: {
                        return lith.getDescr();
                    }
                    case 2: {
                        return lith.getAbr();
                    }
                    case 3: {
                        return lith;
                    }
                    case 4: {
                        return lith.getBackColour();
                    }
                    case 5: {
                        return Float.valueOf(lith.getGrainSize());
                    }
                    case 6: {
                        return lith.getSortOrder();
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            try {
                Lithology lith = this.list.get(row);
                if (lith == null) {
                    return;
                }
                switch (col) {
                    case 1: {
                        lith.setDescr(obj.toString());
                        break;
                    }
                    case 2: {
                        lith.setAbr(obj.toString());
                        break;
                    }
                    case 5: {
                        lith.setGrainSize(Float.parseFloat(obj.toString()));
                        break;
                    }
                    case 6: {
                        lith.setSortOrder(Integer.parseInt(obj.toString()));
                        break;
                    }
                    case 4: {
                        lith.setBackColour((Color)obj);
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Lithology.class;
                }
                case 4: {
                    return Color.class;
                }
                default: {
                    return String.class;
                }
                case 6: {
                    return Integer.class;
                }
                case 5: 
            }
            return Float.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        void setupTable(JTable jTable) {
            SB.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(COL_TITLES[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
            }
            jTable.getColumnModel().getColumn(3).setCellRenderer(new LithologyCellRenderer());
            jTable.getColumnModel().getColumn(4).setCellRenderer(new ColourButtonRenderer(false));
            jTable.getColumnModel().getColumn(4).setCellEditor(new ColourChooserEditor());
        }
    }
}

