/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;

public abstract class DialogMatch
extends SBDialog {
    private static final Image backgroundImage;
    final boolean inWizard;
    private AbstractTableModel model;
    private JButton jButtonAdd;
    private JButton jButtonAddAll;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonLoad;
    private JButton jButtonMatchAll;
    private JButton jButtonRead;
    private JButton jButtonSave;
    private JButton jButtonSelect;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    JTable jTableMatch;

    public DialogMatch(Frame parent, boolean modal, boolean inWizard) {
        super(parent, modal);
        this.inWizard = inWizard;
        this.initComponents();
    }

    public DialogMatch(JDialog parent, boolean modal, boolean inWizard) {
        super((Window)parent, modal);
        this.inWizard = inWizard;
        this.initComponents();
    }

    void init(AbstractTableModel tableModel, String dialogTitle, ActionListener excludeAction, ActionListener deleteAction, ActionListener matchAllAction, ActionListener addAction, ActionListener selectAction, ActionListener addAllAction, ActionListener readAction, ActionListener saveAction, ActionListener loadAction) {
        this.setTitle(dialogTitle);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.model = tableModel;
        this.refreshSorter();
        this.jTableMatch.setModel(this.model);
        this.jTableMatch.setRowSorter(new TableRowSorter<AbstractTableModel>(this.model));
        new ColumnSortResetHandler(this.jTableMatch).attach();
        this.jTableMatch.getTableHeader().setReorderingAllowed(false);
        if (excludeAction != null) {
            this.jButtonExclude.addActionListener(excludeAction);
        } else {
            this.jButtonExclude.setVisible(false);
        }
        if (deleteAction != null) {
            this.jButtonDelete.addActionListener(deleteAction);
        } else {
            this.jButtonDelete.setVisible(false);
        }
        if (matchAllAction != null) {
            this.jButtonMatchAll.addActionListener(matchAllAction);
        } else {
            this.jButtonMatchAll.setVisible(false);
        }
        if (addAction != null) {
            this.jButtonAdd.addActionListener(addAction);
        } else {
            this.jButtonAdd.setVisible(false);
        }
        if (selectAction != null) {
            this.jButtonSelect.addActionListener(selectAction);
        } else {
            this.jButtonSelect.setVisible(false);
        }
        if (addAllAction != null) {
            this.jButtonAddAll.addActionListener(addAllAction);
        } else {
            this.jButtonAddAll.setVisible(false);
        }
        if (readAction != null) {
            this.jButtonRead.addActionListener(readAction);
        } else {
            this.jButtonRead.setVisible(false);
        }
        if (saveAction != null) {
            this.jButtonSave.addActionListener(saveAction);
        } else {
            this.jButtonSave.setVisible(false);
        }
        if (loadAction != null) {
            this.jButtonLoad.addActionListener(loadAction);
        } else {
            this.jButtonLoad.setVisible(false);
        }
        if (this.inWizard) {
            this.jButtonClose.setText("Continue");
        }
    }

    List<Integer> getSeletedRows() {
        int[] selected;
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i : selected = this.jTableMatch.getSelectedRows()) {
            rows.add(this.jTableMatch.convertRowIndexToModel(i));
        }
        return rows;
    }

    void refreshSorter() {
        this.model.fireTableDataChanged();
    }

    void closeWindow() {
        int opt;
        if (this.inWizard && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Exit guided import?", this.getTitle(), 0)) != 0) {
            return;
        }
        this.dispose();
    }

    void OK() {
        this.setOK();
    }

    public static Image getBackgroundImage() {
        return backgroundImage;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatch this$0;
            {
                DialogMatch dialogMatch = this$0;
                Objects.requireNonNull(dialogMatch);
                this.this$0 = dialogMatch;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatch = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonMatchAll = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonSelect = new JButton();
        this.jButtonAddAll = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonLoad = new JButton();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(300, 300));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogMatch this$0;
            {
                DialogMatch dialogMatch = this$0;
                Objects.requireNonNull(dialogMatch);
                this.this$0 = dialogMatch;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatch);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatch this$0;
            {
                DialogMatch dialogMatch = this$0;
                Objects.requireNonNull(dialogMatch);
                this.this$0 = dialogMatch;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonMatchAll.setText("Match all");
        this.jButtonAdd.setText("Add...");
        this.jButtonSelect.setText("Select...");
        this.jButtonAddAll.setText("Add all");
        this.jButtonRead.setText("Read ...");
        this.jButtonRead.setToolTipText("Read values into workspace from a file");
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save workspace to database");
        this.jButtonLoad.setText("Load...");
        this.jButtonLoad.setToolTipText("Load values into workspace from a master table");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 473, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMatchAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSelect, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRead, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonLoad, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMatchAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addGap(9, 9, 9).addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 349, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.OK();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeWindow();
    }

    static {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().createImage(DialogMatch.class.getResource("/resources/icon/matchBG.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        backgroundImage = image;
    }
}

