/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.DialogAgeCurve;
import jsbugs.DialogList;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchSamples;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.AgeCurve;
import model3.SBdb;
import util.SB;
import util.SBException;

public class DialogMatchAgeCurves
extends DialogMatch {
    private static final int COL_DONOR_NAME = 0;
    private static final int COL_DONOR_UNITS = 1;
    private static final int COL_ARROW = 2;
    private static final int COL_HOST_NAME = 3;
    private static final int COL_HOST_UNITS = 4;
    private static final String[] colTitles = new String[]{"Name", "Units", "", "Name", "Units"};
    private static final int[] colWidths = new int[]{60, 30, 20, 60, 30};
    private final List<AgeCurve> ageCurves = new ArrayList<AgeCurve>();
    private final SBdb ws;
    private final SBdb db;

    public DialogMatchAgeCurves(Frame parent, boolean modal, SBdb ws, SBdb db, boolean inWizard) throws SQLException {
        super(parent, modal, inWizard);
        this.ws = ws;
        this.db = db;
        this.ageCurves.addAll(ws.getAgeCurves());
        this.init();
    }

    private void init() throws SQLException {
        this.matchAll();
        TableModelMatchAgeCurves model = new TableModelMatchAgeCurves(this);
        ActionListener addAction = new ActionListener(this){
            final /* synthetic */ DialogMatchAgeCurves this$0;
            {
                DialogMatchAgeCurves dialogMatchAgeCurves = this$0;
                Objects.requireNonNull(dialogMatchAgeCurves);
                this.this$0 = dialogMatchAgeCurves;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.add();
            }
        };
        ActionListener selectAction = new ActionListener(this){
            final /* synthetic */ DialogMatchAgeCurves this$0;
            {
                DialogMatchAgeCurves dialogMatchAgeCurves = this$0;
                Objects.requireNonNull(dialogMatchAgeCurves);
                this.this$0 = dialogMatchAgeCurves;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.select();
            }
        };
        super.init(model, "Match Age Curves", null, null, null, addAction, selectAction, null, null, null, null);
        for (int i = 0; i < colTitles.length; ++i) {
            this.jTableMatch.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
            this.jTableMatch.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        this.jTableMatch.getColumnModel().getColumn(2).setMaxWidth(TableModelMatchSamples.colWidths[2]);
        this.jTableMatch.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        SB.setTableHeaderBold((JTable)this.jTableMatch);
    }

    private void matchAll() throws SQLException {
        block0: for (AgeCurve c : this.ageCurves) {
            if (c.getLink() != null) continue;
            for (AgeCurve dbC : this.db.getAgeCurves()) {
                if (!c.getTitle().equalsIgnoreCase(dbC.getTitle())) continue;
                c.setLink(dbC);
                continue block0;
            }
        }
    }

    private void add() {
        if (this.getSeletedRows().size() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one curve to add.", this.getTitle(), 2);
            return;
        }
        AgeCurve wsCurve = this.ageCurves.get(this.getSeletedRows().get(0));
        try {
            AgeCurve dbCurve = wsCurve.copyToDatabase(this.ws, this.db);
            DialogAgeCurve dialog = new DialogAgeCurve((Dialog)((Object)this), true, dbCurve, this.db);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                assert (dbCurve.getCurveID() > 0);
                wsCurve.setLink(dbCurve);
            }
            this.refreshSorter();
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
    }

    private void select() {
        if (this.getSeletedRows().size() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one curve to match.", this.getTitle(), 2);
            return;
        }
        AgeCurve wsCurve = this.ageCurves.get(this.getSeletedRows().get(0));
        try {
            if (this.db.getAgeCurves().isEmpty()) {
                int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "There are no age curves in your database! Add workspace curve to database?", this.getTitle(), 0);
                if (opt == 0) {
                    this.add();
                }
                return;
            }
            DialogList<AgeCurve> dialog = new DialogList<AgeCurve>((JDialog)((Object)this), true, "Select Age Curve", new UserPrefsHelper(this.db), this.db.getAgeCurves(), true, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                wsCurve.setLink(dialog.getSelection());
                this.refreshSorter();
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    private class TableModelMatchAgeCurves
    extends AbstractTableModel {
        final /* synthetic */ DialogMatchAgeCurves this$0;

        private TableModelMatchAgeCurves(DialogMatchAgeCurves dialogMatchAgeCurves) {
            DialogMatchAgeCurves dialogMatchAgeCurves2 = dialogMatchAgeCurves;
            Objects.requireNonNull(dialogMatchAgeCurves2);
            this.this$0 = dialogMatchAgeCurves2;
        }

        @Override
        public int getRowCount() {
            return this.this$0.ageCurves.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int row, int columnIndex) {
            if (this.this$0.ageCurves.isEmpty()) {
                return null;
            }
            AgeCurve c = this.this$0.ageCurves.get(row);
            switch (columnIndex) {
                case 0: {
                    return c.getTitle();
                }
                case 1: {
                    return c.getUnits();
                }
                case 2: {
                    return c.getLink() != null;
                }
                case 3: {
                    return c.getLink() != null ? c.getLink().getTitle() : null;
                }
                case 4: {
                    return c.getLink() != null ? c.getLink().getUnits() : null;
                }
            }
            assert (false);
            return null;
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 2: {
                    return Boolean.class;
                }
            }
            return String.class;
        }
    }
}

