/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchCasing;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.DepthRenderer;
import jsbugs.table.DepthStatusRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.CasingPoint;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchCasing
extends JDialog {
    WsWell well = null;
    SBdb db;
    TableModelMatchCasing model = new TableModelMatchCasing();
    Image backgroundImage;
    WellInterp interp = null;
    WellInterp dbInterp = null;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JButton jButtonSave;
    private JButton jButtonSelectView;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableCasing;

    public DialogMatchCasing(Frame parent, boolean modal, SBdb db, WsWell well, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.model.units = units;
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogMatchCasing(JDialog parent, boolean modal, SBdb db, WsWell well, char units) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.well = well;
        this.model.units = units;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Casing");
        SB.setTableHeaderBold((JTable)this.jTableCasing);
        TableColumnModel columnModel = this.jTableCasing.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchCasing.colTitles[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchCasing.colWidths[i]);
        }
        columnModel.getColumn(2).setMaxWidth(TableModelMatchCasing.colWidths[2]);
        DepthStatusRenderer dsr = new DepthStatusRenderer(2);
        dsr.setUnits(Character.valueOf(this.model.units));
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)dsr));
        DepthRenderer dr = new DepthRenderer(2);
        dr.setUnits(Character.valueOf(this.model.units));
        columnModel.getColumn(3).setCellRenderer(dr);
        this.model.init(this.well.getCasing(), this.well.getLink() != null ? this.well.getLink().getCasing() : null);
        if (this.well.getLink() == null || !this.well.getLink().getDataModel().isConnected() || !this.well.getLink().getDataModel().hasCasingMaster()) {
            this.jButtonSelectView.setVisible(false);
        }
        if (this.well.getLink() == null) {
            this.jButtonSave.setEnabled(false);
        }
        this.jTableCasing.setDefaultRenderer(CasingPoint.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableCasing.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableCasing.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        this.jTableCasing.setRowSorter(new TableRowSorter<TableModelMatchCasing>(this.model));
        new ColumnSortResetHandler(this.jTableCasing).attach();
        this.backgroundImage = this.backgroundImage = DialogMatch.getBackgroundImage();
        this.jTableCasing.getTableHeader().setReorderingAllowed(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchCasing this$0;
            {
                DialogMatchCasing dialogMatchCasing = this$0;
                Objects.requireNonNull(dialogMatchCasing);
                this.this$0 = dialogMatchCasing;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableCasing = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSelectView = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonRead = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(480, 320));
        this.setModal(true);
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableCasing.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCasing);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCasing this$0;
            {
                DialogMatchCasing dialogMatchCasing = this$0;
                Objects.requireNonNull(dialogMatchCasing);
                this.this$0 = dialogMatchCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCasing this$0;
            {
                DialogMatchCasing dialogMatchCasing = this$0;
                Objects.requireNonNull(dialogMatchCasing);
                this.this$0 = dialogMatchCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCasing this$0;
            {
                DialogMatchCasing dialogMatchCasing = this$0;
                Objects.requireNonNull(dialogMatchCasing);
                this.this$0 = dialogMatchCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonSelectView.setText("Load");
        this.jButtonSelectView.setToolTipText("Load casing points for well from CDS");
        this.jButtonSelectView.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCasing this$0;
            {
                DialogMatchCasing dialogMatchCasing = this$0;
                Objects.requireNonNull(dialogMatchCasing);
                this.this$0 = dialogMatchCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectViewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save unsaved casing points in database");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCasing this$0;
            {
                DialogMatchCasing dialogMatchCasing = this$0;
                Objects.requireNonNull(dialogMatchCasing);
                this.this$0 = dialogMatchCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read ...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCasing this$0;
            {
                DialogMatchCasing dialogMatchCasing = this$0;
                Objects.requireNonNull(dialogMatchCasing);
                this.this$0 = dialogMatchCasing;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 223, Short.MAX_VALUE).add((Component)this.jLabel2)).add(2, (Component)this.jScrollPane1, -1, 381, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add(2, (Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonExclude, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectView, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSave, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonRead, -2, 0, Short.MAX_VALUE)).add(14, 14, 14)));
        jPanel1Layout.linkSize(new Component[]{this.jButtonDelete, this.jButtonExclude, this.jButtonSave, this.jButtonSelectView}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(1).add((Component)this.jButtonSelectView).addPreferredGap(0).add((Component)this.jButtonSave).addPreferredGap(0).add((Component)this.jButtonRead).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 268, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteCasingPoint(true);
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteCasingPoint(false);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        try {
            if (this.well.getCasing().getSize() == 0) {
                return;
            }
            if (this.well.getLink() == null) {
                return;
            }
            HashSet<Integer> dType = new HashSet<Integer>();
            dType.add(20);
            try {
                this.well.store(dType);
            }
            catch (Exception ex) {
                FrameJsbugs.showStackError(ex.toString(), ex, this.well.getLink() != null ? this.well.getLink().getDataModel() : null);
            }
            this.well.updateCasingStatus(true);
            this.model.init(this.well.getCasing(), this.well.getLink() != null ? this.well.getLink().getCasing() : null);
            this.model.fireTableDataChanged();
        }
        catch (Exception ex) {
            FrameJsbugs.showStackError(ex.toString(), ex, this.well.getLink() != null ? this.well.getLink().getDataModel() : null);
        }
    }

    public void load() {
        try {
            if (this.well.getCasing().getSize() > 0 && JOptionPane.showConfirmDialog(this, "Clear workspace?", this.getTitle(), 0, 3) == 1) {
                return;
            }
            this.well.getCasing().loadFromView(this.well.getLink().getDataModel(), this.well.getLink().getWellCode());
            this.well.updateCasingStatus(true);
            this.model.init(this.well.getCasing(), this.well.getLink() != null ? this.well.getLink().getCasing() : null);
            this.model.fireTableDataChanged();
        }
        catch (Exception ex) {
            FrameJsbugs.showStackError(ex.toString(), ex, this.well.getLink() != null ? this.well.getLink().getDataModel() : null);
        }
    }

    private void jButtonSelectViewActionPerformed(ActionEvent evt) {
        this.load();
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.db, "JCASGFLE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("dat");
        filter.addExtension("csv");
        filter.addExtension("txt");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            try {
                Lastval.putString(this.db, "JCASGFLE", fileName);
                this.db.commit();
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                String delim = "[;,\t]";
                String buff = in.readLine();
                if (buff != null && buff.toLowerCase().contains("depth")) {
                    buff = in.readLine();
                }
                while (buff != null) {
                    String[] cols;
                    if (buff.length() > 0 && (cols = buff.split(delim)).length > 1) {
                        double depth = DepthUtils.parseDepthString((String)cols[0], (char)this.model.units);
                        String diam = cols[1];
                        if (cols.length == 3) {
                            diam = cols[2];
                        }
                        while (diam.contains("'")) {
                            diam = diam.replace("'", "");
                        }
                        CasingPoint casingPoint = new CasingPoint(depth, diam);
                        this.well.getCasing().add(casingPoint);
                    }
                    buff = in.readLine();
                }
                in.close();
                this.model.init(this.well.getCasing(), this.well.getLink() != null ? this.well.getLink().getCasing() : null);
                this.model.fireTableDataChanged();
            }
            catch (Exception eio) {
                SbugsExceptionHandler.showStackError(eio, this);
            }
        }
    }

    private void deleteCasingPoint(boolean fromDatabase) {
        block7: {
            String msg;
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableCasing.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableCasing.getSelectedRows();
            LinkedList<CasingPoint> toRemove = new LinkedList<CasingPoint>();
            for (int i : selected) {
                CasingPoint casing = fromDatabase ? (CasingPoint)this.model.data.get(this.jTableCasing.convertRowIndexToModel(i)).getDb() : (CasingPoint)this.model.data.get(this.jTableCasing.convertRowIndexToModel(i)).getWs();
                if (casing == null) continue;
                toRemove.add(casing);
            }
            if (fromDatabase && toRemove.size() > 0 && JOptionPane.showConfirmDialog(this, msg = "Really delete " + (String)(toRemove.size() == 1 ? "this casing point?" : "these " + toRemove.size() + " casing points?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
            try {
                Well deleteFromWell = fromDatabase ? this.well.getLink() : this.well;
                deleteFromWell.deleteCasingPoints(toRemove);
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Casing Points " + text + ": " + toRemove.size(), this.getTitle(), 1);
                this.well.updateCasingStatus(true);
                this.model.init(this.well.getCasing(), this.well.getLink() != null ? this.well.getLink().getCasing() : null);
                this.model.fireTableDataChanged();
                if (fromDatabase) {
                    deleteFromWell.getDataModel().commit();
                    deleteFromWell.notifyObservers();
                    deleteFromWell.getCasing().notifyObservers();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block7;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }
}

