/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.list.CategoryComboBox;
import jsbugs.list.CategoryListCellRenderer;
import jsbugs.model2.taxon.DialogCategory;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Category;
import model3.SBdb;

public class DialogMatchCategories
extends SBDialog {
    private static final String[] COL_TITLES = new String[]{"Donor Cat.", "Occs", "", "Host Cat."};
    private static final int[] COL_WIDTHS = new int[]{40, 30, 20, 120};
    private static final int COL_DONOR = 0;
    private static final int COL_OCCS = 1;
    private static final int COL_ARROW = 2;
    private static final int COL_HOST = 3;
    private final TableModelMatchCategories model = new TableModelMatchCategories();
    private final CategoryComboBox categoryComboBox = new CategoryComboBox();
    private final SBdb ws;
    private final SBdb db;
    private final Discipline discID;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTableCats;

    public DialogMatchCategories(JDialog parent, boolean modal, SBdb ws, SBdb db, List<Taxon> list, Discipline discID) throws SQLException {
        super((Window)parent, modal);
        this.ws = ws;
        this.db = db;
        this.discID = discID;
        this.setTitle("Match Categories");
        this.initComponents();
        this.init(list);
    }

    private void init(List<Taxon> list) {
        this.setTitle("Match Categories");
        this.setUpTable();
        this.setUpModel(list);
        this.categoryComboBox.setCategoryService(this.db.getCategoryService());
        this.categoryComboBox.fill(this.discID);
        this.model.fireTableDataChanged();
    }

    private void setUpTable() {
        TableUtils.setTableHeaderBold((JTable)this.jTableCats);
        TableColumnModel columnModel = this.jTableCats.getColumnModel();
        for (int i = 0; i < COL_TITLES.length; ++i) {
            columnModel.getColumn(i).setHeaderValue(COL_TITLES[i]);
            columnModel.getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
        }
        TableColumn hostIDColumn = this.jTableCats.getColumnModel().getColumn(3);
        hostIDColumn.setCellEditor(new DefaultCellEditor(this.categoryComboBox));
        CategoryListCellRenderer categoryListCellRenderer = new CategoryListCellRenderer();
        categoryListCellRenderer.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        hostIDColumn.setCellRenderer(categoryListCellRenderer);
        columnModel.getColumn(2).setMaxWidth(COL_WIDTHS[2]);
        columnModel.getColumn(2).setCellRenderer(new ArrowCellRenderer());
        this.jTableCats.getTableHeader().setReorderingAllowed(false);
        new ColumnSortResetHandler(this.jTableCats).attach();
        this.jTableCats.setRowSorter(new TableRowSorter<TableModelMatchCategories>(this.model));
    }

    private void setUpModel(List<Taxon> list) {
        HashMap<String, Integer> donorMap = new HashMap<String, Integer>();
        for (Taxon taxon : list) {
            String mnem = taxon.getGenus().getCategory().getMnemonic();
            if (!donorMap.containsKey(mnem)) {
                donorMap.put(mnem, 1);
                continue;
            }
            donorMap.put(mnem, (Integer)donorMap.get(mnem) + 1);
        }
        ArrayList donorCats = new ArrayList(donorMap.keySet());
        Collections.sort(donorCats);
        try {
            for (String mnem : donorCats) {
                Category donorCat = this.ws.getCategory(mnem);
                if (donorCat == null) {
                    this.ws.getCategoryService().addCategory(mnem, Discipline.MICRO, mnem, Color.BLACK);
                    donorCat = this.ws.getCategory(mnem);
                }
                this.model.rows.add(new TableModelMatchCategories.MatchCategoryRow(donorCat, (Integer)donorMap.get(mnem), this.db.getCategoryService().findCategory(mnem).orElse(null)));
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCats = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAdd = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 250));
        this.jTableCats.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCats);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCategories this$0;
            {
                DialogMatchCategories dialogMatchCategories = this$0;
                Objects.requireNonNull(dialogMatchCategories);
                this.this$0 = dialogMatchCategories;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCategories this$0;
            {
                DialogMatchCategories dialogMatchCategories = this$0;
                Objects.requireNonNull(dialogMatchCategories);
                this.this$0 = dialogMatchCategories;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCategories this$0;
            {
                DialogMatchCategories dialogMatchCategories = this$0;
                Objects.requireNonNull(dialogMatchCategories);
                this.this$0 = dialogMatchCategories;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel, -2, 67, -2).addComponent(this.jButtonOK, -2, 67, -2)).addComponent(this.jButtonAdd, GroupLayout.Alignment.LEADING, -2, 67, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 241, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 166, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        boolean makeSwitches = false;
        boolean clearNulls = false;
        boolean asked = false;
        for (TableModelMatchCategories.MatchCategoryRow row : this.model.rows) {
            if (row.hostCat == null) {
                if (asked) continue;
                Object[] options = new Object[]{"Keep donor", "Clear donor", "Cancel"};
                int n = JOptionPane.showOptionDialog((Component)((Object)this), "There are unmatched Categories.", this.getTitle(), 1, 3, null, options, options[0]);
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    clearNulls = false;
                } else {
                    clearNulls = true;
                    makeSwitches = true;
                }
                asked = true;
                continue;
            }
            if (row.donorCat.getMnem().equals(row.hostCat.getMnemonic())) continue;
            makeSwitches = true;
        }
        if (makeSwitches) {
            try {
                for (TableModelMatchCategories.MatchCategoryRow row : this.model.rows) {
                    if (row.hostCat != null) {
                        com.stratadata.model3.taxon.Category newHostCat = com.stratadata.model3.taxon.Category.copy((com.stratadata.model3.taxon.Category)row.hostCat);
                        if (this.discID != null) {
                            newHostCat.setDiscipline(this.discID);
                        }
                        this.ws.getCategoryService().updateCategory(row.donorCat.getMnem(), newHostCat);
                        continue;
                    }
                    if (!clearNulls) continue;
                    com.stratadata.model3.taxon.Category nullCat = new com.stratadata.model3.taxon.Category("");
                    nullCat.setDiscipline(this.discID != null ? this.discID : Discipline.MICRO);
                    this.ws.getCategoryService().updateCategory(row.donorCat.getMnem(), nullCat);
                }
            }
            catch (RuntimeException sql) {
                SbugsExceptionHandler.showStackError(sql);
            }
        }
        this.setOK();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.jTableCats.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row", this.getTitle(), 2);
            return;
        }
        int row = this.jTableCats.convertRowIndexToModel(this.jTableCats.getSelectedRow());
        Category donor = this.model.rows.get((int)row).donorCat;
        DialogCategory dialog = new DialogCategory((JDialog)((Object)this), true, this.db, donor.getMnem(), donor.getMnem(), this.discID);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getResult() != null) {
            this.model.rows.get((int)row).hostCat = dialog.getResult();
            this.categoryComboBox.fill();
            this.model.fireTableDataChanged();
        }
    }

    private static class TableModelMatchCategories
    extends AbstractTableModel {
        final List<MatchCategoryRow> rows = new ArrayList<MatchCategoryRow>();

        private TableModelMatchCategories() {
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int col) {
            MatchCategoryRow row = this.rows.get(rowIndex);
            return switch (col) {
                case 0 -> row.donorCat.getMnem();
                case 1 -> row.donorOccs;
                case 2 -> row.hostCat != null;
                case 3 -> row.hostCat;
                default -> "";
            };
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (col == 3) {
                this.rows.get((int)row).hostCat = (com.stratadata.model3.taxon.Category)obj;
            }
        }

        public Class getColumnClass(int c) {
            return switch (c) {
                case 0 -> String.class;
                case 1 -> Integer.class;
                case 3 -> com.stratadata.model3.taxon.Category.class;
                case 2 -> Boolean.class;
                default -> Object.class;
            };
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3;
        }

        static class MatchCategoryRow {
            final Category donorCat;
            final int donorOccs;
            com.stratadata.model3.taxon.Category hostCat;

            public MatchCategoryRow(Category donorCat, int donorOccs, com.stratadata.model3.taxon.Category hostCat) {
                this.donorCat = donorCat;
                this.donorOccs = donorOccs;
                this.hostCat = hostCat;
            }
        }
    }
}

