/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.io.FileChooserUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.DepthRenderer;
import jsbugs.table.DepthStatusRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.Audit;
import model3.CoredInterval;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import model3.WsWell;
import util.DepthUtils;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;
import util.status.DoubleStatus;
import util.status.SbugsStatus;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchCores
extends DialogMatch {
    private static final int COL_DONOR_TOP = 0;
    private static final int COL_DONOR_BASE = 1;
    private static final int COL_DONOR_NUMBER = 2;
    private static final int COL_ARROW = 3;
    private static final int COL_HOST_TOP = 4;
    private static final int COL_HOST_BASE = 5;
    private static final int COL_HOST_NUMBER = 6;
    private static final String[] colTitles = new String[]{"Top", "Base", "Number", "", "Top", "Base", "Number"};
    private static final int[] colWidths = new int[]{40, 40, 30, 20, 40, 40, 30};
    private UserPrefsHelper prefs;
    private final WsWell well;
    private final char units;
    private final MatchData<CoredInterval> data = new MatchData();
    private final SBdb db;

    public DialogMatchCores(Frame parent, boolean modal, SBdb db, WsWell well, char units) throws SQLException, SBException {
        super(parent, modal, false);
        this.well = well;
        this.units = units;
        this.db = db;
        this.init();
    }

    public DialogMatchCores(JDialog parent, boolean modal, SBdb db, WsWell well, char units) throws SQLException, SBException {
        super(parent, modal, false);
        this.well = well;
        this.units = units;
        this.db = db;
        this.init();
    }

    private void init() throws SQLException, SBException {
        SB.setTableHeaderBold((JTable)this.jTableMatch);
        this.prefs = new UserPrefsHelper(this.db);
        this.data.init(this.well.getCores().getList(), this.well.getLink() != null ? this.well.getLink().getCores().getList() : null);
        TableModelMatchCores model = new TableModelMatchCores(this);
        ActionListener excludeAction = new ActionListener(this){
            final /* synthetic */ DialogMatchCores this$0;
            {
                DialogMatchCores dialogMatchCores = this$0;
                Objects.requireNonNull(dialogMatchCores);
                this.this$0 = dialogMatchCores;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.deleteCore(false);
            }
        };
        ActionListener deleteAction = new ActionListener(this){
            final /* synthetic */ DialogMatchCores this$0;
            {
                DialogMatchCores dialogMatchCores = this$0;
                Objects.requireNonNull(dialogMatchCores);
                this.this$0 = dialogMatchCores;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.deleteCore(true);
            }
        };
        ActionListener readAction = new ActionListener(this){
            final /* synthetic */ DialogMatchCores this$0;
            {
                DialogMatchCores dialogMatchCores = this$0;
                Objects.requireNonNull(dialogMatchCores);
                this.this$0 = dialogMatchCores;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.readGrid();
            }
        };
        ActionListener saveAction = new ActionListener(this){
            final /* synthetic */ DialogMatchCores this$0;
            {
                DialogMatchCores dialogMatchCores = this$0;
                Objects.requireNonNull(dialogMatchCores);
                this.this$0 = dialogMatchCores;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.save();
            }
        };
        ActionListener loadAction = new ActionListener(this){
            final /* synthetic */ DialogMatchCores this$0;
            {
                DialogMatchCores dialogMatchCores = this$0;
                Objects.requireNonNull(dialogMatchCores);
                this.this$0 = dialogMatchCores;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.load();
            }
        };
        super.init(model, "Match Cored Intervals", excludeAction, deleteAction, null, null, null, null, readAction, saveAction, loadAction);
        TableColumnModel columnModel = this.jTableMatch.getTableHeader().getColumnModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setWidth(colWidths[i]);
        }
        columnModel.getColumn(3).setMaxWidth(colWidths[3]);
        this.jTableMatch.setDefaultRenderer(CoredInterval.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatch.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatch.setDefaultRenderer(DoubleStatus.class, (TableCellRenderer)((Object)new DepthStatusRenderer(2)));
        this.jTableMatch.setDefaultRenderer(Double.class, new DepthRenderer(2));
        this.jTableMatch.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
    }

    private void save() {
        try {
            if (this.well.getCores().getSize() == 0) {
                return;
            }
            if (this.well.getLink() == null) {
                return;
            }
            HashSet<Integer> dType = new HashSet<Integer>();
            dType.add(19);
            try {
                this.well.store(dType);
            }
            catch (Exception ex) {
                SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
            }
            this.well.updateCoreStatus(true);
            this.data.init(this.well.getCores().getList(), this.well.getLink() != null ? this.well.getLink().getCores().getList() : null);
            this.refreshSorter();
        }
        catch (Exception ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void readGrid() {
        File file = null;
        try {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel or CSV file", "csv", "xls", "xlsx");
            file = FileChooserUtils.chooseReadableFile((Component)((Object)this), (FileNameExtensionFilter)filter, (File)new File(Lastval.getString(this.db, "JCOREFLE")));
            GridReader in = GridReader.getGridReader((String)file.getPath(), null);
            Lastval.putString(this.db, "JCOREFLE", file.getPath());
            this.db.commit();
            boolean firstRow = true;
            boolean warnDepths = false;
            CoreXLSColumn[] columns = null;
            double lastBase = 0.0;
            while (in.nextRow()) {
                String cell;
                if (firstRow) {
                    String cell2 = in.getNextCell(false);
                    if (cell2 == null || cell2.isEmpty()) continue;
                    try {
                        Double.parseDouble(cell2);
                        String[] colNames = new String[]{"TOP", "BASE", "NUMBER"};
                        columns = new CoreXLSColumn[colNames.length];
                        for (int i = 0; i < colNames.length; ++i) {
                            columns[i] = CoreXLSColumn.getColumnType(colNames[i]);
                        }
                    }
                    catch (NumberFormatException ne) {
                        columns = this.parseColumnTitles(in, cell2);
                    }
                    firstRow = false;
                    continue;
                }
                int colnum = 0;
                double topDepth = 0.0;
                double baseDepth = 0.0;
                String coreNumber = "";
                while ((cell = in.getNextCell(false)) != null) {
                    if (columns[colnum] != null) {
                        CoreXLSColumn type = columns[colnum];
                        switch (type.ordinal()) {
                            case 3: {
                                break;
                            }
                            case 0: {
                                topDepth = DepthUtils.parseDepthString((String)cell, (char)this.units);
                                break;
                            }
                            case 1: {
                                baseDepth = DepthUtils.parseDepthString((String)cell, (char)this.units);
                                break;
                            }
                            case 2: {
                                coreNumber = cell.replace("Core", "").replace("CORE", "").replace("core", "").trim();
                            }
                        }
                    }
                    if (++colnum < columns.length) continue;
                }
                if (topDepth > 0.0 || baseDepth > 0.0) {
                    if (topDepth < lastBase) {
                        topDepth = lastBase;
                        System.out.println("Warning: top depth of core number " + coreNumber + " modified to fit base of upper unit: " + topDepth);
                        warnDepths = true;
                    }
                    CoredInterval coredInterval = new CoredInterval(topDepth, baseDepth, coreNumber, true, new Audit());
                    try {
                        this.well.getCores().add(coredInterval);
                    }
                    catch (SBException sbe) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Error adding interval: " + String.valueOf(coredInterval) + " : " + sbe.getMessage(), this.getTitle(), 0);
                    }
                }
                lastBase = baseDepth;
            }
            if (warnDepths) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Warning: some depths adjusted or rounded to avoid top of cores overlapping base of overlying core", this.getTitle(), 2);
            }
            in.close();
            this.data.init(this.well.getCores().getList(), this.well.getLink() != null ? this.well.getLink().getCores().getList() : null);
            this.well.updateCoreStatus(true);
            this.refreshSorter();
        }
        catch (SQLException | SBException | GridReaderException ex) {
            StackError.showStackError((String)("An error occurred while reading the file " + (file == null ? "<no file>" : file.getName()) + "."), (Throwable)ex);
        }
    }

    private CoreXLSColumn[] parseColumnTitles(GridReader in, String cell) throws GridReaderException {
        String[] colNames = new String[30];
        int maxCol = 0;
        int cellNum = 0;
        do {
            if (cellNum >= colNames.length) {
                System.out.println("CellNumber: " + cellNum + " exceeds column title length!");
            }
            if (cell != null) {
                colNames[cellNum] = cell;
                maxCol = cellNum;
            }
            ++cellNum;
        } while ((cell = in.getNextCell()) != null);
        CoreXLSColumn[] columns = new CoreXLSColumn[maxCol + 1];
        for (int i = 0; i <= maxCol; ++i) {
            try {
                if (colNames[i] == null) {
                    columns[i] = null;
                    continue;
                }
                columns[i] = CoreXLSColumn.getColumnType(colNames[i]);
                continue;
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                columns[i] = null;
            }
        }
        return columns;
    }

    private void readCoredIntervals() {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.db, "JCOREFLE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("dat");
        filter.addExtension("csv");
        filter.addExtension("txt");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            try {
                Lastval.putString(this.db, "JCOREFLE", fileName);
                this.db.commit();
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                String delim = "[;,\t]";
                String buff = in.readLine();
                if (buff != null && buff.toLowerCase().contains("depth")) {
                    buff = in.readLine();
                }
                while (buff != null) {
                    String[] cols;
                    if (buff.length() > 0 && (cols = buff.split(delim)).length > 2) {
                        double topDepth = DepthUtils.parseDepthString((String)cols[0], (char)this.units);
                        double baseDepth = DepthUtils.parseDepthString((String)cols[1], (char)this.units);
                        String coreNumber = cols[2];
                        coreNumber = coreNumber.replace("Core", "").replace("CORE", "").replace("core", "").trim();
                        CoredInterval coredInterval = new CoredInterval(topDepth, baseDepth, coreNumber, true, new Audit());
                        this.well.getCores().add(coredInterval);
                    }
                    buff = in.readLine();
                }
                in.close();
                this.data.init(this.well.getCores().getList(), this.well.getLink() != null ? this.well.getLink().getCores().getList() : null);
                this.well.updateCoreStatus(true);
                this.refreshSorter();
            }
            catch (Exception eio) {
                SbugsExceptionHandler.showStackError(eio, (Component)((Object)this));
            }
        }
    }

    private void deleteCore(boolean fromDatabase) {
        String msg;
        if (fromDatabase && this.well.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatch.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No intervals selected", this.getTitle(), 2);
            return;
        }
        LinkedList<CoredInterval> toRemove = new LinkedList<CoredInterval>();
        for (int i : this.getSeletedRows()) {
            CoredInterval coredInterval = fromDatabase ? (CoredInterval)this.data.get(i).getDb() : (CoredInterval)this.data.get(i).getWs();
            if (coredInterval == null) continue;
            toRemove.add(coredInterval);
        }
        if (fromDatabase && toRemove.size() > 0 && JOptionPane.showConfirmDialog((Component)((Object)this), msg = "Really delete " + (String)(toRemove.size() == 1 ? "this core?" : "these " + toRemove.size() + " cores?"), this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            Well deleteWell = fromDatabase ? this.well.getLink() : this.well;
            deleteWell.deleteCoredIntervals(toRemove);
            String text = fromDatabase ? "deleted" : "excluded";
            JOptionPane.showMessageDialog((Component)((Object)this), "Cored intervals " + text + ": " + toRemove.size(), this.getTitle(), 1);
            this.well.updateCoreStatus(true);
            this.data.init(this.well.getCores().getList(), this.well.getLink() != null ? this.well.getLink().getCores().getList() : null);
            this.refreshSorter();
            if (fromDatabase) {
                deleteWell.getDataModel().commit();
                deleteWell.notifyObservers();
                deleteWell.getCores().notifyObservers();
            }
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException e) {
            if (fromDatabase) {
                this.well.getLink().getDataModel().doRollback();
            }
            FrameJsbugs.showStackError("Error " + (fromDatabase ? "deleting" : "excluding"), (Exception)e, this.well.getLink() != null ? this.well.getLink().getDataModel() : null);
        }
    }

    public void load() {
        try {
            if (this.well.getCores().getSize() > 0 && JOptionPane.showConfirmDialog((Component)((Object)this), "Clear workspace?", this.getTitle(), 0, 3) == 1) {
                return;
            }
            this.well.getCores().loadFromView(this.well.getLink().getDataModel(), this.well.getLink().getWellCode());
            this.well.updateCoreStatus(true);
            this.data.init(this.well.getCores().getList(), this.well.getLink() != null ? this.well.getLink().getCores().getList() : null);
            this.refreshSorter();
        }
        catch (Exception ex) {
            FrameJsbugs.showStackError(ex.toString(), ex, this.well.getLink() != null ? this.well.getLink().getDataModel() : null);
        }
    }

    private class TableModelMatchCores
    extends AbstractTableModel {
        final /* synthetic */ DialogMatchCores this$0;

        private TableModelMatchCores(DialogMatchCores dialogMatchCores) {
            DialogMatchCores dialogMatchCores2 = dialogMatchCores;
            Objects.requireNonNull(dialogMatchCores2);
            this.this$0 = dialogMatchCores2;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.data == null) {
                return 0;
            }
            return this.this$0.data.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MatchData.MatchPair pair = this.this$0.data.get(rowIndex);
            if (pair == null) {
                return "";
            }
            CoredInterval ws = (CoredInterval)pair.getWs();
            CoredInterval db = (CoredInterval)pair.getDb();
            switch (columnIndex) {
                case 0: {
                    return ws != null ? new DoubleStatus(Double.valueOf(DepthUtils.convFromM((double)ws.getTopDepth(), (char)this.this$0.units, (char)this.this$0.well.getType())), ws.getStatus()) : null;
                }
                case 1: {
                    return ws != null ? new DoubleStatus(Double.valueOf(DepthUtils.convFromM((double)ws.getBaseDepth(), (char)this.this$0.units, (char)this.this$0.well.getType())), ws.getStatus()) : null;
                }
                case 2: {
                    return ws != null ? new StringStatus(ws.getCorenum(), ws.getStatus()) : null;
                }
                case 3: {
                    return ws != null && db != null && ws.getStatus() == SbugsStatus.STORED ? TableModelSB.linked : TableModelSB.unlinked;
                }
                case 4: {
                    return db != null ? Double.valueOf(DepthUtils.convFromM((double)db.getTopDepth(), (char)this.this$0.units)) : "";
                }
                case 5: {
                    return db != null ? Double.valueOf(DepthUtils.convFromM((double)db.getBaseDepth(), (char)this.this$0.units)) : "";
                }
                case 6: {
                    return db != null ? db.getCorenum() : "";
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: {
                    return DoubleStatus.class;
                }
                case 2: {
                    return StringStatus.class;
                }
                case 4: 
                case 5: {
                    return Double.class;
                }
                case 6: {
                    return String.class;
                }
                default: {
                    return CoredInterval.class;
                }
                case 3: 
            }
            return Boolean.class;
        }
    }

    private static enum CoreXLSColumn {
        TOP(new String[]{"TOP", "TOP DEPTH", "TOP_DEPTH"}),
        BASE(new String[]{"BASE", "BASE DEPTH", "BASE_DEPTH"}),
        NUM(new String[]{"NUMBER", "CORE_NO"}),
        NULLCOLUMN(new String[]{"XXXXXXXXXXXXXXXXXXX"});

        private final String[] titles;

        private CoreXLSColumn(String[] titles) {
            this.titles = titles;
        }

        static CoreXLSColumn getColumnType(String title) {
            if (title == null || title.trim().isEmpty()) {
                return NULLCOLUMN;
            }
            title = title.toUpperCase().trim();
            for (CoreXLSColumn col : CoreXLSColumn.values()) {
                for (String title1 : col.titles) {
                    if (!title.equals(title1)) continue;
                    return col;
                }
            }
            throw new IllegalStateException("Unrecognised column title: " + title);
        }
    }
}

