/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.curve.Curve;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogMatch;
import jsbugs.TableModelSB;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.LogDef;
import model3.Well;
import model3.WsWell;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchCurves
extends DialogMatch {
    private static final int COL_DONOR = 0;
    private static final int COL_ARROW = 1;
    private static final int COL_HOST = 2;
    private static final String[] colTitles = new String[]{"Curve/Range", "", "Curve/Range"};
    private static final int[] colWidths = new int[]{60, 20, 60};
    private final WsWell well;
    private final char units;
    private final MatchData<CurveEntry> data = new MatchData();

    public DialogMatchCurves(Frame parent, boolean modal, WsWell well, char units) throws SQLException, SBException {
        super(parent, modal, false);
        this.well = well;
        this.units = units;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.initData();
        TableModelMatchCurves model = new TableModelMatchCurves(this);
        ActionListener excludeAction = e -> this.deleteCurve(false);
        ActionListener deleteAction = e -> this.deleteCurve(true);
        super.init(model, "Match Wireline Logs", excludeAction, deleteAction, null, null, null, null, null, null, null);
        TableUtils.setTableHeaderBold((JTable)this.jTableMatch);
        TableColumnModel columnModel = this.jTableMatch.getTableHeader().getColumnModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setWidth(colWidths[i]);
        }
        columnModel.getColumn(1).setMaxWidth(colWidths[1]);
        this.jTableMatch.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatch.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
    }

    private void initData() throws SQLException, SBException {
        ArrayList<CurveEntry> wsData = new ArrayList<CurveEntry>();
        for (Curve curve2 : this.well.getCurveService().getCurves()) {
            LogDef linkedLogDef = this.well.getDataModel().getLogDef(curve2.getAbr()).getLink();
            String abr = linkedLogDef != null ? linkedLogDef.getAbr() : curve2.getAbr();
            wsData.add(new CurveEntry(curve2, abr));
        }
        ArrayList<CurveEntry> dbData = new ArrayList<CurveEntry>();
        if (this.well.getLink() != null) {
            dbData.addAll(this.well.getLink().getCurveService().getCurves().stream().map(curve -> new CurveEntry((Curve)curve, curve.getAbr())).toList());
        }
        this.data.init(wsData, dbData);
    }

    private void deleteCurve(boolean fromDatabase) {
        String msg;
        if (fromDatabase && this.well.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatch.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No logs selected", this.getTitle(), 2);
            return;
        }
        ArrayList<Curve> toRemove = new ArrayList<Curve>();
        for (int i : this.getSeletedRows()) {
            Curve curve = ((CurveEntry)(fromDatabase ? this.data.get(i).getDb() : this.data.get(i).getWs())).curve();
            if (curve == null) continue;
            toRemove.add(curve);
        }
        if (fromDatabase && toRemove.size() > 0 && JOptionPane.showConfirmDialog((Component)((Object)this), msg = "Really delete " + (String)(toRemove.size() == 1 ? "this curve?" : "these " + toRemove.size() + " curves?"), this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            Well deleteWell = fromDatabase ? this.well.getLink() : this.well;
            deleteWell.getCurves().deleteCurves(toRemove);
            String text = fromDatabase ? "deleted" : "excluded";
            JOptionPane.showMessageDialog((Component)((Object)this), "Curves " + text + ": " + toRemove.size(), this.getTitle(), 1);
            this.well.updateCurvesStatus(true);
            this.initData();
            this.refreshSorter();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error " + (fromDatabase ? "deleting" : "excluding"), e, (Component)((Object)this));
        }
    }

    private class TableModelMatchCurves
    extends AbstractTableModel {
        final /* synthetic */ DialogMatchCurves this$0;

        private TableModelMatchCurves(DialogMatchCurves dialogMatchCurves) {
            DialogMatchCurves dialogMatchCurves2 = dialogMatchCurves;
            Objects.requireNonNull(dialogMatchCurves2);
            this.this$0 = dialogMatchCurves2;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.data == null) {
                return 0;
            }
            return this.this$0.data.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MatchData.MatchPair pair = this.this$0.data.get(rowIndex);
            if (pair == null) {
                return "";
            }
            CurveEntry ws = (CurveEntry)pair.getWs();
            CurveEntry db = (CurveEntry)pair.getDb();
            switch (columnIndex) {
                case 0: {
                    return ws != null ? new StringStatus(ws.toString(this.this$0.units, this.this$0.well.getType()), db != null ? SbugsStatus.STORED : SbugsStatus.NOTSTORED) : null;
                }
                case 1: {
                    return ws != null && db != null ? TableModelSB.linked : TableModelSB.unlinked;
                }
                case 2: {
                    return db != null ? db.toString(this.this$0.units, this.this$0.well.getType()) : "";
                }
            }
            assert (false);
            return "";
        }

        public Class getColumnClass(int c) {
            return switch (c) {
                case 0 -> StringStatus.class;
                default -> String.class;
                case 1 -> Boolean.class;
            };
        }
    }

    private record CurveEntry(Curve curve, String abr) implements SortEntry
    {
        public String toString(char units, char sectionType) {
            Object name = this.abr;
            if (this.curve.getTopDepth() != null && this.curve.getBaseDepth() != null) {
                name = (String)name + " (" + SB.getDepthString((double)this.curve.getTopDepth(), (char)units, (int)2, (char)sectionType).trim() + " - " + SB.getDepthString((double)this.curve.getBaseDepth(), (char)units, (int)2, (char)sectionType).trim() + ")";
            }
            return name;
        }

        public String getSortEntry() {
            return this.curve.getSortEntry(this.abr);
        }

        public boolean isFuncEquivalent(SortEntry e) {
            return e.getSortEntry().equals(this.getSortEntry());
        }
    }
}

