/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import jsbugs.DialogMatchDict;
import jsbugs.FrameJsbugs;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.ColourRenderer;
import model3.AnalystHeader;
import model3.EnvScheme;
import model3.IGDIntervalEnv;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import model3.WellInterp;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchEnvScheme
extends DialogMatchDict {
    static final String[] colTitles = new String[]{"Environment", "Colour", "Comments", "Occs", "", "Environment", "Colour", "Comments"};
    static final int[] colWidths = new int[]{120, 20, 40, 20, 20, 120, 20, 40};
    private final TableModelMatchEnvScheme model = new TableModelMatchEnvScheme(this);
    private final SBdb ws;
    private final SBdb db;
    private final EnvScheme scheme;
    private boolean inStartup = true;

    public DialogMatchEnvScheme(Frame parent, boolean modal, EnvScheme scheme, SBdb ws, SBdb db, boolean inWizard) throws SBException, SQLException {
        super(parent, modal, inWizard);
        this.ws = ws;
        this.db = db;
        this.scheme = scheme;
        this.init();
    }

    private void init() throws SBException, SQLException {
        super.init(this.model, "Match Palaeoenvironment Scheme", this.scheme.getName());
        this.model.setUpTable(this.jTableMatch);
        this.getDonorOccs();
        this.setHostSchemes();
    }

    private void setHostSchemes() throws SQLException, SBException {
        this.dbModel.removeAllElements();
        this.dbModel.addElement("<Select>");
        for (EnvScheme sch : this.db.getEnvSchemes()) {
            this.dbModel.addElement(sch);
        }
        this.inStartup = false;
        if (this.scheme.getLink() != null) {
            this.dbModel.setSelectedItem(this.scheme.getLink());
        } else {
            for (EnvScheme sch : this.db.getEnvSchemes()) {
                if (!sch.getName().equalsIgnoreCase(this.scheme.getName())) continue;
                this.scheme.setLink(sch);
                this.dbModel.setSelectedItem(sch);
                break;
            }
        }
    }

    private void getDonorOccs() throws SQLException, SBException {
        this.scheme.resetNoccs();
        Iterator<Well> it = this.ws.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            Iterator<WellInterp> iti = well.getInterpIterator();
            while (iti.hasNext()) {
                WellInterp wellInterp = iti.next();
                for (IGDIntervalEnv zone : wellInterp.getEnvs()) {
                    if (zone.getSchID() != this.scheme.getID()) continue;
                    HashSet<Integer> set = new HashSet<Integer>();
                    this.setSchemeNocc(this.scheme, set, zone.getUp());
                    this.setSchemeNocc(this.scheme, set, zone.getUd());
                    this.setSchemeNocc(this.scheme, set, zone.getLp());
                    this.setSchemeNocc(this.scheme, set, zone.getLd());
                    this.setSchemeNocc(this.scheme, set, zone.getQual());
                }
            }
        }
    }

    @Override
    void comboModelActionPerformed() {
        if (this.inStartup) {
            return;
        }
        if (this.dbModel.getSelectedItem() instanceof EnvScheme) {
            this.scheme.setLink((EnvScheme)this.dbModel.getSelectedItem());
            this.model.envComboBox.removeAllItems();
            this.scheme.getLink().fillCombo(this.model.envComboBox, 0, false);
        } else {
            this.scheme.setLink(null);
            this.model.envComboBox.removeAllItems();
        }
        this.model.fireTableDataChanged();
    }

    @Override
    void add() {
        if (JOptionPane.showConfirmDialog((Component)((Object)this), "Add '" + this.scheme.getName() + "' scheme to database?", this.getTitle(), 0) != 0) {
            return;
        }
        try {
            String schemeName = this.scheme.getName();
            while (this.db.getEnvScheme(schemeName) != null) {
                schemeName = (String)JOptionPane.showInputDialog((Component)((Object)this), "A scheme of the name '" + this.scheme.getName() + "' already exists in the database. \nAdd new scheme with different name?", this.getTitle(), 1, null, null, this.scheme.getName());
                if (schemeName == null) {
                    return;
                }
                this.scheme.setName(schemeName);
                this.updateDonorName(schemeName);
            }
            EnvScheme dbScheme = EnvScheme.createCopy(this.scheme, this.db);
            this.db.addEnvScheme(dbScheme);
            this.db.commit();
            dbScheme.setLink(dbScheme);
            this.setHostSchemes();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    @Override
    void closeWindow() {
        int opt;
        if (this.inWizard && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Exit guided import?", this.getTitle(), 0)) != 0) {
            return;
        }
        for (int i = 0; i < this.scheme.getNClasses(); ++i) {
            if (this.scheme.getLinkTerm(i + 1) != null || this.scheme.getNoccs(i + 1) <= 0) continue;
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "Not all terms are matched - scheme will be unmatched. Continue?", this.getTitle(), 0) != 0) {
                return;
            }
            this.scheme.setLink(null);
            break;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void OK() {
        if (this.inWizard && this.scheme.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must match or add this scheme.", this.getTitle(), 2);
            return;
        }
        for (int i = 0; i < this.scheme.getNClasses(); ++i) {
            if (this.scheme.getLinkTerm(i + 1) != null || this.scheme.getNoccs(i + 1) <= 0) continue;
            if (this.inWizard) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You must match all terms.", this.getTitle(), 2);
                return;
            }
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "Not all terms are matched - scheme will be unmatched. Continue?", this.getTitle(), 0) != 0) {
                return;
            }
            this.scheme.setLink(null);
            break;
        }
        if (this.scheme.getLink() != null) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                Iterator<Well> wit = this.ws.getWellIterator();
                while (wit.hasNext()) {
                    Well well = wit.next();
                    LinkedList<AnalystHeader> selectedAnalystHeaders = null;
                    Iterator<AnalystHeader> ait = well.getAnalystHeaderIterator();
                    while (ait.hasNext()) {
                        AnalystHeader header = ait.next();
                        if (header.getEnvSchID() <= 0 || header.getEnvSchID() != this.scheme.getID()) continue;
                        if (selectedAnalystHeaders == null) {
                            selectedAnalystHeaders = new LinkedList<AnalystHeader>();
                        }
                        selectedAnalystHeaders.add(header);
                    }
                    for (Sample sample : well.getSamples()) {
                        block9: for (Smpdtl smpdtl : sample.getSmpdtls()) {
                            if (selectedAnalystHeaders == null) continue;
                            for (AnalystHeader header : selectedAnalystHeaders) {
                                if (header != smpdtl.getHeader()) continue;
                                if (smpdtl.getProximal() > 0) {
                                    smpdtl.setProximal(this.scheme.getLinkTermIndex(smpdtl.getProximal()));
                                }
                                if (smpdtl.getDistal() > 0) {
                                    smpdtl.setDistal(this.scheme.getLinkTermIndex(smpdtl.getDistal()));
                                }
                                if (smpdtl.getProximal() <= smpdtl.getDistal()) continue block9;
                                int tmp = smpdtl.getProximal();
                                smpdtl.setProximal(smpdtl.getDistal());
                                smpdtl.setDistal(tmp);
                                continue block9;
                            }
                        }
                    }
                }
                this.scheme.updateSchemeFromLink();
            }
            catch (SQLException | SBException e) {
                FrameJsbugs.showStackError("Error", (Exception)e, this.db);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.setOK();
    }

    private void setSchemeNocc(EnvScheme scheme, HashSet<Integer> set, int env) {
        if (set.add(env)) {
            if (env > 0 && env <= scheme.getNClasses()) {
                scheme.setNoccs(env, scheme.getNoccs(env) + 1);
            } else if (env != 0) {
                System.out.println("Env zone scheme reference invalid: " + env);
            }
        }
    }

    @Override
    String getHelpPage() {
        return "dialogmatchenvscheme.html";
    }

    private class TableModelMatchEnvScheme
    extends AbstractTableModel {
        static final int COL_DONOR_ENV = 0;
        static final int COL_DONOR_COLOUR = 1;
        static final int COL_DONOR_COMMENTS = 2;
        static final int COL_DONOR_OCCS = 3;
        static final int COL_ARROW = 4;
        static final int COL_HOST_ENV = 5;
        static final int COL_HOST_COLOUR = 6;
        static final int COL_HOST_COMMENTS = 7;
        JComboBox envComboBox;
        final /* synthetic */ DialogMatchEnvScheme this$0;

        private TableModelMatchEnvScheme(DialogMatchEnvScheme dialogMatchEnvScheme) {
            DialogMatchEnvScheme dialogMatchEnvScheme2 = dialogMatchEnvScheme;
            Objects.requireNonNull(dialogMatchEnvScheme2);
            this.this$0 = dialogMatchEnvScheme2;
            this.envComboBox = new JComboBox();
        }

        @Override
        public int getRowCount() {
            if (this.this$0.scheme == null) {
                return 0;
            }
            return this.this$0.scheme.getNClasses();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                switch (columnIndex) {
                    case 0: {
                        return new StringStatus(this.this$0.scheme.getTerm(rowIndex + 1), this.this$0.scheme.getStatus());
                    }
                    case 3: {
                        return new StringStatus("" + this.this$0.scheme.getNoccs(rowIndex + 1), this.this$0.scheme.getStatus());
                    }
                    case 2: {
                        return new StringStatus(this.this$0.scheme.getComment(rowIndex + 1) == null ? "" : this.this$0.scheme.getComment(rowIndex + 1), this.this$0.scheme.getStatus());
                    }
                    case 1: {
                        return this.this$0.scheme.getColour(rowIndex + 1);
                    }
                    case 4: {
                        return this.this$0.scheme.getLinkTerm(rowIndex + 1) != null;
                    }
                    case 5: {
                        return this.this$0.scheme.getLinkTerm(rowIndex + 1);
                    }
                    case 6: {
                        return this.this$0.scheme.getLinkColour(rowIndex + 1);
                    }
                    case 7: {
                        return this.this$0.scheme.getLinkComment(rowIndex + 1) == null ? "" : this.this$0.scheme.getLinkComment(rowIndex + 1);
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 2: 
                case 3: {
                    return StringStatus.class;
                }
                case 4: {
                    return Boolean.class;
                }
                case 5: 
                case 7: {
                    return String.class;
                }
                case 1: 
                case 6: {
                    return Color.class;
                }
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                case 5: {
                    try {
                        String termName;
                        if (obj == null || this.this$0.scheme.getLink() == null || (termName = (String)obj).length() <= 0) break;
                        this.this$0.scheme.setLinkTerm(row + 1, termName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                default: {
                    return false;
                }
                case 5: 
            }
            return true;
        }

        void setUpTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
            }
            columnModel.getColumn(4).setMaxWidth(colWidths[4]);
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Color.class, new ColourRenderer(true));
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
            columnModel.getColumn(5).setCellEditor(new DefaultCellEditor(this.envComboBox));
            columnModel.getColumn(5).setCellRenderer(new ComboCellRenderer());
        }
    }
}

