/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventContext;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogEvent;
import jsbugs.DialogMatch;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogSource;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import jsbugs.table.ArrowCellRenderer;
import model3.SBEvent;
import model3.SBdb;
import model3.Source;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchEvents
extends SBDialog {
    private final TableModelMatchEvents model = new TableModelMatchEvents();
    private Image backgroundImage;
    private final SBdb ws;
    private final SBdb db;
    private Source source;
    private final boolean inWizard;
    private JButton jButtonAdd;
    private JButton jButtonAddAll;
    private JButton jButtonAddSelected;
    private JButton jButtonExclude;
    private JButton jButtonHelp;
    private JButton jButtonLoad;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JButton jButtonSelectEvent;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchEvents;
    private JTextField jTextFieldSource;

    public DialogMatchEvents(Frame parent, boolean modal, SBdb ws, SBdb db, boolean inWizard) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.ws = ws;
        this.inWizard = inWizard;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Events ");
        this.jButtonOK.setText(this.inWizard ? "Continue" : "Close");
        this.model.setUpTable(this.jTableMatchEvents);
        this.jTableMatchEvents.setRowSorter(new TableRowSorter<TableModelMatchEvents>(this.model));
        new ColumnSortResetHandler(this.jTableMatchEvents).attach();
        this.model.data = new LinkedList<SBEvent>(this.ws.getSBEvents(false));
        for (SBEvent event : this.model.data) {
            if (event.getLink() == null) continue;
            event.getLink().getNoccs(true);
        }
        this.model.fireTableDataChanged();
        this.backgroundImage = DialogMatch.getBackgroundImage();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchEvents = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonMatchAll = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonAddAll = new JButton();
        this.jButtonAddSelected = new JButton();
        this.jButtonSelectEvent = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonLoad = new JButton();
        this.jTextFieldSource = new JTextField();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(800, 500));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jPanel1.setMinimumSize(new Dimension(400, 300));
        this.jTableMatchEvents.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTableMatchEvents.setModel(this.model);
        this.jTableMatchEvents.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableMatchEventsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatchEvents);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected events from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.setToolTipText("Add selected event to dictionary via dialog");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonAddAll.setText("Add all");
        this.jButtonAddAll.setToolTipText("Add all unmatched events to the event dictionary");
        this.jButtonAddAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddAllActionPerformed(evt);
            }
        });
        this.jButtonAddSelected.setText("Add selected");
        this.jButtonAddSelected.setToolTipText("Add selected unmatched events to the event dictionary");
        this.jButtonAddSelected.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddSelected.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddSelectedActionPerformed(evt);
            }
        });
        this.jButtonSelectEvent.setText("Select...");
        this.jButtonSelectEvent.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectEventActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Data Source", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jButtonLoad.setText("Load...");
        this.jButtonLoad.setToolTipText("<html>Select a location for a text file which will store matches,<br>\nor select a previous match file to load matches.</html>");
        this.jButtonLoad.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchEvents this$0;
            {
                DialogMatchEvents dialogMatchEvents = this$0;
                Objects.requireNonNull(dialogMatchEvents);
                this.this$0 = dialogMatchEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLoadActionPerformed(evt);
            }
        });
        this.jTextFieldSource.setEditable(false);
        this.jTextFieldSource.setBackground(new Color(255, 255, 204));
        this.jTextFieldSource.setText("<none>");
        this.jTextFieldSource.setToolTipText("");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonLoad)).addComponent(this.jTextFieldSource)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldSource, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 667, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jButtonHelp, GroupLayout.Alignment.TRAILING, -2, 99, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAddAll, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonSelectEvent, -1, 83, Short.MAX_VALUE).addComponent(this.jButtonAddSelected, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMatchAll, -1, 99, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, 99, Short.MAX_VALUE)).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING, -2, 99, -2)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAdd, this.jButtonAddAll, this.jButtonAddSelected, this.jButtonExclude, this.jButtonMatchAll, this.jButtonSelectEvent);
        jPanel1Layout.linkSize(0, this.jButtonHelp, this.jButtonOK);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(11, 11, 11).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addGap(4, 4, 4).addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectEvent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddSelected).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOK)).addComponent(this.jScrollPane1, -1, 428, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.inWizard) {
            boolean hasUnmatched = false;
            for (SBEvent event : this.model.data) {
                if (event.getLink() != null) continue;
                hasUnmatched = true;
                break;
            }
            if (hasUnmatched) {
                String msg = "\nThere are unmatched events. They will be excluded from wells and composite standards if you continue.";
                Object[] options = new String[]{"Continue (exclude occurrences)", "Close (exit guided import)", "Cancel"};
                int opt = JOptionPane.showOptionDialog((Component)((Object)this), msg, this.getTitle(), 1, 3, null, options, null);
                switch (opt) {
                    case 0: {
                        try {
                            this.excludeUnmatched();
                        }
                        catch (SQLException | SBException | SBPermissionException sql) {
                            StackError.showStackError((String)"Error", (Throwable)sql);
                            return;
                        }
                        this.commitMatches();
                        this.setOK();
                        return;
                    }
                    case 1: {
                        this.commitMatches();
                        this.dispose();
                        return;
                    }
                }
                return;
            }
        }
        this.commitMatches();
        this.setOK();
    }

    private void commitMatches() {
        for (SBEvent event : this.model.data) {
            if (event.getLink() == null) continue;
            this.ws.copyLinkedEvent(event.getEvID());
        }
    }

    private void excludeUnmatched() throws SQLException, SBPermissionException, SBException {
        for (SBEvent event : this.ws.getEvents()) {
            if (event.getLink() != null) continue;
            this.ws.deleteSBEvent(event);
            this.model.data.remove(event);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        int opt;
        if (this.inWizard && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Exit guided import?", this.getTitle(), 0)) != 0) {
            return;
        }
        this.commitMatches();
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchEvents.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No events selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchEvents.getSelectedRows();
        LinkedList<SBEvent> toRemove = new LinkedList<SBEvent>();
        for (int i : selected) {
            SBEvent event = this.model.data.get(this.jTableMatchEvents.convertRowIndexToModel(i));
            if (event == null) continue;
            toRemove.add(event);
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to exclude " + (String)(toRemove.size() > 1 ? "these " + toRemove.size() + " events" : "this event") + "?\nThey will be immediately removed from all workspace wells and composite standards.", "Exclude Events", 0, 2);
        if (opt != 0) {
            return;
        }
        try {
            for (SBEvent event : toRemove) {
                this.ws.deleteSBEvent(event);
                this.model.data.remove(event);
            }
        }
        catch (SQLException | SBException | SBPermissionException e) {
            StackError.showStackError((String)"Error", (Throwable)e);
        }
        this.model.fireTableDataChanged();
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (SBEvent event : this.model.data) {
                if (event.getLink() != null) continue;
                event.findLink(this.db, true);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        this.jTableMatchEvents.getRowSorter().setSortKeys(null);
        this.model.fireTableDataChanged();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.jTableMatchEvents.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one event in the table to add", this.getTitle(), 1);
            return;
        }
        SBEvent event = this.model.data.get(this.jTableMatchEvents.convertRowIndexToModel(this.jTableMatchEvents.getSelectedRow()));
        DialogEvent dialog = new DialogEvent((JDialog)((Object)this), true, this.db, event);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.sbEvent != null) {
            event.setLink(dialog.sbEvent);
            this.model.fireTableDataChanged();
            int index = this.model.data.indexOf(event);
            index = this.jTableMatchEvents.convertRowIndexToView(index);
            this.jTableMatchEvents.setRowSelectionInterval(index, index);
        }
    }

    private void jButtonAddAllActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (SBEvent event : this.model.data) {
                String taxonName;
                if (event.getLink() == null) {
                    event.findLink(this.db);
                }
                if (event.getLink() != null) continue;
                SBEvent.Builder builder = SBEvent.Builder.copyOf(event);
                boolean generate = event.isGenerate();
                if (event.getTaxon() != null) {
                    builder.taxon(event.getTaxon().getLink());
                    taxonName = event.getTaxon().toString(false, false, false);
                } else {
                    taxonName = event.getName();
                    generate = true;
                    if (taxonName.indexOf(42) > 0 && taxonName.lastIndexOf(42) > taxonName.indexOf(42)) {
                        taxonName = taxonName.substring(0, taxonName.indexOf(42));
                        generate = false;
                    } else if (taxonName.indexOf(91) > 0) {
                        taxonName = taxonName.substring(0, taxonName.indexOf(91)).trim();
                        generate = false;
                    }
                }
                builder.isGenerate(generate);
                event.setLink(this.db.addSBEvent(builder, taxonName));
                this.db.commit();
            }
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), "Permission Error", 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        this.model.fireTableDataChanged();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonAddSelectedActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableMatchEvents.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No rows selected", this.getTitle(), 1);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (int i = 0; i < selection.length; ++i) {
                String taxonName;
                SBEvent event = this.model.data.get(this.jTableMatchEvents.convertRowIndexToModel(selection[i]));
                if (event.getLink() == null) {
                    event.findLink(this.db);
                }
                if (event.getLink() != null) continue;
                SBEvent.Builder builder = SBEvent.Builder.copyOf(event);
                boolean generate = event.isGenerate();
                if (event.getTaxon() != null) {
                    builder.taxon(event.getTaxon().getLink());
                    taxonName = event.getTaxon().toString(false, false, false);
                } else {
                    taxonName = event.getName();
                    generate = true;
                    if (taxonName.indexOf(42) > 0 && taxonName.lastIndexOf(42) > taxonName.indexOf(42)) {
                        taxonName = taxonName.substring(0, taxonName.indexOf(42));
                        generate = false;
                    } else if (taxonName.indexOf(91) > 0) {
                        taxonName = taxonName.substring(0, taxonName.indexOf(91)).trim();
                        generate = false;
                    }
                }
                builder.isGenerate(generate);
                event.setLink(this.db.addSBEvent(builder, taxonName));
                this.db.commit();
            }
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), "Permission Error", 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        this.model.fireTableDataChanged();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonSelectEventActionPerformed(ActionEvent evt) {
        if (this.jTableMatchEvents.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one event in the table to add", this.getTitle(), 1);
        }
        SBEvent event = this.model.data.get(this.jTableMatchEvents.convertRowIndexToModel(this.jTableMatchEvents.getSelectedRow()));
        try {
            DialogSelectEvent dialog = new DialogSelectEvent((JDialog)((Object)this), true, this.db, event.getLink(), event.getName(), true);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.selection != null) {
                event.setLink(dialog.selection);
                this.model.fireTableDataChanged();
                int index = this.model.data.indexOf(event);
                index = this.jTableMatchEvents.convertRowIndexToModel(index);
                this.jTableMatchEvents.setRowSelectionInterval(index, index);
                if (this.source != null) {
                    this.source.storeMatch(this.db, event);
                    this.db.commit();
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error: ", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jTableMatchEventsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonSelectEventActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchevents.html");
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        this.loadSource();
    }

    private void loadSource() {
        DialogSource dialog;
        try {
            dialog = new DialogSource((JDialog)((Object)this), true, this.db);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Could not load sources", sql, this.db);
            return;
        }
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.selection != null) {
            this.source = dialog.selection;
            this.jTextFieldSource.setText(this.source.getID() + "," + this.source.getName());
        }
        try {
            this.source.matchEvents(this.db, this.model.data);
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private static class TableModelMatchEvents
    extends AbstractTableModel {
        static final int COL_WS_EVENT = 0;
        static final int COL_WS_TAXON = 1;
        static final int COL_WS_PREFIX = 2;
        static final int COL_WS_GEN = 3;
        static final int COL_WS_ABR = 4;
        static final int COL_WS_DESC = 5;
        static final int COL_ARROW = 6;
        static final int COL_DB_EVENT = 7;
        static final int COL_DB_TAXON = 8;
        static final int COL_DB_PREFIX = 9;
        static final int COL_DB_GEN = 10;
        static final int COL_DB_ABR = 11;
        static final int COL_DB_DESC = 12;
        static final int COL_DB_OCCS = 13;
        static final String[] colTitles = new String[]{"Event", "Taxon", "Type", "Flag", "Abr", "Desc", "", "Event", "Taxon", "Type", "Flag", "Abr", "Desc", "Occs"};
        static final int[] colWidths = new int[]{100, 60, 30, 20, 20, 50, 20, 100, 60, 30, 20, 20, 50, 30};
        LinkedList<SBEvent> data = new LinkedList();

        private TableModelMatchEvents() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SBEvent ws = this.data.get(rowIndex);
            SBEvent db = ws != null ? ws.getLink() : null;
            try {
                switch (columnIndex) {
                    case 0: {
                        return ws != null ? new StringStatus(ws.getDictionaryName(), ws.getStatus()) : null;
                    }
                    case 1: {
                        Color status = SBEvent.NOTSTORED;
                        if (ws == null || ws.getTaxon() == null) {
                            status = SBEvent.STORED;
                        } else if (ws.getTaxon().getLink() != null) {
                            status = SBEvent.STORED;
                        }
                        return ws != null && ws.getTaxon() != null ? new StringStatus(ws.getTaxon().toString(), status) : null;
                    }
                    case 2: {
                        return ws != null ? new StringStatus(ws.getPrefix(EventContext.WELL), ws.getStatus()) : null;
                    }
                    case 3: {
                        return ws != null ? new StringStatus(ws.isGenerate() ? "Yes" : "No", ws.getStatus()) : null;
                    }
                    case 4: {
                        return ws != null ? new StringStatus(ws.getAbr() != null ? ws.getAbr() : "", ws.getStatus()) : null;
                    }
                    case 5: {
                        return ws != null ? new StringStatus(ws.getEvDesc() != null ? ws.getEvDesc() : "", ws.getStatus()) : null;
                    }
                    case 6: {
                        return ws != null && db != null && ws.getStatus() == SBEvent.STORED ? TableModelSB.linked : TableModelSB.unlinked;
                    }
                    case 7: {
                        return db != null ? db.getDictionaryName() : null;
                    }
                    case 8: {
                        return db != null && db.getTaxon() != null ? db.getTaxon().toString() : "";
                    }
                    case 9: {
                        return db != null ? db.getCombinedPrefix() : "";
                    }
                    case 10: {
                        return db != null ? (db.isGenerate() ? "Yes" : "No") : "";
                    }
                    case 11: {
                        return db != null ? (db.getAbr() != null ? db.getAbr() : "") : "";
                    }
                    case 12: {
                        return db != null ? db.getEvDesc() : null;
                    }
                    case 13: {
                        return db != null ? Integer.valueOf(db.getNoccs(false)) : null;
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return StringStatus.class;
                }
                case 6: {
                    return Boolean.class;
                }
                default: {
                    return String.class;
                }
                case 13: 
            }
            return Integer.class;
        }

        void setUpTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
            }
            columnModel.getColumn(6).setMaxWidth(colWidths[6]);
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
            table.getTableHeader().setReorderingAllowed(false);
        }
    }
}

