/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogFilePreviewSelect;
import jsbugs.DialogInterval;
import jsbugs.DialogMatch;
import jsbugs.DialogSelectScheme;
import jsbugs.TableModelMatchIGDInterval;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.DepthUtils;
import util.InvalidFieldException;
import util.MatchData;
import util.SBException;
import util.SbugsFileFilter;

public class DialogMatchIGDIntervals
extends JDialog {
    TableModelMatchIGDInterval model = new TableModelMatchIGDInterval();
    Image backgroundImage;
    InterpHdr hdr;
    SBdb wsDB;
    SBdb dbDB;
    private JButton jButton1;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JButton jButtonSave;
    private JButton jButtonSaveSelected;
    private JInternalFrame jInternalFrame1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTable jTableMatchIGDIntervals;

    public DialogMatchIGDIntervals(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well, char units, InterpHdr hdr, int igdType) throws SQLException, SBException {
        super(parent, modal);
        this.model.wsWell = well;
        this.hdr = hdr;
        this.model.igdType = igdType;
        this.model.units = units;
        this.wsDB = ws;
        this.dbDB = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Stratigraphic Intervals for : " + String.valueOf(this.model.wsWell));
        this.getRootPane().setDefaultButton(this.jButtonCancel);
        if (this.model.wsWell.hasInterpLoaded(this.hdr.getInterpID())) {
            this.model.wsInterp = this.model.wsWell.getInterp(this.hdr.getInterpID());
        }
        if (this.model.wsWell.getLink() != null && this.hdr.getLink() != null && this.model.wsWell.getLink().hasInterpLoaded(this.hdr.getLink().getInterpID())) {
            this.model.dbInterp = this.model.wsWell.getLink().getInterp(this.hdr.getLink().getInterpID());
            this.model.wsWell.getLink().loadInterp(this.model.dbInterp);
        }
        this.checkLinks();
        this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
        this.model.setUpTable(this.jTableMatchIGDIntervals);
        this.jTableMatchIGDIntervals.setRowSorter(new TableRowSorter<TableModelMatchIGDInterval>(this.model));
        new ColumnSortResetHandler(this.jTableMatchIGDIntervals).attach();
        this.model.fireTableDataChanged();
        this.backgroundImage = DialogMatch.getBackgroundImage();
    }

    private void checkLinks() throws SQLException, SBException {
        if (this.model.wsWell.getLink() != null) {
            for (InterpHdr interpHdr : this.wsDB.getInterps()) {
                WellInterp wellInterp;
                if (interpHdr.getLink() != null || (wellInterp = this.model.wsWell.getInterp(interpHdr.getInterpID())) == null || !wellInterp.hasData()) continue;
                throw new SBException("Cannot open dialog, Versions not Matched");
            }
            for (IGDIntervalZone zone : this.model.wsInterp.getIGDList(this.model.igdType, 0)) {
                if (zone.getSchID() <= 0) continue;
                if (this.wsDB.getIGDScheme(zone.getSchID()) == null) {
                    throw new SBException("Cannot open dialog, Stratigraphic Scheme(s) missing from workspace in workspace interval(s).\nScheme ID=" + zone.getSchID() + ", interval=" + zone.toString());
                }
                if (this.wsDB.getIGDScheme(zone.getSchID()).getLink() != null) continue;
                throw new SBException("Cannot open dialog, Stratigraphic Schemes not Matched");
            }
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jInternalFrame1 = new JInternalFrame();
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchIGDIntervals this$0;
            {
                DialogMatchIGDIntervals dialogMatchIGDIntervals = this$0;
                Objects.requireNonNull(dialogMatchIGDIntervals);
                this.this$0 = dialogMatchIGDIntervals;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane2 = new JScrollPane();
        this.jTableMatchIGDIntervals = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonExclude = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonRead = new JButton();
        this.jButtonSaveSelected = new JButton();
        this.jButtonEdit = new JButton();
        this.jButton1.setText("jButton1");
        this.jInternalFrame1.setVisible(true);
        GroupLayout jInternalFrame1Layout = new GroupLayout(this.jInternalFrame1.getContentPane());
        this.jInternalFrame1.getContentPane().setLayout((LayoutManager)jInternalFrame1Layout);
        jInternalFrame1Layout.setHorizontalGroup((GroupLayout.Group)jInternalFrame1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jInternalFrame1Layout.setVerticalGroup((GroupLayout.Group)jInternalFrame1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.lightGray);
        this.setMinimumSize(new Dimension(600, 300));
        this.setModal(true);
        this.jScrollPane2.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableMatchIGDIntervals.setModel(this.model);
        this.jTableMatchIGDIntervals.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMatchIGDIntervals this$0;
            {
                DialogMatchIGDIntervals dialogMatchIGDIntervals = this$0;
                Objects.requireNonNull(dialogMatchIGDIntervals);
                this.this$0 = dialogMatchIGDIntervals;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableMatchIGDIntervalsMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableMatchIGDIntervals);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDIntervals this$0;
            {
                DialogMatchIGDIntervals dialogMatchIGDIntervals = this$0;
                Objects.requireNonNull(dialogMatchIGDIntervals);
                this.this$0 = dialogMatchIGDIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save ALL unsaved intervals from workspace into database");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDIntervals this$0;
            {
                DialogMatchIGDIntervals dialogMatchIGDIntervals = this$0;
                Objects.requireNonNull(dialogMatchIGDIntervals);
                this.this$0 = dialogMatchIGDIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected intervals from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDIntervals this$0;
            {
                DialogMatchIGDIntervals dialogMatchIGDIntervals = this$0;
                Objects.requireNonNull(dialogMatchIGDIntervals);
                this.this$0 = dialogMatchIGDIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected intervals from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDIntervals this$0;
            {
                DialogMatchIGDIntervals dialogMatchIGDIntervals = this$0;
                Objects.requireNonNull(dialogMatchIGDIntervals);
                this.this$0 = dialogMatchIGDIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDIntervals this$0;
            {
                DialogMatchIGDIntervals dialogMatchIGDIntervals = this$0;
                Objects.requireNonNull(dialogMatchIGDIntervals);
                this.this$0 = dialogMatchIGDIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonSaveSelected.setText("Save selected");
        this.jButtonSaveSelected.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSaveSelected.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDIntervals this$0;
            {
                DialogMatchIGDIntervals dialogMatchIGDIntervals = this$0;
                Objects.requireNonNull(dialogMatchIGDIntervals);
                this.this$0 = dialogMatchIGDIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveSelectedActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.setToolTipText("Edit interval in workspace");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGDIntervals this$0;
            {
                DialogMatchIGDIntervals dialogMatchIGDIntervals = this$0;
                Objects.requireNonNull(dialogMatchIGDIntervals);
                this.this$0 = dialogMatchIGDIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel2)).add((Component)this.jScrollPane2, -1, 643, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jButtonRead, -2, 87, -2).add((Component)this.jSeparator1, -2, 87, -2).add((Component)this.jButtonSaveSelected).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSave, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonExclude, -2, 87, -2)).add((Component)this.jButtonEdit, -2, 86, -2)).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonDelete, this.jButtonEdit, this.jButtonExclude, this.jButtonRead, this.jButtonSave, this.jButtonSaveSelected, this.jSeparator1}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonSave).addPreferredGap(0).add((Component)this.jButtonSaveSelected).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonRead).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane2, -1, 416, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteIntervals(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteIntervals(true);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        LinkedList<MatchData.MatchPair> selection = new LinkedList<MatchData.MatchPair>();
        for (int row = 0; row < this.model.data.size(); ++row) {
            selection.add(this.model.data.get(row));
        }
        this.saveSelection(selection);
    }

    /*
     * Exception decompiling
     */
    private void saveSelection(List<MatchData.MatchPair> selection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.dbDB, "JIGDFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.addExtension("csv");
        filter.addExtension("lst");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            String[] types = new String[]{"CSV 2 lines: well | interval | depth (1 header lines)", "CSV (semi colon delimeter) 2 lines: pick top/base | depth | label (no header lines)", "CSV 2 lines: pick top/base | depth | label (no header lines)", "TABBED: well | top depth | base depth | * | label"};
            try {
                Lastval.putString(this.dbDB, "JIGDFILE", fileName);
                this.dbDB.commit();
                DialogFilePreviewSelect selector = new DialogFilePreviewSelect(this, true, fileName, types);
                selector.setLocationRelativeTo(this);
                selector.setVisible(true);
                if (!selector.isOK()) {
                    return;
                }
                String selectedFileType = types[selector.selectedItem];
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                String schemeName = jFileChooser.getSelectedFile().getName();
                schemeName = schemeName.substring(0, schemeName.indexOf(46));
                DialogSelectScheme dialog = new DialogSelectScheme(this, true, this.dbDB, this.model.igdType, null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    IGDScheme scheme = IGDScheme.copyToWorkspace(this.wsDB, dialog.selection);
                    this.wsDB.addIGDScheme(scheme);
                    HashSet<Integer> dummy = new HashSet<Integer>();
                    dummy.add(1);
                    this.model.wsWell.fillData(dummy, 0);
                    if (selectedFileType.equals(types[0])) {
                        this.importTextFile(in, scheme, ',', 1, 3, 2, 0, 2, 2, 1);
                    } else if (selectedFileType.equals(types[1])) {
                        this.importTextFile(in, scheme, ';', 0, 3, 2, -1, 1, 1, 0);
                    } else if (selectedFileType.equals(types[2])) {
                        this.importTextFile(in, scheme, ',', 0, 3, 2, -1, 1, 1, 0);
                    } else if (selectedFileType.equals(types[3])) {
                        this.importTextFile(in, scheme, '\t', 1, 5, 1, 0, 1, 2, 4);
                    } else {
                        JOptionPane.showMessageDialog(this, "Cannot recognise file type. Please select a file type from the list of types at the base of the dialog", this.getTitle(), 2);
                    }
                    in.close();
                    if (this.model.wsInterp != null) {
                        // empty if block
                    }
                    this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
                    this.model.fireTableDataChanged();
                }
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
        }
    }

    private void jButtonSaveSelectedActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.jTableMatchIGDIntervals.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Make a selection of rows to save", this.getTitle(), 2);
            return;
        }
        LinkedList<MatchData.MatchPair> selection = new LinkedList<MatchData.MatchPair>();
        for (int i = 0; i < selectedRows.length; ++i) {
            selection.add(this.model.data.get(this.jTableMatchIGDIntervals.convertRowIndexToModel(selectedRows[i])));
        }
        this.saveSelection(selection);
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.jTableMatchIGDIntervals.getSelectedRows();
        if (selectedRows.length != 1) {
            JOptionPane.showMessageDialog(this, "Select one row of workspace data to edit", this.getTitle(), 2);
            return;
        }
        MatchData.MatchPair selection = this.model.data.get(this.jTableMatchIGDIntervals.convertRowIndexToModel(selectedRows[0]));
        if (selection.getWs() == null) {
            JOptionPane.showMessageDialog(this, "Select one row of workspace data to edit", this.getTitle(), 2);
            return;
        }
        IGDIntervalZone zone = (IGDIntervalZone)selection.getWs();
        try {
            DialogInterval dialog = new DialogInterval(this, true, zone.getIGDType(), this.wsDB, this.model.wsWell, this.model.wsInterp, this.model.units, zone);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.wsWell.updateSampleStatus(true);
                this.model.wsWell.updateInterpStatus(this.model.wsInterp, this.model.units);
                this.jTableMatchIGDIntervals.clearSelection();
                this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DialogMatchIGDIntervals.class.getName()).log(Level.SEVERE, "SQL Error opening DialogInterval", ex);
        }
        catch (SBException ex) {
            Logger.getLogger(DialogMatchIGDIntervals.class.getName()).log(Level.WARNING, "Error opening DialogInterval", ex);
        }
    }

    private void jTableMatchIGDIntervalsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    void importTextFile(BufferedReader in, IGDScheme scheme, char delim, int nHeaders, int nColumns, int nRowsPerInterval, int wellColumn, int topColumn, int baseColumn, int nameColumn) throws IOException, SBException, SQLException {
        String buff;
        for (int i = 0; i < nHeaders; ++i) {
            buff = in.readLine();
        }
        buff = in.readLine();
        String wellUWI = null;
        while (buff != null) {
            if (buff.indexOf(delim) > 0) {
                Sample topSample = null;
                Sample baseSample = null;
                String intervalName = null;
                Object zone = null;
                double depth = 0.0;
                for (int row = 1; row <= nRowsPerInterval; ++row) {
                    depth = 0.0;
                    for (int column = 0; column < nColumns && buff != null && buff.length() > 0; buff = buff.substring(buff.indexOf(delim) + 1), ++column) {
                        String strg = buff.indexOf(delim) > 0 ? buff.substring(0, buff.indexOf(delim)).trim() : buff.trim();
                        if (column == wellColumn) {
                            if (wellUWI == null) {
                                wellUWI = strg;
                            }
                            if (wellUWI.equals(strg)) continue;
                            throw new SBException("Well identifier changes in file - edit file to separate");
                        }
                        if (column == topColumn && (nRowsPerInterval == 1 || nRowsPerInterval == 2 && row == 1)) {
                            depth = DepthUtils.parseDepthString((String)strg, (char)this.model.units);
                            topSample = this.model.wsWell.getSample(depth, null, true);
                            if (topSample != null) continue;
                            topSample = this.model.wsWell.addSample(this.dbDB.useSampleTops() ? Double.valueOf(depth) : null, this.dbDB.useSampleTops() ? null : Double.valueOf(depth), "LOG", null);
                            continue;
                        }
                        if (column == baseColumn && (nRowsPerInterval == 1 || nRowsPerInterval == 2 && row == 2)) {
                            depth = DepthUtils.parseDepthString((String)strg, (char)this.model.units);
                            baseSample = this.model.wsWell.getSample(depth, null, true);
                            if (baseSample != null) continue;
                            baseSample = this.model.wsWell.addSample(this.dbDB.useSampleTops() ? Double.valueOf(depth) : null, this.dbDB.useSampleTops() ? null : Double.valueOf(depth), "LOG", null);
                            continue;
                        }
                        if (column != nameColumn || nRowsPerInterval != 1 && (nRowsPerInterval != 2 || row != 1)) continue;
                        intervalName = buff.substring(0).trim();
                        if (intervalName.indexOf(delim) >= 0) {
                            intervalName = intervalName.substring(0, intervalName.indexOf(delim)).trim();
                        }
                        if (!intervalName.toUpperCase().endsWith(" TOP")) continue;
                        intervalName = intervalName.substring(0, intervalName.length() - 4);
                    }
                    buff = in.readLine();
                }
                if (topSample != null && baseSample != null && intervalName != null) {
                    try {
                        int hier = IGDIntervalZone.getDefaultHier(this.model.igdType);
                        IGDUnitBase unit = scheme.findUnitBase(intervalName);
                        if (unit != null) {
                            hier = unit.getHier();
                        }
                        IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.wsDB, this.model.igdType, topSample, baseSample, hier, scheme.getID()).uppInf(intervalName);
                        if (unit != null) {
                            builder.uppZone(unit.getUnitID());
                        }
                        this.model.wsInterp.addZone(builder, this.model.wsWell);
                        continue;
                    }
                    catch (SBException ex) {
                        ex.printStackTrace();
                        if (this.handleException((Exception)((Object)ex))) continue;
                        break;
                    }
                    catch (IllegalStateException | InvalidFieldException ex) {
                        if (this.handleException((Exception)ex)) continue;
                        break;
                    }
                }
                System.out.println("Can't add interval for depth: " + depth + ": " + intervalName);
                continue;
            }
            buff = in.readLine();
        }
    }

    private boolean handleException(Exception ex) {
        int opt = JOptionPane.showConfirmDialog(this, "Error reading file: " + ex.getMessage() + "\nContinue reading?", this.getTitle(), 0, 3);
        return opt == 0;
    }

    private void deleteIntervals(boolean fromDatabase) {
        block10: {
            if (fromDatabase && this.model.wsWell.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchIGDIntervals.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No intervals selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchIGDIntervals.getSelectedRows();
            LinkedList<IGDIntervalZone> toRemove = new LinkedList<IGDIntervalZone>();
            for (int i : selected) {
                IGDIntervalZone zone = fromDatabase ? (IGDIntervalZone)this.model.data.get(this.jTableMatchIGDIntervals.convertRowIndexToModel(i)).getDb() : (IGDIntervalZone)this.model.data.get(this.jTableMatchIGDIntervals.convertRowIndexToModel(i)).getWs();
                if (zone == null) continue;
                toRemove.add(zone);
            }
            if (fromDatabase && toRemove.size() > 0) {
                Object msg = "Really delete ";
                msg = (String)msg + (String)(toRemove.size() == 1 ? "this interval" : "these " + toRemove.size() + " interval");
                if (JOptionPane.showConfirmDialog(this, msg = (String)msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            try {
                int nSamples = 0;
                Well deleteWell = fromDatabase ? this.model.wsWell.getLink() : this.model.wsWell;
                WellInterp deleteInterp = fromDatabase ? this.model.dbInterp : this.model.wsInterp;
                deleteInterp.deleteZones(deleteWell, toRemove);
                Object deletedZone = null;
                for (IGDIntervalZone zone : toRemove) {
                    deletedZone = deletedZone == null || deletedZone instanceof IGDIntervalZone && ((IGDInterval)deletedZone).getIGDType() == zone.getIGDType() && (zone.getIGDType() != 4 || ((IGDIntervalZone)deletedZone).getSchID() == zone.getSchID()) ? zone : Integer.valueOf(zone.getIGDType());
                    ++nSamples;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Intervals " + text + ": " + nSamples, this.getTitle(), 1);
                if (fromDatabase) {
                    deleteWell.getDataModel().commit();
                    deleteInterp.notifyObservers(deletedZone);
                } else {
                    this.model.wsWell.updateZoneStatus(this.model.wsInterp, this.model.dbInterp != null ? this.model.dbInterp.getHeader() : null, this.model.igdType, this.model.units, true);
                }
                this.model.data.init(this.model.wsInterp != null ? this.model.wsInterp.getIGDList(this.model.igdType, 0) : null, this.model.dbInterp != null ? this.model.dbInterp.getIGDList(this.model.igdType, 0) : null);
                this.model.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block10;
                this.model.wsWell.getLink().getDataModel().doRollback();
            }
        }
    }
}

