/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogFilePreviewSelect;
import jsbugs.DialogMatch;
import jsbugs.DialogMatchLithology;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchIntLith;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.DepthRenderer;
import jsbugs.table.DepthStatusRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Lastval;
import model3.LithBase;
import model3.LithInterval;
import model3.LithQualifier;
import model3.LogFile;
import model3.SBdb;
import model3.Well;
import model3.WsLithology;
import model3.WsWell;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.exception.StackError;
import util.status.DoubleStatus;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchIntLith
extends JDialog {
    private final TableModelMatchIntLith model = new TableModelMatchIntLith();
    private Image backgroundImage;
    private final SBdb ws;
    private final SBdb db;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchIntLith;

    public DialogMatchIntLith(Frame parent, boolean modal, WsWell well, char units, SBdb ws, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        this.initComponents();
        this.init(well);
    }

    private void init(WsWell well) throws SQLException, SBException {
        this.setTitle("Match Interpreted Lithology");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        SB.setTableHeaderBold((JTable)this.jTableMatchIntLith);
        TableColumnModel columnModel = this.jTableMatchIntLith.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchIntLith.colTitles[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchIntLith.colWidths[i]);
        }
        columnModel.getColumn(3).setMaxWidth(TableModelMatchIntLith.colWidths[3]);
        this.model.well = well;
        this.model.units = well.getWellUnits();
        this.model.data.init(well.getLithIntervals(), well.getLink() != null ? well.getLink().getLithIntervals() : null);
        this.jTableMatchIntLith.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchIntLith.setDefaultRenderer(DoubleStatus.class, (TableCellRenderer)((Object)new DepthStatusRenderer(2)));
        this.jTableMatchIntLith.setDefaultRenderer(Double.class, new DepthRenderer(2));
        this.jTableMatchIntLith.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        this.jTableMatchIntLith.setRowSorter(new TableRowSorter<TableModelMatchIntLith>(this.model));
        new ColumnSortResetHandler(this.jTableMatchIntLith).attach();
        this.jTableMatchIntLith.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = DialogMatch.getBackgroundImage();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchIntLith this$0;
            {
                DialogMatchIntLith dialogMatchIntLith = this$0;
                Objects.requireNonNull(dialogMatchIntLith);
                this.this$0 = dialogMatchIntLith;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchIntLith = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 300));
        this.setModal(true);
        this.jTableMatchIntLith.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchIntLith);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIntLith this$0;
            {
                DialogMatchIntLith dialogMatchIntLith = this$0;
                Objects.requireNonNull(dialogMatchIntLith);
                this.this$0 = dialogMatchIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIntLith this$0;
            {
                DialogMatchIntLith dialogMatchIntLith = this$0;
                Objects.requireNonNull(dialogMatchIntLith);
                this.this$0 = dialogMatchIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIntLith this$0;
            {
                DialogMatchIntLith dialogMatchIntLith = this$0;
                Objects.requireNonNull(dialogMatchIntLith);
                this.this$0 = dialogMatchIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Import lithology intervals from file...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIntLith this$0;
            {
                DialogMatchIntLith dialogMatchIntLith = this$0;
                Objects.requireNonNull(dialogMatchIntLith);
                this.this$0 = dialogMatchIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIntLith this$0;
            {
                DialogMatchIntLith dialogMatchIntLith = this$0;
                Objects.requireNonNull(dialogMatchIntLith);
                this.this$0 = dialogMatchIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 225, Short.MAX_VALUE).addComponent(this.jLabel2).addGap(16, 16, 16)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 409, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRead, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 342, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteIntervals(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteIntervals(true);
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        this.read();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.model.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.model.well.storeLithology();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        try {
            this.db.commit();
            this.model.well.updateLithologyStatus(true);
            this.model.data.init(this.model.well.getLithIntervals(), this.model.well.getLink() != null ? this.model.well.getLink().getLithIntervals() : null);
            this.model.fireTableDataChanged();
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void read() {
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.db, "JLITHFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.addExtension("csv");
        filter.addExtension("lst");
        filter.addExtension("las");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            String[] types = new String[]{"TABBED 'Depth | Lithology Description' with header", "TABBED 'Top Depth | Base Depth | Lithology Description' with header", "CSV 'Top Depth | Base Depth | Lithology Description'", "Openworks FIXED 'LITH | Top Depth | Base Depth | Lithology | %' (uses descriptors)", "Openworks text 'WELL_UWI | LITHO_CLASS | TOP_DEPTH | BASE_DEPTH | DATA_SOURCE' (uses descriptors)", "Applecore (uses numeric codes)", "Openworks TABBED lithology (uses numeric codes)", "CSV 'Depth | Lithology Code' (code is lithology FROM depth TO the next depth)", "CSV 'Depth | Lithology Code' (code is lithology TO depth FROM the previous depth)", "TABBED 'Well ID | Top Depth | Base Depth | Lithology | Comments' (uses descriptors, numbers with ',' decimal)", "TABBED 'Well ID | Top Depth | Base Depth | Lithology | Comments' (uses descriptors, numbers with '.' decimal)", "WellCad 'Top Depth | Base Depth | Code | CSV files' (2 header lines)"};
            try {
                Lastval.putString(this.db, "JLITHFILE", fileName);
                this.db.commit();
                LinkedList<WsLithology> wsLiths = new LinkedList<WsLithology>();
                LinkedList<LithInterval> lithIntervals = new LinkedList<LithInterval>();
                if (fileName.toLowerCase().endsWith(".las")) {
                    this.importLasFile(fileName, wsLiths, lithIntervals);
                } else {
                    DialogFilePreviewSelect selector = new DialogFilePreviewSelect(this, true, fileName, types);
                    selector.setLocationRelativeTo(this);
                    selector.setVisible(true);
                    if (!selector.isOK()) {
                        return;
                    }
                    int selectedFileType = selector.selectedItem;
                    BufferedReader in = new BufferedReader(new FileReader(fileName));
                    boolean isNumericScheme = false;
                    switch (selectedFileType) {
                        case 0: {
                            isNumericScheme = false;
                            this.importTextFile(in, '\t', wsLiths, lithIntervals);
                            break;
                        }
                        case 1: {
                            isNumericScheme = false;
                            this.importDualDepthTextFile(in, '\t', wsLiths, lithIntervals);
                            break;
                        }
                        case 2: {
                            isNumericScheme = false;
                            this.importDualDepthTextFile(in, ',', wsLiths, lithIntervals);
                            break;
                        }
                        case 3: {
                            isNumericScheme = false;
                            this.importOWLstFile(in, wsLiths, lithIntervals);
                            break;
                        }
                        case 4: {
                            isNumericScheme = false;
                            this.importOWLstTextFile(in, wsLiths, lithIntervals);
                            break;
                        }
                        case 5: {
                            isNumericScheme = true;
                            this.importApplecoreFile(in, wsLiths, lithIntervals);
                            break;
                        }
                        case 6: {
                            isNumericScheme = true;
                            this.importOWFile(in, wsLiths, lithIntervals);
                            break;
                        }
                        case 7: {
                            isNumericScheme = true;
                            this.importDepthCSVFile(in, wsLiths, lithIntervals, true);
                            break;
                        }
                        case 8: {
                            isNumericScheme = true;
                            this.importDepthCSVFile(in, wsLiths, lithIntervals, false);
                            break;
                        }
                        case 9: 
                        case 10: {
                            isNumericScheme = false;
                            this.importBOREFile(in, wsLiths, lithIntervals, selectedFileType == 9);
                            break;
                        }
                        case 11: {
                            isNumericScheme = true;
                            this.importWellCadCSVFile(in, wsLiths, lithIntervals);
                            break;
                        }
                        default: {
                            JOptionPane.showMessageDialog(this, "Cannot recognise file type. Please select a file type from the list of types at the base of the dialog", "Lithology", 2);
                        }
                    }
                    in.close();
                }
                DialogMatchLithology dialog = new DialogMatchLithology((Dialog)this, true, wsLiths, this.db);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    for (LithInterval lithInterval : lithIntervals) {
                        WsLithology wslith = (WsLithology)lithInterval.getLithology();
                        if (wslith.getLink() == null) continue;
                        if (wslith.getLink().isQual()) {
                            LithQualifier lithQualifier = new LithQualifier(this.ws);
                            lithQualifier.setLithology(wslith);
                            lithQualifier.setTopDepth((lithInterval.getBaseDepth() + lithInterval.getTopDepth()) / 2.0);
                            lithQualifier.setType(wslith.getLink().getCmp());
                            this.model.well.insertLithInterval(lithQualifier);
                            continue;
                        }
                        lithInterval.setLithology(lithInterval.getLithology());
                        this.model.well.insertLithInterval(lithInterval);
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                }
                this.model.data.init(this.model.well.getLithIntervals(), this.model.well.getLink() != null ? this.model.well.getLink().getLithIntervals() : null);
                this.model.well.updateLithologyStatus(true);
                this.model.fireTableDataChanged();
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, "Problem reading number: " + nfe.getMessage());
                nfe.printStackTrace();
            }
            catch (IOException | SQLException | SBException ex) {
                SbugsExceptionHandler.showStackError(ex, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIntervals(boolean fromDatabase) {
        String msg;
        if (fromDatabase && this.model.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatchIntLith.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No intervals selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchIntLith.getSelectedRows();
        LinkedList<LithBase> toRemove = new LinkedList<LithBase>();
        for (int i : selected) {
            LithBase lb = fromDatabase ? (LithBase)this.model.data.get(this.jTableMatchIntLith.convertRowIndexToModel(i)).getDb() : (LithBase)this.model.data.get(this.jTableMatchIntLith.convertRowIndexToModel(i)).getWs();
            if (lb == null) continue;
            toRemove.add(lb);
        }
        if (fromDatabase && toRemove.size() > 0 && JOptionPane.showConfirmDialog(this, msg = "Really delete " + (String)(toRemove.size() == 1 ? "this interval?" : "these " + toRemove.size() + " intervals?"), this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Well deleteWell = fromDatabase ? this.model.well.getLink() : this.model.well;
            deleteWell.deleteLithBases(toRemove);
            String text = fromDatabase ? "deleted" : "excluded";
            JOptionPane.showMessageDialog(this, "Lithology intervals " + text + ": " + toRemove.size(), this.getTitle(), 1);
            if (fromDatabase) {
                deleteWell.getDataModel().commit();
                deleteWell.setDataChanged();
                deleteWell.notifyObservers(LithBase.class);
            } else {
                this.model.well.updateLithologyStatus(true);
            }
            this.model.data.init(this.model.well.getLithIntervals(), this.model.well.getLink() != null ? this.model.well.getLink().getLithIntervals() : null);
            this.model.fireTableDataChanged();
        }
        catch (SBException sbe) {
            StackError.showStackError((String)("Error " + (fromDatabase ? "deleting" : "excluding")), (Throwable)sbe);
        }
        catch (SQLException sql) {
            if (fromDatabase) {
                this.model.well.getLink().getDataModel().doRollback();
            }
            FrameJsbugs.showStackError("Error " + (fromDatabase ? "deleting" : "excluding"), sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void addInterval(LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> intervals, double topDepth, double baseDepth, String mnem, int code) throws SBException, SQLException {
        WsLithology lith = null;
        for (WsLithology wsl : wsLiths) {
            if (code > 0) {
                if (wsl.getCode() != code) continue;
                lith = wsl;
                break;
            }
            if (!wsl.getDescription().equals(mnem)) continue;
            lith = wsl;
            break;
        }
        if (lith == null) {
            lith = new WsLithology(mnem, code);
            wsLiths.add(lith);
        }
        intervals.add(new LithInterval(this.ws, topDepth, baseDepth, lith));
    }

    void importTextFile(BufferedReader in, char delim, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals) throws IOException, SBException, SQLException {
        in.readLine();
        String buff = in.readLine();
        String lastMnem = null;
        double topDepth = 0.0;
        double baseDepth = 0.0;
        while (buff != null) {
            if (buff.indexOf(delim) > 0) {
                String mnem;
                String numberString = buff.substring(0, buff.indexOf(delim)).trim();
                if (numberString.length() > 0) {
                    baseDepth = Double.parseDouble(numberString);
                    baseDepth = DepthUtils.convToM((double)baseDepth, (char)this.model.units);
                    if (topDepth == 0.0) {
                        topDepth = baseDepth;
                    }
                }
                if ((mnem = (buff = buff.substring(buff.indexOf(delim) + 1)).substring(0).trim()).indexOf(delim) >= 0) {
                    mnem = mnem.substring(0, mnem.indexOf(delim));
                }
                if (lastMnem != null && !lastMnem.equalsIgnoreCase(mnem)) {
                    this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, lastMnem, -1);
                    topDepth = baseDepth;
                }
                lastMnem = mnem;
            }
            buff = in.readLine();
        }
        if (topDepth > 0.0 && lastMnem.length() > 0) {
            this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, lastMnem, -1);
        }
    }

    void importLasFile(String fileName, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals) throws IOException, SBException, SQLException {
        LogFile logFile = new LogFile(new File(fileName));
        Iterator<LogFile.CurveHeader> itHead = logFile.getCurveHeaders();
        int curveNumber = 0;
        int i = 0;
        while (itHead.hasNext()) {
            LogFile.CurveHeader header = itHead.next();
            if (header.getMnem().startsWith("LITH")) {
                curveNumber = i;
            }
            ++i;
        }
        Iterator<LogFile.LogValue> it = logFile.getRecords().iterator();
        Double topDepth = null;
        Double baseDepth = null;
        int lastCode = -1;
        while (it.hasNext()) {
            LogFile.LogValue logFileValue = it.next();
            double depth = logFileValue.getDepth();
            double lithCodeD = logFileValue.getValue(curveNumber);
            int lithCode = (int)lithCodeD;
            baseDepth = DepthUtils.convToM((double)depth, (char)logFile.getDepthUnits());
            if (topDepth == null) {
                topDepth = baseDepth;
                lastCode = lithCode;
                continue;
            }
            if (lastCode == lithCode) continue;
            if (lastCode > 0) {
                this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, "", lastCode);
            }
            topDepth = baseDepth;
            lastCode = lithCode;
        }
        if (baseDepth != null && baseDepth != topDepth && lastCode > 0) {
            this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, null, lastCode);
        }
    }

    void importDualDepthTextFile(BufferedReader in, char delim, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals) throws IOException, SBException, SQLException {
        in.readLine();
        String buff = in.readLine();
        String mnem = "";
        Double lastTop = null;
        Double lastBase = null;
        while (buff != null) {
            if (buff.indexOf(delim) > 0) {
                String tempMnem;
                double topDepth;
                double baseDepth = 0.0;
                String numberString = buff.substring(0, buff.indexOf(delim)).trim();
                if (numberString.length() > 0) {
                    topDepth = Double.parseDouble(numberString);
                    topDepth = DepthUtils.convToM((double)topDepth, (char)this.model.units);
                } else {
                    topDepth = 0.0;
                }
                buff = buff.substring(buff.indexOf(delim) + 1);
                numberString = buff.substring(0, buff.indexOf(delim)).trim();
                if (numberString.length() > 0) {
                    baseDepth = Double.parseDouble(numberString);
                    baseDepth = DepthUtils.convToM((double)baseDepth, (char)this.model.units);
                }
                if ((tempMnem = (buff = buff.substring(buff.indexOf(delim) + 1)).substring(0).trim()).indexOf(delim) >= 0) {
                    tempMnem = tempMnem.substring(0, tempMnem.indexOf(delim));
                }
                if (tempMnem != null && Math.abs(baseDepth - topDepth) > 0.0) {
                    if (!tempMnem.equals(mnem) && lastTop != null && lastBase != null) {
                        this.addInterval(wsLiths, lithIntervals, lastTop, lastBase, mnem, -1);
                        lastTop = topDepth;
                        lastBase = baseDepth;
                    } else {
                        if (lastTop == null) {
                            lastTop = topDepth;
                        }
                        lastBase = baseDepth;
                    }
                    mnem = tempMnem;
                }
            }
            buff = in.readLine();
        }
        if (lastTop != null && lastBase != null && mnem != null) {
            this.addInterval(wsLiths, lithIntervals, lastTop, lastBase, mnem, -1);
        }
    }

    void importOWLstFile(BufferedReader in, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        double topDepth = 0.0;
        double baseDepth = 0.0;
        while (buff != null) {
            if (buff.indexOf("LITH ") == 0) {
                String numberString = buff.substring(12, 24).trim();
                if (numberString.length() > 0) {
                    topDepth = Double.parseDouble(numberString);
                    topDepth = DepthUtils.convToM((double)topDepth, (char)this.model.units);
                }
                if ((numberString = buff.substring(25, 37).trim()).length() > 0) {
                    baseDepth = Double.parseDouble(numberString);
                    baseDepth = DepthUtils.convToM((double)baseDepth, (char)this.model.units);
                }
                String trnDesc = buff.substring(38, 63).trim();
                this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, trnDesc, -1);
            }
            buff = in.readLine();
        }
    }

    void importOWLstTextFile(BufferedReader in, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        double topDepth = 0.0;
        double baseDepth = 0.0;
        while (buff != null) {
            if (buff.indexOf("WELL_UWI") == 0) {
                in.readLine();
                break;
            }
            buff = in.readLine();
        }
        buff = in.readLine();
        while (buff != null) {
            if (buff.length() >= 70) {
                String trnDesc;
                String numberString = buff.substring(37, 47).trim();
                if (numberString.length() > 0) {
                    topDepth = Double.parseDouble(numberString);
                    topDepth = DepthUtils.convToM((double)topDepth, (char)this.model.units);
                }
                if ((numberString = buff.substring(51, 61).trim()).length() > 0) {
                    baseDepth = Double.parseDouble(numberString);
                    baseDepth = DepthUtils.convToM((double)baseDepth, (char)this.model.units);
                }
                if ((trnDesc = buff.substring(16, 36).trim()).indexOf(45) > 0) {
                    trnDesc = trnDesc.substring(0, trnDesc.indexOf(45));
                    this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, trnDesc, -1);
                }
            }
            buff = in.readLine();
        }
    }

    void importApplecoreFile(BufferedReader in, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        while (buff != null) {
            if (buff.startsWith("LTH")) {
                int appleCoreCode;
                String numberString;
                double baseDepth = 0.0;
                double topDepth = 0.0;
                StringTokenizer tok = new StringTokenizer(buff, "\t, ");
                tok.nextToken();
                if (tok.countTokens() > 9) {
                    tok.nextToken();
                    tok.nextToken();
                }
                if ((numberString = tok.nextToken()).length() > 0) {
                    topDepth = Double.parseDouble(numberString);
                    topDepth = DepthUtils.convToM((double)topDepth, (char)this.model.units);
                }
                if ((numberString = tok.nextToken()).length() > 0) {
                    baseDepth = Double.parseDouble(numberString);
                    baseDepth = DepthUtils.convToM((double)baseDepth, (char)this.model.units);
                }
                if ((appleCoreCode = Integer.parseInt(numberString = tok.nextToken())) != 0) {
                    this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, "", appleCoreCode);
                }
            }
            buff = in.readLine();
        }
    }

    void importOWFile(BufferedReader in, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        double topDepth = 0.0;
        double baseDepth = 0.0;
        String trnDesc = "";
        int trnID = 0;
        while (buff != null) {
            if (buff.indexOf(9) > 0) {
                String owCode = buff.substring(0, buff.indexOf(9)).trim();
                String numberString = (buff = buff.substring(buff.indexOf(9) + 1)).substring(0, buff.indexOf(9)).trim();
                if (numberString.length() > 0) {
                    baseDepth = Double.parseDouble(numberString);
                    DepthUtils.convToM((double)baseDepth, (char)this.model.units);
                    if (trnID != 0 && topDepth > 0.0) {
                        this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, trnDesc, trnID);
                    }
                    topDepth = baseDepth;
                }
                buff = buff.substring(buff.indexOf(9) + 1);
                trnDesc = buff = buff.substring(buff.indexOf(9) + 1);
                numberString = (buff = buff.substring(buff.indexOf(9) + 1)).trim();
                if (numberString.length() > 0) {
                    trnID = Integer.parseInt(numberString);
                }
            }
            buff = in.readLine();
        }
        if (trnID != 0 && topDepth > 0.0) {
            this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, trnDesc, trnID);
        }
    }

    void importDepthCSVFile(BufferedReader in, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals, boolean useTopLith) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        double depth = 0.0;
        double lastDepth = -1.0;
        int trnID = 0;
        int lastTrnID = 0;
        class LithInt {
            double top;
            double base;
            int code;

            LithInt(DialogMatchIntLith this$0) {
                Objects.requireNonNull(this$0);
            }
        }
        LinkedList<LithInt> list = new LinkedList<LithInt>();
        while (buff != null) {
            if (buff.indexOf(44) > 0) {
                String numberString = buff.substring(0, buff.indexOf(44)).trim();
                if (numberString.length() > 0) {
                    depth = Double.parseDouble(numberString);
                    depth = DepthUtils.convToM((double)depth, (char)this.model.units);
                    numberString = (buff = buff.substring(buff.indexOf(44) + 1)).trim();
                    if (numberString.length() > 0) {
                        trnID = Integer.parseInt(numberString);
                    }
                }
                if (lastDepth >= 0.0) {
                    LithInt l = new LithInt(this);
                    l.top = lastDepth;
                    l.base = depth;
                    l.code = useTopLith ? lastTrnID : trnID;
                    list.add(l);
                }
                lastDepth = depth;
                lastTrnID = trnID;
            }
            buff = in.readLine();
        }
        block1: for (int i = 0; i < list.size() - 1; ++i) {
            LithInt l = (LithInt)list.get(i);
            boolean removed = true;
            while (removed) {
                removed = false;
                if (list.size() == i + 1) continue block1;
                LithInt lNext = (LithInt)list.get(i + 1);
                if (l.code != lNext.code) continue;
                l.base = lNext.base;
                list.remove(i + 1);
                removed = true;
            }
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (((LithInt)it.next()).code >= 0) continue;
            it.remove();
        }
        for (LithInt l : list) {
            this.addInterval(wsLiths, lithIntervals, l.top, l.base, "", l.code);
        }
    }

    void importBOREFile(BufferedReader in, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals, boolean commaNumbers) throws IOException, SBException, SQLException {
        String buff = in.readLine();
        NumberFormat format = NumberFormat.getInstance(commaNumbers ? Locale.GERMAN : Locale.UK);
        while (buff != null) {
            StringTokenizer tok = new StringTokenizer(buff, "\t");
            if (tok.countTokens() >= 4) {
                tok.nextToken();
                String numberString = tok.nextToken().trim();
                try {
                    float topDepth = format.parse(numberString).floatValue();
                    numberString = tok.nextToken().trim();
                    float baseDepth = format.parse(numberString).floatValue();
                    String trnDesc = tok.nextToken();
                    this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, trnDesc, -1);
                }
                catch (SQLException e) {
                    System.out.println("SQL exception for line: " + buff + " : " + e.getMessage());
                }
                catch (ParseException e) {
                    System.out.println("Parse exception for line: " + buff + " : " + e.getMessage());
                }
                catch (SBException e) {
                    System.out.println("SB exception for line: " + buff + " : " + e.getMessage());
                }
            }
            buff = in.readLine();
        }
    }

    void importWellCadCSVFile(BufferedReader in, LinkedList<WsLithology> wsLiths, LinkedList<LithInterval> lithIntervals) throws IOException, SBException, SQLException {
        int opt;
        String buff = in.readLine();
        buff = in.readLine();
        char readUnits = 'M';
        if (buff.toLowerCase().startsWith("ft")) {
            readUnits = 'F';
        }
        if ((opt = JOptionPane.showConfirmDialog(this, "Do you want to extend adjoining intervals that have the same lithology (or keep them discrete)?", this.getTitle(), 1)) == 2 || opt == -1) {
            return;
        }
        buff = in.readLine();
        while (buff != null) {
            StringTokenizer tok = new StringTokenizer(buff, ",");
            if (tok.countTokens() >= 3) {
                String numberString = tok.nextToken().trim();
                try {
                    float topDepth = DepthUtils.convToM((float)Float.parseFloat(numberString), (char)readUnits);
                    numberString = tok.nextToken().trim();
                    float baseDepth = DepthUtils.convToM((float)Float.parseFloat(numberString), (char)readUnits);
                    int trnID = Integer.parseInt(tok.nextToken().trim());
                    this.addInterval(wsLiths, lithIntervals, topDepth, baseDepth, "", trnID);
                }
                catch (NumberFormatException e) {
                    System.out.println("Parse exception for line: " + buff + " : " + e.getMessage());
                }
                catch (SQLException e) {
                    System.out.println("SQL exception for line: " + buff + " : " + e.getMessage());
                }
                catch (SBException e) {
                    System.out.println("SB exception for line: " + buff + " : " + e.getMessage());
                }
            }
            buff = in.readLine();
        }
    }
}

