/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.ComboCellRenderer;
import jsbugs.DialogLogDef;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchSamples;
import jsbugs.table.ArrowCellRenderer;
import model3.LogDef;
import model3.SBdb;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogMatchLogdef
extends DialogMatch {
    private static final int COL_DONOR_ABR = 0;
    private static final int COL_DONOR_NAME = 1;
    private static final int COL_DONOR_UNITS = 2;
    private static final int COL_DONOR_STYLE = 3;
    private static final int COL_ARROW = 4;
    private static final int COL_HOST_ABR = 5;
    private static final int COL_HOST_NAME = 6;
    private static final int COL_HOST_UNITS = 7;
    private static final int COL_HOST_STYLE = 8;
    private static final String[] colTitles = new String[]{"Abr", "Name", "Units", "Style", "", "Abr", "Name", "Units", "Style"};
    private static final int[] colWidths = new int[]{20, 30, 30, 30, 20, 20, 30, 30, 30};
    private final List<LogDef> logDef = new ArrayList<LogDef>();
    private final JComboBox dbCombo = new JComboBox();
    private final SBdb db;

    public DialogMatchLogdef(Frame parent, boolean modal, SBdb ws, SBdb db, boolean inWizard) throws SQLException {
        super(parent, modal, inWizard);
        this.db = db;
        this.logDef.addAll(ws.getLogDefs());
        Collections.sort(this.logDef);
        this.init();
    }

    private void init() throws SQLException {
        this.fillCombo();
        this.matchAll();
        TableModelMatchLogdef model = new TableModelMatchLogdef(this);
        ActionListener addAction = new ActionListener(this){
            final /* synthetic */ DialogMatchLogdef this$0;
            {
                DialogMatchLogdef dialogMatchLogdef = this$0;
                Objects.requireNonNull(dialogMatchLogdef);
                this.this$0 = dialogMatchLogdef;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.add();
            }
        };
        super.init(model, "Match Wireline Log Headers", null, null, null, addAction, null, null, null, null, null);
        for (int i = 0; i < colTitles.length; ++i) {
            this.jTableMatch.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
            this.jTableMatch.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        this.jTableMatch.getColumnModel().getColumn(4).setMaxWidth(TableModelMatchSamples.colWidths[4]);
        this.jTableMatch.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        this.jTableMatch.getColumnModel().getColumn(5).setCellEditor(new DefaultCellEditor(this.dbCombo));
        this.jTableMatch.getColumnModel().getColumn(5).setCellRenderer(new ComboCellRenderer());
        SB.setTableHeaderBold((JTable)this.jTableMatch);
    }

    private void fillCombo() throws SQLException {
        this.dbCombo.removeAllItems();
        this.dbCombo.addItem("<None>");
        ArrayList<LogDef> logDefs = new ArrayList<LogDef>(this.db.getLogDefs());
        Collections.sort(logDefs);
        for (LogDef o : logDefs) {
            this.dbCombo.addItem(o);
        }
    }

    private void matchAll() throws SQLException {
        for (LogDef l : this.logDef) {
            if (l.getLink() != null) continue;
            l.setLink(this.db.getLogDef(l.getAbr()));
        }
    }

    private void add() {
        if (this.jTableMatch.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row from the table to add.", this.getTitle(), 1);
            return;
        }
        LogDef wsLD = this.logDef.get(this.getSeletedRows().get(0));
        if (wsLD.getLink() != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "This item is already linked!", this.getTitle(), 1);
            return;
        }
        LogDef copy = new LogDef(wsLD);
        DialogLogDef dialog = new DialogLogDef((Dialog)((Object)this), true, copy, null);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                LogDef dbDef = this.db.addLogDef(wsLD.getAbr(), wsLD.getTitle(), wsLD.getUnits(), wsLD.getMinval(), wsLD.getMaxval(), wsLD.isAsLog(), wsLD.getBackColour(), wsLD.getLineColour(), wsLD.getPenStyle(), wsLD.getTraceStyle(), wsLD.getPenWidth(), wsLD.getWrapTrace(), wsLD.getSymbol());
                this.db.commit();
                wsLD.setLink(dbDef);
                this.refreshSorter();
                this.fillCombo();
            }
            catch (SBPermissionException pe) {
                JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
            }
            catch (SQLException | SBException sql) {
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
            }
        }
    }

    @Override
    void OK() {
        if (this.inWizard) {
            for (LogDef ld : this.logDef) {
                if (ld.getLink() != null) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "You must match every item.", this.getTitle(), 2);
                return;
            }
        }
        super.OK();
    }

    private class TableModelMatchLogdef
    extends AbstractTableModel {
        final /* synthetic */ DialogMatchLogdef this$0;

        private TableModelMatchLogdef(DialogMatchLogdef dialogMatchLogdef) {
            DialogMatchLogdef dialogMatchLogdef2 = dialogMatchLogdef;
            Objects.requireNonNull(dialogMatchLogdef2);
            this.this$0 = dialogMatchLogdef2;
        }

        @Override
        public int getRowCount() {
            return this.this$0.logDef.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int row, int columnIndex) {
            if (this.this$0.logDef.isEmpty()) {
                return null;
            }
            LogDef l = this.this$0.logDef.get(row);
            switch (columnIndex) {
                case 0: {
                    return l.getAbr();
                }
                case 1: {
                    return l.getTitle();
                }
                case 2: {
                    return l.getUnits();
                }
                case 3: {
                    return l;
                }
                case 4: {
                    return l.getLink() != null;
                }
                case 5: {
                    return l.getLink() != null ? l.getLink().getAbr() : "<Select>";
                }
                case 6: {
                    return l.getLink() != null ? l.getLink().getTitle() : null;
                }
                case 7: {
                    return l.getLink() != null ? l.getLink().getUnits() : null;
                }
                case 8: {
                    return l.getLink();
                }
            }
            assert (false);
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            switch (columnIndex) {
                case 5: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                default: {
                    break;
                }
                case 5: {
                    this.this$0.logDef.get(row).setLink(obj instanceof LogDef ? (LogDef)obj : null);
                }
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 4: {
                    return Boolean.class;
                }
            }
            return String.class;
        }
    }
}

