/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchMarkers;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.ColourRenderer;
import jsbugs.table.DepthRenderer;
import jsbugs.table.DepthStatusRenderer;
import model3.Lastval;
import model3.SBdb;
import model3.SeismicMarker;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.DepthUnits;
import util.DepthUtils;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;
import util.status.DoubleStatus;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchMarkers
extends JDialog {
    WsWell well = null;
    SBdb sbdb;
    TableModelMatchMarkers model = new TableModelMatchMarkers();
    Image backgroundImage;
    WellInterp interp = null;
    WellInterp dbInterp = null;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMarkers;

    public DialogMatchMarkers(Frame parent, boolean modal, SBdb db, WsWell well, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.sbdb = db;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    public DialogMatchMarkers(JDialog parent, boolean modal, SBdb db, WsWell well, char units) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.well = well;
        this.sbdb = db;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Markers");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        SB.setTableHeaderBold((JTable)this.jTableMarkers);
        TableColumnModel columnModel = this.jTableMarkers.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchMarkers.COL_TITLES[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchMarkers.COL_WIDTHS[i]);
        }
        columnModel.getColumn(3).setMaxWidth(TableModelMatchMarkers.COL_WIDTHS[3]);
        this.model.init(this.well.getMarkers(), this.well.getLink() != null ? this.well.getLink().getMarkers() : null);
        this.jTableMarkers.setDefaultRenderer(SeismicMarker.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMarkers.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        DepthStatusRenderer dsr = new DepthStatusRenderer(2);
        dsr.setUnits(Character.valueOf(this.model.units));
        this.jTableMarkers.setDefaultRenderer(DoubleStatus.class, (TableCellRenderer)((Object)dsr));
        DepthRenderer dr = new DepthRenderer(2);
        dr.setUnits(Character.valueOf(this.model.units));
        this.jTableMarkers.setDefaultRenderer(Double.class, dr);
        this.jTableMarkers.setDefaultRenderer(Color.class, new ColourRenderer(true));
        this.jTableMarkers.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        this.jTableMarkers.setRowSorter(new TableRowSorter<TableModelMatchMarkers>(this.model));
        new ColumnSortResetHandler(this.jTableMarkers).attach();
        this.backgroundImage = DialogMatch.getBackgroundImage();
        this.jTableMarkers.getTableHeader().setReorderingAllowed(false);
    }

    public void load() {
        try {
            if (this.well.getMarkers().getSize() > 0 && JOptionPane.showConfirmDialog(this, "Clear workspace?", this.getTitle(), 0, 3) == 1) {
                return;
            }
            this.well.getMarkers().loadFromView(this.well.getLink().getDataModel(), this.well.getLink().getWellCode());
            this.well.updateMarkersStatus(true);
            this.model.init(this.well.getMarkers(), this.well.getLink() != null ? this.well.getLink().getMarkers() : null);
            this.model.fireTableDataChanged();
        }
        catch (Exception ex) {
            FrameJsbugs.showStackError(ex.toString(), ex, this.well.getLink() != null ? this.well.getLink().getDataModel() : null);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchMarkers this$0;
            {
                DialogMatchMarkers dialogMatchMarkers = this$0;
                Objects.requireNonNull(dialogMatchMarkers);
                this.this$0 = dialogMatchMarkers;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMarkers = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(480, 320));
        this.setModal(true);
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableMarkers.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMarkers);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchMarkers this$0;
            {
                DialogMatchMarkers dialogMatchMarkers = this$0;
                Objects.requireNonNull(dialogMatchMarkers);
                this.this$0 = dialogMatchMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchMarkers this$0;
            {
                DialogMatchMarkers dialogMatchMarkers = this$0;
                Objects.requireNonNull(dialogMatchMarkers);
                this.this$0 = dialogMatchMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchMarkers this$0;
            {
                DialogMatchMarkers dialogMatchMarkers = this$0;
                Objects.requireNonNull(dialogMatchMarkers);
                this.this$0 = dialogMatchMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Delete selected data from database");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchMarkers this$0;
            {
                DialogMatchMarkers dialogMatchMarkers = this$0;
                Objects.requireNonNull(dialogMatchMarkers);
                this.this$0 = dialogMatchMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save workspace data to database");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchMarkers this$0;
            {
                DialogMatchMarkers dialogMatchMarkers = this$0;
                Objects.requireNonNull(dialogMatchMarkers);
                this.this$0 = dialogMatchMarkers;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 208, Short.MAX_VALUE).add((Component)this.jLabel2)).add(2, (Component)this.jScrollPane1, -1, 387, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2, false).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonExclude, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE)).add(2, (Component)this.jButtonRead, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonSave, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).add(18, 18, 18).add((Component)this.jButtonRead).addPreferredGap(0).add((Component)this.jButtonSave).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 286, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteMarkers(true);
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteMarkers(false);
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "MRKCSV"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("xls");
        filter.addExtension("xlsx");
        filter.addExtension("csv");
        filter.setDescription("XLS/CSV Files");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (0 == jFileChooser.showOpenDialog(this)) {
            File csvFile = jFileChooser.getSelectedFile();
            try {
                this.openCSVfile(csvFile);
                Lastval.putString(this.sbdb, "MRKCSV", csvFile.getPath());
                this.sbdb.commit();
            }
            catch (SQLException sqle) {
                FrameJsbugs.showStackError("Error reading file", sqle, this.sbdb);
            }
            catch (GridReaderException ex) {
                FrameJsbugs.showStackError("Error reading file", (Exception)((Object)ex), this.sbdb);
            }
            catch (SBException ex) {
                FrameJsbugs.showStackError("Error reading file", (Exception)((Object)ex), this.sbdb);
            }
            catch (SBPermissionException ex) {
                FrameJsbugs.showStackError("Error reading file", (Exception)((Object)ex), this.sbdb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        SeismicMarker db;
        SeismicMarker ws;
        MatchData.MatchPair pair;
        int row;
        if (this.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        for (row = 0; row < this.model.data.size(); ++row) {
            pair = this.model.data.get(row);
            ws = (SeismicMarker)pair.getWs();
            db = (SeismicMarker)pair.getDb();
            if (ws == null || ws.getStatus() != SeismicMarker.CONFLICT) continue;
            JOptionPane.showMessageDialog(this, "Conflicting data in workspace", this.getTitle(), 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (row = 0; row < this.model.data.size(); ++row) {
                pair = this.model.data.get(row);
                ws = (SeismicMarker)pair.getWs();
                db = (SeismicMarker)pair.getDb();
                if (ws == null || ws.getStatus() != SeismicMarker.NOTSTORED) continue;
                this.well.getLink().addMarker(ws.getDepth(), ws.getName(), ws.getColour() == null ? Color.BLACK : ws.getColour());
                this.sbdb.commit();
            }
            this.well.getLink().getMarkers().store(this.well.getLink().getWellID());
        }
        catch (SBPermissionException e) {
            this.sbdb.doRollback();
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        try {
            this.well.updateMarkersStatus(true);
            this.model.init(this.well.getMarkers(), this.well.getLink() != null ? this.well.getLink().getMarkers() : null);
            this.model.fireTableDataChanged();
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void deleteMarkers(boolean fromDatabase) {
        block8: {
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMarkers.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMarkers.getSelectedRows();
            LinkedList<SeismicMarker> toRemove = new LinkedList<SeismicMarker>();
            for (int i : selected) {
                SeismicMarker marker = fromDatabase ? (SeismicMarker)this.model.data.get(this.jTableMarkers.convertRowIndexToModel(i)).getDb() : (SeismicMarker)this.model.data.get(this.jTableMarkers.convertRowIndexToModel(i)).getWs();
                if (marker == null) continue;
                toRemove.add(marker);
            }
            if (fromDatabase && toRemove.size() > 0) {
                Object msg = "Really delete ";
                msg = (String)msg + (String)(toRemove.size() == 1 ? "this marker" : "these " + toRemove.size() + " marker");
                if (JOptionPane.showConfirmDialog(this, msg = (String)msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) == 1) {
                    return;
                }
            }
            try {
                Well deleteFromWell = fromDatabase ? this.well.getLink() : this.well;
                deleteFromWell.deleteMarkers(toRemove);
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Markers " + text + ": " + toRemove.size(), this.getTitle(), 1);
                this.well.updateMarkersStatus(true);
                this.model.init(this.well.getMarkers(), this.well.getLink() != null ? this.well.getLink().getMarkers() : null);
                this.model.fireTableDataChanged();
                if (fromDatabase) {
                    deleteFromWell.getDataModel().commit();
                    deleteFromWell.notifyObservers();
                    deleteFromWell.getMarkers().notifyObservers();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block8;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openCSVfile(File csvFile) throws GridReaderException, SBException, SBPermissionException, SQLException {
        block16: {
            boolean COL_NAME = true;
            int COL_DEPTH = 2;
            int COL_UNITS = 3;
            String[] columnNames = new String[]{"pick_name", "name", "marker", "depth", "pick_depth", "units", "depth_unit"};
            int[] columnType = new int[]{1, 1, 1, 2, 2, 3, 3};
            boolean first = true;
            int[] cols = null;
            GridReader in = null;
            try {
                in = GridReader.getGridReader((String)csvFile.getPath(), null);
                while (in.nextRow()) {
                    String cell;
                    if (first) {
                        LinkedList<String> titles = new LinkedList<String>();
                        while ((cell = in.getNextCell()) != null) {
                            titles.add(cell);
                        }
                        cols = new int[titles.size()];
                        block9: for (int i = 0; i < cols.length; ++i) {
                            for (int j = 0; j < columnNames.length; ++j) {
                                if (!columnNames[j].equalsIgnoreCase((String)titles.get(i))) continue;
                                cols[i] = columnType[j];
                                continue block9;
                            }
                        }
                        first = false;
                        continue;
                    }
                    if (cols == null) {
                        throw new SBException("No column titles in first row of file/sheet");
                    }
                    int i = 0;
                    String name = "";
                    String cdepth = "";
                    String units = "";
                    while ((cell = in.getNextCell()) != null) {
                        if (i >= cols.length) {
                            System.out.println("Line for cell: " + cell + " Exceeds utitles length");
                            break;
                        }
                        switch (cols[i]) {
                            case 1: {
                                name = cell;
                                break;
                            }
                            case 2: {
                                cdepth = cell;
                                break;
                            }
                            case 3: {
                                units = cell;
                                break;
                            }
                        }
                        ++i;
                    }
                    DepthUnits du = DepthUnits.parseDepthUnitsFromString((String)units);
                    Double depth = DepthUtils.convToM((double)Double.parseDouble(cdepth), (char)du.getChar());
                    SeismicMarker marker = new SeismicMarker(depth, name, Color.BLACK);
                    this.well.getMarkers().add(marker);
                }
                if (in == null) break block16;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    in.close();
                }
                this.model.init(this.well.getMarkers(), this.well.getLink() != null ? this.well.getLink().getMarkers() : null);
                this.model.fireTableDataChanged();
                throw throwable;
            }
            in.close();
        }
        this.model.init(this.well.getMarkers(), this.well.getLink() != null ? this.well.getLink().getMarkers() : null);
        this.model.fireTableDataChanged();
    }
}

