/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.SampleRenderer;
import jsbugs.table.SampleStatusRenderer;
import model3.IGDIntervalEnv;
import model3.InterpHdr;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import util.MatchData;
import util.SB;
import util.SBException;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchPalaeoenvs
extends JDialog {
    TableModelMatchPalaeoenvs model = new TableModelMatchPalaeoenvs(this);
    WsWell well = null;
    Image backgroundImage;
    InterpHdr hdr;
    WellInterp wsInterp;
    WellInterp dbInterp;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonSave;
    private JButton jButtonSaveSelected;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchPalaeoenvs;

    public DialogMatchPalaeoenvs(Frame parent, boolean modal, WsWell well, char units, InterpHdr hdr) throws SBException, SQLException {
        super(parent, modal);
        this.well = well;
        this.hdr = hdr;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.setTitle("Match Palaeoenvironments");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        if (this.well.hasInterpLoaded(this.hdr.getInterpID())) {
            this.wsInterp = this.well.getInterp(this.hdr.getInterpID());
        }
        this.checkLinks();
        if (this.well.getLink() != null && this.hdr.getLink() != null && this.well.getLink().hasInterpLoaded(this.hdr.getInterpID())) {
            this.dbInterp = this.well.getLink().getInterp(this.hdr.getLink().getInterpID());
        }
        this.model.data.init(this.wsInterp != null ? this.wsInterp.getEnvs() : null, this.dbInterp != null ? this.dbInterp.getEnvs() : null);
        this.model.setUpTable(this.jTableMatchPalaeoenvs);
        this.jTableMatchPalaeoenvs.setRowSorter(new TableRowSorter<TableModelMatchPalaeoenvs>(this.model));
        new ColumnSortResetHandler(this.jTableMatchPalaeoenvs).attach();
        this.backgroundImage = DialogMatch.getBackgroundImage();
    }

    private void checkLinks() throws SBException, SQLException {
        if (this.well != null && this.well.getLink() != null) {
            for (IGDIntervalEnv env : this.wsInterp.getEnvs()) {
                if (this.well.getDataModel().getEnvScheme(env.getSchID()).getLink() != null) continue;
                throw new SBException("Cannot open dialog - Palaeoenvironment Schemes not Matched");
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchPalaeoenvs this$0;
            {
                DialogMatchPalaeoenvs dialogMatchPalaeoenvs = this$0;
                Objects.requireNonNull(dialogMatchPalaeoenvs);
                this.this$0 = dialogMatchPalaeoenvs;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchPalaeoenvs = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveSelected = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 250));
        this.setModal(true);
        this.jTableMatchPalaeoenvs.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchPalaeoenvs);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected sample from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchPalaeoenvs this$0;
            {
                DialogMatchPalaeoenvs dialogMatchPalaeoenvs = this$0;
                Objects.requireNonNull(dialogMatchPalaeoenvs);
                this.this$0 = dialogMatchPalaeoenvs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchPalaeoenvs this$0;
            {
                DialogMatchPalaeoenvs dialogMatchPalaeoenvs = this$0;
                Objects.requireNonNull(dialogMatchPalaeoenvs);
                this.this$0 = dialogMatchPalaeoenvs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchPalaeoenvs this$0;
            {
                DialogMatchPalaeoenvs dialogMatchPalaeoenvs = this$0;
                Objects.requireNonNull(dialogMatchPalaeoenvs);
                this.this$0 = dialogMatchPalaeoenvs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save new intervals from workspace into database");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchPalaeoenvs this$0;
            {
                DialogMatchPalaeoenvs dialogMatchPalaeoenvs = this$0;
                Objects.requireNonNull(dialogMatchPalaeoenvs);
                this.this$0 = dialogMatchPalaeoenvs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveSelected.setText("Save selected");
        this.jButtonSaveSelected.setToolTipText("Save new intervals from workspace into database");
        this.jButtonSaveSelected.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchPalaeoenvs this$0;
            {
                DialogMatchPalaeoenvs dialogMatchPalaeoenvs = this$0;
                Objects.requireNonNull(dialogMatchPalaeoenvs);
                this.this$0 = dialogMatchPalaeoenvs;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveSelectedActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 327, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 506, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveSelected, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 115, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 278, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteIntervals(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteIntervals(true);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        LinkedList<MatchData.MatchPair> selection = new LinkedList<MatchData.MatchPair>();
        for (int row = 0; row < this.model.data.size(); ++row) {
            selection.add(this.model.data.get(row));
        }
        this.saveSelection(selection);
    }

    private void jButtonSaveSelectedActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.jTableMatchPalaeoenvs.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Make a selection of rows to save", this.getTitle(), 2);
            return;
        }
        LinkedList<MatchData.MatchPair> selection = new LinkedList<MatchData.MatchPair>();
        for (int i = 0; i < selectedRows.length; ++i) {
            selection.add(this.model.data.get(this.jTableMatchPalaeoenvs.convertRowIndexToModel(selectedRows[i])));
        }
        this.saveSelection(selection);
    }

    /*
     * Exception decompiling
     */
    private void saveSelection(List<MatchData.MatchPair> selection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteIntervals(boolean fromDatabase) {
        block9: {
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchPalaeoenvs.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No intervals selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchPalaeoenvs.getSelectedRows();
            LinkedList<IGDIntervalEnv> toRemove = new LinkedList<IGDIntervalEnv>();
            for (int i : selected) {
                IGDIntervalEnv envInterval = fromDatabase ? (IGDIntervalEnv)this.model.data.get(this.jTableMatchPalaeoenvs.convertRowIndexToModel(i)).getDb() : (IGDIntervalEnv)this.model.data.get(this.jTableMatchPalaeoenvs.convertRowIndexToModel(i)).getWs();
                if (envInterval == null) continue;
                toRemove.add(envInterval);
            }
            if (fromDatabase && toRemove.size() > 0) {
                Object msg = "Really delete ";
                msg = (String)msg + (String)(toRemove.size() == 1 ? "this interval" : "these " + toRemove.size() + " interval");
                if (JOptionPane.showConfirmDialog(this, msg = (String)msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            try {
                Well deleteWell = fromDatabase ? this.well.getLink() : this.well;
                WellInterp deleteInterp = fromDatabase ? this.dbInterp : this.wsInterp;
                deleteInterp.deleteEnvs(toRemove, deleteWell.getWellID());
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Intervals " + text + ": " + toRemove.size(), this.getTitle(), 1);
                if (fromDatabase) {
                    deleteWell.getDataModel().commit();
                    deleteInterp.notifyObservers(5);
                } else {
                    this.well.updateEnvStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
                }
                this.model.data.init(this.wsInterp != null ? this.wsInterp.getEnvs() : null, this.dbInterp != null ? this.dbInterp.getEnvs() : null);
                this.model.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block9;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }

    class TableModelMatchPalaeoenvs
    extends AbstractTableModel {
        static final int COL_DONOR_TOP = 0;
        static final int COL_DONOR_BASE = 1;
        static final int COL_DONOR_ENV = 2;
        static final int COL_CONFLICT = 3;
        static final int COL_ARROW = 4;
        static final int COL_HOST_TOP = 5;
        static final int COL_HOST_BASE = 6;
        static final int COL_HOST_ENV = 7;
        String[] colTitles;
        int[] colWidths;
        char units;
        MatchData data;
        final /* synthetic */ DialogMatchPalaeoenvs this$0;

        TableModelMatchPalaeoenvs(DialogMatchPalaeoenvs this$0) {
            DialogMatchPalaeoenvs dialogMatchPalaeoenvs = this$0;
            Objects.requireNonNull(dialogMatchPalaeoenvs);
            this.this$0 = dialogMatchPalaeoenvs;
            this.colTitles = new String[]{"Top", "Base", "Environment", "Conflict", "", "Top", "Base", "Environment"};
            this.colWidths = new int[]{30, 30, 100, 100, 20, 30, 30, 100};
            this.units = (char)77;
            this.data = new MatchData();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MatchData.MatchPair pair = this.data.get(rowIndex);
            if (pair == null) {
                return "";
            }
            IGDIntervalEnv ws = (IGDIntervalEnv)pair.getWs();
            IGDIntervalEnv db = (IGDIntervalEnv)pair.getDb();
            try {
                switch (columnIndex) {
                    case 0: {
                        return ws != null ? ws.getTopSample() : null;
                    }
                    case 1: {
                        return ws != null ? ws.getBaseSample() : null;
                    }
                    case 2: {
                        return ws != null ? new StringStatus(ws.toString(), ws.getStatus()) : null;
                    }
                    case 3: {
                        return ws != null ? new StringStatus(ws.getConflictReason(), ws.getStatus()) : null;
                    }
                    case 4: {
                        return ws != null && db != null && ws.getStatus() == Sample.STORED;
                    }
                    case 5: {
                        return db != null ? db.getTopSample() : null;
                    }
                    case 6: {
                        return db != null ? db.getBaseSample() : null;
                    }
                    case 7: {
                        return db != null ? db.toString() : null;
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: {
                    return Sample.class;
                }
                case 2: 
                case 3: {
                    return StringStatus.class;
                }
                case 4: {
                    return Boolean.class;
                }
                case 5: 
                case 6: {
                    return Sample.class;
                }
            }
            return String.class;
        }

        void setUpTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(this.colWidths[i]);
            }
            columnModel.getColumn(4).setMaxWidth(this.colWidths[4]);
            columnModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)new SampleStatusRenderer(this.units)));
            columnModel.getColumn(1).setCellRenderer((TableCellRenderer)((Object)new SampleStatusRenderer(this.units)));
            columnModel.getColumn(5).setCellRenderer(new SampleRenderer(this.units));
            columnModel.getColumn(6).setCellRenderer(new SampleRenderer(this.units));
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
            table.getTableHeader().setReorderingAllowed(false);
        }
    }
}

