/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.DialogMatchLithology;
import jsbugs.DialogSampleLithologyImport;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.SampleRenderer;
import jsbugs.table.SampleStatusRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Lastval;
import model3.SBdb;
import model3.Sample;
import model3.SampleLithology;
import model3.Well;
import model3.WsLithology;
import model3.WsWell;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchSampleLithology
extends JDialog {
    TableModelMatchSampleLithology model = new TableModelMatchSampleLithology(this);
    Image backgroundImage;
    WsWell well;
    SBdb db;
    SBdb ws;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchLith;

    public DialogMatchSampleLithology(Frame parent, boolean modal, WsWell well, SBdb db, SBdb ws, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.db = db;
        this.ws = ws;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Sample Lithology");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.backgroundImage = DialogMatch.getBackgroundImage();
        this.initData();
        this.model.setupTable(this.jTableMatchLith);
        this.jTableMatchLith.setRowSorter(new TableRowSorter<TableModelMatchSampleLithology>(this.model));
        new ColumnSortResetHandler(this.jTableMatchLith).attach();
    }

    private void initData() throws SBException, SQLException {
        LinkedList<Sample> lithSamples = new LinkedList<Sample>();
        for (Sample sample : this.well.getSamples()) {
            if (sample.getLithology() == null || sample.getLithology().getLithology().size() <= 0) continue;
            lithSamples.add(sample);
        }
        LinkedList<Sample> dbSamples = null;
        if (this.well.getLink() != null) {
            dbSamples = new LinkedList<Sample>();
            for (Sample samp : this.well.getLink().getSamples()) {
                dbSamples.add(samp);
            }
            LinkedList<Sample> linkedList = new LinkedList<Sample>();
            for (Sample dbSample : dbSamples) {
                if (dbSample.getLithology() != null && !dbSample.getLithology().getLithology().isEmpty()) continue;
                boolean found = false;
                for (Sample s : lithSamples) {
                    if (dbSample.compareTo(s) != 0) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                linkedList.add(dbSample);
            }
            for (Sample remove : linkedList) {
                dbSamples.remove(remove);
            }
        }
        this.model.data.init(lithSamples, dbSamples);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchSampleLithology this$0;
            {
                DialogMatchSampleLithology dialogMatchSampleLithology = this$0;
                Objects.requireNonNull(dialogMatchSampleLithology);
                this.this$0 = dialogMatchSampleLithology;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchLith = new JTable();
        this.jButtonDelete = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonClose = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonRead = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.jTableMatchLith.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchLith);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSampleLithology this$0;
            {
                DialogMatchSampleLithology dialogMatchSampleLithology = this$0;
                Objects.requireNonNull(dialogMatchSampleLithology);
                this.this$0 = dialogMatchSampleLithology;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSampleLithology this$0;
            {
                DialogMatchSampleLithology dialogMatchSampleLithology = this$0;
                Objects.requireNonNull(dialogMatchSampleLithology);
                this.this$0 = dialogMatchSampleLithology;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSampleLithology this$0;
            {
                DialogMatchSampleLithology dialogMatchSampleLithology = this$0;
                Objects.requireNonNull(dialogMatchSampleLithology);
                this.this$0 = dialogMatchSampleLithology;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSampleLithology this$0;
            {
                DialogMatchSampleLithology dialogMatchSampleLithology = this$0;
                Objects.requireNonNull(dialogMatchSampleLithology);
                this.this$0 = dialogMatchSampleLithology;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonReadActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 238, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 417, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonExclude, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRead, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 219, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 347, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteLithology(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteLithology(true);
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        this.read();
    }

    private void deleteLithology(boolean fromDatabase) {
        block8: {
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchLith.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "Select rows to " + (fromDatabase ? "delete" : "exclude"), this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchLith.getSelectedRows();
            LinkedList<Sample> toRemove = new LinkedList<Sample>();
            for (int i : selected) {
                Sample sample = fromDatabase ? (Sample)this.model.data.get(this.jTableMatchLith.convertRowIndexToModel(i)).getDb() : (Sample)this.model.data.get(this.jTableMatchLith.convertRowIndexToModel(i)).getWs();
                if (sample == null) continue;
                toRemove.add(sample);
            }
            if (fromDatabase && toRemove.size() > 0 && JOptionPane.showConfirmDialog(this, "Really delete " + (String)(toRemove.size() == 1 ? "this" : "these " + toRemove.size()) + (toRemove.size() == 1 ? " sample lithology?" : " sample lithologies?"), this.getTitle(), 0, 3) == 1) {
                return;
            }
            try {
                int nSamples = 0;
                Well deleteWell = fromDatabase ? this.well.getLink() : this.well;
                for (Sample sample : toRemove) {
                    sample.deleteLithology(deleteWell.getWellID());
                    ++nSamples;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Sample lithologies " + text + ": " + nSamples, this.getTitle(), 1);
                this.well.updateSampleLithologyStatus(true);
                this.initData();
                this.model.fireTableDataChanged();
                if (fromDatabase) {
                    deleteWell.getDataModel().commit();
                    deleteWell.setDataChanged();
                    deleteWell.notifyObservers(toRemove.get(0));
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error excluding samples: " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block8;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }

    private void read() {
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.db, "SAMPLITHFL"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            try {
                Lastval.putString(this.db, "SAMPLITHFL", fileName);
                this.db.commit();
                LinkedList<WsLithology> wsLiths = new LinkedList<WsLithology>();
                LinkedList<Sample.Builder> samples = new LinkedList<Sample.Builder>();
                DialogSampleLithologyImport importDialog = new DialogSampleLithologyImport((Dialog)this, true, this.well, fileName.toLowerCase().endsWith(".las"));
                importDialog.setLocationRelativeTo(this);
                importDialog.setVisible(true);
                if (importDialog.isOK) {
                    if (fileName.toLowerCase().endsWith(".las")) {
                        SampleLithology.readLAS(fileName, this.ws, this.well, wsLiths, samples, importDialog.interval, this.db.useSampleTops(), importDialog.type);
                    } else {
                        SampleLithology.readFile(fileName, this.ws, this.well, wsLiths, samples, importDialog.singleDepth, importDialog.interval, importDialog.units, this.db.useSampleTops(), importDialog.type);
                    }
                } else {
                    return;
                }
                DialogMatchLithology dialog = new DialogMatchLithology((Dialog)this, true, wsLiths, this.db);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    for (Sample.Builder sample : samples) {
                        sample.sampleLithology.discardUnmatched();
                        if (sample.sampleLithology.getLithology().isEmpty()) continue;
                        Sample existing = this.well.getSample(sample);
                        if (existing == null) {
                            this.well.addSample(sample, 0, null);
                            continue;
                        }
                        existing.copyLithology(sample.sampleLithology);
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                }
                this.well.updateSampleStatus(true);
                this.well.updateSampleLithologyStatus(true);
                this.initData();
                this.model.fireTableDataChanged();
            }
            catch (IOException | SQLException | SBException | SBPermissionException ex) {
                SbugsExceptionHandler.showStackError(ex, this);
            }
        }
    }

    class TableModelMatchSampleLithology
    extends AbstractTableModel {
        static final int COL_WS_SAMP = 0;
        static final int COL_WS_LITH = 1;
        static final int COL_ARROW = 2;
        static final int COL_DB_SAMP = 3;
        static final int COL_DB_LITH = 4;
        final String[] colTitles;
        final int[] colWidths;
        char units;
        MatchData data;
        final /* synthetic */ DialogMatchSampleLithology this$0;

        TableModelMatchSampleLithology(DialogMatchSampleLithology this$0) {
            DialogMatchSampleLithology dialogMatchSampleLithology = this$0;
            Objects.requireNonNull(dialogMatchSampleLithology);
            this.this$0 = dialogMatchSampleLithology;
            this.colTitles = new String[]{"Sample", "Lithology", "", "Sample", "Lithology"};
            this.colWidths = new int[]{15, 80, 20, 15, 80};
            this.units = (char)77;
            this.data = new MatchData();
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            MatchData.MatchPair pair = this.data.get(row);
            if (pair == null) {
                return "";
            }
            Sample ws = (Sample)pair.getWs();
            Sample db = (Sample)pair.getDb();
            switch (col) {
                case 0: {
                    return ws;
                }
                case 1: {
                    return ws == null ? null : new StringStatus(ws.getLithology().toString(), db != null && db.getLithology() != null && !db.getLithology().getLithology().isEmpty() ? ws.getLithology().getStatus(db.getLithology()) : Sample.NOTSTORED);
                }
                case 2: {
                    return ws != null && db != null && ws.getStatus() == Sample.STORED;
                }
                case 3: {
                    return db;
                }
                case 4: {
                    return db == null || db.getLithology() == null || db.getLithology().getLithology().isEmpty() ? null : new StringStatus(db.getLithology().toString(), Sample.STORED);
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Sample.class;
                }
                case 1: {
                    return StringStatus.class;
                }
                case 3: {
                    return Sample.class;
                }
                case 4: {
                    return StringStatus.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        void setupTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < this.this$0.model.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
                columnModel.getColumn(i).setWidth(this.colWidths[i]);
            }
            columnModel.getColumn(2).setMaxWidth(this.colWidths[2]);
            SampleStatusRenderer ssr = new SampleStatusRenderer(this.units);
            ssr.setShowLabels(true);
            ssr.setShowUnits(true);
            columnModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)ssr));
            SampleRenderer sr = new SampleRenderer(this.units);
            sr.setShowLabels(true);
            sr.setShowUnits(true);
            columnModel.getColumn(3).setCellRenderer(sr);
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
            table.getTableHeader().setReorderingAllowed(false);
        }
    }
}

