/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchSamples;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.DepthRenderer;
import jsbugs.table.DepthStatusRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import model3.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.MatchData;
import util.SBException;
import util.SBPermissionException;
import util.status.DoubleStatus;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchSamples
extends JDialog {
    TableModelMatchSamples model = new TableModelMatchSamples();
    WsWell well;
    Image backgroundImage;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonDeleteLabels;
    private JButton jButtonExclude;
    private JButton jButtonExcludeBases;
    private JButton jButtonExcludeLabels;
    private JButton jButtonExcludeTops;
    private JButton jButtonHelp;
    private JButton jButtonMoveBase;
    private JButton jButtonMoveTops;
    private JButton jButtonSave;
    private JButton jButtonSaveBases;
    private JButton jButtonSaveTops;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchSamples;

    public DialogMatchSamples(Frame parent, boolean modal, WsWell well, char units) throws SBException, SQLException {
        super(parent, modal);
        this.well = well;
        this.model.units = units;
        this.model.wellType = well.getType();
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.setTitle("Match Samples: " + String.valueOf(this.well));
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.model.data.init(this.well.getSamples(), this.well.getLink() != null ? this.well.getLink().getSamples() : null);
        TableUtils.setTableHeaderBold((JTable)this.jTableMatchSamples);
        TableColumnModel columnModel = this.jTableMatchSamples.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchSamples.colTitles[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchSamples.colWidths[i]);
        }
        columnModel.getColumn(4).setMaxWidth(TableModelMatchSamples.colWidths[4]);
        int dps = this.model.units == 'F' ? 2 : 3;
        columnModel.getColumn(5).setCellRenderer(new DepthRenderer(dps));
        columnModel.getColumn(6).setCellRenderer(new DepthRenderer(dps));
        this.jTableMatchSamples.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchSamples.setDefaultRenderer(DoubleStatus.class, (TableCellRenderer)((Object)new DepthStatusRenderer(this.model.units == 'F' ? 2 : 3)));
        this.jTableMatchSamples.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        this.jTableMatchSamples.setRowSorter(new TableRowSorter<TableModelMatchSamples>(this.model));
        new ColumnSortResetHandler(this.jTableMatchSamples).attach();
        this.backgroundImage = DialogMatch.getBackgroundImage();
        this.jTableMatchSamples.getTableHeader().setReorderingAllowed(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchSamples = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonExcludeLabels = new JButton();
        this.jButtonDeleteLabels = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonExcludeTops = new JButton();
        this.jButtonSaveTops = new JButton();
        this.jButtonMoveTops = new JButton();
        this.jPanel4 = new JPanel();
        this.jButtonExcludeBases = new JButton();
        this.jButtonSaveBases = new JButton();
        this.jButtonMoveBase = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 485));
        this.setModal(true);
        this.jTableMatchSamples.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchSamples);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected samples from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected samples from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save ALL unsaved samples in database");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Labels", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jButtonExcludeLabels.setText("Exclude");
        this.jButtonExcludeLabels.setToolTipText("Exclude selected sample labels from workspace");
        this.jButtonExcludeLabels.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonExcludeLabels.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeLabelsActionPerformed(evt);
            }
        });
        this.jButtonDeleteLabels.setText("Delete");
        this.jButtonDeleteLabels.setToolTipText("Delete selected sample labels from database");
        this.jButtonDeleteLabels.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteLabelsActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jButtonExcludeLabels, -2, 0, Short.MAX_VALUE).add(2, (Component)this.jButtonDeleteLabels, -1, -1, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonExcludeLabels).addPreferredGap(0).add((Component)this.jButtonDeleteLabels)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Top depths", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jButtonExcludeTops.setText("Exclude");
        this.jButtonExcludeTops.setToolTipText("Exclude selected workspace depths (only where base depths exist)");
        this.jButtonExcludeTops.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeTopsActionPerformed(evt);
            }
        });
        this.jButtonSaveTops.setText("Save");
        this.jButtonSaveTops.setToolTipText("Save top depths into data from samples with matching base depth and type");
        this.jButtonSaveTops.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveTopsActionPerformed(evt);
            }
        });
        this.jButtonMoveTops.setText("Move to base");
        this.jButtonMoveTops.setToolTipText("Move selected sample top depths to base depth");
        this.jButtonMoveTops.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveTopsActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(2).add(1, (Component)this.jButtonExcludeTops, -2, 0, Short.MAX_VALUE).add((Component)this.jButtonSaveTops, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMoveTops, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jButtonExcludeTops).addPreferredGap(0).add((Component)this.jButtonSaveTops).addPreferredGap(0).add((Component)this.jButtonMoveTops).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Base depths", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jButtonExcludeBases.setText("Exclude");
        this.jButtonExcludeBases.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeBasesActionPerformed(evt);
            }
        });
        this.jButtonSaveBases.setText("Save");
        this.jButtonSaveBases.setToolTipText("Save base depths into data from samples with matching top depth and type");
        this.jButtonSaveBases.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveBasesActionPerformed(evt);
            }
        });
        this.jButtonMoveBase.setText("Move to tops");
        this.jButtonMoveBase.setToolTipText("Move selected base depths to top depth");
        this.jButtonMoveBase.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveBaseActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jButtonExcludeBases, -2, 0, Short.MAX_VALUE).add((Component)this.jButtonSaveBases, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMoveBase, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jButtonExcludeBases).addPreferredGap(0).add((Component)this.jButtonSaveBases).addPreferredGap(0).add((Component)this.jButtonMoveBase).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchSamples this$0;
            {
                DialogMatchSamples dialogMatchSamples = this$0;
                Objects.requireNonNull(dialogMatchSamples);
                this.this$0 = dialogMatchSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 301, Short.MAX_VALUE).add((Component)this.jLabel2)).add((Component)this.jScrollPane1, -1, 459, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jPanel4, 0, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonSave, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonExclude, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonSave).add(13, 13, 13).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add(48, 48, 48).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.delete(false, true);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.delete(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        try {
            Statement stmt = null;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int row = 0; row < this.model.data.size(); ++row) {
                MatchData.MatchPair pair = this.model.data.get(row);
                Sample ws = (Sample)pair.getWs();
                Sample db = (Sample)pair.getDb();
                if (db == null) {
                    if (stmt == null) {
                        stmt = this.well.getLink().getDataModel().getDatabase().createStatement();
                    }
                    this.well.getLink().addSampleCopy(stmt, ws);
                    continue;
                }
                if (ws == null || ws.getStatus() != Sample.PARTSTORED) continue;
                db.update(this.well.getLink(), ws);
                this.well.getLink().setDataChanged();
            }
            if (stmt != null) {
                stmt.close();
            }
            this.model.data.init(this.well.getSamples(), this.well.getLink().getSamples());
            this.model.fireTableDataChanged();
            this.well.getLink().getDataModel().commit();
            this.well.getLink().notifyObservers(Sample.class);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error saving samples: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            this.well.getLink().getDataModel().doRollback();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonExcludeLabelsActionPerformed(ActionEvent evt) {
        this.delete(false, false);
    }

    private void jButtonDeleteLabelsActionPerformed(ActionEvent evt) {
        this.delete(true, false);
    }

    private void jButtonExcludeTopsActionPerformed(ActionEvent evt) {
        this.excludeDepth(true);
    }

    private void jButtonExcludeBasesActionPerformed(ActionEvent evt) {
        this.excludeDepth(false);
    }

    private void jButtonSaveTopsActionPerformed(ActionEvent evt) {
        this.saveDepth(true);
    }

    private void jButtonSaveBasesActionPerformed(ActionEvent evt) {
        this.saveDepth(false);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchsamples.html");
    }

    private void jButtonMoveTopsActionPerformed(ActionEvent evt) {
        this.moveDepth(true);
    }

    private void jButtonMoveBaseActionPerformed(ActionEvent evt) {
        this.moveDepth(false);
    }

    private void excludeDepth(boolean top) {
        if (this.jTableMatchSamples.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No samples selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchSamples.getSelectedRows();
        try {
            for (int i : selected) {
                Sample sample = (Sample)this.model.data.get(this.jTableMatchSamples.convertRowIndexToModel(i)).getWs();
                if (sample == null) continue;
                if (top && sample.getBaseDepth() != null) {
                    sample.setDepth(null, sample.getBaseDepth(), this.well.getWellUnits());
                    continue;
                }
                if (top || sample.getTopDepth() == null) continue;
                sample.setDepth(sample.getTopDepth(), null, this.well.getWellUnits());
            }
            this.well.updateSampleStatus(false);
            this.model.data.init(this.well.getSamples(), this.well.getLink() != null ? this.well.getLink().getSamples() : null);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError("Error excluding depths", ex, this);
        }
    }

    private void saveDepth(boolean saveTop) {
        if (this.jTableMatchSamples.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No samples selected", this.getTitle(), 2);
            return;
        }
        if (this.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "Wells not linked", this.getTitle(), 2);
            return;
        }
        try {
            if (this.well.getLink().getSamples().isEmpty()) {
                JOptionPane.showMessageDialog(this, "No samples in linked well", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchSamples.getSelectedRows();
            LinkedHashMap<Sample, Double> toUpdate = new LinkedHashMap<Sample, Double>();
            for (int i : selected) {
                Sample sample = (Sample)this.model.data.get(this.jTableMatchSamples.convertRowIndexToModel(i)).getWs();
                if (sample == null || (!saveTop || sample.getTopDepth() == null) && (saveTop || sample.getBaseDepth() == null)) continue;
                for (Sample s : this.well.getLink().getSamples()) {
                    if (saveTop && s.getTopDepth() == null && sample.getType() == s.getType() && Math.abs(sample.getBaseDepth() - s.getBaseDepth()) < (double)0.0029f) {
                        toUpdate.put(s, sample.getTopDepth());
                        continue;
                    }
                    if (saveTop || s.getBaseDepth() != null || sample.getType() != s.getType() || !(Math.abs(sample.getTopDepth() - s.getTopDepth()) < (double)0.0029f)) continue;
                    toUpdate.put(s, sample.getBaseDepth());
                }
            }
            for (Map.Entry e : ((HashMap)toUpdate).entrySet()) {
                Sample samp = (Sample)e.getKey();
                Double d = (Double)e.getValue();
                Sample.Builder builder = Sample.Builder.copyOf(samp);
                if (saveTop) {
                    builder.topDepth(d);
                    this.well.getLink().updateSample(samp, builder);
                    continue;
                }
                builder.baseDepth(d);
                this.well.getLink().updateSample(samp, builder);
            }
            if (!toUpdate.isEmpty()) {
                this.well.getLink().getDataModel().commit();
                this.model.data.init(this.well.getSamples(), this.well.getLink() != null ? this.well.getLink().getSamples() : null);
                this.well.updateSampleStatus(false);
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError("Error saving depths", ex, this);
        }
    }

    private void moveDepth(boolean moveTop) {
        if (this.jTableMatchSamples.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No samples selected", this.getTitle(), 2);
            return;
        }
        try {
            int[] selected = this.jTableMatchSamples.getSelectedRows();
            boolean depthSet = false;
            for (int i : selected) {
                Sample sample = (Sample)this.model.data.get(this.jTableMatchSamples.convertRowIndexToModel(i)).getWs();
                if (sample == null) continue;
                if (moveTop && sample.getTopDepth() != null && sample.getBaseDepth() == null) {
                    sample.setDepth(null, sample.getTopDepth(), sample.displayUnits);
                    depthSet = true;
                    continue;
                }
                if (moveTop || sample.getBaseDepth() == null || sample.getTopDepth() != null) continue;
                sample.setDepth(sample.getBaseDepth(), null, sample.displayUnits);
                depthSet = true;
            }
            if (depthSet) {
                this.model.data.init(this.well.getSamples(), this.well.getLink() != null ? this.well.getLink().getSamples() : null);
                this.well.updateSampleStatus(false);
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError("Error saving depths", ex, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(boolean fromDatabase, boolean samples) {
        String strg;
        if (fromDatabase && this.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatchSamples.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No samples selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchSamples.getSelectedRows();
        LinkedList<Sample> toRemove = new LinkedList<Sample>();
        for (int i : selected) {
            Sample sample = fromDatabase ? (Sample)this.model.data.get(this.jTableMatchSamples.convertRowIndexToModel(i)).getDb() : (Sample)this.model.data.get(this.jTableMatchSamples.convertRowIndexToModel(i)).getWs();
            if (sample == null) continue;
            toRemove.add(sample);
        }
        if (toRemove.size() == 0) {
            return;
        }
        if (fromDatabase && JOptionPane.showConfirmDialog(this, strg = "Really delete " + (String)(toRemove.size() == 1 ? "this " : "these " + toRemove.size() + " ") + (samples ? "sample" : "sample label") + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (samples) {
                this.deleteSamples(fromDatabase, toRemove);
            } else {
                this.deleteLabels(fromDatabase, toRemove);
            }
            this.model.data.init(this.well.getSamples(), this.well.getLink() != null ? this.well.getLink().getSamples() : null);
            this.model.fireTableDataChanged();
            if (fromDatabase) {
                this.well.getLink().getDataModel().commit();
                this.well.getLink().notifyObservers(Sample.class);
            } else {
                this.well.updateSampleStatus(true);
            }
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this, "Error excluding samples: " + sbe.getMessage(), this.getTitle(), 0);
            sbe.printStackTrace();
            if (fromDatabase) {
                this.well.getLink().getDataModel().doRollback();
            }
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(this, "SQL Error excluding samples: " + sqle.getMessage(), this.getTitle(), 0);
            sqle.printStackTrace();
            if (fromDatabase) {
                this.well.getLink().getDataModel().doRollback();
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void deleteLabels(boolean fromDatabase, LinkedList<Sample> toRemove) throws SBException, SQLException {
        for (Sample sample : toRemove) {
            Well w = fromDatabase ? this.well.getLink() : this.well;
            w.updateSample(sample, Sample.Builder.copyOf(sample).label(""));
        }
    }

    private void deleteSamples(boolean fromDatabase, LinkedList<Sample> toRemove) throws SBException, SQLException {
        String text;
        int nSamples = 0;
        Well deleteWell = fromDatabase ? this.well.getLink() : this.well;
        Boolean deleteAnalyses = null;
        LinkedList<Sample> reallyRemove = new LinkedList<Sample>();
        for (Sample sample : toRemove) {
            boolean hasIGD = false;
            boolean hasAnalyses = false;
            Iterator<Smpdtl> iterator = sample.getSmpdtls().iterator();
            if (iterator.hasNext()) {
                Smpdtl dtl = iterator.next();
                if (deleteAnalyses == null) {
                    int opt;
                    deleteAnalyses = !fromDatabase ? Boolean.valueOf((opt = JOptionPane.showConfirmDialog(this, "Do you want to exclude linked analysis data?", this.getTitle(), 0)) == 0) : Boolean.valueOf(false);
                }
                if (deleteAnalyses.booleanValue()) {
                    sample.deleteDtl(deleteWell.getWellID(), dtl.getAnalyID(), dtl);
                    deleteWell.setDataChanged();
                    hasAnalyses = false;
                } else {
                    hasAnalyses = true;
                }
            }
            if (!hasAnalyses && deleteWell.hasSampleIGD(sample) > 0) {
                hasIGD = true;
            }
            if (hasAnalyses || hasIGD) continue;
            reallyRemove.add(sample);
            ++nSamples;
        }
        try {
            deleteWell.deleteSamples(reallyRemove);
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
            return;
        }
        String string = text = fromDatabase ? "deleted" : "excluded";
        if (toRemove.size() - nSamples > 0) {
            JOptionPane.showMessageDialog(this, "Not all samples " + text + " (" + nSamples + "/" + toRemove.size() + "): linked interpreted or analysis data", this.getTitle(), 2);
        } else {
            JOptionPane.showMessageDialog(this, "Samples " + text + ": " + nSamples, this.getTitle(), 1);
        }
    }
}

