/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonComparator;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.ws.LinkedWorkspace;
import com.stratadata.util.process.AbstractMultiStageProcess;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbchart.core.ChartManager;
import jsbugs.DialogMatch;
import jsbugs.DialogMatchCategories;
import jsbugs.DialogMatchTaxaEdit;
import jsbugs.DialogSelectTaxa;
import jsbugs.DialogSource;
import jsbugs.FrameOrganiser;
import jsbugs.FrameTaxaDB;
import jsbugs.WebSearch;
import jsbugs.imagegallery.DialogTaxonImages;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.table.ImageIconRenderer;
import jsbugs.table.TaxonNameRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.webservices.DialogConfigureWebCitationServices;
import jsbugs.webservices.WebCitationService;
import model3.SBEvent;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Source;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.Well;
import model3.exception.SuppressedSQLException;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import util.ImageUtils;
import util.SBException;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchTaxa
extends JDialog {
    private static final int COL_DONCAT = 0;
    private static final int COL_DONOR = 1;
    private static final int COL_OCCS = 2;
    private static final int COL_OCC_IMAGES = 3;
    private static final int COL_REF = 4;
    private static final int COL_ARROW = 5;
    private static final int COL_HOSTCAT = 6;
    private static final int COL_HOST = 7;
    private static final int COL_PREF = 8;
    private static final int COL_ALPHA = 9;
    private static final int COL_OCC_TYPE = 10;
    private static final int COL_IMAGES = 11;
    private static final String[] colTitles = new String[]{"Cat.", "Taxon", "Occurrences", "Image?", "Reference", "", "Cat.", "Matched taxon", "Preferred name", "Alpha.Code", "Type", "Image?"};
    private static final int[] colWidths = new int[]{20, 130, 10, 10, 0, 20, 20, 130, 50, 30, 30, 10};
    private static final int MAXLIST = 7;
    private static final int L_EV = 4;
    private static final int L_GRP = 5;
    private static final int L_CHT = 6;
    private static final String[] PRGSTRG = new String[]{Discipline.values()[0].getAbr(true), Discipline.values()[1].getAbr(true), Discipline.values()[2].getAbr(true), Discipline.values()[3].getAbr(true), "Events", "Groups", "Charts"};
    private final JProgressBar[] pBars = new JProgressBar[7];
    private final JRadioButton[] pButts = new JRadioButton[7];
    private ButtonGroup buttonGroupDiscipline = new ButtonGroup();
    private boolean isOK;
    private int selectedIndex = 0;
    private int synSch = 0;
    private final TableModelMatchTaxa model = new TableModelMatchTaxa(this);
    private final SBdb ws;
    private final SBdb db;
    private final LinkedWorkspace linkedWorkspace;
    private final ChartManager wsCM;
    private Source source;
    private final JComboBox<String> jComboBoxOccType = new JComboBox();
    private Image backgroundImage;
    private boolean askDataSource = true;
    private final boolean inWizard;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchTaxa;
    private JPanel jPanelProgress;
    private JRadioButton radioButton1;
    private JProgressBar progressBar1;
    private JPanel jPanel5;
    private JPanel jPanelDataSource;
    private JTextField jTextFieldSource;
    private JButton jButtonLoad;
    private JButton jButtonSelectSource;
    private JLabel jLabelSynonymScheme;
    private JButton jButtonCategories;
    private JButton jButtonMatchAll;
    private JButton jButtonClean;
    private JButton jButtonCodes;
    private JButton jButtonEdit;
    private JButton jButtonWebRefs;
    private JButton jButtonWebLookup;
    private JButton jButtonExclude;
    private JButton jButtonAddAll;
    private JButton jButtonSwitchPrefs;
    private JButton jButtonWrite;
    private JButton jButtonHelp;
    private JSeparator jSeparator2;
    private JButton jButtonOK;

    public DialogMatchTaxa(Frame parent, boolean modal, SBdb ws, ChartManager wsCm, SBdb db, boolean inWizard) throws SQLException, SBException {
        super(parent, modal);
        this.ws = ws;
        this.wsCM = wsCm;
        this.db = db;
        this.linkedWorkspace = null;
        this.inWizard = inWizard;
        this.setTitle("Match Taxa");
        this.model.init();
        this.initComponents();
        this.init();
    }

    public DialogMatchTaxa(Frame parent, boolean modal, LinkedWorkspace linkedWorkspace, boolean inWizard) throws SQLException {
        super(parent, modal);
        this.linkedWorkspace = linkedWorkspace;
        this.ws = linkedWorkspace.sourceModel;
        this.db = linkedWorkspace.targetModel;
        this.wsCM = null;
        this.inWizard = inWizard;
        this.setTitle("Match Taxa");
        this.model.init();
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.getRootPane().setDefaultButton(this.jButtonMatchAll);
        this.jButtonOK.setText(this.inWizard ? "Continue" : "Close");
        this.model.setupTable(this.jTableMatchTaxa);
        TableRowSorter<TableModelMatchTaxa> rowSorter = new TableRowSorter<TableModelMatchTaxa>(this.model);
        this.jTableMatchTaxa.setRowSorter(rowSorter);
        rowSorter.setComparator(7, (Comparator<?>)TaxonComparator.compareGenus());
        rowSorter.setComparator(1, (Comparator<?>)TaxonComparator.compareGenus());
        new ColumnSortResetHandler(this.jTableMatchTaxa).attach();
        this.initProgressPanel();
        this.jTextFieldSource.setText("<not selected>");
        for (Situation situation : Situation.values()) {
            this.jComboBoxOccType.addItem(situation.getDescr());
        }
        this.jComboBoxOccType.addItem("Questionable");
        List speciesTypes = this.db.getSpeciesTypeService().getAllSpeciesTypes();
        for (SpeciesType speciesType : speciesTypes) {
            if (speciesType.specTypeID() <= 0) continue;
            this.jComboBoxOccType.addItem(speciesType.description());
        }
        this.jTableMatchTaxa.getTableHeader().getColumnModel().getColumn(10).setCellEditor(new DefaultCellEditor(this.jComboBoxOccType));
        this.backgroundImage = DialogMatch.getBackgroundImage();
        if (this.getParent() instanceof FrameOrganiser) {
            this.synSch = ((FrameOrganiser)this.getParent()).getSynSchID();
            if (this.db.getSynSch(this.synSch) != null) {
                this.jLabelSynonymScheme.setText("Synonym scheme: " + this.db.getSynSch(this.synSch).getName());
            }
        } else if (this.getParent() instanceof FrameTaxaDB) {
            this.synSch = ((FrameTaxaDB)this.getParent()).getSynSchID();
            if (this.db.getSynSch(this.synSch) != null) {
                this.jLabelSynonymScheme.setText("Synonym scheme: " + this.db.getSynSch(this.synSch).getName());
            }
        }
        this.pack();
    }

    private void initProgressPanel() {
        int nLists = 0;
        for (int i = 0; i < 7; ++i) {
            if (this.model.taxonPages[i] == null) continue;
            ++nLists;
        }
        this.jPanelProgress.removeAll();
        this.jPanelProgress.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 3", "[fill][grow,fill]", StringUtils.repeat((String)"[fill]", (int)nLists)));
        int n = -1;
        for (int i = 0; i < 7; ++i) {
            if (this.model.taxonPages[i] == null) continue;
            ++n;
            int selection = i;
            JRadioButton button = new JRadioButton(PRGSTRG[i]);
            button.addActionListener(e -> {
                this.selectedIndex = selection;
                this.model.fireTableDataChanged();
                this.model.calcNMatched(selection);
            });
            button.setContentAreaFilled(false);
            button.setHorizontalAlignment(11);
            button.setHorizontalTextPosition(10);
            button.setFocusable(false);
            this.buttonGroupDiscipline.add(button);
            this.pBars[i] = new JProgressBar();
            this.pBars[i].setStringPainted(true);
            this.pBars[i].setForeground(Color.RED);
            this.pButts[i] = button;
            this.jPanelProgress.add((Component)this.pButts[i], "cell 0 " + n);
            this.jPanelProgress.add((Component)this.pBars[i], "cell 1 " + n);
            this.setProgressBar(i);
        }
        if (this.pButts[this.selectedIndex] != null) {
            this.pButts[this.selectedIndex].setSelected(true);
        }
    }

    private model3.Taxon getSelectedTaxon() {
        try {
            Taxon wsTx = this.model.getSelectedPage().get(this.jTableMatchTaxa.convertRowIndexToModel(this.jTableMatchTaxa.getSelectedRow())).taxon();
            return this.ws.getTaxon(wsTx.getSpecID());
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private model3.Taxon mapWsTaxon(Taxon domainTaxon) {
        try {
            return this.ws.getTaxon(domainTaxon.getSpecID());
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonWebRefsActionPerformed() {
        int nRows = this.jTableMatchTaxa.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        DialogConfigureWebCitationServices dialog = new DialogConfigureWebCitationServices((Dialog)this, true, this.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getSelectedServices().isEmpty()) {
            return;
        }
        List<TableModelMatchTaxa.TaxonRow> page = this.model.getSelectedPage();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int nFound = 0;
            int[] nArray = this.jTableMatchTaxa.getSelectedRows();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer selectedViewRow = nArray[i];
                int selectedModelIndex = this.jTableMatchTaxa.convertRowIndexToModel(selectedViewRow);
                TableModelMatchTaxa.TaxonRow selectedRow = page.get(selectedModelIndex);
                WebCitationService.WebCitation citation = WebCitationService.wsQueryTaxon(dialog.getSelectedServices(), selectedRow.taxon());
                if (citation == null) continue;
                ++nFound;
                page.set(selectedModelIndex, selectedRow.withCitation(citation));
            }
            if (nFound > 0) {
                TableColumn column = this.jTableMatchTaxa.getColumnModel().getColumn(4);
                if (column.getMaxWidth() == 0) {
                    column.setMaxWidth(1000);
                    column.setPreferredWidth(150);
                }
                this.model.fireTableDataChanged();
            } else {
                JOptionPane.showMessageDialog(this, "No references found", this.getTitle(), 1);
            }
        }
        catch (IOException | RuntimeException ioe) {
            SbugsExceptionHandler.showStackError("Error running query", ioe, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void editTaxon() {
        block7: {
            int selectedRow = this.jTableMatchTaxa.getSelectedRow();
            int modelRow = this.jTableMatchTaxa.convertRowIndexToModel(selectedRow);
            TableModelMatchTaxa.TaxonRow taxonRow = this.model.getSelectedPage().get(modelRow);
            Taxon wsTx = taxonRow.taxon();
            if (this.source == null && this.askDataSource) {
                int opt = JOptionPane.showConfirmDialog(this, "Do you want to select a data source to record matches?", this.getTitle(), 0);
                if (opt == 0) {
                    this.jButtonSelectSourceActionPerformed(null);
                }
                this.askDataSource = false;
            }
            try {
                Taxon searchTaxon = Taxon.copy((Taxon)wsTx);
                searchTaxon.setGenus(Genus.copy((Genus)searchTaxon.getGenus()));
                DialogSelectTaxa selectDialog = new DialogSelectTaxa(this, true, this.db, this.synSch, true, wsTx);
                selectDialog.setLocationRelativeTo(this);
                selectDialog.setVisible(true);
                if (selectDialog.getSelectedItem() == null) break block7;
                this.model.setLink(wsTx, (Taxon)selectDialog.getSelectedItem());
                this.model.updateStatusForTaxon(wsTx.getSpecID(), TableModelMatchTaxa.MatchStatus.MANUAL);
                if (this.source != null) {
                    try {
                        this.source.storeMatch(this.db, this.ws.getTaxon(wsTx.getSpecID()), taxonRow.donorOccType());
                        this.db.commit();
                    }
                    catch (SQLException sql) {
                        this.db.doRollback();
                        SbugsExceptionHandler.showStackError(sql, this);
                    }
                }
                this.model.fireTableDataChanged();
                int row = this.jTableMatchTaxa.convertRowIndexToView(this.model.getSelectedPage().indexOf(taxonRow.withStatus(TableModelMatchTaxa.MatchStatus.MANUAL)));
                this.jTableMatchTaxa.setRowSelectionInterval(row, row);
            }
            catch (RuntimeException re) {
                SbugsExceptionHandler.showStackError(re, this);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchTaxa this$0;
            {
                DialogMatchTaxa dialogMatchTaxa = this$0;
                Objects.requireNonNull(dialogMatchTaxa);
                this.this$0 = dialogMatchTaxa;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jLabel1 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchTaxa = new JTable();
        this.jPanelProgress = new JPanel();
        this.radioButton1 = new JRadioButton();
        this.progressBar1 = new JProgressBar();
        this.jPanel5 = new JPanel();
        this.jPanelDataSource = new JPanel();
        this.jTextFieldSource = new JTextField();
        this.jButtonLoad = new JButton();
        this.jButtonSelectSource = new JButton();
        this.jLabelSynonymScheme = new JLabel();
        this.jButtonCategories = new JButton();
        this.jButtonMatchAll = new JButton();
        this.jButtonClean = new JButton();
        this.jButtonCodes = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonWebRefs = new JButton();
        this.jButtonWebLookup = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonAddAll = new JButton();
        this.jButtonSwitchPrefs = new JButton();
        this.jButtonWrite = new JButton();
        this.jButtonHelp = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(600, 530));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogMatchTaxa this$0;
            {
                DialogMatchTaxa dialogMatchTaxa = this$0;
                Objects.requireNonNull(dialogMatchTaxa);
                this.this$0 = dialogMatchTaxa;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.windowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        this.jPanel1.setLayout((LayoutManager)new MigLayout("insets dialog,hidemode 3,gap 5 5", "[grow,fill][fill]unrel[fill]", "[shrink 0,fill][33,fill]unrel[grow,fill]"));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, (float)this.jLabel1.getFont().getSize() + 2.0f));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setText("Workspace...");
        this.jPanel1.add((Component)this.jLabel1, "cell 0 0");
        this.jLabel7.setFont(this.jLabel7.getFont().deriveFont(this.jLabel7.getFont().getStyle() | 1, (float)this.jLabel7.getFont().getSize() + 2.0f));
        this.jLabel7.setText("...Database");
        this.jPanel1.add((Component)this.jLabel7, "cell 1 0");
        this.jScrollPane1.setPreferredSize(new Dimension(750, 427));
        this.jTableMatchTaxa.setModel(this.model);
        this.jTableMatchTaxa.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMatchTaxa this$0;
            {
                DialogMatchTaxa dialogMatchTaxa = this$0;
                Objects.requireNonNull(dialogMatchTaxa);
                this.this$0 = dialogMatchTaxa;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.this$0.jTableMatchTaxaMouseClicked(e);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatchTaxa);
        this.jPanel1.add((Component)this.jScrollPane1, "cell 0 1 2 2,growy");
        this.jPanelProgress.setOpaque(false);
        this.jPanelProgress.setPreferredSize(new Dimension(201, 145));
        this.jPanelProgress.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 2,aligny top", "[fill][grow,fill]", "[fill]"));
        this.radioButton1.setText("text");
        this.radioButton1.setHorizontalTextPosition(10);
        this.jPanelProgress.add((Component)this.radioButton1, "cell 0 0");
        this.jPanelProgress.add((Component)this.progressBar1, "cell 1 0");
        this.jPanel1.add((Component)this.jPanelProgress, "cell 2 1");
        this.jPanel5.setOpaque(false);
        this.jPanel5.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3,gap 5 5", "[grow,fill][grow,fill]", "[fill]unrel[fill]unrel[grow,fill][]unrel[][][][]unrel[][]unrel[]"));
        this.jPanelDataSource.setBorder(new TitledBorder("Data Source"));
        this.jPanelDataSource.setOpaque(false);
        this.jPanelDataSource.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 3,gap 5 5", "[grow,fill]", "[fill][fill]"));
        this.jTextFieldSource.setEditable(false);
        this.jTextFieldSource.setBackground(new Color(0xFFFFCC));
        this.jTextFieldSource.setText("jTextField1");
        this.jPanelDataSource.add((Component)this.jTextFieldSource, "cell 0 0");
        this.jButtonLoad.setText("Load matches...");
        this.jButtonLoad.addActionListener(e -> this.jButtonLoadActionPerformed(e));
        this.jPanelDataSource.add((Component)this.jButtonLoad, "cell 0 1");
        this.jButtonSelectSource.setText("...");
        this.jButtonSelectSource.addActionListener(e -> this.jButtonSelectSourceActionPerformed(e));
        this.jButtonSelectSource.putClientProperty("JComponent.sizeVariant", "small");
        this.jPanelDataSource.add((Component)this.jButtonSelectSource, "cell 0 1,alignx right,growx 0");
        this.jPanel5.add((Component)this.jPanelDataSource, "cell 0 0 2 1");
        this.jLabelSynonymScheme.setText("<No synonym scheme set>");
        this.jLabelSynonymScheme.setToolTipText("The synonym scheme needs to be pre-selected from the Match menu");
        this.jPanel5.add((Component)this.jLabelSynonymScheme, "cell 0 1 2 1,alignx center,growx 0");
        this.jButtonCategories.setText("Categories...");
        this.jButtonCategories.setToolTipText("Match taxon categories in workspace against categories in database");
        this.jButtonCategories.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonCategories.addActionListener(e -> this.jButtonCategoriesActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonCategories, "cell 0 3");
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.setToolTipText("Attempt to match all taxa in workspace with taxa of the same nams in database");
        this.jButtonMatchAll.setFont(this.jButtonMatchAll.getFont().deriveFont(this.jButtonMatchAll.getFont().getStyle() | 1));
        this.jButtonMatchAll.addActionListener(e -> this.jButtonMatchAllActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonMatchAll, "cell 0 4");
        this.jButtonClean.setText("Edit list...");
        this.jButtonClean.setToolTipText("Make changes to all taxa in workspace to make more consistent");
        this.jButtonClean.addActionListener(e -> this.jButtonCleanActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonClean, "cell 1 3");
        this.jButtonCodes.setText("Match codes");
        this.jButtonCodes.setToolTipText("Use taxon codes for matching instead of taxon names");
        this.jButtonCodes.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonCodes.addActionListener(e -> this.jButtonCodesActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonCodes, "cell 1 4");
        this.jButtonEdit.setText("Edit/Search...");
        this.jButtonEdit.setToolTipText("Search for a taxon to match to");
        this.jButtonEdit.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonEdit.addActionListener(e -> this.jButtonEditActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonEdit, "cell 0 5");
        this.jButtonWebRefs.setText("Web refs...");
        this.jButtonWebRefs.setToolTipText("Find online citations for selected taxa");
        this.jButtonWebRefs.addActionListener(e -> this.jButtonWebRefsActionPerformed());
        this.jPanel5.add((Component)this.jButtonWebRefs, "cell 0 6");
        this.jButtonWebLookup.setText("Web lookup...");
        this.jButtonWebLookup.setToolTipText("Look up selected taxon on the WWW");
        this.jButtonWebLookup.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonWebLookup.addActionListener(e -> this.jButtonWebLookupActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonWebLookup, "cell 1 6");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude taxa from workspace");
        this.jButtonExclude.addActionListener(e -> this.jButtonExcludeActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonExclude, "cell 0 7");
        this.jButtonAddAll.setText("Add all");
        this.jButtonAddAll.setToolTipText("Add all unmatched taxa from workspace into database");
        this.jButtonAddAll.addActionListener(e -> this.jButtonAddAllActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonAddAll, "cell 1 7");
        this.jButtonSwitchPrefs.setText("Switch syns");
        this.jButtonSwitchPrefs.setToolTipText("Update database taxon to preferred term from synonym scheme where workspace taxon is linked to a junior synonym");
        this.jButtonSwitchPrefs.addActionListener(e -> this.jButtonSwitchPrefsActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonSwitchPrefs, "cell 0 8");
        this.jButtonWrite.setText("Write...");
        this.jButtonWrite.setToolTipText("Output a list of unmatched taxa to a text file");
        this.jButtonWrite.addActionListener(e -> this.jButtonWriteActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonWrite, "cell 1 8");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(e -> this.jButtonHelpActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonHelp, "cell 0 10");
        this.jPanel5.add((Component)this.jSeparator2, "cell 0 9 2 1");
        this.jButtonOK.setText("Continue");
        this.jButtonOK.addActionListener(e -> this.jButtonOKActionPerformed(e));
        this.jPanel5.add((Component)this.jButtonOK, "cell 1 10");
        this.jPanel1.add((Component)this.jPanel5, "cell 2 2");
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addComponent(this.jPanel1, -1, 1011, Short.MAX_VALUE));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addComponent(this.jPanel1, -1, 604, Short.MAX_VALUE));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        boolean ignoreCategory = false;
        try {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                String cat_mnem;
                Taxon wsTx = this.model.getSelectedPage().get(i).taxon();
                if (!this.model.getLink(wsTx).isEmpty() || (cat_mnem = wsTx.getGenus().getCategory().getMnemonic()).isEmpty() || this.db.getCategory(cat_mnem) != null) continue;
                int opt = JOptionPane.showConfirmDialog(this, "Unknown category found\nDo you want to ignore unknown categories in search?", "Match Taxa", 0, 3);
                if (opt == 0) {
                    ignoreCategory = true;
                    break;
                }
                if (opt == 1) break;
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.linkedWorkspace != null) {
                this.linkedWorkspace.matchUnmatchedTaxa(ignoreCategory);
            } else {
                for (model3.Taxon wsTaxon : this.ws.getTaxa()) {
                    this.db.matchTaxon(wsTaxon, ignoreCategory);
                }
            }
            for (int nPage = 0; nPage < 7; ++nPage) {
                List<TableModelMatchTaxa.TaxonRow> page = this.model.getPage(nPage);
                if (page == null) continue;
                for (int nRow = 0; nRow < page.size(); ++nRow) {
                    TableModelMatchTaxa.TaxonRow row = page.get(nRow);
                    if (row.status != TableModelMatchTaxa.MatchStatus.UNMATCHED || !this.model.getLink(row.taxon).isPresent()) continue;
                    page.set(nRow, row.withStatus(TableModelMatchTaxa.MatchStatus.MATCHED));
                    int n = nPage;
                    this.model.nMatched[n] = this.model.nMatched[n] + 1;
                }
            }
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.setProgress();
        this.model.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.source == null) {
            this.selectSource(true);
            if (this.source == null) {
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try (Statement stmt = this.db.getDatabase().createStatement();){
            List<TableModelMatchTaxa.TaxonRow> page = this.model.getSelectedPage();
            for (int i = 0; i < page.size(); ++i) {
                TableModelMatchTaxa.TaxonRow row = page.get(i);
                model3.Taxon taxon = this.mapWsTaxon(row.taxon());
                if (taxon.getLink() != null) continue;
                this.source.getTaxon(this.db, stmt, taxon);
                if (taxon.getLink() == null) continue;
                page.set(i, row.withOccType(taxon.getDonorOccType()));
                this.model.updateStatusForTaxon(taxon.getSpecID(), TableModelMatchTaxa.MatchStatus.LOADED);
            }
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError("Error loading matches", ex, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.model.fireTableDataChanged();
        this.setProgressBar(this.selectedIndex);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void setProgress() {
        for (int i = 0; i < 7; ++i) {
            this.model.calcNMatched(i);
            this.setProgressBar(i);
        }
    }

    private void setProgressBar(int index) {
        JProgressBar bar = this.pBars[index];
        if (bar == null) {
            return;
        }
        bar.setString(this.model.nMatched[index] + "/" + this.model.taxonPages[index].size());
        if (this.model.taxonPages[index] != null) {
            bar.setValue(this.model.nMatched[index] * 100 / this.model.taxonPages[index].size());
        } else {
            bar.setValue(0);
        }
        if (bar.getValue() == 100) {
            bar.setForeground(new Color(50, 150, 50));
            bar.setStringPainted(true);
        }
        bar.repaint();
    }

    private void jButtonWebLookupActionPerformed(ActionEvent evt) {
        int nRows = this.jTableMatchTaxa.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        WebSearch webSearch = new WebSearch();
        try {
            int[] selectedRows = this.jTableMatchTaxa.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                TableModelMatchTaxa.TaxonRow selectedRow = this.model.getSelectedPage().get(this.jTableMatchTaxa.convertRowIndexToModel(selectedRows[i]));
                String name = this.model.getDonorString(selectedRow.taxon());
                if (StringUtils.isBlank((CharSequence)name)) {
                    name = selectedRow.taxon().toString(true);
                }
                Desktop.getDesktop().browse(new URI(webSearch.getURL(this.db, name)));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), this.getTitle(), 2);
            ex.printStackTrace();
        }
    }

    private void jButtonCategoriesActionPerformed(ActionEvent evt) {
        try {
            List<Taxon> list = this.model.getSelectedPage().stream().map(TableModelMatchTaxa.TaxonRow::taxon).toList();
            DialogMatchCategories dialog = new DialogMatchCategories(this, true, this.ws, this.db, list, this.selectedIndex < Discipline.values().length ? Discipline.values()[this.selectedIndex] : null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.updateTaxa();
                this.model.fireTableDataChanged();
            }
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableMatchTaxa.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one taxon", this.getTitle(), 1);
            return;
        }
        this.editTaxon();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        int nRows = this.jTableMatchTaxa.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to exclude " + (String)(nRows > 1 ? "these " + nRows + " taxa" : "this taxon") + "?\nAll occurrences of " + (nRows > 1 ? "them" : "it") + " will be excluded from wells and groups in the workspace immediately.", this.getTitle(), 0, 3) != 0) {
            return;
        }
        this.excludeSelected();
    }

    /*
     * WARNING - void declaration
     */
    private void excludeSelected() {
        void var6_13;
        LinkedList<Taxon> excluders = new LinkedList<Taxon>();
        int[] selectedRows = this.jTableMatchTaxa.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            int index = this.jTableMatchTaxa.convertRowIndexToModel(selectedRows[i]);
            excluders.add(this.model.getSelectedPage().get(index).taxon());
        }
        Iterator txit = excluders.iterator();
        block3: while (txit.hasNext()) {
            Taxon taxon = (Taxon)txit.next();
            for (SBEvent sBEvent : this.ws.getEvents()) {
                if (sBEvent.getTaxon() == null || sBEvent.getTaxon().getSpecID() != taxon.getSpecID()) continue;
                txit.remove();
                continue block3;
            }
        }
        int nRemoved = this.jTableMatchTaxa.getSelectedRowCount() - excluders.size();
        if (nRemoved > 0) {
            JOptionPane.showMessageDialog(this, nRemoved + " taxa could not be excluded because they are linked to events.", this.getTitle(), 2);
        }
        if (excluders.isEmpty()) {
            return;
        }
        LinkedList<model3.Taxon> modelExcluders = new LinkedList<model3.Taxon>();
        try {
            for (Taxon domainTaxon : excluders) {
                modelExcluders.add(this.ws.getTaxon(domainTaxon.getSpecID()));
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        this.ws.excludeSpecies(modelExcluders);
        boolean bl = false;
        while (var6_13 < 7) {
            List<TableModelMatchTaxa.TaxonRow> page = this.model.getPage((int)var6_13);
            if (page != null) {
                this.model.taxonPages[var6_13] = page.stream().filter(taxonRow -> !excluders.contains(taxonRow.taxon)).collect(Collectors.toCollection(ArrayList::new));
            }
            ++var6_13;
        }
        this.setProgress();
        this.jTableMatchTaxa.clearSelection();
        this.model.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonAddAllActionPerformed(ActionEvent evt) {
        List<TableModelMatchTaxa.TaxonRow> list = this.model.getSelectedPage();
        if (list.isEmpty()) {
            return;
        }
        int toAdd = list.size() - this.model.nMatched[this.selectedIndex];
        if (toAdd == 0) {
            JOptionPane.showMessageDialog(this, "There are no unmatched taxa to add.", this.getTitle(), 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "WARNING: This option may add duplicate, unnecessary, or inconsistent species to your database.\nDo you want to continue?", "Add all", 0, 2) != 0) {
            return;
        }
        try {
            int nTaxa = this.db.getTaxonService().getTaxonCount();
            if ((nTaxa > 9000 || toAdd > 20) && JOptionPane.showConfirmDialog(this, "WARNING: There are already " + nTaxa + " entries in your species dictionary.\nAre you sure you want to continue to add these " + toAdd + "?", "Add all", 0, 3) != 0) {
                return;
            }
        }
        catch (SuppressedSQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        HashMap<AbstractMultiStageProcess.ProcessResult, Taxon> failures = new HashMap<AbstractMultiStageProcess.ProcessResult, Taxon>();
        int unknownCategory = 0;
        if (this.linkedWorkspace != null) {
            unknownCategory = this.linkedWorkspace.addUnmatchedTaxa();
        } else {
            Boolean importWebCitations = null;
            try {
                for (TableModelMatchTaxa.TaxonRow row : list) {
                    AbstractMultiStageProcess.ProcessResult result;
                    if (!this.model.getLink(row.taxon()).isEmpty()) continue;
                    try {
                        this.db.matchTaxon(this.ws.getTaxon(row.taxon().getSpecID()), false);
                    }
                    catch (SQLException ex) {
                        SbugsExceptionHandler.showStackError("Error attempting to match taxon: " + String.valueOf(row.taxon()), ex, this);
                        this.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    if (this.model.getLink(row.taxon).isPresent()) {
                        this.model.updateStatusForTaxon(row.taxon.getSpecID(), TableModelMatchTaxa.MatchStatus.MATCHED);
                        continue;
                    }
                    Optional<Category> category = this.db.getCategoryService().findCategory(row.taxon().getGenus().getCategory().getMnemonic());
                    if (category.isEmpty()) {
                        Genus query = Genus.copy((Genus)row.taxon.getGenus());
                        query.setCategory(null);
                        List matchingGenera = this.db.getGenusService().findMatchingGenera(query, SearchMode.LOOKUP);
                        if (matchingGenera.size() == 1) {
                            category = Optional.of(((Genus)matchingGenera.get(0)).getCategory());
                        }
                    }
                    if (category.isEmpty()) {
                        ++unknownCategory;
                        continue;
                    }
                    if (row.webCitation != null) {
                        if (importWebCitations == null) {
                            int opt = JOptionPane.showConfirmDialog(this, "Import web citations?", "References and Notes", 0);
                            importWebCitations = opt == 0;
                        }
                        if (importWebCitations.booleanValue()) {
                            if (StringUtils.isBlank((CharSequence)row.taxon.getUrl())) {
                                row.taxon.setUrl(row.webCitation().url());
                            }
                            if (StringUtils.isBlank((CharSequence)row.taxon.getReference())) {
                                String source = row.webCitation().source();
                                String reference = row.webCitation().reference();
                                String citation = !StringUtils.isBlank((CharSequence)source) && !StringUtils.isBlank((CharSequence)reference) ? source + ": " + reference : source + reference;
                                row.taxon.setReference(citation);
                            }
                        }
                    }
                    if ((result = this.db.fillTaxonFromWorkspace(this.ws, row.taxon(), (Category)category.get())).result() == AbstractMultiStageProcess.ResultType.SUCCESS) {
                        this.model.updateStatusForTaxon(row.taxon.getSpecID(), TableModelMatchTaxa.MatchStatus.ADDED);
                        continue;
                    }
                    failures.put(result, row.taxon);
                }
            }
            catch (RuntimeException re) {
                SbugsExceptionHandler.showStackError(re, this);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        if (unknownCategory > 0) {
            JOptionPane.showMessageDialog(this, unknownCategory + (unknownCategory > 1 ? " taxa were " : " taxon was ") + "not added because the category was blank or not recognised", "Match Taxa", 1);
        }
        if (!failures.isEmpty()) {
            List<String> messages = failures.entrySet().stream().map(entry -> ((Taxon)entry.getValue()).toString(false, true) + ": " + ((AbstractMultiStageProcess.ProcessResult)entry.getKey()).resultMessage()).sorted().toList();
            String message = "Some taxa could not be added:\n" + StringUtils.join(messages, (String)"\n");
            JOptionPane.showMessageDialog(this, message, "Match Taxa", 2);
        }
        this.model.fireTableDataChanged();
        this.setProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonCodesActionPerformed(ActionEvent evt) {
        List<TableModelMatchTaxa.TaxonRow> list = this.model.getSelectedPage();
        if (list == null || list.isEmpty()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (TableModelMatchTaxa.TaxonRow taxonRow : list) {
                if (!this.model.getLink(taxonRow.taxon()).isEmpty()) continue;
                Taxon query = new Taxon();
                query.setGenus(new Genus());
                query.setAlphaCode(this.model.getDonorString(taxonRow.taxon));
                List matchingTaxa = this.db.getTaxonService().findMatchingTaxa(query, null, SearchMode.SEARCH);
                if (matchingTaxa.isEmpty()) continue;
                this.model.setLink(taxonRow.taxon, (Taxon)matchingTaxa.get(0));
                this.model.updateStatusForTaxon(taxonRow.taxon.getSpecID(), TableModelMatchTaxa.MatchStatus.MATCHED);
            }
        }
        catch (RuntimeException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.model.fireTableDataChanged();
        this.setProgress();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        List<model3.Taxon> modelTaxa = this.model.getSelectedPage().stream().map(TableModelMatchTaxa.TaxonRow::taxon).map(this::mapWsTaxon).toList();
        DialogMatchTaxaEdit dialog = new DialogMatchTaxaEdit(this, true, this.ws, modelTaxa);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.model.updateTaxa();
            this.model.fireTableDataChanged();
        }
    }

    private void jButtonWriteActionPerformed(ActionEvent evt) {
        File setDir = System.getProperty("os.name").equals("SunOS") ? new File("~/") : new File("\\My Documents");
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        String TEXT = "Text files";
        filter.setDescription("Text files");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                Object fileName = jFileChooser1.getSelectedFile().getPath();
                if (!((String)fileName).toLowerCase().contains(".txt")) {
                    fileName = (String)fileName + ".txt";
                }
                try (FileWriter out = new FileWriter((String)fileName);){
                    out.write("List of unmatched taxa. Produced: " + df.format(new Date()) + "\r\n\r\n");
                    List unmatched = this.model.getSelectedPage().stream().map(TableModelMatchTaxa.TaxonRow::taxon).filter(taxon -> this.model.getLink((Taxon)taxon).isEmpty()).sorted().collect(Collectors.toCollection(LinkedList::new));
                    for (Taxon tx : unmatched) {
                        out.write(String.valueOf(tx) + "\r\n");
                    }
                }
                JOptionPane.showMessageDialog(this, "File written", this.getTitle(), 1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            for (int listIndex = 0; listIndex <= 6; ++listIndex) {
                int opt;
                boolean hasUnswitchedJuniorSynonymns;
                List<TableModelMatchTaxa.TaxonRow> page = this.model.taxonPages[listIndex];
                if (page == null || !(hasUnswitchedJuniorSynonymns = page.stream().map(TableModelMatchTaxa.TaxonRow::taxon).map(this.model::getLink).filter(Optional::isPresent).map(Optional::get).map(dbTaxon -> this.db.getSynonymService().getPreferredTerm(this.synSch, dbTaxon.getSpecID(), this.db.getTaxonService())).anyMatch(Optional::isPresent)) || (opt = JOptionPane.showConfirmDialog(this, "There are unswitched junior synonyms in the list of matched taxa.\nContinue to import using the junior synonyms?", this.getTitle(), 0)) != 1) continue;
                return;
            }
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
        if (this.inWizard) {
            if (this.model.taxonPages[4] != null && this.model.nMatched[4] < this.model.taxonPages[4].size()) {
                JOptionPane.showMessageDialog(this, "You must match all event taxa", this.getTitle(), 2);
                return;
            }
            Object msg = "";
            for (int i = 0; i < Discipline.values().length; ++i) {
                if (this.model.taxonPages[i] == null || this.model.nMatched[i] >= this.model.taxonPages[i].size()) continue;
                if (!((String)msg).isEmpty()) {
                    msg = (String)msg + ", ";
                }
                msg = (String)msg + Discipline.values()[i].getAbr(true);
            }
            if (!((String)msg).isEmpty()) {
                msg = "There are unmatched taxa for disciplines: " + (String)msg;
            }
            if (this.model.taxonPages[5] != null && this.model.nMatched[5] < this.model.taxonPages[5].size()) {
                msg = ((String)msg).isEmpty() ? "There are unmatched taxa for taxon groups." : (String)msg + "\nand taxon groups.";
            }
            if (!((String)msg).isEmpty()) {
                msg = (String)msg + "\nAll occurrences of unmatched taxa will be excluded from workspace.\n\nAre you sure you want to continue?\n";
                Object[] options = new String[]{"Continue (exclude occurrences)", "Close (exit guided import)", "Cancel"};
                int opt = JOptionPane.showOptionDialog(this, msg, this.getTitle(), 1, 3, null, options, null);
                switch (opt) {
                    case 0: {
                        this.excludeUnmatched();
                        this.commitMatches();
                        this.saveWsTypeImages();
                        if (this.mergeDuplicates()) {
                            this.isOK = true;
                            this.dispose();
                        }
                        return;
                    }
                    case 1: {
                        this.commitMatches();
                        this.saveWsTypeImages();
                        this.dispose();
                        return;
                    }
                }
                return;
            }
        }
        this.commitMatches();
        this.saveWsTypeImages();
        if (this.mergeDuplicates()) {
            this.isOK = true;
            this.dispose();
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    private void excludeUnmatched() {
        try {
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                Iterator<Sample> sit = well.getSamples().iterator();
                while (sit.hasNext()) {
                    Iterator<Smpdtl> dit = sit.next().getSmpdtls().iterator();
                    while (dit.hasNext()) {
                        dit.next().excludeUnmatchedTaxa();
                    }
                }
            }
            for (TxGroup group : this.ws.getTxGroups()) {
                ArrayList<model3.Taxon> toRemove = new ArrayList<model3.Taxon>();
                for (model3.Taxon taxon : this.ws.getTxGroupTaxa(group)) {
                    if (taxon.getLink() != null) continue;
                    toRemove.add(taxon);
                }
                group.deleteTaxa(toRemove);
            }
        }
        catch (SBPermissionException pe) {
            throw new RuntimeException("Unexpected permission exception excluding taxa from groups in workspace");
        }
        catch (SQLException sql) {
            throw new RuntimeException("Unexpected exception loading samples in workspace");
        }
    }

    private boolean mergeDuplicates() {
        boolean askMerge = false;
        try {
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                Iterator<Sample> sit = well.getSamples().iterator();
                while (sit.hasNext()) {
                    for (Smpdtl dtl : sit.next().getAnalysesCopy()) {
                        if (!dtl.hasDuplicateOccurrences()) continue;
                        if (!askMerge) {
                            int opt = JOptionPane.showConfirmDialog(this, "Warning: there are duplicate taxon occurrences in analyses which might be a result of matching > 1 taxon to the same host taxon.\nDo you want to add the abundances together?", this.getTitle(), 1, 3);
                            switch (opt) {
                                case 1: {
                                    return true;
                                }
                                case 0: {
                                    break;
                                }
                                default: {
                                    return false;
                                }
                            }
                            askMerge = true;
                        }
                        AbundanceScheme abnScheme = this.ws.getAbundanceSchemeService().findAbundanceScheme(dtl.getHeader().getAbnSchID()).orElse(null);
                        dtl.mergeDuplicateOccurrences(abnScheme);
                    }
                }
            }
        }
        catch (SQLException sql) {
            throw new RuntimeException("Unexpected exception loading samples in workspace");
        }
        catch (SBException se) {
            SbugsExceptionHandler.showStackError("Error from mergeDuplicateOccrruences", se, this);
            return false;
        }
        return true;
    }

    private void saveWsTypeImages() {
        List<TableModelMatchTaxa.TaxonRow> page = this.model.getGroupPage();
        if (page == null) {
            return;
        }
        boolean askedImageImport = false;
        for (TableModelMatchTaxa.TaxonRow taxonRow : page) {
            List<TaxonImageSet> wsStandaloneTaxonImages;
            Taxon linkTaxon = this.model.getLink(taxonRow.taxon).orElse(null);
            if (linkTaxon == null || (wsStandaloneTaxonImages = this.ws.getTaxonImageService().getImages(taxonRow.taxon.getSpecID()).stream().filter(taxonImageSet -> taxonImageSet.getAnalysisID().isEmpty()).toList()).isEmpty()) continue;
            if (!askedImageImport) {
                if (JOptionPane.showConfirmDialog(this, "Import type images?", this.getTitle(), 0, 3) != 0) {
                    return;
                }
                askedImageImport = true;
            }
            List<TaxonImageSet> dbStandaloneTaxonImages = this.db.getTaxonImageService().getImages(linkTaxon.getSpecID()).stream().filter(taxonImageSet -> taxonImageSet.getAnalysisID().isEmpty()).toList();
            boolean dbTaxonHasTypeImageSet = dbStandaloneTaxonImages.stream().anyMatch(TaxonImageSet::isType);
            try {
                block3: for (TaxonImageSet wsImageSet : wsStandaloneTaxonImages) {
                    Iterator wsImageIterator = wsImageSet.getImageIterator(this.ws.getImageRecordService(), this.ws.getImageLoader(), null);
                    while (wsImageIterator.hasNext()) {
                        Image wsImage = (Image)wsImageIterator.next();
                        boolean wsImageFound = false;
                        block5: for (TaxonImageSet dbImageSet : dbStandaloneTaxonImages) {
                            Iterator dbImageIterator = dbImageSet.getImageIterator(this.db.getImageRecordService(), this.db.getImageLoader(), null);
                            while (dbImageIterator.hasNext()) {
                                Image dbImage = (Image)dbImageIterator.next();
                                if (!ImageUtils.compareImages((Image)wsImage, (Image)dbImage)) continue;
                                wsImageFound = true;
                                break block5;
                            }
                        }
                        if (wsImageFound) continue;
                        List<ImageRecord> unstoredImageRecords = wsImageSet.getImageRecords(this.ws.getImageRecordService()).stream().map(ir -> new ImageRecord(0, ir.caption(), ir.picPath())).toList();
                        int imageSetID = this.db.getImageRecordService().storeImageSet(0, unstoredImageRecords, this.ws.getImageLoader());
                        this.db.getTaxonImageService().addTaxonImageSet(linkTaxon.getSpecID(), new TaxonImageSet(imageSetID, linkTaxon.getSpecID(), !dbTaxonHasTypeImageSet));
                        continue block3;
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                SbugsExceptionHandler.showStackError("Error storing workspace image for " + String.valueOf(taxonRow.taxon), e);
            }
        }
    }

    private void commitMatches() {
        HashMap updatedOccTypes = new HashMap();
        for (int i = 0; i < 7; ++i) {
            List<TableModelMatchTaxa.TaxonRow> page = this.model.getPage(i);
            if (page == null) continue;
            page.stream().filter(taxonRow -> taxonRow.donorOccType() != null && !Situation.INSITU.getDescr().equals(taxonRow.donorOccType()) && this.model.getLink(taxonRow.taxon).isPresent()).forEach(taxonRow -> updatedOccTypes.put(taxonRow.taxon().getSpecID(), taxonRow.donorOccType()));
        }
        Iterator<Well> it = this.ws.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            try {
                Iterator<Sample> sit = well.getSamples().iterator();
                while (sit.hasNext()) {
                    for (Smpdtl dtl : sit.next().getAnalysesCopy()) {
                        Iterator<TaxonOcc> oit = dtl.getOccurIterator();
                        while (oit.hasNext()) {
                            TaxonOcc occ = oit.next();
                            String updatedOccType = (String)updatedOccTypes.get(occ.getTaxon().getSpecID());
                            if (updatedOccType == null) continue;
                            this.ws.setFssOccType(occ, updatedOccType);
                        }
                    }
                }
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError("Unexpected SQL Exception in workspace", sql, this);
            }
        }
        for (int i = 0; i < 7; ++i) {
            List<TableModelMatchTaxa.TaxonRow> page = this.model.getPage(i);
            if (page == null) continue;
            for (TableModelMatchTaxa.TaxonRow row : page) {
                if (!this.model.getLink(row.taxon()).isPresent()) continue;
            }
        }
        if (this.source != null) {
            try {
                for (Map.Entry updatedOccTypeEntry : updatedOccTypes.entrySet()) {
                    model3.Taxon wsTaxon = this.ws.getTaxon((Integer)updatedOccTypeEntry.getKey());
                    this.source.storeMatch(this.db, wsTaxon, (String)updatedOccTypeEntry.getValue());
                }
                this.db.commit();
            }
            catch (SQLException sqle) {
                this.db.doRollback();
                SbugsExceptionHandler.showStackError("Error storing matches", sqle, this);
            }
        }
    }

    private void jTableMatchTaxaMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            int selectedRow = this.jTableMatchTaxa.getSelectedRow();
            try {
                model3.Taxon wsTx = this.ws.getTaxon(this.model.getSelectedPage().get(this.jTableMatchTaxa.convertRowIndexToModel(selectedRow)).taxon().getSpecID());
                if (this.jTableMatchTaxa.getSelectedColumn() == 11) {
                    model3.Taxon dbTx = wsTx.getLink();
                    if (dbTx == null) {
                        JOptionPane.showMessageDialog(this, "No matched taxon", this.getTitle(), 1);
                        return;
                    }
                    if (this.db.getTaxonImageService().getImages(dbTx.getSpecID()).isEmpty()) {
                        JOptionPane.showMessageDialog(this, "There are no images in the database for selected taxon.", this.getTitle(), 1);
                        return;
                    }
                    DialogTaxonImages dialog = DialogTaxonImages.imageGalleryDialogForTaxon(this, dbTx, this.db);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                } else if (this.jTableMatchTaxa.getSelectedColumn() == 3) {
                    if (Objects.equals(this.model.getValueAt(this.jTableMatchTaxa.convertRowIndexToModel(selectedRow), 3), Boolean.FALSE)) {
                        JOptionPane.showMessageDialog(this, "There are no images in the workspace for selected taxon.", this.getTitle(), 1);
                        return;
                    }
                    DialogTaxonImages dialog = DialogTaxonImages.imageGalleryDialogForTaxon(this, wsTx, this.ws);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                } else {
                    this.editTaxon();
                }
            }
            catch (RuntimeException | SQLException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                ex.printStackTrace();
            }
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogmatchtaxa.html");
    }

    private void jButtonSelectSourceActionPerformed(ActionEvent evt) {
        this.selectSource(false);
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        this.load();
    }

    private void windowClosing(WindowEvent evt) {
        int opt;
        if (this.inWizard && (opt = JOptionPane.showConfirmDialog(this, "Exit guided import?", this.getTitle(), 0)) != 0) {
            return;
        }
        this.commitMatches();
        this.dispose();
    }

    private void jButtonSwitchPrefsActionPerformed(ActionEvent evt) {
        record RowWithJuniorSynonym(TableModelMatchTaxa.TaxonRow taxonRow, Taxon preferredTerm, boolean rowIsSelected) {
        }
        int opt;
        List<Object> rowsToUse = new LinkedList();
        for (TableModelMatchTaxa.TaxonRow taxonRow : this.model.getSelectedPage()) {
            Optional preferredTerm;
            Optional<Taxon> link = this.model.getLink(taxonRow.taxon());
            if (!link.isPresent() || !(preferredTerm = this.db.getSynonymService().getPreferredTerm(this.synSch, link.get().getSpecID(), this.db.getTaxonService())).isPresent()) continue;
            rowsToUse.add(new RowWithJuniorSynonym(taxonRow, (Taxon)preferredTerm.get(), this.jTableMatchTaxa.isRowSelected(this.jTableMatchTaxa.convertRowIndexToView(this.model.getSelectedPage().indexOf(taxonRow)))));
        }
        if (rowsToUse.isEmpty()) {
            JOptionPane.showMessageDialog(this, "There are no matched taxa which are junior synonyms in the currently selected scheme", this.getTitle(), 1);
            return;
        }
        if (rowsToUse.stream().anyMatch(RowWithJuniorSynonym::rowIsSelected) && (opt = JOptionPane.showConfirmDialog(this, "Restrict switch to selected rows only?", this.getTitle(), 0)) == 0) {
            rowsToUse = rowsToUse.stream().filter(RowWithJuniorSynonym::rowIsSelected).toList();
        }
        try {
            for (RowWithJuniorSynonym rowWithJuniorSynonym : rowsToUse) {
                model3.Taxon wsTaxon = this.mapWsTaxon(rowWithJuniorSynonym.taxonRow.taxon());
                wsTaxon.setLink(this.db.getTaxon(rowWithJuniorSynonym.preferredTerm.getSpecID()));
            }
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError("Error updating matches", e, this);
            return;
        }
        this.model.fireTableDataChanged();
        JOptionPane.showMessageDialog(this, "Number of taxa updated: " + rowsToUse.size(), this.getTitle(), 1);
    }

    private void selectSource(boolean fromLoad) {
        try {
            DialogSource dialog = new DialogSource(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.source = dialog.selection;
                this.jTextFieldSource.setText(this.source.getID() + "," + this.source.getName());
            }
            if (dialog.isOK()) {
                int option;
                if (!fromLoad && (option = JOptionPane.showConfirmDialog(this, "Do you want to load previous matches for this data source?", "Load Matches", 0)) == 0) {
                    fromLoad = true;
                }
                if (fromLoad) {
                    this.load();
                }
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private class TableModelMatchTaxa
    extends AbstractTableModel {
        private final List<TaxonRow>[] taxonPages;
        private final int[] nMatched;
        final /* synthetic */ DialogMatchTaxa this$0;

        private TableModelMatchTaxa(DialogMatchTaxa dialogMatchTaxa) {
            DialogMatchTaxa dialogMatchTaxa2 = dialogMatchTaxa;
            Objects.requireNonNull(dialogMatchTaxa2);
            this.this$0 = dialogMatchTaxa2;
            this.taxonPages = new List[7];
            this.nMatched = new int[7];
        }

        TaxonRow taxonRowWithStatus(Taxon taxon, int nOcc, int nOccImageSets, String donorOccType) {
            MatchStatus status = this.getLink(taxon).isPresent() ? MatchStatus.MATCHED : MatchStatus.UNMATCHED;
            return new TaxonRow(taxon, nOcc, nOccImageSets, donorOccType, status, null);
        }

        List<TaxonRow> getPage(int page) {
            return this.taxonPages[page];
        }

        List<TaxonRow> getGroupPage() {
            return this.taxonPages[5];
        }

        List<TaxonRow> getSelectedPage() {
            return this.taxonPages[this.this$0.selectedIndex];
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        /*
         * WARNING - void declaration
         */
        public void init() throws SQLException {
            void var7_30;
            void var7_28;
            Map[] pageMaps = new Map[7];
            for (int i2 = 0; i2 < 7; ++i2) {
                pageMaps[i2] = new HashMap();
            }
            Iterator<Well> it = this.this$0.ws.getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                for (Sample sample : well.getSamples()) {
                    for (Smpdtl smpdtl : sample.getAnalysesCopy()) {
                        int discInt = smpdtl.getDiscipline().ordinal();
                        Map page = pageMaps[discInt];
                        Iterator<TaxonOcc> oit = smpdtl.getOccurIterator();
                        while (oit.hasNext()) {
                            TaxonOcc occ = oit.next();
                            if (occ.getTaxon() == null) {
                                throw new IllegalStateException("Occurrence has null taxon reference: " + String.valueOf(smpdtl.getSample()) + "," + String.valueOf((Object)smpdtl) + "," + String.valueOf(occ));
                            }
                            Taxon taxon = occ.getTaxon().getTaxonCopy();
                            if (page.get(taxon.getSpecID()) == null) {
                                page.put(taxon.getSpecID(), this.taxonRowWithStatus(taxon, 1, occ.getImageSetID() > 0 ? 1 : 0, occ.getTaxon().getDonorOccType()));
                                continue;
                            }
                            TaxonRow existing = (TaxonRow)page.get(taxon.getSpecID());
                            page.put(taxon.getSpecID(), new TaxonRow(taxon, existing.nOcc + 1, existing.nOccImageSets + (occ.getImageSetID() > 0 ? 1 : 0), existing.donorOccType, existing.status));
                        }
                    }
                }
            }
            Map eventPage = pageMaps[4];
            for (SBEvent sBEvent : this.this$0.ws.getSBEvents(false)) {
                model3.Taxon taxon = sBEvent.getTaxon();
                if (taxon == null) continue;
                Taxon taxon2 = taxon.getTaxonCopy();
                if (eventPage.get(taxon2.getSpecID()) == null) {
                    eventPage.put(taxon2.getSpecID(), this.taxonRowWithStatus(taxon2, 1, 0, null));
                    continue;
                }
                eventPage.put(taxon2.getSpecID(), ((TaxonRow)eventPage.get(taxon2.getSpecID())).incremented());
            }
            Map groupPage = pageMaps[5];
            for (TxGroup txGroup : this.this$0.ws.getTxGroups()) {
                for (model3.Taxon taxon : this.this$0.ws.getTxGroupTaxa(txGroup)) {
                    Taxon domainTaxon = taxon.getTaxonCopy();
                    int nImages = this.this$0.ws.getTaxonImageService().getImages(domainTaxon.getSpecID()).size();
                    if (groupPage.get(domainTaxon.getSpecID()) == null) {
                        groupPage.put(domainTaxon.getSpecID(), this.taxonRowWithStatus(domainTaxon, 1, nImages, null));
                        continue;
                    }
                    TaxonRow existing = (TaxonRow)groupPage.get(domainTaxon.getSpecID());
                    groupPage.put(domainTaxon.getSpecID(), new TaxonRow(existing.taxon, existing.nOcc, nImages, "In-situ", existing.status));
                }
            }
            Map map = pageMaps[6];
            for (model3.Taxon taxon : this.this$0.ws.getTaxa()) {
                if (this.this$0.wsCM == null || !this.this$0.wsCM.hasOccurrences(taxon)) continue;
                Taxon domainTaxon = taxon.getTaxonCopy();
                if (map.get(domainTaxon.getSpecID()) == null) {
                    map.put(domainTaxon.getSpecID(), this.taxonRowWithStatus(domainTaxon, 1, 0, null));
                    continue;
                }
                map.put(domainTaxon.getSpecID(), ((TaxonRow)map.get(domainTaxon.getSpecID())).incremented());
            }
            boolean bl = Arrays.stream(pageMaps).allMatch(Map::isEmpty);
            if (bl) {
                for (Taxon domainTaxon : this.this$0.ws.getTaxonService().getAllTaxa()) {
                    if (groupPage.get(domainTaxon.getSpecID()) == null) {
                        groupPage.put(domainTaxon.getSpecID(), this.taxonRowWithStatus(domainTaxon, 1, this.this$0.ws.getTaxonImageService().getImages(domainTaxon.getSpecID()).size(), null));
                        continue;
                    }
                    groupPage.put(domainTaxon.getSpecID(), ((TaxonRow)groupPage.get(domainTaxon.getSpecID())).incremented());
                }
            }
            boolean bl2 = false;
            while (var7_28 < 7) {
                if (!pageMaps[var7_28].isEmpty()) {
                    ArrayList pageList = new ArrayList(pageMaps[var7_28].values());
                    Collections.sort(pageList);
                    this.taxonPages[var7_28] = pageList;
                    this.calcNMatched((int)var7_28);
                }
                ++var7_28;
            }
            boolean bl3 = false;
            while (var7_30 < 7) {
                if (this.taxonPages[var7_30] != null && !this.taxonPages[var7_30].isEmpty()) {
                    this.this$0.selectedIndex = var7_30;
                    break;
                }
                ++var7_30;
            }
        }

        private Optional<Taxon> getLink(Taxon donor) {
            if (this.this$0.linkedWorkspace != null) {
                return this.this$0.linkedWorkspace.getTaxonLink(donor);
            }
            try {
                model3.Taxon donorTaxon = this.this$0.ws.getTaxon(donor.getSpecID());
                if (donorTaxon.getLink() != null) {
                    return Optional.of(donorTaxon.getLink().getTaxonCopy());
                }
                return Optional.empty();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }

        private void setLink(Taxon donor, Taxon host) {
            if (this.this$0.linkedWorkspace != null) {
                this.this$0.linkedWorkspace.setTaxonLink(donor.getSpecID(), host != null ? Integer.valueOf(host.getSpecID()) : null);
                return;
            }
            try {
                this.this$0.ws.getTaxon(donor.getSpecID()).setLink(this.this$0.db.getTaxon(host.getSpecID()));
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        private String getDonorString(Taxon taxon) {
            if (this.this$0.linkedWorkspace != null) {
                return this.this$0.linkedWorkspace.getDonorString(taxon.getSpecID());
            }
            try {
                return this.this$0.ws.getTaxon(taxon.getSpecID()).getDonorString();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private void updateTaxa() {
            for (int i = 0; i < 7; ++i) {
                List<TaxonRow> page = this.getPage(i);
                if (page == null) continue;
                for (int j = 0; j < page.size(); ++j) {
                    TaxonRow existing = page.get(j);
                    page.set(j, new TaxonRow((Taxon)this.this$0.ws.getTaxonService().findTaxon(existing.taxon().getSpecID()).get(), existing.nOcc, existing.nOccImageSets, existing.donorOccType, existing.status));
                }
            }
        }

        private void updateStatusForTaxon(int specID, MatchStatus newStatus) {
            block0: for (int i = 0; i < 7; ++i) {
                List<TaxonRow> page = this.getPage(i);
                if (page == null) continue;
                for (int j = 0; j < page.size(); ++j) {
                    TaxonRow existing = page.get(j);
                    if (existing.taxon.getSpecID() != specID || existing.status == newStatus) continue;
                    page.set(j, existing.withStatus(newStatus));
                    int n = i;
                    this.nMatched[n] = this.nMatched[n] + 1;
                    this.this$0.setProgressBar(i);
                    continue block0;
                }
            }
        }

        @Override
        public int getRowCount() {
            List<TaxonRow> taxa = this.getSelectedPage();
            return taxa != null ? taxa.size() : 0;
        }

        public void calcNMatched(int index) {
            List<TaxonRow> page = this.getPage(index);
            this.nMatched[index] = 0;
            if (page != null) {
                this.nMatched[index] = (int)page.stream().map(taxonRow -> this.getLink(taxonRow.taxon)).filter(Optional::isPresent).count();
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            List<TaxonRow> selectedPage = this.getSelectedPage();
            if (selectedPage == null || row >= selectedPage.size()) {
                return null;
            }
            TaxonRow donor = selectedPage.get(row);
            return switch (col) {
                case 0 -> donor.taxon().getGenus().getCategory().getMnemonic();
                case 1 -> donor.taxon();
                case 7 -> this.getLink(donor.taxon()).orElse(null);
                case 8 -> this.getLink(donor.taxon()).map(taxon -> this.this$0.db.getSynonymService().getPreferredTerm(this.this$0.synSch, taxon.getSpecID(), this.this$0.db.getTaxonService()).orElse(null)).map(taxon -> taxon.toString(false, true)).orElse("");
                case 4 -> {
                    if (donor.webCitation != null) {
                        Object webRef;
                        if (!StringUtils.isBlank((CharSequence)donor.webCitation.source())) {
                            webRef = "<html><strong>" + donor.webCitation.source() + "</strong>";
                            if (!StringUtils.isBlank((CharSequence)donor.webCitation.reference())) {
                                webRef = (String)webRef + ": " + donor.webCitation.reference();
                            }
                            webRef = (String)webRef + "</html>";
                        } else {
                            webRef = donor.webCitation.reference();
                        }
                        yield webRef;
                    }
                    yield "";
                }
                case 5 -> donor.status;
                case 9 -> this.getLink(donor.taxon()).map(Taxon::getAlphaCode).orElse("");
                case 6 -> this.getLink(donor.taxon()).map(t -> t.getGenus().getCategory().getMnemonic()).orElse("");
                case 2 -> Integer.valueOf(donor.nOcc());
                case 3 -> Boolean.valueOf(donor.nOccImageSets() > 0);
                case 10 -> donor.donorOccType();
                case 11 -> this.getLink(donor.taxon()).map(link -> this.this$0.db.getTaxonImageService().hasTypeImage(link.getSpecID())).orElse(Boolean.FALSE);
                default -> "";
            };
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            TaxonRow donor = this.getSelectedPage().get(row);
            if (col == 10) {
                String occType = (String)obj;
                if (donor.donorOccType() == null || !donor.donorOccType().equals(occType)) {
                    this.getSelectedPage().set(row, donor.withOccType(occType));
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 10) {
                return this.this$0.selectedIndex < Discipline.values().length;
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return switch (c) {
                case 0, 6, 8, 9, 10 -> String.class;
                case 1, 7 -> Taxon.class;
                case 2 -> Integer.class;
                case 3, 11 -> Boolean.class;
                case 5 -> MatchStatus.class;
                default -> Object.class;
            };
        }

        void setupTable(JTable jTableMatchTaxa) {
            TableUtils.setTableHeaderBold((JTable)jTableMatchTaxa);
            jTableMatchTaxa.getTableHeader().setReorderingAllowed(false);
            jTableMatchTaxa.setColumnSelectionAllowed(false);
            TableColumnModel columnModel = jTableMatchTaxa.getTableHeader().getColumnModel();
            columnModel.getColumn(5).setMaxWidth(colWidths[5]);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
            }
            columnModel.getColumn(4).setMinWidth(0);
            columnModel.getColumn(4).setMaxWidth(0);
            columnModel.getColumn(4).setPreferredWidth(0);
            jTableMatchTaxa.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            jTableMatchTaxa.setDefaultRenderer(MatchStatus.class, new MatchStatusRenderer());
            columnModel.getColumn(1).setCellRenderer(new TaxonNameRenderer());
            columnModel.getColumn(7).setCellRenderer(new TaxonNameRenderer());
            columnModel.getColumn(10).setCellRenderer(new ComboRenderer());
            ImageIconRenderer imageIconRenderer = ImageIconRenderer.cameraImageIconRenderer();
            columnModel.getColumn(3).setCellRenderer(imageIconRenderer);
            columnModel.getColumn(11).setCellRenderer(imageIconRenderer);
        }

        static enum MatchStatus {
            UNMATCHED(false, "Not matched"),
            MANUAL(true, "Manual match"),
            ADDED(true, "Added"),
            LOADED(true, "Loaded match"),
            MATCHED(true, "Matched");

            final boolean isMatched;
            final String descr;

            private MatchStatus(boolean isMatched, String descr) {
                this.isMatched = isMatched;
                this.descr = descr;
            }

            public String toString() {
                return this.descr;
            }
        }

        private record TaxonRow(Taxon taxon, int nOcc, int nOccImageSets, String donorOccType, MatchStatus status, WebCitationService.WebCitation webCitation) implements Comparable<TaxonRow>
        {
            public TaxonRow(Taxon taxon, int nOcc, int nOccImageSets, String donorOccType, MatchStatus status) {
                this(taxon, nOcc, nOccImageSets, donorOccType, status, null);
            }

            TaxonRow incremented() {
                return new TaxonRow(this.taxon, this.nOcc + 1, this.nOccImageSets, this.donorOccType, this.status, this.webCitation);
            }

            TaxonRow withOccType(String donorOccType) {
                return new TaxonRow(this.taxon, this.nOcc, this.nOccImageSets, donorOccType, this.status, this.webCitation);
            }

            TaxonRow withStatus(MatchStatus newStatus) {
                return new TaxonRow(this.taxon, this.nOcc, this.nOccImageSets, this.donorOccType, newStatus, this.webCitation);
            }

            TaxonRow withCitation(WebCitationService.WebCitation citation) {
                return new TaxonRow(this.taxon, this.nOcc, this.nOccImageSets, this.donorOccType, this.status, citation);
            }

            @Override
            public int compareTo(TaxonRow o) {
                return this.taxon.compareTo(o.taxon);
            }
        }
    }

    private static class MatchStatusRenderer
    extends ArrowCellRenderer {
        private static final Color MATCHED_COLOR = new Color(51, 102, 204);
        private static final Color LOADED_COLOR = new Color(33, 182, 168);
        private static final Color MANUAL_COLOR = new Color(148, 49, 99);
        private static final Color ADDED_COLOR = new Color(254, 191, 16);

        private MatchStatusRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            if (object instanceof TableModelMatchTaxa.MatchStatus) {
                TableModelMatchTaxa.MatchStatus status = (TableModelMatchTaxa.MatchStatus)((Object)object);
                Component comp = super.getTableCellRendererComponent(table, status.isMatched, isSelected, hasFocus, row, column);
                Color colour = switch (status.ordinal()) {
                    case 3 -> LOADED_COLOR;
                    case 1 -> MANUAL_COLOR;
                    case 2 -> ADDED_COLOR;
                    default -> MATCHED_COLOR;
                };
                comp.setForeground(colour);
                ((JLabel)comp).setToolTipText(status.descr);
                return comp;
            }
            return this;
        }
    }
}

