/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogMatchDict;
import jsbugs.DialogMatchTxGroup;
import jsbugs.DialogSet;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.ColourRenderer;
import model3.SBdb;
import model3.Taxon;
import model3.TxGroup;
import model3.TxGroupSet;
import util.MatchData;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchTxGroupSet
extends DialogMatchDict {
    private final SBdb ws;
    private final SBdb db;
    private final TxGroupSet wsSet;
    private final TableModelMatchSet model = new TableModelMatchSet();
    private final int projID;
    static final String SAVE_IMAGE_QUESTION = "Do you want to save the images in the import file as new linked images?\nNote: if taxa are already linked to the same images then they will be duplicated";
    boolean inStartup = true;

    public DialogMatchTxGroupSet(Frame parent, boolean modal, boolean inWizard, SBdb ws, SBdb db, TxGroupSet wsSet, int projID) throws SQLException {
        super(parent, modal, inWizard);
        this.ws = ws;
        this.db = db;
        this.wsSet = wsSet;
        this.projID = projID;
        this.init();
    }

    private void init() throws SQLException {
        super.init(this.model, "Match Group Set", this.wsSet.getName());
        this.model.setUpTable(this.jTableMatch);
        this.dbModel.addElement("<Select>");
        List<TxGroupSet> dbSets = this.db.getTxGroupSets(this.projID, true);
        Collections.sort(dbSets);
        for (TxGroupSet set : dbSets) {
            this.dbModel.addElement(set);
        }
        if (this.wsSet.getLink() != null) {
            this.dbModel.setSelectedItem(this.wsSet.getLink());
        } else {
            TxGroupSet match = this.db.getTxGroupSet(this.wsSet.getName(), this.projID);
            if (match != null) {
                this.wsSet.setLink(match);
                this.dbModel.setSelectedItem(match);
            }
        }
        this.initData();
        JButton jButtonExclude = new JButton("Exclude");
        jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchTxGroupSet this$0;
            {
                DialogMatchTxGroupSet dialogMatchTxGroupSet = this$0;
                Objects.requireNonNull(dialogMatchTxGroupSet);
                this.this$0 = dialogMatchTxGroupSet;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonExcludeActionPerformed(e);
            }
        });
        this.addSidebarButton(jButtonExclude);
        JButton jButtonMatchGroup = new JButton("Match Group");
        jButtonMatchGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchTxGroupSet this$0;
            {
                DialogMatchTxGroupSet dialogMatchTxGroupSet = this$0;
                Objects.requireNonNull(dialogMatchTxGroupSet);
                this.this$0 = dialogMatchTxGroupSet;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonMatchGroupActionPerformed();
            }
        });
        this.addSidebarButton(jButtonMatchGroup);
        JButton jButtonSave = new JButton("Save");
        jButtonSave.setToolTipText("Save all new groups to database set");
        jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchTxGroupSet this$0;
            {
                DialogMatchTxGroupSet dialogMatchTxGroupSet = this$0;
                Objects.requireNonNull(dialogMatchTxGroupSet);
                this.this$0 = dialogMatchTxGroupSet;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.saveGroups();
            }
        });
        this.addSidebarButton(jButtonSave);
        this.jTableMatch.getTableHeader().setReorderingAllowed(false);
        this.inStartup = false;
    }

    private void initData() {
        if (this.wsSet == null) {
            return;
        }
        try {
            this.model.data = new MatchData();
            this.model.data.init(this.wsSet.getGroups(), this.wsSet.getLink() != null ? this.wsSet.getLink().getGroups() : null);
            for (int i = 0; i < this.model.data.size(); ++i) {
                MatchData.MatchPair pair = this.model.data.get(i);
                TxGroup wsGroup = (TxGroup)pair.getWs();
                if (wsGroup == null) continue;
                wsGroup.updateStatus();
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    @Override
    String getHelpPage() {
        return "dialogmatchset.html";
    }

    @Override
    void comboModelActionPerformed() {
        if (!this.inStartup) {
            TxGroupSet selected;
            TxGroupSet txGroupSet = selected = this.dbModel.getSelectedItem() instanceof TxGroupSet ? (TxGroupSet)this.dbModel.getSelectedItem() : null;
            if (this.wsSet.getLink() != selected) {
                this.wsSet.setLink(selected);
            }
            this.initData();
        }
    }

    private void jButtonMatchGroupActionPerformed() {
        if (this.jTableMatch.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row of the table to match", this.getTitle(), 2);
            return;
        }
        MatchData.MatchPair pair = this.model.data.get(this.jTableMatch.getSelectedRow());
        if (pair.getWs() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a workspace group", this.getTitle(), 2);
            return;
        }
        try {
            TxGroup wsGroup = (TxGroup)pair.getWs();
            for (Taxon taxon : this.ws.getTxGroupTaxa(wsGroup)) {
                if (taxon.getLink() != null) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "You must match all workspace taxa from this group first.", this.getTitle(), 2);
                return;
            }
            DialogMatchTxGroup dialog = new DialogMatchTxGroup((JDialog)((Object)this), true, wsGroup, this.db, this.projID, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (wsGroup != null) {
                this.initData();
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    @Override
    void add() {
        try {
            ArrayList<TxGroup> dbGroups = new ArrayList<TxGroup>();
            for (TxGroup group : this.wsSet.getGroups()) {
                if (group.getLink() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "All groups must be matched! Use 'Save' to add new groups", this.getTitle(), 2);
                    return;
                }
                dbGroups.add(group.getLink());
            }
            DialogSet dialog = new DialogSet((Dialog)((Object)this), true, this.db, this.wsSet.getName(), this.wsSet.getDescr(), this.projID, this.wsSet.isOrdered(), dbGroups);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.dbModel.addElement(dialog.set);
                this.dbModel.setSelectedItem(dialog.set);
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)sql, this.db);
        }
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        int[] selected = this.jTableMatch.getSelectedRows();
        LinkedList<TxGroup> toRemove = new LinkedList<TxGroup>();
        for (int i : selected) {
            TxGroup wsGroup = (TxGroup)this.model.data.get(i).getWs();
            if (wsGroup == null) continue;
            toRemove.add(wsGroup);
        }
        try {
            Object object = toRemove.iterator();
            while (object.hasNext()) {
                TxGroup wsGroup = (TxGroup)object.next();
                this.wsSet.removeGroup(wsGroup.getID());
            }
            this.initData();
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    @Override
    void jTableMouseDoubleClick() {
        this.jButtonMatchGroupActionPerformed();
    }

    @Override
    void OK() {
        if (this.inWizard && this.wsSet.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No database set selected/added", this.getTitle(), 2);
            return;
        }
        try {
            this.wsSet.updateStatus();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error updating status", sql, this.db);
        }
        this.setOK();
    }

    @Override
    void closeWindow() {
        try {
            this.wsSet.updateStatus();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error updating status", sql, this.db);
        }
        super.closeWindow();
    }

    void saveGroups() {
        if (this.wsSet.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No database set selected/added", this.getTitle(), 2);
            return;
        }
        try {
            for (TxGroup group : this.wsSet.getGroups()) {
                if (group.getLink() != null) continue;
                for (Taxon taxon : this.ws.getTxGroupTaxa(group)) {
                    if (taxon.getLink() != null) continue;
                    JOptionPane.showMessageDialog((Component)((Object)this), "Groups cannot be saved because there are unmatched taxa.", this.getTitle(), 2);
                    return;
                }
            }
            for (TxGroup group : this.wsSet.getGroups()) {
                if (group.getLink() != null) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "Workspace group '" + String.valueOf(group) + "' is not matched.", this.getTitle(), 2);
                return;
            }
            List<TxGroup> dbGroups = this.wsSet.getLink().getGroups();
            for (TxGroup group : this.wsSet.getGroups()) {
                if (dbGroups.contains(group.getLink())) continue;
                dbGroups.add(group.getLink());
            }
            this.wsSet.getLink().update(this.wsSet.getLink().getName(), this.wsSet.getLink().getProjID(), dbGroups, this.wsSet.getLink().isOrdered(), this.wsSet.getLink().getDescr());
            this.wsSet.updateStatus();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException e) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
    }

    private static class TableModelMatchSet
    extends AbstractTableModel {
        static final int COL_DONOR_GROUP = 0;
        static final int COL_DONOR_TAXA = 1;
        static final int COL_DONOR_GENERA = 2;
        static final int COL_ARROW = 3;
        static final int COL_HOST_GROUP = 4;
        static final int COL_HOST_TAXA = 5;
        static final int COL_HOST_GENERA = 6;
        static final String[] colTitles = new String[]{"Group", "No. Taxa", "No. Genera", "", "Group", "No. Taxa", "No. Genera"};
        static final int[] colWidths = new int[]{120, 20, 20, 20, 120, 20, 20};
        private MatchData data;

        private TableModelMatchSet() {
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MatchData.MatchPair pair = this.data.get(rowIndex);
            if (pair == null) {
                return "";
            }
            TxGroup ws = (TxGroup)pair.getWs();
            TxGroup db = (TxGroup)pair.getDb();
            try {
                switch (columnIndex) {
                    case 0: {
                        return ws == null ? null : new StringStatus(ws.getLink() != null ? ws.getLink().getName() : ws.getName(), ws.getStatus());
                    }
                    case 1: {
                        return ws == null ? null : new StringStatus("" + ws.getSpecSize(), ws.getStatus());
                    }
                    case 2: {
                        return ws == null ? null : new StringStatus("" + ws.getGenSize(), ws.getStatus());
                    }
                    case 3: {
                        return db != null && ws != null ? TableModelSB.linked : TableModelSB.unlinked;
                    }
                    case 4: {
                        return db;
                    }
                    case 5: {
                        return db != null ? "" + db.getSpecSize() : "";
                    }
                    case 6: {
                        return db != null ? "" + db.getGenSize() : "";
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 2: {
                    return StringStatus.class;
                }
                case 3: {
                    return Boolean.class;
                }
                case 4: {
                    return TxGroup.class;
                }
            }
            return String.class;
        }

        void setUpTable(JTable table) {
            TableUtils.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
            }
            columnModel.getColumn(3).setMaxWidth(colWidths[3]);
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Color.class, new ColourRenderer(true));
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        }
    }
}

