/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMergeOcc;
import model3.CoOccurrence;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SBException;
import util.exception.StackError;

public class DialogMergeOccurrences
extends SBDialog {
    private final TableModelMergeOcc model = new TableModelMergeOcc();
    private final SBdb db;
    private ButtonGroup buttonGroupMerge;
    private JButton jButtonCancel;
    private JButton jButtonMerge;
    private JLabel jLabel1;
    private JRadioButton jRadioButtonDeleteDonor;
    private JRadioButton jRadioButtonMerge;
    private JScrollPane jScrollPane1;
    private JTable jTableMergeOcc;

    public DialogMergeOccurrences(JDialog parent, boolean modal, SBdb db, List coOccs) {
        super((Window)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(coOccs);
    }

    private void init(List coOccs) {
        this.setTitle("Merge Occurrences");
        this.getRootPane().setDefaultButton(this.jButtonMerge);
        for (int i = 0; i < TableModelMergeOcc.colTitles.length; ++i) {
            this.jTableMergeOcc.getColumnModel().getColumn(i).setHeaderValue(TableModelMergeOcc.colTitles[i]);
            this.jTableMergeOcc.getColumnModel().getColumn(i).setPreferredWidth(TableModelMergeOcc.colWidths[i]);
        }
        this.model.coOccs = coOccs;
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroupMerge = new ButtonGroup();
        this.jButtonMerge = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMergeOcc = new JTable();
        this.jLabel1 = new JLabel();
        this.jRadioButtonMerge = new JRadioButton();
        this.jRadioButtonDeleteDonor = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 200));
        this.jButtonMerge.setText("Merge");
        this.jButtonMerge.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeOccurrences this$0;
            {
                DialogMergeOccurrences dialogMergeOccurrences = this$0;
                Objects.requireNonNull(dialogMergeOccurrences);
                this.this$0 = dialogMergeOccurrences;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMergeActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMergeOccurrences this$0;
            {
                DialogMergeOccurrences dialogMergeOccurrences = this$0;
                Objects.requireNonNull(dialogMergeOccurrences);
                this.this$0 = dialogMergeOccurrences;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jTableMergeOcc.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMergeOcc);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Warning: to prevent duplicate data the following occurrences must be merged unless you cancel:");
        this.buttonGroupMerge.add(this.jRadioButtonMerge);
        this.jRadioButtonMerge.setText("<html><strong>Merge</strong> taxa, adding abundance and attributes together</html>");
        this.buttonGroupMerge.add(this.jRadioButtonDeleteDonor);
        this.jRadioButtonDeleteDonor.setText("<html><strong>Delete</strong> donor occurrences, leaving target occurrences and attributes unchanged</html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonMerge).add(4, 4, 4).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)).add((Component)this.jRadioButtonMerge).add((Component)this.jRadioButtonDeleteDonor)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 136, -2).addPreferredGap(1).add((Component)this.jRadioButtonMerge, -2, -1, -2).addPreferredGap(0).add((Component)this.jRadioButtonDeleteDonor, -2, -1, -2).addPreferredGap(0, 7, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonMerge).add((Component)this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonMergeActionPerformed(ActionEvent evt) {
        if (this.buttonGroupMerge.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must select a merge option", this.getTitle(), 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (CoOccurrence coOcc : this.model.coOccs) {
                this.db.mergeOcc(coOcc, this.jRadioButtonMerge.isSelected());
            }
            this.setOK();
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

