/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.exception.StackError;

public class DialogMiscColours
extends JDialog {
    SBdb db;
    private JButton jButtonCancel;
    private JButton jButtonHST;
    private JButton jButtonLST;
    private JButton jButtonOK;
    private JButton jButtonTST;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JTextField jTextFieldHST;
    private JTextField jTextFieldLST;
    private JTextField jTextFieldTST;

    public DialogMiscColours(Frame parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Miscellaneous Colours");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldHST.setBackground(this.db.getMiscColour("COL_HST", Color.RED));
        this.jTextFieldTST.setBackground(this.db.getMiscColour("COL_TST", Color.GREEN));
        this.jTextFieldLST.setBackground(this.db.getMiscColour("COL_LST", Color.BLUE));
        if ((this.db.getUser().getPriv() & 0x40) <= 0) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText("You need to be a super user to change these");
        }
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldHST = new JTextField();
        this.jButtonHST = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldTST = new JTextField();
        this.jButtonTST = new JButton();
        this.jButtonLST = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldLST = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMiscColours this$0;
            {
                DialogMiscColours dialogMiscColours = this$0;
                Objects.requireNonNull(dialogMiscColours);
                this.this$0 = dialogMiscColours;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMiscColours this$0;
            {
                DialogMiscColours dialogMiscColours = this$0;
                Objects.requireNonNull(dialogMiscColours);
                this.this$0 = dialogMiscColours;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Highstand systems tract:");
        this.jTextFieldHST.setEditable(false);
        this.jButtonHST.setText("...");
        this.jButtonHST.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMiscColours this$0;
            {
                DialogMiscColours dialogMiscColours = this$0;
                Objects.requireNonNull(dialogMiscColours);
                this.this$0 = dialogMiscColours;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHSTActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Transgressive systems tract:");
        this.jTextFieldTST.setEditable(false);
        this.jButtonTST.setText("...");
        this.jButtonTST.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMiscColours this$0;
            {
                DialogMiscColours dialogMiscColours = this$0;
                Objects.requireNonNull(dialogMiscColours);
                this.this$0 = dialogMiscColours;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTSTActionPerformed(evt);
            }
        });
        this.jButtonLST.setText("...");
        this.jButtonLST.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMiscColours this$0;
            {
                DialogMiscColours dialogMiscColours = this$0;
                Objects.requireNonNull(dialogMiscColours);
                this.this$0 = dialogMiscColours;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLSTActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Lowstand systems tract:");
        this.jTextFieldLST.setEditable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jSeparator1, -1, 224, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabel2).add(2, (Component)this.jLabel1).add(2, (Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jTextFieldTST, -2, 43, -2).add(2, (Component)this.jTextFieldLST, -2, 43, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonLST, 0, 0, Short.MAX_VALUE).add((Component)this.jButtonTST, -2, 32, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldHST, -2, 43, -2).addPreferredGap(0).add((Component)this.jButtonHST, -2, 32, -2)))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldHST, -2, -1, -2).add((Component)this.jButtonHST)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldTST, -2, -1, -2).add((Component)this.jButtonTST)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldLST, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jButtonLST)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 5, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonHSTActionPerformed(ActionEvent evt) {
        Color colour = JColorChooser.showDialog(this, "Select Colour", this.jTextFieldHST.getBackground());
        if (colour != null) {
            this.jTextFieldHST.setBackground(colour);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.db.setMiscColour("COL_HST", this.jTextFieldHST.getBackground());
            this.db.setMiscColour("COL_TST", this.jTextFieldTST.getBackground());
            this.db.setMiscColour("COL_LST", this.jTextFieldLST.getBackground());
            this.db.commit();
            this.dispose();
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
            this.db.doRollback();
        }
    }

    private void jButtonTSTActionPerformed(ActionEvent evt) {
        Color colour = JColorChooser.showDialog(this, "Select Colour", this.jTextFieldTST.getBackground());
        if (colour != null) {
            this.jTextFieldTST.setBackground(colour);
        }
    }

    private void jButtonLSTActionPerformed(ActionEvent evt) {
        Color colour = JColorChooser.showDialog(this, "Select Colour", this.jTextFieldLST.getBackground());
        if (colour != null) {
            this.jTextFieldLST.setBackground(colour);
        }
    }
}

