/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbugs.FrameJsbugs;
import model3.Overlay;
import model3.SBRestrictable;
import model3.SBdb;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogOverlay
extends SBDialog {
    private final SBdb db;
    Overlay overlay = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAlphacode;
    private JCheckBox jCheckBoxCatCols;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelCells;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonMax;
    private JRadioButton jRadioButtonShrink;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerColumns;
    private JSpinner jSpinnerRows;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldName;

    public DialogOverlay(Frame parent, boolean modal, SBdb db, Overlay overlay) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(overlay);
    }

    public DialogOverlay(JDialog parent, boolean modal, SBdb db, Overlay overlay) {
        super((Window)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(overlay);
    }

    private void init(Overlay overlay) {
        if (overlay == null) {
            this.setTitle("Overlay : Add");
        } else {
            this.setTitle("Overlay : Edit " + overlay.getName());
            this.jSpinnerRows.setValue(overlay.getRows());
            this.jSpinnerColumns.setValue(overlay.getCols());
            this.jTextFieldName.setText(overlay.getName());
            this.jTextAreaDescription.setText(overlay.getDescrip());
            this.jCheckBoxAlphacode.setSelected(overlay.useCodes());
            this.jRadioButtonMax.setSelected(overlay.getMaximiseText());
            this.jRadioButtonShrink.setSelected(!overlay.getMaximiseText());
            this.jCheckBoxCatCols.setVisible(false);
        }
        this.calculateCells(true);
        this.overlay = overlay;
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void calculateCells(boolean row) {
        int rows = (Integer)this.jSpinnerRows.getValue();
        int columns = (Integer)this.jSpinnerColumns.getValue();
        int cells = rows * columns;
        this.jLabelCells.setText("" + cells);
        if (this.overlay != null && !this.overlay.checkCapacity(rows, columns)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Warning: this overlay requires more " + (row ? "rows" : "columns"), this.getTitle(), 2);
            if (row) {
                this.jSpinnerRows.setValue((Integer)this.jSpinnerRows.getValue() + 1);
            } else {
                this.jSpinnerColumns.setValue((Integer)this.jSpinnerColumns.getValue() + 1);
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSpinnerRows = new JSpinner();
        this.jSpinnerColumns = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jLabelCells = new JLabel();
        this.jButtonHelp = new JButton();
        this.jRadioButtonMax = new JRadioButton();
        this.jRadioButtonShrink = new JRadioButton();
        this.jCheckBoxAlphacode = new JCheckBox();
        this.jCheckBoxCatCols = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlay this$0;
            {
                DialogOverlay dialogOverlay = this$0;
                Objects.requireNonNull(dialogOverlay);
                this.this$0 = dialogOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlay this$0;
            {
                DialogOverlay dialogOverlay = this$0;
                Objects.requireNonNull(dialogOverlay);
                this.this$0 = dialogOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Name:");
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogOverlay this$0;
            {
                DialogOverlay dialogOverlay = this$0;
                Objects.requireNonNull(dialogOverlay);
                this.this$0 = dialogOverlay;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Description:");
        this.jTextAreaDescription.setColumns(20);
        this.jTextAreaDescription.setFont(this.jTextAreaDescription.getFont());
        this.jTextAreaDescription.setRows(5);
        this.jTextAreaDescription.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogOverlay this$0;
            {
                DialogOverlay dialogOverlay = this$0;
                Objects.requireNonNull(dialogOverlay);
                this.this$0 = dialogOverlay;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextAreaDescriptionKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Overlay size", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel1.setText("Rows:");
        this.jLabel2.setText("Columns:");
        this.jSpinnerRows.setModel(new SpinnerNumberModel(5, 1, 100, 1));
        this.jSpinnerRows.setRequestFocusEnabled(false);
        this.jSpinnerRows.setValue(16);
        this.jSpinnerRows.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogOverlay this$0;
            {
                DialogOverlay dialogOverlay = this$0;
                Objects.requireNonNull(dialogOverlay);
                this.this$0 = dialogOverlay;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jSpinnerRowsStateChanged(evt);
            }
        });
        this.jSpinnerColumns.setModel(new SpinnerNumberModel(5, 0, 100, 1));
        this.jSpinnerColumns.setValue(14);
        this.jSpinnerColumns.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogOverlay this$0;
            {
                DialogOverlay dialogOverlay = this$0;
                Objects.requireNonNull(dialogOverlay);
                this.this$0 = dialogOverlay;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jSpinnerColumnsStateChanged(evt);
            }
        });
        this.jLabel3.setText("Cells:");
        this.jLabelCells.setText("jLabel8");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSpinnerRows).addComponent(this.jSpinnerColumns)).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCells).addGap(162, 162, 162)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerRows, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabelCells)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerColumns, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlay this$0;
            {
                DialogOverlay dialogOverlay = this$0;
                Objects.requireNonNull(dialogOverlay);
                this.this$0 = dialogOverlay;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonMax);
        this.jRadioButtonMax.setSelected(true);
        this.jRadioButtonMax.setText("Maximise text size (may truncate)");
        this.buttonGroup1.add(this.jRadioButtonShrink);
        this.jRadioButtonShrink.setText("Shrink to fit");
        this.jCheckBoxAlphacode.setSelected(true);
        this.jCheckBoxAlphacode.setText("Use alphanumeric codes (where available)");
        this.jCheckBoxCatCols.setText("Show category colours");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jTextFieldName).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonMax).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonShrink)).addComponent(this.jCheckBoxAlphacode).addComponent(this.jCheckBoxCatCols)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 91, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonMax).addComponent(this.jRadioButtonShrink)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAlphacode).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxCatCols).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String name = this.jTextFieldName.getText();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter an overlay name", this.getTitle(), 2);
            return;
        }
        int nrows = (Integer)this.jSpinnerRows.getValue();
        int ncols = (Integer)this.jSpinnerColumns.getValue();
        if (nrows == 0 || ncols == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Must have rows and columns", this.getTitle(), 2);
            return;
        }
        try {
            String descrip = this.jTextAreaDescription.getText();
            if (this.overlay != null) {
                if (!this.overlay.checkCapacity(nrows, ncols)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "You can't make this overlay smaller without clearing some cells", this.getTitle(), 2);
                    return;
                }
                this.overlay.update(name, descrip, nrows, ncols, this.jRadioButtonMax.isSelected(), this.jCheckBoxAlphacode.isSelected());
                this.overlay.notifyObservers();
            } else {
                if (this.db.getOverlay(name) != null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "An overlay of that name already exists", this.getTitle(), 2);
                    return;
                }
                this.overlay = new Overlay(this.db, name, descrip, nrows, ncols, this.jRadioButtonMax.isSelected(), this.jCheckBoxAlphacode.isSelected());
                this.db.addOverlay(this.overlay);
            }
            this.db.commit();
            this.setOK();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
    }

    private void jSpinnerRowsStateChanged(ChangeEvent evt) {
        this.calculateCells(true);
    }

    private void jSpinnerColumnsStateChanged(ChangeEvent evt) {
        this.calculateCells(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)25, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextAreaDescriptionKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaDescription, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogoverlay.html");
    }
}

