/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jsbugs.FrameJsbugs;
import model3.Lastval;
import model3.Overlay;
import model3.SBdb;
import util.SB;
import util.exception.StackError;

public class DialogOverlayWeb
extends JDialog {
    boolean isOk = false;
    int portNo = 4330;
    int textSize = 10;
    SBdb db;
    String myIp = "UNKNOWN";
    boolean useSounds = true;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxSounds;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelBrowserAddress;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerTextSize;
    private JTextField jTextFieldOverlay;
    private JTextField jTextFieldPort;

    public DialogOverlayWeb(Frame parent, boolean modal, SBdb db, Overlay overlay) throws SQLException, UnknownHostException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(overlay);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldOverlay = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldPort = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabelBrowserAddress = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jCheckBoxSounds = new JCheckBox();
        this.jButtonHelp = new JButton();
        this.jLabel8 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSpinnerTextSize = new JSpinner();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Overlay: ");
        this.jTextFieldOverlay.setEditable(false);
        this.jTextFieldOverlay.setText("jTextField1");
        this.jLabel2.setText("Port no:");
        this.jTextFieldPort.setText("4330");
        this.jTextFieldPort.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlayWeb this$0;
            {
                DialogOverlayWeb dialogOverlayWeb = this$0;
                Objects.requireNonNull(dialogOverlayWeb);
                this.this$0 = dialogOverlayWeb;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jTextFieldPortActionPerformed(evt);
            }
        });
        this.jTextFieldPort.addPropertyChangeListener(new PropertyChangeListener(this){
            final /* synthetic */ DialogOverlayWeb this$0;
            {
                DialogOverlayWeb dialogOverlayWeb = this$0;
                Objects.requireNonNull(dialogOverlayWeb);
                this.this$0 = dialogOverlayWeb;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.this$0.jTextFieldPortPropertyChange(evt);
            }
        });
        this.jTextFieldPort.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogOverlayWeb this$0;
            {
                DialogOverlayWeb dialogOverlayWeb = this$0;
                Objects.requireNonNull(dialogOverlayWeb);
                this.this$0 = dialogOverlayWeb;
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                this.this$0.jTextFieldPortKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldPortKeyTyped(evt);
            }
        });
        this.jLabel3.setText("<html>\n<strong>Note:</strong> You may need to configure your firewall to allow use of your selected port.<br>\nYou may also need to configure your router to open the selected port<br>\nSee your network administrator or contact StrataData for help.<br>\n<strong>Note:</strong> You will need to use different port numbers to have different pages open for different wells\n</html>");
        this.jLabel4.setText("<html>After you press OK, Use and bookmark the following address<br>\nin your tablet's browser:</html>");
        this.jLabelBrowserAddress.setFont(new Font("Tahoma", 1, 11));
        this.jLabelBrowserAddress.setText("http://x.x.x.x:x");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlayWeb this$0;
            {
                DialogOverlayWeb dialogOverlayWeb = this$0;
                Objects.requireNonNull(dialogOverlayWeb);
                this.this$0 = dialogOverlayWeb;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlayWeb this$0;
            {
                DialogOverlayWeb dialogOverlayWeb = this$0;
                Objects.requireNonNull(dialogOverlayWeb);
                this.this$0 = dialogOverlayWeb;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel5.setText("<html>Press <strong>Refresh</strong> on the browser window after selecting analyses.</html>");
        this.jLabel6.setText("Text size:");
        this.jLabel7.setText("px");
        this.jCheckBoxSounds.setSelected(true);
        this.jCheckBoxSounds.setText("Use confirmation sound when recording occurrences");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogOverlayWeb this$0;
            {
                DialogOverlayWeb dialogOverlayWeb = this$0;
                Objects.requireNonNull(dialogOverlayWeb);
                this.this$0 = dialogOverlayWeb;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel8.setFont(new Font("Tahoma", 0, 10));
        this.jLabel8.setText("(we recommend using a number in the range 4330-4339)");
        this.jSpinnerTextSize.setModel(new SpinnerNumberModel(10, 6, 60, 1));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldOverlay)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSounds).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPort, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8)).addComponent(this.jLabel4, -2, -1, -2).addComponent(this.jLabelBrowserAddress, -2, 471, -2).addComponent(this.jLabel5, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerTextSize, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -2, -1, -2)))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldOverlay, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPort, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelBrowserAddress).addGap(18, 18, 18).addComponent(this.jLabel5, -2, -1, -2).addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jSpinnerTextSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSounds).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldPortKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldPort, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldPort.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "No port specified", this.getTitle(), 2);
            return;
        }
        try {
            this.portNo = Integer.parseInt(this.jTextFieldPort.getText());
            Lastval.putInt(this.db, "OVPORT", this.portNo);
            this.textSize = Integer.parseInt(this.jSpinnerTextSize.getValue().toString());
            Lastval.putInt(this.db, "OVTEXT", this.textSize);
            this.db.commit();
            this.useSounds = this.jCheckBoxSounds.isSelected();
            this.isOk = true;
            this.dispose();
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
    }

    private void jTextFieldPortActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldPortPropertyChange(PropertyChangeEvent evt) {
    }

    private void jTextFieldPortKeyReleased(KeyEvent evt) {
        this.putAddr();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogoverlayweb.html");
    }

    private void init(Overlay overlay) throws SQLException, UnknownHostException {
        this.setTitle("Overlay Web Server Parameters");
        this.jTextFieldOverlay.setText(overlay.getName());
        this.portNo = Lastval.getInt(this.db, "OVPORT");
        if (this.portNo > 0) {
            this.jTextFieldPort.setText("" + this.portNo);
        }
        if ((this.textSize = Lastval.getInt(this.db, "OVTEXT")) > 0) {
            this.jSpinnerTextSize.setValue(this.textSize);
        }
        try {
            InetAddress[] addrs;
            String hostName = InetAddress.getLocalHost().getHostName();
            for (InetAddress addr : addrs = InetAddress.getAllByName(hostName)) {
                System.out.println("addr.getHostAddress() = " + addr.getHostAddress());
                System.out.println("addr.getHostName() = " + addr.getHostName());
                System.out.println("");
                if (addr.isLoopbackAddress() || !addr.isSiteLocalAddress()) continue;
                this.myIp = addr.getHostAddress();
            }
            System.out.println("\nIP = " + this.myIp);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.putAddr();
    }

    private void putAddr() {
        if (this.jTextFieldPort.getText().length() > 0) {
            this.portNo = Integer.parseInt(this.jTextFieldPort.getText());
            this.jLabelBrowserAddress.setText("http://" + this.myIp + ":" + this.portNo);
        }
    }
}

