/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.db.DBType;
import com.stratadata.model3.user.Userdef;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationTemplate;
import jsbugs.DialogCountryRoles;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.DialogSelectAnalyst;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import model3.TxGroup;
import model3.TxGroupSet;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogPermissions
extends SBDialog {
    private final SBRestrictable dbObject;
    private final SBdb sbdb;
    private final TableModelAcl model = new TableModelAcl();
    private final ChartManager chartManager;
    private static final String publicRWText = "<html>Any unrestricted user can read & edit. No key holders required.</html>";
    private static final String publicROText = "<html>Can't be edited, but can be read by all. Can be unlocked by a key holder on the list.</html>";
    private static final String restrictedRWText = "<html>Users in list can read & edit. Hidden from other users.</html>";
    private static final String restrictedROText = "<html>Users in list can read. Hidden from other users.</html>";
    private boolean canUpdatePermissions = true;
    private ButtonGroup buttonGroupLevel;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonRemove;
    private JButton jButtonSaveAcl;
    private JCheckBox jCheckBoxHidden;
    private JLabel jLabel2;
    private JLabel jLabelDeniedReason;
    private JLabel jLabelPriv;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonPublicRO;
    private JRadioButton jRadioButtonPublicRW;
    private JRadioButton jRadioButtonRestrictedRO;
    private JRadioButton jRadioButtonRestrictedRW;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTable jTableACL;

    public DialogPermissions(Frame parent, boolean modal, SBdb db, SBRestrictable o, ChartManager chartManager) throws SQLException, SBException {
        super(parent, modal);
        this.dbObject = o;
        this.sbdb = db;
        this.chartManager = chartManager;
        this.initComponents();
        this.init();
    }

    public DialogPermissions(Dialog parent, boolean modal, SBdb db, SBRestrictable o, ChartManager chartManager) throws SQLException, SBException {
        super((Window)parent, modal);
        this.dbObject = o;
        this.sbdb = db;
        this.chartManager = chartManager;
        this.initComponents();
        this.init();
        if (this.jButtonOK.isEnabled()) {
            this.jButtonSaveAcl.setEnabled(false);
        }
    }

    private void init() throws SQLException, SBException {
        TxGroupSet set;
        this.setTitle("Permissions : " + ((Object)((Object)this.dbObject)).toString());
        this.model.setupTable(this.jTableACL);
        switch (this.dbObject.getAcm(true)) {
            case 0: {
                this.jRadioButtonPublicRW.setSelected(true);
                this.jLabelPriv.setText(publicRWText);
                break;
            }
            case 128: {
                this.jRadioButtonPublicRO.setSelected(true);
                this.jLabelPriv.setText(publicROText);
                this.setAcl();
                break;
            }
            case 1024: {
                this.jRadioButtonRestrictedRW.setSelected(true);
                this.jLabelPriv.setText(restrictedRWText);
                this.setAcl();
                break;
            }
            case 512: {
                this.jRadioButtonRestrictedRO.setSelected(true);
                this.jLabelPriv.setText(restrictedROText);
                this.setAcl();
            }
        }
        if (!this.dbObject.isRestrictable()) {
            this.jRadioButtonRestrictedRO.setEnabled(false);
            this.jRadioButtonRestrictedRW.setEnabled(false);
        }
        if (this.dbObject.isHideable() && this.sbdb.getDBType() == DBType.MSSQLSERVER && DialogCountryRoles.checkSecurityFunctionExists(this.sbdb)) {
            this.jCheckBoxHidden.setEnabled(true);
            if (this.dbObject.isHidden()) {
                this.jCheckBoxHidden.setSelected(true);
            }
        } else {
            this.jCheckBoxHidden.setEnabled(false);
        }
        if (this.sbdb.getUser().isReadOnly()) {
            this.canUpdatePermissions = false;
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(SBRestrictable.getDeniedReason(false));
            return;
        }
        Object tooltip = "<html>This item is locked and you do not have permission to unlock it.";
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0 && ((this.sbdb.getUser().getPriv() & 0x400) == 0 || !this.dbObject.canWrite(this.sbdb, null) && !this.dbObject.canRestrict(this.sbdb, null))) {
            this.canUpdatePermissions = false;
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText((String)tooltip);
            return;
        }
        boolean OKenabled = this.jButtonOK.isEnabled();
        if (this.dbObject instanceof TxGroup && !this.dbObject.canWrite(this.sbdb, null)) {
            tooltip = "<html>You can't change permissions on this group, as a member of the following read-only sets:<br>";
            TxGroup group = (TxGroup)this.dbObject;
            for (TxGroupSet txGroupSet : this.sbdb.getTxGroupSets(group)) {
                if (txGroupSet.canWrite(this.sbdb, null)) continue;
                tooltip = (String)tooltip + txGroupSet.getName() + "<br>";
                OKenabled = false;
            }
        }
        if (this.dbObject instanceof TxGroupSet && (set = (TxGroupSet)this.dbObject).canWrite(this.sbdb, null)) {
            tooltip = "<html>You can't lock this set because the following groups are unlocked:<br>";
            for (TxGroup txGroup : set.getGroups()) {
                if (!txGroup.canWrite(this.sbdb, null)) continue;
                OKenabled = false;
                tooltip = (String)tooltip + txGroup.getName() + "<br>";
            }
        }
        if (this.dbObject instanceof ChartTemplate && this.dbObject.canWrite(this.sbdb, null)) {
            ChartTemplate templ = (ChartTemplate)this.dbObject;
            if (this.chartManager == null) {
                throw new SBException("Chart manager null for chart template permissions");
            }
            tooltip = "<html>You can't lock this chart template because the following elements are unlocked:<br>";
            String s = this.chartManager.getCanWrite(templ);
            if (!s.isEmpty()) {
                OKenabled = false;
                tooltip = (String)tooltip + s;
            }
        }
        if (this.dbObject instanceof CorrelationTemplate) {
            tooltip = "<html>You can't change permissions on this template, as a member of the following read-only charts:<br>";
            CorrelationTemplate corrTemplate = (CorrelationTemplate)this.dbObject;
            if (!this.dbObject.canWrite(this.sbdb, null)) {
                for (ChartTemplateBase chartTemplateBase : this.chartManager.searchCharts(corrTemplate.getID(), false)) {
                    if (chartTemplateBase.canWrite(this.sbdb, null)) continue;
                    tooltip = (String)tooltip + chartTemplateBase.getName() + "<br>";
                    OKenabled = false;
                }
            }
        }
        if (this.dbObject instanceof BlockTemplate) {
            BlockTemplate blockTemplate = (BlockTemplate)this.dbObject;
            if (!this.dbObject.canWrite(this.sbdb, null)) {
                tooltip = "<html>You can't change permissions on this template, as a member of the following read-only charts:<br>";
                for (ChartTemplateBase chartTemplateBase : this.chartManager.searchCharts(blockTemplate.getID(), false)) {
                    if (chartTemplateBase.canWrite(this.sbdb, null)) continue;
                    tooltip = (String)tooltip + chartTemplateBase.getName() + "<br>";
                    OKenabled = false;
                }
            } else {
                tooltip = "<html>You can't change permissions on this template, because it contains the following unlocked panels:<br>";
                for (Integer n : blockTemplate.getPanelIDs()) {
                    PanelTemplate templ = this.chartManager.getPanelTemplate(n);
                    if (!templ.isVisible() || !templ.canWrite(this.sbdb, null)) continue;
                    tooltip = (String)tooltip + templ.getName() + "<br>";
                    OKenabled = false;
                }
            }
        }
        if (this.dbObject instanceof PanelTemplate) {
            tooltip = "<html>You can't change permissions on this panel template, as a member of the following read-only blocks:<br>";
            PanelTemplate panelTemplate = (PanelTemplate)this.dbObject;
            if (!this.dbObject.canWrite(this.sbdb, null)) {
                for (BlockTemplate blockTemplate : this.chartManager.searchBlocks(panelTemplate.getID())) {
                    if (blockTemplate.canWrite(this.sbdb, null)) continue;
                    tooltip = (String)tooltip + blockTemplate.getName() + "<br>";
                    OKenabled = false;
                }
            }
        }
        tooltip = (String)tooltip + "</html>";
        if (!OKenabled) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText((String)tooltip);
            this.jLabelDeniedReason.setText((String)tooltip);
        } else {
            this.jLabelDeniedReason.setText("");
        }
        this.pack();
    }

    private void setAcl() throws SQLException {
        this.model.acl = new LinkedHashSet<Userdef>(this.dbObject.getAcl(this.sbdb));
    }

    private void initComponents() {
        this.buttonGroupLevel = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonPublicRW = new JRadioButton();
        this.jRadioButtonPublicRO = new JRadioButton();
        this.jRadioButtonRestrictedRW = new JRadioButton();
        this.jRadioButtonRestrictedRO = new JRadioButton();
        this.jLabelPriv = new JLabel();
        this.jLabelDeniedReason = new JLabel();
        this.jCheckBoxHidden = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTableACL = new JTable();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jButtonSaveAcl = new JButton();
        this.jSeparator2 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Permission Level", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupLevel.add(this.jRadioButtonPublicRW);
        this.jRadioButtonPublicRW.setText("Public Read/Write");
        this.jRadioButtonPublicRW.setFocusable(false);
        this.jRadioButtonPublicRW.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPublicRWActionPerformed(evt);
            }
        });
        this.buttonGroupLevel.add(this.jRadioButtonPublicRO);
        this.jRadioButtonPublicRO.setText("Public Read Only");
        this.jRadioButtonPublicRO.setFocusable(false);
        this.jRadioButtonPublicRO.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPublicROActionPerformed(evt);
            }
        });
        this.buttonGroupLevel.add(this.jRadioButtonRestrictedRW);
        this.jRadioButtonRestrictedRW.setText("Restricted Read/Write");
        this.jRadioButtonRestrictedRW.setFocusable(false);
        this.jRadioButtonRestrictedRW.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonRestrictedRWActionPerformed(evt);
            }
        });
        this.buttonGroupLevel.add(this.jRadioButtonRestrictedRO);
        this.jRadioButtonRestrictedRO.setText("Restricted Read Only");
        this.jRadioButtonRestrictedRO.setFocusable(false);
        this.jRadioButtonRestrictedRO.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonRestrictedROActionPerformed(evt);
            }
        });
        this.jLabelPriv.setForeground(new Color(51, 102, 204));
        this.jLabelPriv.setText("jLabel7");
        this.jLabelDeniedReason.setForeground(new Color(204, 0, 0));
        this.jLabelDeniedReason.setText("jLabel1");
        this.jCheckBoxHidden.setText("Hidden from unauthorised users");
        this.jCheckBoxHidden.setToolTipText("Prevents access from users assigned role in SQL server");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDeniedReason, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonRestrictedRO).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonPublicRW, -2, 118, -2).addComponent(this.jRadioButtonPublicRO).addComponent(this.jRadioButtonRestrictedRW)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jCheckBoxHidden, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.jLabelPriv, -2, 185, -2))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jRadioButtonPublicRO, this.jRadioButtonPublicRW, this.jRadioButtonRestrictedRO, this.jRadioButtonRestrictedRW);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabelPriv, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonPublicRW).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonPublicRO).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonRestrictedRW).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonRestrictedRO))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxHidden).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.jLabelDeniedReason, -2, 14, -2)));
        jPanel1Layout.linkSize(1, this.jRadioButtonPublicRO, this.jRadioButtonPublicRW, this.jRadioButtonRestrictedRO, this.jRadioButtonRestrictedRW);
        this.jTableACL.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableACL);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel2.setForeground(new Color(51, 102, 204));
        this.jLabel2.setText("Users & Key holders:");
        this.jButtonSaveAcl.setText("Save");
        this.jButtonSaveAcl.setToolTipText("Updates users and key holders in database");
        this.jButtonSaveAcl.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPermissions this$0;
            {
                DialogPermissions dialogPermissions = this$0;
                Objects.requireNonNull(dialogPermissions);
                this.this$0 = dialogPermissions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAclActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonRemove, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveAcl, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveAcl)).addComponent(this.jScrollPane1, -2, 105, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addGap(20, 20, 20)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            int perm = this.getPerm();
            if (!this.saveAcl(perm)) {
                return;
            }
            this.dbObject.updateAcm(this.sbdb, null, perm);
            this.sbdb.commit();
            this.setOK();
        }
        catch (SQLException | SBException | SBPermissionException sbe) {
            SbugsExceptionHandler.showStackError("Error saving permissions", sbe, (Component)((Object)this));
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogpermissions.html");
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.sbdb, false);
            dialog.setVisible(true);
            if (dialog.selectedUser != null) {
                if (this.model.acl == null) {
                    this.model.acl = new LinkedHashSet();
                }
                if (this.model.acl.contains(dialog.selectedUser)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "User already in list!", this.getTitle(), 2);
                    return;
                }
                this.model.acl.add(dialog.selectedUser);
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex);
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.model.acl == null || this.model.acl.isEmpty() || this.jTableACL.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No row selected", this.getTitle(), 2);
            return;
        }
        ArrayList<Userdef> toRemove = new ArrayList<Userdef>();
        Object object = this.jTableACL.getSelectedRows();
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = object[i];
            toRemove.add((Userdef)this.model.acl.toArray()[i2]);
        }
        object = toRemove.iterator();
        while (object.hasNext()) {
            Userdef user = (Userdef)object.next();
            this.model.acl.remove(user);
        }
        this.model.fireTableDataChanged();
    }

    private void jRadioButtonPublicRWActionPerformed(ActionEvent evt) {
        this.jLabelPriv.setText(publicRWText);
    }

    private void jRadioButtonPublicROActionPerformed(ActionEvent evt) {
        this.jLabelPriv.setText(publicROText);
    }

    private void jRadioButtonRestrictedRWActionPerformed(ActionEvent evt) {
        this.jLabelPriv.setText(restrictedRWText);
    }

    private void jRadioButtonRestrictedROActionPerformed(ActionEvent evt) {
        this.jLabelPriv.setText(restrictedROText);
    }

    private void jButtonSaveAclActionPerformed(ActionEvent evt) {
        try {
            if (!this.saveAcl(this.getPerm())) {
                return;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "Values saved", this.getTitle(), 1);
        }
        catch (SQLException | SBException | SBPermissionException sbe) {
            SbugsExceptionHandler.showStackError("Error saving permissions", sbe, (Component)((Object)this));
        }
    }

    private int getPerm() {
        int perm = 0;
        if (this.jRadioButtonPublicRO.isSelected()) {
            perm = 128;
        } else if (this.jRadioButtonRestrictedRO.isSelected()) {
            perm = 512;
        } else if (this.jRadioButtonRestrictedRW.isSelected()) {
            perm = 1024;
        }
        if (this.jCheckBoxHidden.isSelected()) {
            perm |= 2;
        }
        return perm;
    }

    private boolean saveAcl(int perm) throws SQLException, SBException, SBPermissionException {
        if (perm == 0 || perm == 2) {
            String msg;
            if (this.model.acl != null && !this.model.acl.isEmpty() && JOptionPane.showConfirmDialog((Component)((Object)this), msg = "No key holders are required for 'public' level.\nAll users will be cleared from list.\nContinue?", this.getTitle(), 0, 3) != 0) {
                return false;
            }
            this.model.acl = null;
        } else {
            if (this.model.acl == null) {
                this.model.acl = new LinkedHashSet();
            }
            if (!this.model.acl.contains(this.sbdb.getUser())) {
                int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you want to add yourself to the list of users?", this.getTitle(), 0);
                if (opt == 2) {
                    return false;
                }
                if (opt == 0) {
                    this.model.acl.add(this.sbdb.getUser());
                }
            }
            if (this.model.acl.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You must select at least one key user.", this.getTitle(), 2);
                return false;
            }
            Iterator it = this.model.acl.iterator();
            boolean keyFound = false;
            while (it.hasNext()) {
                Userdef user = (Userdef)it.next();
                if ((user.getPriv() & 0x400) <= 0) continue;
                keyFound = true;
                break;
            }
            if (!keyFound) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You must select at least one key user.", this.getTitle(), 2);
                return false;
            }
        }
        this.dbObject.setAcl(this.sbdb, this.model.acl, perm);
        this.sbdb.commit();
        return true;
    }

    private static class TableModelAcl
    extends AbstractTableModel {
        LinkedHashSet<Userdef> acl;
        static String[] titles = new String[]{"User ID", "Name", "Status"};
        static int[] widths = new int[]{20, 50, 20};

        private TableModelAcl() {
        }

        @Override
        public int getColumnCount() {
            return titles.length;
        }

        @Override
        public int getRowCount() {
            if (this.acl == null) {
                return 0;
            }
            return this.acl.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Userdef[] l = new Userdef[this.acl.size()];
            l = this.acl.toArray(l);
            Userdef user = l[row];
            switch (col) {
                case 0: {
                    return user.getAbr();
                }
                case 1: {
                    return user.getName();
                }
            }
            return (user.getPriv() & 0x400) > 0 ? "Key holder" : "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                default: 
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                default: 
            }
            return String.class;
        }

        void setupTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                TableColumn column = table.getColumnModel().getColumn(table.convertColumnIndexToView(i));
                column.setHeaderValue(titles[i]);
                column.setPreferredWidth(widths[i]);
            }
        }
    }
}

