/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbchart.block.LocationBlock;
import jsbchart.panel.PanelProjectLocation;
import jsbugs.FrameProjectLocation;
import jsbugs.chart.DialogChartProperties;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.Well;
import model3.project.WellList;

public class DialogProjectLocProps
extends JDialog {
    WellList wellList;
    boolean isOK = false;
    PanelProjectLocation panel;
    FrameProjectLocation parent;
    SBdb db;
    DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    LocationBlock block;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCancel;
    private JButton jButtonFont;
    private JButton jButtonOK;
    private JComboBox jComboBoxScale;
    private JComboBox jComboBoxWells;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonF;
    private JRadioButton jRadioButtonM;
    private JSeparator jSeparator1;

    public DialogProjectLocProps(Frame parent, boolean modal, SBdb db, WellList wellList, PanelProjectLocation panel, LocationBlock block) {
        super(parent, modal);
        this.wellList = wellList;
        this.panel = panel;
        this.parent = (FrameProjectLocation)parent;
        this.db = db;
        this.block = block;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Sidetrack Chart Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.fillWellCombo();
        if (this.panel.getUnits() == 'M') {
            this.jRadioButtonM.setSelected(true);
        } else {
            this.jRadioButtonF.setSelected(true);
        }
        try {
            this.db.getChartScales(this.scaleModel);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("SQL Error loading scales", sql, this);
        }
        String sScale = Integer.toString((int)this.block.scale);
        if (this.scaleModel.getIndexOf(sScale) < 0) {
            this.scaleModel.addElement(sScale);
        }
        this.scaleModel.setSelectedItem(sScale);
    }

    private void fillWellCombo() {
        this.jComboBoxWells.removeAllItems();
        Iterator it = this.db.getWellService().getWellListWells(this.wellList.getID());
        while (it.hasNext()) {
            Well well = (Well)it.next();
            this.jComboBoxWells.addItem(well);
        }
        if (this.panel.getWellIndex() != null) {
            this.jComboBoxWells.setSelectedItem(this.panel.getWellIndex());
        }
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxWells = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonFont = new JButton();
        this.jPanel1 = new JPanel();
        this.jComboBoxScale = new JComboBox();
        this.jRadioButtonM = new JRadioButton();
        this.jRadioButtonF = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogProjectLocProps this$0;
            {
                DialogProjectLocProps dialogProjectLocProps = this$0;
                Objects.requireNonNull(dialogProjectLocProps);
                this.this$0 = dialogProjectLocProps;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogProjectLocProps this$0;
            {
                DialogProjectLocProps dialogProjectLocProps = this$0;
                Objects.requireNonNull(dialogProjectLocProps);
                this.this$0 = dialogProjectLocProps;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Use spud point of well:");
        this.jComboBoxWells.setToolTipText("<html>Only wells with the same spud location <br>as this well will be plotted</html>");
        this.jButtonFont.setText("Fonts...");
        this.jButtonFont.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogProjectLocProps this$0;
            {
                DialogProjectLocProps dialogProjectLocProps = this$0;
                Objects.requireNonNull(dialogProjectLocProps);
                this.this$0 = dialogProjectLocProps;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFontActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Scale and units", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jComboBoxScale.setEditable(true);
        this.jComboBoxScale.setModel(this.scaleModel);
        this.buttonGroupUnits.add(this.jRadioButtonM);
        this.jRadioButtonM.setText("Metres");
        this.buttonGroupUnits.add(this.jRadioButtonF);
        this.jRadioButtonF.setText("Feet");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonM).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonF)).addComponent(this.jComboBoxScale, -2, 115, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBoxScale, -2, -1, -2).addGap(7, 7, 7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonM).addComponent(this.jRadioButtonF)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFont)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxWells, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxWells, -2, -1, -2).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.jPanel1, -2, -1, -2)).addComponent(this.jButtonFont)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 7, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float scale;
        this.panel.setWellIndex((Well)this.jComboBoxWells.getSelectedItem());
        this.block.scale = scale = Float.parseFloat(String.valueOf(this.jComboBoxScale.getSelectedItem()));
        this.panel.setUnits(this.jRadioButtonM.isSelected() ? (char)'M' : 'F');
        this.isOK = true;
        this.dispose();
    }

    private void jButtonFontActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogChartProperties dialog = new DialogChartProperties(this, true, this.parent.chart.getProperties(), this.db);
        dialog.setLocationRelativeTo(this);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
    }
}

