/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import jsbchart.core.ChartManager;
import jsbugs.FrameJsbugs;
import jsbugs.list.RestrictableListRenderer;
import jsbugs.model2.event.DialogCmpStd;
import model3.CompositeStandard;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.SbugsOptionToggle;
import util.exception.StackError;

public class DialogSelectCmpStd
extends JDialog {
    private final SBdb db;
    private final DefaultListModel listModel = new DefaultListModel();
    CompositeStandard selection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonCopy;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JList jListStd;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToggleButton jToggleButton1;

    public DialogSelectCmpStd(Frame parent, boolean modal, SBdb db, boolean toSelect) throws SQLException {
        super(parent, modal);
        this.db = db;
        if (toSelect) {
            this.setTitle("Composite Standard : Select");
        } else {
            this.setTitle("Composite Standards");
        }
        this.initComponents();
        this.init(toSelect);
    }

    public DialogSelectCmpStd(JDialog parent, boolean modal, SBdb db) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.setTitle("Composite Standard : Select");
        this.initComponents();
        this.init(true);
    }

    private void init(boolean toSelect) throws SQLException {
        List<CompositeStandard> stds = this.db.getCompositeStandards();
        this.listModel.clear();
        for (CompositeStandard o : stds) {
            this.listModel.addElement(o);
        }
        this.jListStd.setModel(this.listModel);
        this.jListStd.updateUI();
        if (!toSelect) {
            this.jButtonOK.setVisible(false);
            this.jButtonCancel.setText("Close");
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
        this.jListStd.setCellRenderer(new RestrictableListRenderer());
        ((SbugsOptionToggle)this.jToggleButton1).addComponents(!toSelect, new JComponent[]{this.jButtonAdd, this.jButtonEdit, this.jButtonDelete, this.jButtonCopy, this.jSeparator1});
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListStd = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonCopy = new JButton();
        this.jToggleButton1 = new SbugsOptionToggle();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 375));
        this.setModal(true);
        this.setName("Select Scheme");
        this.jListStd.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListStd.setModel(new AbstractListModel(this){
            String[] strings;
            final /* synthetic */ DialogSelectCmpStd this$0;
            {
                DialogSelectCmpStd dialogSelectCmpStd = this$0;
                Objects.requireNonNull(dialogSelectCmpStd);
                this.this$0 = dialogSelectCmpStd;
                this.strings = new String[]{"model"};
            }

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListStd.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectCmpStd this$0;
            {
                DialogSelectCmpStd dialogSelectCmpStd = this$0;
                Objects.requireNonNull(dialogSelectCmpStd);
                this.this$0 = dialogSelectCmpStd;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListStdMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListStd);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectCmpStd this$0;
            {
                DialogSelectCmpStd dialogSelectCmpStd = this$0;
                Objects.requireNonNull(dialogSelectCmpStd);
                this.this$0 = dialogSelectCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectCmpStd this$0;
            {
                DialogSelectCmpStd dialogSelectCmpStd = this$0;
                Objects.requireNonNull(dialogSelectCmpStd);
                this.this$0 = dialogSelectCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectCmpStd this$0;
            {
                DialogSelectCmpStd dialogSelectCmpStd = this$0;
                Objects.requireNonNull(dialogSelectCmpStd);
                this.this$0 = dialogSelectCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectCmpStd this$0;
            {
                DialogSelectCmpStd dialogSelectCmpStd = this$0;
                Objects.requireNonNull(dialogSelectCmpStd);
                this.this$0 = dialogSelectCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectCmpStd this$0;
            {
                DialogSelectCmpStd dialogSelectCmpStd = this$0;
                Objects.requireNonNull(dialogSelectCmpStd);
                this.this$0 = dialogSelectCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectCmpStd this$0;
            {
                DialogSelectCmpStd dialogSelectCmpStd = this$0;
                Objects.requireNonNull(dialogSelectCmpStd);
                this.this$0 = dialogSelectCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCopy.setText("Copy...");
        this.jButtonCopy.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectCmpStd this$0;
            {
                DialogSelectCmpStd dialogSelectCmpStd = this$0;
                Objects.requireNonNull(dialogSelectCmpStd);
                this.this$0 = dialogSelectCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyActionPerformed(evt);
            }
        });
        this.jToggleButton1.setText(">");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 226, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jSeparator1).add(2, (Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCopy)).add((Component)this.jToggleButton1, -2, 40, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCopy, this.jButtonDelete, this.jButtonEdit}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToggleButton1).addPreferredGap(0).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonCopy).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 350, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jListStdMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.jButtonOK.isVisible()) {
                this.jButtonOKActionPerformed(null);
            } else {
                this.jButtonEditActionPerformed(null);
            }
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListStd.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No selection", this.getTitle(), 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogCmpStd dialog = new DialogCmpStd(this, true, this.db, (CompositeStandard)this.jListStd.getSelectedValue());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.init(this.jButtonOK.isVisible());
            }
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error opening dialog", (Exception)e, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selection = (CompositeStandard)this.jListStd.getSelectedValue();
        if (this.selection == null) {
            JOptionPane.showMessageDialog(this, "Select a Composite Standard", this.getTitle(), 1);
            return;
        }
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogCmpStd dialog = new DialogCmpStd(this, true, this.db, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.init(this.jButtonOK.isVisible());
            }
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error opening dialog", (Exception)e, this.db);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListStd.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No selection", this.getTitle(), 2);
            return;
        }
        if (this.jListStd.getSelectedValuesList().size() > 1) {
            JOptionPane.showMessageDialog(this, "Select one from the list to delete.", this.getTitle(), 2);
            return;
        }
        try {
            CompositeStandard toDelete = (CompositeStandard)this.jListStd.getSelectedValue();
            if (!ChartManager.checkDeleteCmpStd(this.db, toDelete.getID())) {
                JOptionPane.showMessageDialog(this, "You can't delete this Composite Standard because it is used in charts.", "Delete Comp.", 2);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Really delete '" + toDelete.getName() + "'?", this.getTitle(), 0, 2) == 0) {
                this.db.deleteCompositeStandard(toDelete);
                this.db.commit();
                this.init(this.jButtonOK.isVisible());
            }
        }
        catch (SBException sbe) {
            FrameJsbugs.showStackError("Error", (Exception)((Object)sbe), this.db);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtousecmpstds.html");
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
        if (this.jListStd.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No selection", this.getTitle(), 2);
            return;
        }
        try {
            CompositeStandard cmpStd = (CompositeStandard)this.jListStd.getSelectedValue();
            String newNameObj = JOptionPane.showInputDialog(this, "Enter name of new copy:", cmpStd.getName());
            if (newNameObj == null || newNameObj.toString().trim().isEmpty()) {
                return;
            }
            String newName = newNameObj.toString();
            this.db.copyCompositeStandard(cmpStd, newName);
            this.init(this.jButtonOK.isVisible());
        }
        catch (InvalidFieldException | SBPermissionException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    public CompositeStandard getSelection() {
        return this.selection;
    }
}

