/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jsbchart.core.ChartManager;
import jsbugs.DialogProject;
import jsbugs.DialogSelectProject;
import jsbugs.sbdb.ProjectUtils;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import model3.exception.SuppressedSQLException;
import model3.project.Project;
import model3.project.WellList;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogSelectProjectWellList
extends JDialog {
    private final SBdb sbdb;
    private final ChartManager chartManager;
    private final DefaultComboBoxModel comboBoxModelProjects = new DefaultComboBoxModel();
    private final DefaultListModel model = new DefaultListModel();
    private Project project;
    private WellList selection = null;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonOK;
    private JButton jButtonProjects;
    private JComboBox<String> jComboBoxProject;
    private JLabel jLabelProject;
    private JList jListWellLists;
    private JScrollPane jScrollPane1;

    public DialogSelectProjectWellList(Window parent, SBdb sbdb, Project project, ChartManager chartManager) throws SuppressedSQLException {
        super(parent, Dialog.DEFAULT_MODALITY_TYPE);
        this.sbdb = sbdb;
        this.chartManager = chartManager;
        this.initComponents();
        this.init(project);
    }

    private void init(Project project) throws SuppressedSQLException {
        this.setTitle("Well List : Select");
        this.jComboBoxProject.setModel(this.comboBoxModelProjects);
        if (project != null) {
            this.project = project;
            this.comboBoxModelProjects.addElement(project);
            this.comboBoxModelProjects.setSelectedItem((Object)project);
            this.jComboBoxProject.setEnabled(false);
            this.jButtonProjects.setEnabled(false);
            this.jLabelProject.setEnabled(false);
        } else {
            this.initProjectList();
        }
        this.initWellLists();
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jListWellLists.repaint();
        if (this.chartManager == null) {
            this.jButtonDelete.setVisible(false);
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jButtonAdd.setEnabled(false);
            this.jButtonEdit.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initProjectList() throws SuppressedSQLException {
        Project selectedProject = null;
        Object object = this.jComboBoxProject.getSelectedItem();
        if (object instanceof Project) {
            Project p;
            selectedProject = p = (Project)((Object)object);
        }
        this.comboBoxModelProjects.removeAllElements();
        ProjectUtils.loadProjectCombo(this.sbdb, this.comboBoxModelProjects, true);
        this.jComboBoxProject.setSelectedItem((Object)selectedProject);
    }

    private void initWellLists() {
        Object pSelection = this.jListWellLists.getSelectedValue();
        this.model.removeAllElements();
        if (this.project != null) {
            List list = this.sbdb.getWellListService().getWellLists(this.project.getID());
            Collections.sort(list);
            this.model.addAll(list);
            if (this.model.getSize() == 1) {
                this.jListWellLists.setSelectedIndex(0);
            } else if (pSelection != null) {
                this.jListWellLists.setSelectedValue(pSelection, true);
            }
        }
        this.jListWellLists.repaint();
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListWellLists = new JList();
        this.jButtonOK = new JButton();
        this.jLabelProject = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jButtonProjects = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 300));
        this.jButtonAdd.setFont(this.jButtonAdd.getFont());
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProjectWellList this$0;
            {
                DialogSelectProjectWellList dialogSelectProjectWellList = this$0;
                Objects.requireNonNull(dialogSelectProjectWellList);
                this.this$0 = dialogSelectProjectWellList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setFont(this.jButtonEdit.getFont());
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProjectWellList this$0;
            {
                DialogSelectProjectWellList dialogSelectProjectWellList = this$0;
                Objects.requireNonNull(dialogSelectProjectWellList);
                this.this$0 = dialogSelectProjectWellList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setFont(this.jButtonDelete.getFont());
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProjectWellList this$0;
            {
                DialogSelectProjectWellList dialogSelectProjectWellList = this$0;
                Objects.requireNonNull(dialogSelectProjectWellList);
                this.this$0 = dialogSelectProjectWellList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setFont(this.jButtonClose.getFont());
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProjectWellList this$0;
            {
                DialogSelectProjectWellList dialogSelectProjectWellList = this$0;
                Objects.requireNonNull(dialogSelectProjectWellList);
                this.this$0 = dialogSelectProjectWellList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jListWellLists.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListWellLists.setModel(this.model);
        this.jListWellLists.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectProjectWellList this$0;
            {
                DialogSelectProjectWellList dialogSelectProjectWellList = this$0;
                Objects.requireNonNull(dialogSelectProjectWellList);
                this.this$0 = dialogSelectProjectWellList;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListWellListsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListWellLists);
        this.jButtonOK.setFont(this.jButtonOK.getFont());
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProjectWellList this$0;
            {
                DialogSelectProjectWellList dialogSelectProjectWellList = this$0;
                Objects.requireNonNull(dialogSelectProjectWellList);
                this.this$0 = dialogSelectProjectWellList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelProject.setText("Project:");
        this.jComboBoxProject.setMaximumRowCount(60);
        this.jComboBoxProject.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxProject.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProjectWellList this$0;
            {
                DialogSelectProjectWellList dialogSelectProjectWellList = this$0;
                Objects.requireNonNull(dialogSelectProjectWellList);
                this.this$0 = dialogSelectProjectWellList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxProjectActionPerformed(evt);
            }
        });
        this.jButtonProjects.setText("...");
        this.jButtonProjects.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectProjectWellList this$0;
            {
                DialogSelectProjectWellList dialogSelectProjectWellList = this$0;
                Objects.requireNonNull(dialogSelectProjectWellList);
                this.this$0 = dialogSelectProjectWellList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonProjectsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelProject).addPreferredGap(0).add(this.jComboBoxProject, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonProjects)).add((Component)this.jScrollPane1, -1, 274, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelProject).add(this.jComboBoxProject, -2, -1, -2).add((Component)this.jButtonProjects)).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 56, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selection = (WellList)((Object)this.jListWellLists.getSelectedValue());
        if (this.selection == null) {
            JOptionPane.showMessageDialog(this, "Select a well list", this.getTitle(), 0);
            return;
        }
        this.dispose();
    }

    private void jListWellListsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        try {
            WellList wellList = (WellList)((Object)this.jListWellLists.getSelectedValue());
            if (wellList == null) {
                JOptionPane.showMessageDialog(this, "Select a well list to edit", this.getTitle(), 0);
                return;
            }
            DialogProject dialog = new DialogProject(this, "Well List : Edit Details", wellList.getName(), wellList.getDescription(), true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                wellList.update(this.sbdb, dialog.getProjectName(), dialog.getDescr());
                this.sbdb.commit();
                this.jListWellLists.repaint();
            }
        }
        catch (SQLException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.project == null) {
            JOptionPane.showMessageDialog(this, "Select a project", this.getTitle(), 0);
            return;
        }
        DialogProject dialog = new DialogProject(this, "Well List : Add", null, null, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.selection = this.sbdb.addWellList(dialog.getProjectName(), dialog.getDescr(), this.project.getID());
                this.sbdb.commit();
                this.dispose();
            }
            catch (SQLException | InvalidFieldException | SBPermissionException e) {
                SbugsExceptionHandler.showStackError(e, this);
            }
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListWellLists.getModel().getSize() < 2) {
            JOptionPane.showMessageDialog(this, "You must have at least one well list in a project", this.getTitle(), 0);
            return;
        }
        WellList wellList = (WellList)((Object)this.jListWellLists.getSelectedValue());
        if (wellList == null) {
            JOptionPane.showMessageDialog(this, "Select a well list", this.getTitle(), 0);
            return;
        }
        int opt = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this well list?", "Delete Well List", 0);
        if (opt != 0) {
            return;
        }
        try {
            this.chartManager.checkWellListDelete(wellList.getID());
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, "Can't delete well list:\n" + ife.getMessage(), this.getTitle(), 2);
            return;
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError("SQL Error checking for well list in charts", sql, this);
            return;
        }
        try {
            this.sbdb.deleteWellList(wellList.getID());
            this.sbdb.commit();
            this.initWellLists();
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            this.sbdb.doRollback();
            SbugsExceptionHandler.showStackError(sql, this);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonProjectsActionPerformed(ActionEvent evt) {
        try {
            DialogSelectProject dialogProjects = new DialogSelectProject(this, true, this.sbdb);
            Point p = this.getLocation();
            dialogProjects.setLocation(p.x + 25, p.y + 25);
            dialogProjects.setVisible(true);
            this.initProjectList();
            if (dialogProjects.selection != null) {
                this.jComboBoxProject.setSelectedItem((Object)dialogProjects.selection);
            }
        }
        catch (SQLException | SBException sql) {
            StackError.showStackError((String)"Error", (Throwable)sql);
        }
    }

    private void jComboBoxProjectActionPerformed(ActionEvent evt) {
        Project p;
        Object o = this.jComboBoxProject.getSelectedItem();
        if (!(o instanceof Project)) {
            o = null;
        }
        if ((p = (Project)((Object)o)) != this.project) {
            this.project = p;
            this.initWellLists();
        }
    }

    public WellList getWellList() {
        return this.selection;
    }

    public WellList getSelection() {
        return this.selection;
    }
}

