/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogTable;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.ItemSelectorDialog;
import model3.SBRestrictable;
import model3.SBdb;
import model3.SynonymScheme;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;

public class DialogSelectSynonymScheme
extends ItemSelectorDialog<SynonymScheme> {
    private final SBdb db;
    private final DefaultListModel<SynonymScheme> listModel = new DefaultListModel();
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonOK;
    private JButton jButtonView;
    private JList<SynonymScheme> jListSchemes;
    private JScrollPane jScrollPane1;

    public DialogSelectSynonymScheme(JDialog parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.setTitle("Synonym Scheme : Select");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initList();
        if (!SBRestrictable.canWrite(db)) {
            this.jButtonAdd.setEnabled(false);
            this.jButtonEdit.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initList() throws SQLException {
        this.listModel.clear();
        for (SynonymScheme s : this.db.getSynSchemes()) {
            this.listModel.addElement(s);
        }
        this.jListSchemes.repaint();
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListSchemes = new JList();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonView = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 230));
        this.setModal(true);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSynonymScheme this$0;
            {
                DialogSelectSynonymScheme dialogSelectSynonymScheme = this$0;
                Objects.requireNonNull(dialogSelectSynonymScheme);
                this.this$0 = dialogSelectSynonymScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Rename");
        this.jButtonEdit.setToolTipText("Edit selected scheme name");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSynonymScheme this$0;
            {
                DialogSelectSynonymScheme dialogSelectSynonymScheme = this$0;
                Objects.requireNonNull(dialogSelectSynonymScheme);
                this.this$0 = dialogSelectSynonymScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSynonymScheme this$0;
            {
                DialogSelectSynonymScheme dialogSelectSynonymScheme = this$0;
                Objects.requireNonNull(dialogSelectSynonymScheme);
                this.this$0 = dialogSelectSynonymScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jListSchemes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSchemes.setModel(this.listModel);
        this.jListSchemes.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectSynonymScheme this$0;
            {
                DialogSelectSynonymScheme dialogSelectSynonymScheme = this$0;
                Objects.requireNonNull(dialogSelectSynonymScheme);
                this.this$0 = dialogSelectSynonymScheme;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListSchemesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSchemes);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSynonymScheme this$0;
            {
                DialogSelectSynonymScheme dialogSelectSynonymScheme = this$0;
                Objects.requireNonNull(dialogSelectSynonymScheme);
                this.this$0 = dialogSelectSynonymScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSynonymScheme this$0;
            {
                DialogSelectSynonymScheme dialogSelectSynonymScheme = this$0;
                Objects.requireNonNull(dialogSelectSynonymScheme);
                this.this$0 = dialogSelectSynonymScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonView.setText("View...");
        this.jButtonView.setToolTipText("View all entries for selected scheme");
        this.jButtonView.setMargin(new Insets(2, 12, 2, 12));
        this.jButtonView.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectSynonymScheme this$0;
            {
                DialogSelectSynonymScheme dialogSelectSynonymScheme = this$0;
                Objects.requireNonNull(dialogSelectSynonymScheme);
                this.this$0 = dialogSelectSynonymScheme;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonViewActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, 237, -2).addPreferredGap(0, 8, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonView, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCancel, this.jButtonDelete, this.jButtonEdit, this.jButtonOK, this.jButtonView}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonView).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 224, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jListSchemesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        String title = "Delete Synonym Scheme";
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", title, 2);
            return;
        }
        SynonymScheme scheme = this.jListSchemes.getSelectedValue();
        if (scheme.getSchID() == 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You cannot delete the default scheme", title, 2);
            return;
        }
        try {
            int nSchemes = scheme.getNTerms();
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "Do you really want to delete this scheme?\nNumber of terms in scheme: " + nSchemes, title, 0, 3) == 0) {
                this.db.deleteSynonymScheme(scheme);
                this.db.commit();
                this.jListSchemes.clearSelection();
                this.initList();
            }
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException ex) {
            this.db.doRollback();
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        try {
            SynonymScheme scheme = this.jListSchemes.getSelectedValue();
            String newName = JOptionPane.showInputDialog((Component)((Object)this), "Change name to: ", scheme.getName());
            if (newName != null) {
                scheme.updateName(newName);
                this.db.commit();
                this.initList();
            }
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBException | SBPermissionException ex) {
            this.db.doRollback();
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            String newName = JOptionPane.showInputDialog((Component)((Object)this), "Name of new Synonym Scheme: ", "New Scheme", -1);
            if (newName != null) {
                this.db.addSynonymScheme(newName);
                this.db.commit();
                this.initList();
            }
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBPermissionException ex) {
            this.db.doRollback();
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonViewActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        SynonymScheme scheme = this.jListSchemes.getSelectedValue();
        try {
            final HashMap<Integer, Integer> synonyms = scheme.getSynonyms();
            final Integer[] species = synonyms.keySet().toArray(new Integer[synonyms.size()]);
            AbstractTableModel tableModel = new AbstractTableModel(this){
                final /* synthetic */ DialogSelectSynonymScheme this$0;
                {
                    DialogSelectSynonymScheme dialogSelectSynonymScheme = this$0;
                    Objects.requireNonNull(dialogSelectSynonymScheme);
                    this.this$0 = dialogSelectSynonymScheme;
                }

                @Override
                public int getRowCount() {
                    return species.length;
                }

                @Override
                public int getColumnCount() {
                    return 2;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    try {
                        return switch (columnIndex) {
                            case 0 -> this.this$0.db.getTaxon(species[rowIndex]);
                            case 1 -> this.this$0.db.getTaxon((Integer)synonyms.get(species[rowIndex]));
                            default -> "";
                        };
                    }
                    catch (SQLException e) {
                        return e.getMessage();
                    }
                }
            };
            DialogTable dialog = new DialogTable((Dialog)((Object)this), true, tableModel, "Synonymy : " + scheme.getName(), false);
            TableUtils.setTableHeaderBold((JTable)dialog.getTable());
            String[] colTitles = new String[]{"Taxon", "Preferred Name"};
            TableColumnModel columnModel = dialog.getTable().getTableHeader().getColumnModel();
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            }
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    @Override
    public List<SynonymScheme> getSelectedItems() {
        if (this.jListSchemes.getSelectedValue() == null) {
            return Collections.emptyList();
        }
        return List.of(this.jListSchemes.getSelectedValue());
    }
}

